/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.statistics;

import de.uni_freiburg.informatik.ultimate.util.csv.CsvUtils;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class StatisticsData
implements IStatisticsDataProvider,
ICsvProviderProvider<Object> {
    private final Map<String, Object> mKey2Value = new HashMap<String, Object>();
    private IStatisticsType mBenchmarkType;

    public void aggregateBenchmarkData(IStatisticsDataProvider iStatisticsDataProvider) {
        if (this.mBenchmarkType == null) {
            assert (this.mKey2Value.isEmpty()) : "may not contain data if type is not known";
            this.mBenchmarkType = iStatisticsDataProvider.getBenchmarkType();
            if (this.mBenchmarkType == null) {
                return;
            }
            for (String string : this.mBenchmarkType.getKeys()) {
                Object object = iStatisticsDataProvider.getValue(string);
                if (object == null) {
                    throw new AssertionError((Object)("no value for " + string + " provided"));
                }
                this.mKey2Value.put(string, object);
            }
        } else {
            if (iStatisticsDataProvider.getBenchmarkType() == null) {
                return;
            }
            if (this.mBenchmarkType != iStatisticsDataProvider.getBenchmarkType()) {
                throw new AssertionError((Object)String.format("incompatible benchmarks: %s vs %s", this.mBenchmarkType.getClass(), iStatisticsDataProvider.getBenchmarkType().getClass()));
            }
            for (String string : this.mBenchmarkType.getKeys()) {
                Object object = this.mKey2Value.get(string);
                Object object2 = iStatisticsDataProvider.getValue(string);
                Object object3 = this.mBenchmarkType.aggregate(string, object, object2);
                this.mKey2Value.put(string, object3);
            }
        }
    }

    @Override
    public Object getValue(String string) {
        Object object = this.mKey2Value.get(string);
        if (object == null) {
            throw new IllegalArgumentException("No value for " + string + " available");
        }
        return object;
    }

    public String toString() {
        if (this.mBenchmarkType == null) {
            return "No data available";
        }
        return this.mBenchmarkType.prettyprintBenchmarkData(this);
    }

    @Override
    public Collection<String> getKeys() {
        if (this.mBenchmarkType == null) {
            throw new AssertionError((Object)"BenchmarkData not yet initialized");
        }
        return this.mBenchmarkType.getKeys();
    }

    @Override
    public IStatisticsType getBenchmarkType() {
        return this.mBenchmarkType;
    }

    public boolean isEmpty() {
        return this.mKey2Value.isEmpty();
    }

    public Map<String, Object> getFlattenedKeyValueMap() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (String string : this.getKeys()) {
            Object object = this.getValue(string);
            if (object instanceof IStatisticsDataProvider) {
                String string2;
                IStatisticsDataProvider iStatisticsDataProvider;
                if (object instanceof StatisticsData) {
                    iStatisticsDataProvider = (StatisticsData)object;
                    if (((StatisticsData)iStatisticsDataProvider).isEmpty()) continue;
                    Object object3 = ((StatisticsData)iStatisticsDataProvider).getFlattenedKeyValueMap();
                    for (Map.Entry<String, Object> entry : object3.entrySet()) {
                        string2 = string + "_" + entry.getKey();
                        linkedHashMap.put(string2, entry.getValue());
                    }
                    continue;
                }
                iStatisticsDataProvider = (IStatisticsDataProvider)object;
                for (Object object3 : iStatisticsDataProvider.getKeys()) {
                    Object object2 = iStatisticsDataProvider.getValue((String)object3);
                    string2 = string + "_" + (String)object3;
                    linkedHashMap.put(string2, object2);
                }
                continue;
            }
            linkedHashMap.put(string, object);
        }
        return linkedHashMap;
    }

    @Override
    public ICsvProvider<Object> createCsvProvider() {
        Map<String, Object> map = this.getFlattenedKeyValueMap();
        return CsvUtils.constructCvsProviderFromMap(map);
    }
}

