/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg;

import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IActionWithBranchEncoders;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class SequentialComposition
extends CodeBlock
implements IIcfgInternalTransition<IcfgLocation> {
    private static final long serialVersionUID = 9192152338120598669L;
    private final List<CodeBlock> mCodeBlocks;
    private String mPrettyPrinted;
    private final int mCallsWithoutReturns;

    SequentialComposition(int n, BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2, CfgSmtToolkit cfgSmtToolkit, boolean bl, boolean bl2, IUltimateServiceProvider iUltimateServiceProvider, List<CodeBlock> list, SmtUtils.SimplificationTechnique simplificationTechnique) {
        super(n, boogieIcfgLocation, boogieIcfgLocation2, iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID));
        this.mCodeBlocks = list;
        this.mCallsWithoutReturns = this.getCheckedOpenCalls(list).size();
        this.mPrettyPrinted = null;
        boolean bl3 = iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("Convert code blocks to CNF");
        this.mTransitionFormula = SequentialComposition.getInterproceduralTransFormula(cfgSmtToolkit, bl, bl2, bl3, false, this.mLogger, iUltimateServiceProvider, list, simplificationTechnique);
        this.mTransitionFormulaWithBranchEncoders = SequentialComposition.getInterproceduralTransFormula(cfgSmtToolkit, bl, bl2, bl3, true, this.mLogger, iUltimateServiceProvider, list, simplificationTechnique);
        assert (this.mCallsWithoutReturns > 0 || TransFormulaUtils.hasInternalNormalForm((TransFormula)this.mTransitionFormula)) : "Expected TF in internal normal form";
        assert (this.mCallsWithoutReturns > 0 || TransFormulaUtils.hasInternalNormalForm((TransFormula)this.mTransitionFormulaWithBranchEncoders)) : "Expected TF in internal normal form";
    }

    private Deque<Call> getCheckedOpenCalls(List<CodeBlock> list) {
        ArrayDeque<Call> arrayDeque = new ArrayDeque<Call>();
        for (CodeBlock codeBlock : list) {
            Object object;
            CodeBlock codeBlock2;
            if (codeBlock instanceof Call) {
                arrayDeque.addFirst((Call)codeBlock);
                continue;
            }
            if (codeBlock instanceof Return) {
                codeBlock2 = (Return)codeBlock;
                if (arrayDeque.isEmpty()) {
                    throw new IllegalArgumentException("Call/Return order violated");
                }
                object = (Call)((Object)arrayDeque.removeFirst());
                if (Objects.equals(((Return)codeBlock2).getCallStatement(), object.getCallStatement())) continue;
                throw new IllegalArgumentException("Call/Return order violated");
            }
            if (codeBlock.getNumberOfOpenCalls() == 0) continue;
            if (codeBlock instanceof SequentialComposition) {
                codeBlock2 = (SequentialComposition)codeBlock;
                object = this.getCheckedOpenCalls(((SequentialComposition)codeBlock2).getCodeBlocks());
                arrayDeque.addAll((Collection<Call>)object);
                continue;
            }
            throw new IllegalArgumentException("Open calls are only supported in sequential compositions");
        }
        return arrayDeque;
    }

    @Override
    public String getPrettyPrintedStatements() {
        if (this.mPrettyPrinted == null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (CodeBlock codeBlock : this.mCodeBlocks) {
                stringBuilder.append(codeBlock.getPrettyPrintedStatements());
            }
            this.mPrettyPrinted = stringBuilder.toString();
        }
        return this.mPrettyPrinted;
    }

    @Visualizable
    public List<CodeBlock> getCodeBlocks() {
        return this.mCodeBlocks;
    }

    @Override
    public void setTransitionFormula(UnmodifiableTransFormula unmodifiableTransFormula) {
        throw new UnsupportedOperationException("transition formula is computed in constructor");
    }

    public static <ACTION extends IAction> UnmodifiableTransFormula getInterproceduralTransFormula(CfgSmtToolkit cfgSmtToolkit, boolean bl, boolean bl2, boolean bl3, boolean bl4, ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, List<ACTION> list, SmtUtils.SimplificationTechnique simplificationTechnique) {
        return SequentialComposition.getInterproceduralTransFormula(cfgSmtToolkit, bl, bl2, bl3, bl4, null, null, null, null, iLogger, iUltimateServiceProvider, list, simplificationTechnique);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <ACTION extends IAction> UnmodifiableTransFormula getInterproceduralTransFormula(CfgSmtToolkit cfgSmtToolkit, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string, UnmodifiableTransFormula[] unmodifiableTransFormulaArray, ICallAction iCallAction, IReturnAction iReturnAction, ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, List<ACTION> list, SmtUtils.SimplificationTechnique simplificationTechnique) {
        void var19_26;
        UnmodifiableTransFormula unmodifiableTransFormula;
        UnmodifiableTransFormula unmodifiableTransFormula2;
        UnmodifiableTransFormula unmodifiableTransFormula3;
        ArrayList<UnmodifiableTransFormula> arrayList = new ArrayList<UnmodifiableTransFormula>();
        ICallAction iCallAction2 = null;
        int n = 0;
        int n2 = 0;
        ArrayList<IAction> arrayList2 = new ArrayList<IAction>();
        int n3 = 0;
        while (n3 < list.size()) {
            IAction iAction = (IAction)list.get(n3);
            if (iCallAction2 == null) {
                if (iAction instanceof ICallAction) {
                    iCallAction2 = (ICallAction)iAction;
                } else {
                    assert (!(iAction instanceof IReturnAction));
                    if (bl4) {
                        if (!(iAction instanceof CodeBlock)) throw new UnsupportedOperationException("No codeblock, no branch encoders");
                        arrayList.add(((IActionWithBranchEncoders)iAction).getTransitionFormulaWithBranchEncoders());
                    } else {
                        arrayList.add(iAction.getTransformula());
                    }
                }
            } else if (iAction instanceof IReturnAction) {
                if (n == n2) {
                    IReturnAction iReturnAction2 = (IReturnAction)iAction;
                    unmodifiableTransFormula3 = new ArrayList(arrayList2);
                    unmodifiableTransFormula2 = SequentialComposition.getInterproceduralTransFormula(cfgSmtToolkit, bl, bl2, bl3, bl4, null, null, iCallAction2, iReturnAction2, iLogger, iUltimateServiceProvider, unmodifiableTransFormula3, simplificationTechnique);
                    arrayList.add(unmodifiableTransFormula2);
                    iCallAction2 = null;
                    n = 0;
                    n2 = 0;
                    arrayList2 = new ArrayList();
                } else {
                    ++n2;
                    arrayList2.add(iAction);
                }
                assert (n >= n2);
            } else if (iAction instanceof ICallAction) {
                ++n;
                arrayList2.add(iAction);
            } else {
                arrayList2.add(iAction);
            }
            ++n3;
        }
        if (iCallAction2 == null) {
            assert (arrayList2.isEmpty());
            unmodifiableTransFormula = TransFormulaUtils.sequentialComposition((ILogger)iLogger, (IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)cfgSmtToolkit.getManagedScript(), (boolean)bl, (boolean)bl2, (boolean)bl3, (SmtUtils.SimplificationTechnique)simplificationTechnique, arrayList);
        } else {
            assert (iReturnAction == null) : "no pending call between call and return possible!";
            ArrayList<IAction> arrayList3 = arrayList2;
            unmodifiableTransFormula = SequentialComposition.getInterproceduralTransFormula(cfgSmtToolkit, bl, bl2, bl3, bl4, ((IAction)list.get(0)).getPrecedingProcedure(), arrayList.toArray(new UnmodifiableTransFormula[arrayList.size()]), iCallAction2, null, iLogger, iUltimateServiceProvider, arrayList3, simplificationTechnique);
        }
        if (iCallAction == null) {
            assert (iReturnAction == null);
            assert (unmodifiableTransFormulaArray == null);
            UnmodifiableTransFormula unmodifiableTransFormula4 = unmodifiableTransFormula;
            return var19_26;
        } else {
            String string2 = iCallAction.getSucceedingProcedure();
            if (iReturnAction == null) {
                void var23_33;
                unmodifiableTransFormula3 = cfgSmtToolkit.getOldVarsAssignmentCache().getOldVarsAssignment(string2);
                unmodifiableTransFormula2 = cfgSmtToolkit.getOldVarsAssignmentCache().getGlobalVarsAssignment(string2);
                if (iCallAction2 == null) {
                    String string3 = string2;
                } else {
                    String string4 = iCallAction2.getPrecedingProcedure();
                }
                Set set = cfgSmtToolkit.getModifiableGlobalsTable().getModifiedBoogieVars((String)var23_33);
                UnmodifiableTransFormula unmodifiableTransFormula5 = TransFormulaUtils.sequentialCompositionWithPendingCall((ManagedScript)cfgSmtToolkit.getManagedScript(), (boolean)bl, (boolean)bl2, (boolean)bl3, Arrays.asList(unmodifiableTransFormulaArray), (UnmodifiableTransFormula)iCallAction.getLocalVarsAssignment(), (UnmodifiableTransFormula)unmodifiableTransFormula3, (UnmodifiableTransFormula)unmodifiableTransFormula2, (UnmodifiableTransFormula)unmodifiableTransFormula, (ILogger)iLogger, (IUltimateServiceProvider)iUltimateServiceProvider, (Set)set, (SmtUtils.SimplificationTechnique)simplificationTechnique, (IIcfgSymbolTable)cfgSmtToolkit.getSymbolTable(), (String)string, (String)iCallAction.getPrecedingProcedure(), (String)string2, (String)var23_33, (ModifiableGlobalsTable)cfgSmtToolkit.getModifiableGlobalsTable());
                return var19_26;
            } else {
                assert (unmodifiableTransFormulaArray == null);
                unmodifiableTransFormula3 = cfgSmtToolkit.getOldVarsAssignmentCache().getOldVarsAssignment(string2);
                unmodifiableTransFormula2 = cfgSmtToolkit.getOldVarsAssignmentCache().getGlobalVarsAssignment(string2);
                UnmodifiableTransFormula unmodifiableTransFormula6 = TransFormulaUtils.sequentialCompositionWithCallAndReturn((ManagedScript)cfgSmtToolkit.getManagedScript(), (boolean)bl, (boolean)bl2, (boolean)bl3, (UnmodifiableTransFormula)iCallAction.getLocalVarsAssignment(), (UnmodifiableTransFormula)unmodifiableTransFormula3, (UnmodifiableTransFormula)unmodifiableTransFormula2, (UnmodifiableTransFormula)unmodifiableTransFormula, (UnmodifiableTransFormula)iReturnAction.getAssignmentOfReturn(), (ILogger)iLogger, (IUltimateServiceProvider)iUltimateServiceProvider, (SmtUtils.SimplificationTechnique)simplificationTechnique, (IIcfgSymbolTable)cfgSmtToolkit.getSymbolTable(), (Set)cfgSmtToolkit.getModifiableGlobalsTable().getModifiedBoogieVars(string2));
            }
        }
        return var19_26;
    }

    @Override
    public String toString() {
        return this.getPrettyPrintedStatements();
    }

    @Override
    protected int getNumberOfOpenCalls() {
        return this.mCallsWithoutReturns;
    }
}

