/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractAcceptance<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private static final String AT_POSITION = " at position ";
    private static final String UNABLE_TO_CHECK_ACCEPTANCE_LETTER = "Unable to check acceptance. Letter ";
    protected final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    protected boolean mIsAccepted;

    public AbstractAcceptance(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) {
        super(automataLibraryServices);
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
    }

    public Set<ArrayDeque<STATE>> emptyStackConfiguration(Iterable<STATE> iterable) {
        HashSet<ArrayDeque<STATE>> hashSet = new HashSet<ArrayDeque<STATE>>();
        for (STATE STATE : iterable) {
            ArrayDeque<STATE> arrayDeque = new ArrayDeque<STATE>();
            arrayDeque.push(STATE);
            hashSet.add(arrayDeque);
        }
        return hashSet;
    }

    protected boolean isAcceptingConfiguration(Deque<STATE> deque, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) {
        STATE STATE = deque.peek();
        return iNwaOutgoingLetterAndTransitionProvider.isFinal(STATE);
    }

    protected Set<ArrayDeque<STATE>> successorConfigurations(Set<ArrayDeque<STATE>> set, NestedWord<LETTER> nestedWord, int n, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, boolean bl) throws AutomataLibraryException {
        HashSet<ArrayDeque<STATE>> hashSet = new HashSet<ArrayDeque<STATE>>();
        if (bl) {
            set.addAll(set);
        }
        for (ArrayDeque<STATE> arrayDeque : set) {
            if (this.isCancellationRequested()) {
                throw new AutomataOperationCanceledException(this.getClass());
            }
            STATE STATE = arrayDeque.pop();
            Object LETTER = nestedWord.getSymbol(n);
            if (nestedWord.isInternalPosition(n)) {
                this.successorConfigurationsInternal(n, iNwaOutgoingLetterAndTransitionProvider, hashSet, arrayDeque, STATE, LETTER);
            } else if (nestedWord.isCallPosition(n)) {
                this.successorConfigurationsCall(n, iNwaOutgoingLetterAndTransitionProvider, hashSet, arrayDeque, STATE, LETTER);
            } else if (nestedWord.isReturnPosition(n)) {
                this.successorConfigurationsReturn(n, iNwaOutgoingLetterAndTransitionProvider, hashSet, arrayDeque, STATE, LETTER);
            } else {
                throw new AssertionError();
            }
            arrayDeque.push(STATE);
        }
        return hashSet;
    }

    private void successorConfigurationsInternal(int n, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, Set<ArrayDeque<STATE>> set, ArrayDeque<STATE> arrayDeque, STATE STATE, LETTER LETTER) throws AutomataLibraryException {
        if (!iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet().getInternalAlphabet().contains(LETTER)) {
            throw new AutomataLibraryException(this.getClass(), UNABLE_TO_CHECK_ACCEPTANCE_LETTER + String.valueOf(LETTER) + AT_POSITION + n + " not in internal alphabet of automaton.");
        }
        Iterable<OutgoingInternalTransition<LETTER, STATE>> iterable = iNwaOutgoingLetterAndTransitionProvider.internalSuccessors(STATE, LETTER);
        for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : iterable) {
            STATE STATE2 = outgoingInternalTransition.getSucc();
            Object object = arrayDeque.clone();
            ((ArrayDeque)object).push(STATE2);
            set.add((ArrayDeque<STATE>)object);
        }
    }

    private void successorConfigurationsCall(int n, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, Set<ArrayDeque<STATE>> set, ArrayDeque<STATE> arrayDeque, STATE STATE, LETTER LETTER) throws AutomataLibraryException {
        if (!iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet().getCallAlphabet().contains(LETTER)) {
            throw new AutomataLibraryException(this.getClass(), UNABLE_TO_CHECK_ACCEPTANCE_LETTER + String.valueOf(LETTER) + AT_POSITION + n + " not in call alphabet of automaton.");
        }
        Iterable<OutgoingCallTransition<LETTER, STATE>> iterable = iNwaOutgoingLetterAndTransitionProvider.callSuccessors(STATE, LETTER);
        for (OutgoingCallTransition<LETTER, STATE> outgoingCallTransition : iterable) {
            STATE STATE2 = outgoingCallTransition.getSucc();
            Object object = arrayDeque.clone();
            ((ArrayDeque)object).push(STATE);
            ((ArrayDeque)object).push(STATE2);
            set.add((ArrayDeque<STATE>)object);
        }
    }

    private void successorConfigurationsReturn(int n, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, Set<ArrayDeque<STATE>> set, ArrayDeque<STATE> arrayDeque, STATE STATE, LETTER LETTER) throws AutomataLibraryException {
        if (!iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet().getReturnAlphabet().contains(LETTER)) {
            throw new AutomataLibraryException(this.getClass(), UNABLE_TO_CHECK_ACCEPTANCE_LETTER + String.valueOf(LETTER) + AT_POSITION + n + " not in return alphabet of automaton.");
        }
        if (arrayDeque.isEmpty()) {
            if (this.mLogger.isWarnEnabled()) {
                this.mLogger.warn((Object)"Input has pending returns, we reject such words");
            }
        } else {
            STATE STATE2 = arrayDeque.pop();
            Iterable<OutgoingReturnTransition<LETTER, STATE>> iterable = iNwaOutgoingLetterAndTransitionProvider.returnSuccessors(STATE, STATE2, LETTER);
            for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : iterable) {
                STATE STATE3 = outgoingReturnTransition.getSucc();
                Object object = arrayDeque.clone();
                ((ArrayDeque)object).push(STATE3);
                set.add((ArrayDeque<STATE>)object);
            }
            arrayDeque.push(STATE2);
        }
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public Boolean getResult() {
        return this.mIsAccepted;
    }
}

