/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.csv;

import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderTransformer;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class CsvProviderAggregator<T>
implements ICsvProviderTransformer<T> {
    private final Map<String, Aggregation> mColumn2aggregation;
    private final String mCountColumnTitle;

    public CsvProviderAggregator(Map<String, Aggregation> map) {
        this(map, null);
    }

    public CsvProviderAggregator(Map<String, Aggregation> map, String string) {
        this.mColumn2aggregation = map;
        this.mCountColumnTitle = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ICsvProvider<T> transform(ICsvProvider<T> iCsvProvider) {
        ArrayList<String> arrayList;
        Object object;
        List<String> list = iCsvProvider.getRowHeaders();
        int n = list.size();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (n == 0) {
            return new SimpleCsvProvider(arrayList2);
        }
        int n2 = iCsvProvider.getColumnTitles().size();
        boolean[] blArray = new boolean[n2];
        int n3 = 0;
        for (String string : iCsvProvider.getColumnTitles()) {
            Aggregation aggregation = this.mColumn2aggregation.get(string);
            if (aggregation == null) {
                System.err.println("Ignoring column " + string + " which was not specified.");
                this.mColumn2aggregation.put(string, Aggregation.IGNORE);
            } else if (aggregation != Aggregation.IGNORE) {
                arrayList2.add(string);
                blArray[n3] = true;
            }
            ++n3;
        }
        arrayList2.trimToSize();
        this.isCountColumnFresh(arrayList2);
        List<T> list2 = this.filter(iCsvProvider.getRow(0), blArray, arrayList2.size());
        int n4 = 1;
        while (n4 < n) {
            List<T> list3 = iCsvProvider.getRow(n4);
            object = this.filter(list3, blArray, arrayList2.size());
            this.aggregateRows(list2, (List<T>)object, (List<String>)arrayList2, n4);
            ++n4;
        }
        if (this.mCountColumnTitle != null) {
            arrayList = new ArrayList(arrayList2.size() + 1);
            arrayList.addAll(arrayList2);
            arrayList.add(this.mCountColumnTitle);
            if (iCsvProvider.getRow(0).isEmpty() || !(iCsvProvider.getRow(0).get(0) instanceof String)) throw new IllegalArgumentException("Aggregation with adding a count column only works if the CSV has type String.");
            list2.add(Integer.toString(list.size()));
        } else {
            arrayList = arrayList2;
        }
        SimpleCsvProvider<T> simpleCsvProvider = new SimpleCsvProvider<T>(arrayList);
        object = list.get(0);
        simpleCsvProvider.addRow((String)object, list2);
        return simpleCsvProvider;
    }

    private void aggregateRows(List<T> list, List<T> list2, List<String> list3, int n) {
        ListIterator<T> listIterator = list.listIterator();
        ListIterator<T> listIterator2 = list2.listIterator();
        ListIterator<String> listIterator3 = list3.listIterator();
        int n2 = 0;
        while (n2 < list.size()) {
            T t = listIterator.next();
            T t2 = listIterator2.next();
            String string = listIterator3.next();
            Aggregation aggregation = this.mColumn2aggregation.get(string);
            assert (aggregation != null);
            switch (aggregation) {
                case AVERAGE: {
                    listIterator.set(this.getAverage(t, t2, n));
                    break;
                }
                case SUM: {
                    listIterator.set(this.getSum(t, t2, n));
                    break;
                }
                case IGNORE: {
                    assert (false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown aggregation mode: " + String.valueOf((Object)aggregation));
                }
            }
            ++n2;
        }
    }

    private List<T> filter(List<T> list, boolean[] blArray, int n) {
        int n2 = 0;
        ArrayList<T> arrayList = new ArrayList<T>(n);
        for (T t : list) {
            assert (n2 < blArray.length);
            if (blArray[n2]) {
                arrayList.add(t);
            }
            ++n2;
        }
        return arrayList;
    }

    private T getAverage(T t, T t2, int n) {
        double d = Double.parseDouble(t.toString());
        double d2 = Double.parseDouble(t2.toString());
        double d3 = d + 1.0 / (double)(n + 1) * (d2 - d);
        return this.getTypeFromDouble(d3, t);
    }

    private T getSum(T t, T t2, int n) {
        double d = Double.parseDouble(t.toString());
        double d2 = Double.parseDouble(t2.toString());
        double d3 = d + d2;
        return this.getTypeFromDouble(d3, t);
    }

    private T getTypeFromDouble(Double d, T t) {
        if (t instanceof Double) {
            return (T)d;
        }
        if (t instanceof String) {
            return (T)BigDecimal.valueOf(d).toPlainString();
        }
        throw new IllegalArgumentException("Received data not of type Double but of type " + t.getClass().toGenericString());
    }

    private void isCountColumnFresh(ArrayList<String> arrayList) {
        if (this.mCountColumnTitle != null && arrayList.contains(this.mCountColumnTitle)) {
            throw new IllegalArgumentException();
        }
    }

    public static enum Aggregation {
        AVERAGE,
        SUM,
        IGNORE;

    }
}

