/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class ProductNwa<LETTER, STATE>
implements INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> {
    protected final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mFstOperand;
    protected final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mSndOperand;
    private final IEmptyStackStateFactory<STATE> mStateFactory;
    private final STATE mEmptyStackState;
    private final Map<STATE, Map<STATE, ProductState>> mFst2snd2res = new HashMap<STATE, Map<STATE, ProductState>>();
    private final Map<STATE, ProductState> mRes2prod = new HashMap<STATE, ProductState>();
    private final boolean mAssumeInSndNonFinalIsTrap;
    private Set<STATE> mInitialStates;

    protected ProductNwa(INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider2, IEmptyStackStateFactory<STATE> iEmptyStackStateFactory, boolean bl) throws AutomataLibraryException {
        this.mFstOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mSndOperand = iNwaOutgoingLetterAndTransitionProvider2;
        if (!NestedWordAutomataUtils.sameAlphabet(this.mFstOperand, this.mSndOperand)) {
            throw new AutomataLibraryException(this.getClass(), "Unable to apply operation to automata with different alphabets.");
        }
        this.mStateFactory = iEmptyStackStateFactory;
        this.mAssumeInSndNonFinalIsTrap = bl;
        this.mEmptyStackState = iEmptyStackStateFactory.createEmptyStackState();
    }

    public Map<STATE, Map<STATE, ProductState>> getFst2snd2res() {
        return this.mFst2snd2res;
    }

    private Set<STATE> constructInitialState() {
        HashSet hashSet = new HashSet();
        for (Object STATE : this.mFstOperand.getInitialStates()) {
            for (Object STATE2 : this.mSndOperand.getInitialStates()) {
                Object STATE3 = this.getOrConstructState(STATE, STATE2);
                hashSet.add(STATE3);
            }
        }
        return hashSet;
    }

    private STATE getOrConstructState(STATE STATE, STATE STATE2) {
        ProductState productState;
        Map<STATE, ProductState> map = this.mFst2snd2res.get(STATE);
        if (map == null) {
            map = new HashMap<STATE, ProductState>();
            this.mFst2snd2res.put(STATE, map);
        }
        if ((productState = map.get(STATE2)) == null) {
            productState = this.createProductState(STATE, STATE2);
            map.put(STATE2, productState);
            assert (!this.mRes2prod.containsKey(productState.getRes())) : "A product state must not represent multiple pairs of states";
            this.mRes2prod.put(productState.getRes(), productState);
        }
        return productState.getRes();
    }

    protected abstract ProductState createProductState(STATE var1, STATE var2);

    @Override
    public Iterable<STATE> getInitialStates() {
        if (this.mInitialStates == null) {
            this.mInitialStates = this.constructInitialState();
        }
        return this.mInitialStates;
    }

    @Override
    public VpAlphabet<LETTER> getVpAlphabet() {
        return this.mFstOperand.getVpAlphabet();
    }

    @Override
    public IStateFactory<STATE> getStateFactory() {
        return this.mStateFactory;
    }

    @Override
    public boolean isInitial(STATE STATE) {
        if (this.mInitialStates == null) {
            this.mInitialStates = this.constructInitialState();
        }
        return this.mInitialStates.contains(STATE);
    }

    @Override
    public boolean isFinal(STATE STATE) {
        return this.mRes2prod.get(STATE).isFinal();
    }

    @Override
    public STATE getEmptyStackState() {
        return this.mEmptyStackState;
    }

    @Override
    public Set<LETTER> lettersInternal(STATE STATE) {
        Object STATE2 = this.mRes2prod.get(STATE).getFst();
        return this.mFstOperand.lettersInternal(STATE2);
    }

    @Override
    public Set<LETTER> lettersCall(STATE STATE) {
        Object STATE2 = this.mRes2prod.get(STATE).getFst();
        return this.mFstOperand.lettersCall(STATE2);
    }

    @Override
    public Set<LETTER> lettersReturn(STATE STATE, STATE STATE2) {
        Object STATE3 = this.mRes2prod.get(STATE).getFst();
        Object STATE4 = this.mRes2prod.get(STATE2).getFst();
        return this.mFstOperand.lettersReturn(STATE3, STATE4);
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE, LETTER LETTER) {
        ProductState productState = this.mRes2prod.get(STATE);
        Object STATE2 = productState.getFst();
        Object STATE3 = productState.getSnd();
        return this.internalSuccessors(this.mFstOperand.internalSuccessors(STATE2, LETTER), STATE3);
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE) {
        ProductState productState = this.mRes2prod.get(STATE);
        Object STATE2 = productState.getFst();
        Object STATE3 = productState.getSnd();
        return this.internalSuccessors(this.mFstOperand.internalSuccessors(STATE2), STATE3);
    }

    @Override
    private Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(Iterable<OutgoingInternalTransition<LETTER, STATE>> iterable, STATE STATE) {
        ArrayList<OutgoingInternalTransition<LETTER, STATE>> arrayList = new ArrayList<OutgoingInternalTransition<LETTER, STATE>>();
        for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : iterable) {
            LETTER LETTER = outgoingInternalTransition.getLetter();
            for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition2 : this.mSndOperand.internalSuccessors(STATE, LETTER)) {
                STATE STATE2 = outgoingInternalTransition.getSucc();
                STATE STATE3 = outgoingInternalTransition2.getSucc();
                if (this.isTrapInSnd(STATE3)) continue;
                STATE STATE4 = this.getOrConstructState(STATE2, STATE3);
                arrayList.add(new OutgoingInternalTransition<LETTER, STATE>(LETTER, STATE4));
            }
        }
        return arrayList;
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE, LETTER LETTER) {
        ProductState productState = this.mRes2prod.get(STATE);
        Object STATE2 = productState.getFst();
        Object STATE3 = productState.getSnd();
        return this.callSuccessors(this.mFstOperand.callSuccessors(STATE2, LETTER), STATE3);
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE) {
        ProductState productState = this.mRes2prod.get(STATE);
        Object STATE2 = productState.getFst();
        Object STATE3 = productState.getSnd();
        return this.callSuccessors(this.mFstOperand.callSuccessors(STATE2), STATE3);
    }

    @Override
    private Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(Iterable<OutgoingCallTransition<LETTER, STATE>> iterable, STATE STATE) {
        ArrayList<OutgoingCallTransition<LETTER, STATE>> arrayList = new ArrayList<OutgoingCallTransition<LETTER, STATE>>();
        for (OutgoingCallTransition<LETTER, STATE> outgoingCallTransition : iterable) {
            LETTER LETTER = outgoingCallTransition.getLetter();
            for (OutgoingCallTransition<LETTER, STATE> outgoingCallTransition2 : this.mSndOperand.callSuccessors(STATE, LETTER)) {
                STATE STATE2 = outgoingCallTransition.getSucc();
                STATE STATE3 = outgoingCallTransition2.getSucc();
                if (this.isTrapInSnd(STATE3)) continue;
                STATE STATE4 = this.getOrConstructState(STATE2, STATE3);
                arrayList.add(new OutgoingCallTransition<LETTER, STATE>(LETTER, STATE4));
            }
        }
        return arrayList;
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(STATE STATE, STATE STATE2, LETTER LETTER) {
        ProductState productState = this.mRes2prod.get(STATE);
        Object STATE3 = productState.getFst();
        Object STATE4 = productState.getSnd();
        ProductState productState2 = this.mRes2prod.get(STATE2);
        Object STATE5 = productState2.getFst();
        Object STATE6 = productState2.getSnd();
        return this.returnSuccessors(this.mFstOperand.returnSuccessors(STATE3, STATE5, LETTER), STATE2, STATE4, STATE6);
    }

    private Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(Iterable<OutgoingReturnTransition<LETTER, STATE>> iterable, STATE STATE, STATE STATE2, STATE STATE3) {
        ArrayList<OutgoingReturnTransition<LETTER, STATE>> arrayList = new ArrayList<OutgoingReturnTransition<LETTER, STATE>>();
        for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : iterable) {
            LETTER LETTER = outgoingReturnTransition.getLetter();
            for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition2 : this.mSndOperand.returnSuccessors(STATE2, STATE3, LETTER)) {
                STATE STATE4 = outgoingReturnTransition.getSucc();
                STATE STATE5 = outgoingReturnTransition2.getSucc();
                if (this.isTrapInSnd(STATE5)) continue;
                STATE STATE6 = this.getOrConstructState(STATE4, STATE5);
                arrayList.add(new OutgoingReturnTransition<LETTER, STATE>(STATE, LETTER, STATE6));
            }
        }
        return arrayList;
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessorsGivenHier(STATE STATE, STATE STATE2) {
        ProductState productState = this.mRes2prod.get(STATE);
        Object STATE3 = productState.getFst();
        Object STATE4 = productState.getSnd();
        ProductState productState2 = this.mRes2prod.get(STATE2);
        Object STATE5 = productState2.getFst();
        Object STATE6 = productState2.getSnd();
        return this.returnSuccessors(this.mFstOperand.returnSuccessorsGivenHier(STATE3, STATE5), STATE2, STATE4, STATE6);
    }

    @Override
    public int size() {
        return this.mRes2prod.size();
    }

    @Override
    public String sizeInformation() {
        return "currently " + this.size() + " states, but on-demand construction may add more states";
    }

    protected boolean isTrapInSnd(STATE STATE) {
        return this.mAssumeInSndNonFinalIsTrap && !this.mSndOperand.isFinal(STATE);
    }

    public class ProductState {
        private final STATE mFst;
        private final STATE mSnd;
        private final STATE mRes;
        private final boolean mIsFinal;

        ProductState(STATE STATE, STATE STATE2, STATE STATE3, boolean bl) {
            this.mFst = STATE;
            this.mSnd = STATE2;
            this.mRes = STATE3;
            this.mIsFinal = bl;
        }

        public STATE getFst() {
            return this.mFst;
        }

        public STATE getSnd() {
            return this.mSnd;
        }

        public STATE getRes() {
            return this.mRes;
        }

        public boolean isFinal() {
            return this.mIsFinal;
        }

        public String toString() {
            return "<" + this.mFst.toString() + "," + this.mSnd.toString() + ">";
        }
    }
}

