/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveDeadEnds;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationCheckResultStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaPmaxSat;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaPmaxSatDirectBi;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.direct.nwa.ReduceNwaDirectSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.summarycomputationgraph.ReduceNwaDirectSimulationB;

public class DirectSimulationComparison<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IMinimizationCheckResultStateFactory<STATE>> {
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private final ReduceNwaDirectSimulation<LETTER, STATE> mOldSimulation;
    private final ReduceNwaDirectSimulationB<LETTER, STATE> mNewSimulation;
    private final MinimizeNwaPmaxSat<LETTER, STATE> mMaxSat;

    public DirectSimulationComparison(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iNestedWordAutomaton;
        Object object = new RemoveDeadEnds<LETTER, STATE>(this.mServices, this.mOperand).getResult();
        this.mOldSimulation = new ReduceNwaDirectSimulation(this.mServices, iMinimizationStateFactory, object);
        this.mNewSimulation = new ReduceNwaDirectSimulationB(this.mServices, iMinimizationStateFactory, object);
        this.mMaxSat = new MinimizeNwaPmaxSatDirectBi(this.mServices, iMinimizationStateFactory, object);
    }

    @Override
    public Object getResult() {
        return this.mNewSimulation.getResult();
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public boolean checkResult(IMinimizationCheckResultStateFactory<STATE> iMinimizationCheckResultStateFactory) throws AutomataLibraryException {
        boolean bl = this.mOldSimulation.checkResult(iMinimizationCheckResultStateFactory);
        boolean bl2 = this.mNewSimulation.checkResult(iMinimizationCheckResultStateFactory);
        boolean bl3 = this.mMaxSat.checkResult(iMinimizationCheckResultStateFactory);
        int n = this.mOldSimulation.getResult().size();
        int n2 = this.mNewSimulation.getResult().size();
        int n3 = this.mMaxSat.getResult().size();
        boolean bl4 = bl && bl2 && bl3;
        boolean bl5 = bl4 = bl4 && n == n2 && n == n3;
        if (this.mLogger.isWarnEnabled()) {
            this.mLogger.warn((Object)String.format("old: (%b, %d)  new: (%b, %d)  Max-SAT: (%b, %d)", bl, n, bl2, n2, bl3, n3));
        }
        if (!bl4) {
            AutomatonDefinitionPrinter.writeToFileIfPreferred(this.mServices, this.getOperationName() + "Failed", this.getOperationName(), this.mOperand);
        }
        return bl4;
    }
}

