/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.Interpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAtomInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorClauseInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ArrayInterpolator {
    private final Interpolator mInterpolator;
    private final Theory mTheory;
    private final int mNumInterpolants;
    private Set<Term>[] mInterpolants;
    private InterpolatorClauseInfo mLemmaInfo;
    private Term mDiseq;
    private Interpolator.LitInfo mDiseqInfo;
    private Map<SymmetricPair<Term>, Term> mEqualities;
    private Map<SymmetricPair<Term>, Term> mDisequalities;
    private ProofPath mStorePath;
    private Interpolator.Occurrence mABSwitchOccur;
    private Term mIndexEquality;
    private Map<Term, ProofPath> mIndexPaths;
    private Map<Term, WeakPathInfo> mIndexPathInfos;
    private Map<Term, WeakPathInfo> mRecIndexPathInfos;
    private Term[] mRewriteSide;
    private TermVariable mRecursionVar;
    private TermVariable mDoubleDot;

    public ArrayInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
        this.mTheory = interpolator.mTheory;
        this.mNumInterpolants = interpolator.mNumInterpolants;
        this.mInterpolants = new Set[this.mNumInterpolants];
        int n = 0;
        while (n < this.mNumInterpolants) {
            this.mInterpolants[n] = new HashSet<Term>();
            ++n;
        }
    }

    private ApplicationTerm getDiseq(InterpolatorClauseInfo interpolatorClauseInfo) {
        Object[] objectArray = (Object[])interpolatorClauseInfo.getLemmaAnnotation();
        assert (objectArray.length % 2 == 1);
        ApplicationTerm applicationTerm = (ApplicationTerm)objectArray[0];
        assert (applicationTerm.getFunction().getName().equals("="));
        return applicationTerm;
    }

    private ProofPath[] getPaths(InterpolatorClauseInfo interpolatorClauseInfo) {
        Object[] objectArray = (Object[])interpolatorClauseInfo.getLemmaAnnotation();
        assert (objectArray.length % 2 == 1);
        int n = (objectArray.length - 1) / 2;
        ProofPath[] proofPathArray = new ProofPath[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 2 * n2 + 1;
            String string = (String)objectArray[n3];
            Object object = objectArray[n3 + 1];
            proofPathArray[n2] = new ProofPath(string, object);
            ++n2;
        }
        return proofPathArray;
    }

    public Term[] computeInterpolants(InterpolatorClauseInfo interpolatorClauseInfo) {
        Term term;
        this.mLemmaInfo = interpolatorClauseInfo;
        this.mEqualities = new HashMap<SymmetricPair<Term>, Term>();
        this.mDisequalities = new HashMap<SymmetricPair<Term>, Term>();
        this.mABSwitchOccur = new Interpolator.Occurrence(this.mInterpolator);
        FormulaUnLet formulaUnLet = this.mLemmaInfo.getLiterals();
        int n = ((Term[])formulaUnLet).length;
        int n2 = 0;
        while (n2 < n) {
            term = formulaUnLet[n2];
            Term term2 = this.mInterpolator.getAtom(term);
            InterpolatorAtomInfo interpolatorAtomInfo = this.mInterpolator.getAtomTermInfo(term2);
            ApplicationTerm applicationTerm = interpolatorAtomInfo.getEquality();
            Map<SymmetricPair<Term>, Term> map = term2 != term ? this.mEqualities : this.mDisequalities;
            map.put(new SymmetricPair<Term>(applicationTerm.getParameters()[0], applicationTerm.getParameters()[1]), term2);
            ++n2;
        }
        term = this.getDiseq(this.mLemmaInfo);
        Term[] termArray = term.getParameters();
        this.mDiseq = this.mDisequalities.get(new SymmetricPair<Term>(termArray[0], termArray[1]));
        this.mDiseqInfo = this.mInterpolator.getAtomOccurenceInfo(this.mDiseq);
        Term[] termArray2 = new Term[this.mNumInterpolants];
        if (this.mLemmaInfo.getLemmaType().equals(":read-over-weakeq")) {
            termArray2 = this.computeReadOverWeakeqInterpolants();
        } else if (this.mLemmaInfo.getLemmaType().equals(":weakeq-ext")) {
            termArray2 = this.computeWeakeqExtInterpolants();
        } else if (this.mLemmaInfo.getLemmaType().equals(":const-weakeq")) {
            termArray2 = this.computeConstWeakeqInterpolants();
        } else {
            assert (this.mLemmaInfo.getLemmaType().equals(":read-const-weakeq")) : "Unknown array lemma!";
            termArray2 = this.computeReadConstWeakeqInterpolants();
        }
        formulaUnLet = new FormulaUnLet();
        int n3 = 0;
        while (n3 < this.mNumInterpolants) {
            termArray2[n3] = formulaUnLet.unlet(termArray2[n3]);
            ++n3;
        }
        return termArray2;
    }

    private Term[] computeReadOverWeakeqInterpolants() {
        Term term;
        ProofPath[] proofPathArray = this.getPaths(this.mLemmaInfo);
        assert (proofPathArray.length == 1);
        this.mStorePath = proofPathArray[0];
        assert (this.mDiseq != null);
        ApplicationTerm applicationTerm = (ApplicationTerm)this.mDiseq;
        assert (applicationTerm.getFunction().getName().equals("=") && applicationTerm.getParameters()[0] instanceof ApplicationTerm && applicationTerm.getParameters()[1] instanceof ApplicationTerm && ((ApplicationTerm)applicationTerm.getParameters()[0]).getFunction().getName().equals("select") && ((ApplicationTerm)applicationTerm.getParameters()[1]).getFunction().getName().equals("select"));
        Term term2 = ((ApplicationTerm)applicationTerm.getParameters()[0]).getParameters()[1];
        if (term2 != (term = ((ApplicationTerm)applicationTerm.getParameters()[1]).getParameters()[1])) {
            this.mIndexEquality = this.mEqualities.get(new SymmetricPair<Term>(term2, term));
            assert (this.mIndexEquality != null);
        }
        WeakPathInfo weakPathInfo = new WeakPathInfo(this.mStorePath);
        this.determineInterpolationColor();
        weakPathInfo.mSharedIndex = this.findSharedTerms(this.mStorePath.getIndex());
        this.mInterpolants = weakPathInfo.interpolateWeakPathInfo(true);
        if (this.mIndexEquality != null) {
            this.addIndexEqualityReadOverWeakeq(weakPathInfo);
        }
        Term[] termArray = new Term[this.mNumInterpolants];
        int n = 0;
        while (n < this.mNumInterpolants) {
            if (this.mABSwitchOccur.isALocal(n)) {
                assert (this.mDiseqInfo.isALocal(n));
                termArray[n] = this.mTheory.or(this.mInterpolants[n].toArray(new Term[this.mInterpolants[n].size()]));
            } else {
                termArray[n] = this.mTheory.and(this.mInterpolants[n].toArray(new Term[this.mInterpolants[n].size()]));
            }
            ++n;
        }
        return termArray;
    }

    private Term[] computeWeakeqExtInterpolants() {
        ProofPath[] proofPathArray = this.getPaths(this.mLemmaInfo);
        this.mStorePath = proofPathArray[0];
        this.mIndexPaths = new HashMap<Term, ProofPath>();
        this.mIndexPathInfos = new HashMap<Term, WeakPathInfo>();
        int n = 1;
        while (n < proofPathArray.length) {
            if (proofPathArray[n].getIndex() != null) {
                this.mIndexPaths.put(proofPathArray[n].getIndex(), proofPathArray[n]);
            }
            ++n;
        }
        this.mDoubleDot = this.mTheory.createFreshTermVariable("ddot", this.mIndexPaths.keySet().iterator().next().getSort());
        if (this.mDiseqInfo.getMixedVar() != null) {
            this.mRewriteSide = new Term[this.mNumInterpolants];
            this.mRecursionVar = this.mTheory.createFreshTermVariable("recursive", this.mStorePath.getPath()[0].getSort());
            this.mRecIndexPathInfos = new HashMap<Term, WeakPathInfo>();
        } else {
            this.determineInterpolationColor();
        }
        WeakPathInfo weakPathInfo = new WeakPathInfo(this.mStorePath);
        weakPathInfo.collectStorePaths();
        this.mInterpolants = weakPathInfo.interpolateStorePathInfoExt();
        Term[] termArray = new Term[this.mNumInterpolants];
        int n2 = 0;
        while (n2 < this.mNumInterpolants) {
            if (!this.mDiseqInfo.isMixed(n2)) {
                termArray[n2] = this.mDiseqInfo.isALocal(n2) ? this.mTheory.or(this.mInterpolants[n2].toArray(new Term[this.mInterpolants[n2].size()])) : this.mTheory.and(this.mInterpolants[n2].toArray(new Term[this.mInterpolants[n2].size()]));
            } else {
                assert (this.mInterpolants[n2].size() == 1);
                termArray[n2] = this.mInterpolants[n2].iterator().next();
            }
            ++n2;
        }
        return termArray;
    }

    private Term[] computeConstWeakeqInterpolants() {
        ProofPath[] proofPathArray = this.getPaths(this.mLemmaInfo);
        assert (proofPathArray.length == 1);
        this.mStorePath = proofPathArray[0];
        if (this.mDiseqInfo.getMixedVar() != null) {
            this.mRewriteSide = new Term[this.mNumInterpolants];
        } else {
            this.determineInterpolationColor();
        }
        WeakPathInfo weakPathInfo = new WeakPathInfo(this.mStorePath);
        weakPathInfo.collectStorePaths();
        this.mInterpolants = weakPathInfo.interpolateStorePathInfoConst();
        Term[] termArray = new Term[this.mNumInterpolants];
        int n = 0;
        while (n < this.mNumInterpolants) {
            termArray[n] = this.mABSwitchOccur.isALocal(n) ? this.mTheory.or(this.mInterpolants[n].toArray(new Term[this.mInterpolants[n].size()])) : this.mTheory.and(this.mInterpolants[n].toArray(new Term[this.mInterpolants[n].size()]));
            ++n;
        }
        return termArray;
    }

    private Term[] computeReadConstWeakeqInterpolants() {
        ProofPath[] proofPathArray = this.getPaths(this.mLemmaInfo);
        assert (proofPathArray.length == 1);
        this.mStorePath = proofPathArray[0];
        WeakPathInfo weakPathInfo = new WeakPathInfo(this.mStorePath);
        this.determineInterpolationColor();
        Term term = this.mStorePath.getIndex();
        int n = 0;
        while (n < this.mNumInterpolants) {
            Interpolator.Occurrence occurrence = this.mInterpolator.getOccurrence(term);
            if (occurrence.isAB(n)) {
                weakPathInfo.mSharedIndex[n] = term;
            }
            ++n;
        }
        this.mInterpolants = weakPathInfo.interpolateWeakPathInfo(true);
        Term[] termArray = new Term[this.mNumInterpolants];
        int n2 = 0;
        while (n2 < this.mNumInterpolants) {
            termArray[n2] = this.mABSwitchOccur.isALocal(n2) ? this.mTheory.or(this.mInterpolants[n2].toArray(new Term[this.mInterpolants[n2].size()])) : this.mTheory.and(this.mInterpolants[n2].toArray(new Term[this.mInterpolants[n2].size()]));
            ++n2;
        }
        return termArray;
    }

    private void determineInterpolationColor() {
        int n = this.mNumInterpolants;
        if (this.mLemmaInfo.getLemmaType().equals(":read-over-weakeq") || this.mDiseqInfo.getMixedVar() == null) {
            int n2;
            while ((n2 = this.getChild(n, this.mDiseqInfo)) >= 0) {
                assert (this.mDiseqInfo.isALocal(n2));
                n = n2;
            }
        } else if (this.mLemmaInfo.getLemmaType().equals(":read-const-weakeq")) {
            int n3;
            Term term;
            InterpolatorAtomInfo interpolatorAtomInfo = this.mInterpolator.getAtomTermInfo(this.mDiseq);
            ApplicationTerm applicationTerm = interpolatorAtomInfo.getEquality();
            Term term2 = applicationTerm.getParameters()[0];
            Term term3 = applicationTerm.getParameters()[1];
            if (term2 instanceof ApplicationTerm && ((ApplicationTerm)term2).getFunction().getName().equals("select")) {
                term = term2;
            } else {
                assert (term3 instanceof ApplicationTerm && ((ApplicationTerm)term3).getFunction().getName().equals("select"));
                term = term3;
            }
            Interpolator.Occurrence occurrence = this.mInterpolator.getOccurrence(term);
            while ((n3 = this.getChild(n, occurrence)) >= 0) {
                assert (occurrence.isALocal(n3));
                n = n3;
            }
        } else {
            n = 0;
            while (!this.mDiseqInfo.isALocal(n)) {
                if (this.mDiseqInfo.isMixed(n)) {
                    assert (this.mRewriteSide[n] != null);
                    Interpolator.Occurrence occurrence = this.mInterpolator.getOccurrence(this.mRewriteSide[n]);
                    if (occurrence.isALocal(n)) {
                        ++n;
                        continue;
                    }
                    break;
                }
                ++n;
            }
        }
        this.mABSwitchOccur.occursIn(n);
    }

    private Term[] findSharedTerms(Term term) {
        Term[] termArray = new Term[this.mNumInterpolants];
        Interpolator.Occurrence occurrence = this.mInterpolator.getOccurrence(term);
        int n = 0;
        int n2 = 0;
        while (n2 < this.mNumInterpolants) {
            if (occurrence.isAB(n2)) {
                termArray[n2] = term;
                ++n;
            }
            ++n2;
        }
        if (n == this.mNumInterpolants) {
            return termArray;
        }
        for (SymmetricPair<Term> symmetricPair : this.mEqualities.keySet()) {
            if (n == this.mNumInterpolants) {
                return termArray;
            }
            if (!symmetricPair.getFirst().equals(term) && !symmetricPair.getSecond().equals(term)) continue;
            Interpolator.LitInfo litInfo = this.mInterpolator.getAtomOccurenceInfo(this.mEqualities.get(symmetricPair));
            int n3 = 0;
            while (n3 < this.mNumInterpolants) {
                Term term2;
                Interpolator.Occurrence occurrence2;
                if (litInfo.isMixed(n3)) {
                    termArray[n3] = litInfo.getMixedVar();
                } else if (termArray[n3] == null && (occurrence2 = this.mInterpolator.getOccurrence(term2 = symmetricPair.getFirst().equals(term) ? symmetricPair.getSecond() : symmetricPair.getFirst())).isAB(n3)) {
                    termArray[n3] = term2;
                }
                ++n3;
            }
        }
        return termArray;
    }

    private void addIndexEqualityReadOverWeakeq(WeakPathInfo weakPathInfo) {
        Interpolator.LitInfo litInfo = this.mInterpolator.getAtomOccurenceInfo(this.mIndexEquality);
        InterpolatorAtomInfo interpolatorAtomInfo = this.mInterpolator.getAtomTermInfo(this.mDiseq);
        ApplicationTerm applicationTerm = interpolatorAtomInfo.getEquality();
        Term term = ArrayInterpolator.getIndexFromSelect(applicationTerm.getParameters()[0]).equals(this.mStorePath.getIndex()) ? ArrayInterpolator.getIndexFromSelect(applicationTerm.getParameters()[1]) : ArrayInterpolator.getIndexFromSelect(applicationTerm.getParameters()[0]);
        Interpolator.Occurrence occurrence = this.mInterpolator.getOccurrence(term);
        int n = 0;
        while (n < this.mNumInterpolants) {
            if (weakPathInfo.mSharedIndex[n] != null && weakPathInfo.mSharedIndex[n] == this.mStorePath.getIndex()) {
                if (this.mDiseqInfo.isALocal(n) && litInfo.isBLocal(n)) {
                    this.mInterpolants[n].add(this.mTheory.not(this.mIndexEquality));
                } else if (!this.mDiseqInfo.isALocal(n) && litInfo.isALocal(n) && occurrence.isAB(n)) {
                    this.mInterpolants[n].add(this.mIndexEquality);
                }
            }
            ++n;
        }
    }

    private int getParent(int n) {
        int n2 = n + 1;
        while (this.mInterpolator.mStartOfSubtrees[n2] > n) {
            ++n2;
        }
        return n2;
    }

    private int getChild(int n, Interpolator.Occurrence occurrence) {
        int n2 = n - 1;
        while (n2 >= this.mInterpolator.mStartOfSubtrees[n]) {
            if (occurrence.isALocal(n2)) {
                return n2;
            }
            n2 = this.mInterpolator.mStartOfSubtrees[n2] - 1;
        }
        return -1;
    }

    private static boolean isSelectTerm(Term term) {
        if (term instanceof ApplicationTerm) {
            return ((ApplicationTerm)term).getFunction().getName().equals("select");
        }
        return false;
    }

    private static boolean isStoreTerm(Term term) {
        if (term instanceof ApplicationTerm) {
            return ((ApplicationTerm)term).getFunction().getName().equals("store");
        }
        return false;
    }

    private static boolean isConstArray(Term term) {
        if (term instanceof ApplicationTerm) {
            return ((ApplicationTerm)term).getFunction().getName().equals("const");
        }
        return false;
    }

    private static Term getArrayFromSelect(Term term) {
        assert (ArrayInterpolator.isSelectTerm(term));
        return ((ApplicationTerm)term).getParameters()[0];
    }

    private static Term getIndexFromSelect(Term term) {
        assert (ArrayInterpolator.isSelectTerm(term));
        return ((ApplicationTerm)term).getParameters()[1];
    }

    private static Term getArrayFromStore(Term term) {
        assert (ArrayInterpolator.isStoreTerm(term));
        return ((ApplicationTerm)term).getParameters()[0];
    }

    private static Term getIndexFromStore(Term term) {
        assert (ArrayInterpolator.isStoreTerm(term));
        return ((ApplicationTerm)term).getParameters()[1];
    }

    private static Term getValueFromConst(Term term) {
        assert (ArrayInterpolator.isConstArray(term));
        return ((ApplicationTerm)term).getParameters()[0];
    }

    private Term buildConst(Term term, Sort sort) {
        FunctionSymbol functionSymbol = this.mTheory.getFunctionWithResult("const", null, sort, new Sort[]{term.getSort()});
        return this.mTheory.term(functionSymbol, new Term[]{term});
    }

    private Term buildSelectEq(Term term, Term term2, Term term3) {
        if (term.equals(this.mDiseq)) {
            return this.mTheory.term("@EQ", new Term[]{this.mDiseqInfo.getMixedVar(), this.buildSelect(term2, term3)});
        }
        if (term2.equals(this.mDiseq)) {
            return this.mTheory.term("@EQ", new Term[]{this.mDiseqInfo.getMixedVar(), this.buildSelect(term, term3)});
        }
        Term term4 = this.buildSelect(term, term3);
        Term term5 = this.buildSelect(term2, term3);
        return this.mTheory.equals(new Term[]{term4, term5});
    }

    private Term buildSelect(Term term, Term term2) {
        Term term3;
        if (this.mEqualities.containsValue(term)) {
            Interpolator.LitInfo litInfo = this.mInterpolator.getAtomOccurenceInfo(term);
            term3 = litInfo.getMixedVar();
        } else {
            term3 = ArrayInterpolator.isConstArray(term) ? ArrayInterpolator.getValueFromConst(term) : this.mTheory.term("select", new Term[]{term, term2});
        }
        return term3;
    }

    private Term buildWeqTerm(Term term, Term term2, int n, Term term3, TermVariable termVariable) {
        Term term4 = term;
        ApplicationTerm applicationTerm = this.mTheory.mTrue;
        int n2 = 0;
        while (n2 < n) {
            Term term5 = this.mTheory.equals(new Term[]{term4, term2});
            Term term6 = this.mTheory.term("@diff", new Term[]{term4, term2});
            Term term7 = this.mTheory.let(termVariable, term6, term3);
            applicationTerm = this.mTheory.and(new Term[]{applicationTerm, this.mTheory.or(new Term[]{term5, term7})});
            term4 = this.mTheory.term("store", new Term[]{term4, term6, this.buildSelect(term2, term6)});
            ++n2;
        }
        applicationTerm = this.mTheory.and(new Term[]{applicationTerm, this.mTheory.equals(new Term[]{term4, term2})});
        return applicationTerm;
    }

    private Term buildNweqTerm(Term term, Term term2, int n, Term term3, TermVariable termVariable) {
        Term term4 = term;
        ApplicationTerm applicationTerm = this.mTheory.mFalse;
        int n2 = 0;
        while (n2 < n) {
            Term term5 = this.mTheory.not(this.mTheory.equals(new Term[]{term4, term2}));
            Term term6 = this.mTheory.term("@diff", new Term[]{term4, term2});
            Term term7 = this.mTheory.let(termVariable, term6, term3);
            applicationTerm = this.mTheory.or(new Term[]{applicationTerm, this.mTheory.and(new Term[]{term5, term7})});
            term4 = this.mTheory.term("store", new Term[]{term4, term6, this.buildSelect(term2, term6)});
            ++n2;
        }
        applicationTerm = this.mTheory.or(new Term[]{applicationTerm, this.mTheory.not(this.mTheory.equals(new Term[]{term4, term2}))});
        return applicationTerm;
    }

    private Term buildConstPathInterpolant(boolean bl, Term term, Set<Term> set, TermVariable termVariable, int n, Term term2) {
        Term term32;
        TermVariable termVariable2 = this.mTheory.createFreshTermVariable("vTilde", this.mDiseqInfo.getMixedVar().getSort());
        Term term4 = this.mTheory.term("@EQ", new Term[]{this.mDiseqInfo.getMixedVar(), termVariable2});
        Term term5 = bl ? this.buildWeqTerm(this.buildConst((Term)termVariable2, term.getSort()), term, n, term2, termVariable) : this.buildNweqTerm(this.buildConst((Term)termVariable2, term.getSort()), term, n, term2, termVariable);
        Term term6 = bl ? this.mTheory.and(new Term[]{term4, term5}) : this.mTheory.or(new Term[]{term4, term5});
        Term term7 = this.mTheory.term("@diff", new Term[]{term, term});
        Term term8 = this.buildSelect(term, term7);
        Term term9 = this.buildConst(term8, term.getSort());
        for (Term term32 : set) {
            term9 = this.mTheory.term("store", new Term[]{term9, term32, this.buildSelect(term, term32)});
        }
        term32 = this.mTheory.let(termVariable2, term8, term6);
        int n2 = 0;
        while (n2 < n) {
            term7 = this.mTheory.term("@diff", new Term[]{term9, term});
            term8 = this.buildSelect(term, term7);
            term32 = bl ? this.mTheory.or(new Term[]{term32, this.mTheory.let(termVariable2, term8, term6)}) : this.mTheory.and(new Term[]{term32, this.mTheory.let(termVariable2, term8, term6)});
            term9 = this.mTheory.term("store", new Term[]{term9, term7, this.buildSelect(term, term7)});
            ++n2;
        }
        return term32;
    }

    class ProofPath {
        private final Term mPathIndex;
        private final Term[] mPath;

        private ProofPath(String string, Object object) {
            if (string.equals(":subpath")) {
                this.mPathIndex = null;
                this.mPath = (Term[])object;
            } else {
                assert (string.equals(":weakpath"));
                Object[] objectArray = (Object[])object;
                this.mPathIndex = (Term)objectArray[0];
                this.mPath = (Term[])objectArray[1];
            }
        }

        public Term getIndex() {
            return this.mPathIndex;
        }

        public Term[] getPath() {
            return this.mPath;
        }
    }

    private class StorePath {
        final Term mLeft;
        final Term mRight;
        final Set<Term> mStores;
        final boolean mIsAPath;

        public StorePath(Term term, Term term2, Set<Term> set, boolean bl) {
            this.mLeft = term;
            this.mRight = term2;
            this.mStores = set;
            this.mIsAPath = bl;
        }
    }

    class WeakPathInfo {
        Term mPathIndex;
        Term[] mSharedIndex;
        Term[] mPath;
        BitSet mHasABPath;
        int mMaxColor;
        WeakPathEnd mHead;
        WeakPathEnd mTail;
        private final Set<Term>[] mPathInterpolants;
        private Vector<Term> mStores;
        private Vector<StorePath>[] mStorePaths;

        public WeakPathInfo(ProofPath proofPath) {
            this.mPathIndex = proofPath.getIndex();
            this.mSharedIndex = new Term[ArrayInterpolator.this.mNumInterpolants];
            this.mPath = proofPath.getPath();
            this.mHasABPath = new BitSet(ArrayInterpolator.this.mNumInterpolants);
            this.mHasABPath.set(0, ArrayInterpolator.this.mNumInterpolants);
            this.mMaxColor = ArrayInterpolator.this.mNumInterpolants;
            this.mPathInterpolants = new Set[ArrayInterpolator.this.mNumInterpolants];
            int n = 0;
            while (n < ArrayInterpolator.this.mNumInterpolants) {
                this.mPathInterpolants[n] = new HashSet<Term>();
                ++n;
            }
        }

        public Set<Term>[] interpolateWeakPathInfo(boolean bl) {
            Term term;
            Term term2;
            Object object;
            Object object2;
            this.mHead = new WeakPathEnd();
            this.mTail = new WeakPathEnd();
            String string = ArrayInterpolator.this.mLemmaInfo.getLemmaType();
            if (string.equals(":read-over-weakeq") || string.equals(":read-const-weakeq")) {
                object2 = ArrayInterpolator.this.mInterpolator.getAtomTermInfo(ArrayInterpolator.this.mDiseq);
                object = ((InterpolatorAtomInfo)object2).getEquality().getParameters();
                if (ArrayInterpolator.isSelectTerm(object[0]) && ArrayInterpolator.getArrayFromSelect(object[0]).equals(this.mPath[0]) || ArrayInterpolator.isConstArray(this.mPath[0]) && ArrayInterpolator.getValueFromConst(this.mPath[0]).equals(object[0])) {
                    term2 = object[0];
                    term = object[1];
                } else {
                    term2 = object[1];
                    term = object[0];
                }
            } else {
                assert (string.equals(":weakeq-ext"));
                term2 = this.mPath[0];
                term = this.mPath[this.mPath.length - 1];
            }
            object2 = ArrayInterpolator.this.mInterpolator.getOccurrence(term2);
            object = ArrayInterpolator.this.mInterpolator.getOccurrence(term);
            this.mTail.closeAPath(this.mHead, null, (Interpolator.Occurrence)object2);
            this.mTail.openAPath(this.mHead, null, (Interpolator.Occurrence)object2);
            int n = 0;
            while (n < this.mPath.length - 1) {
                Term term3 = this.mPath[n];
                Term term4 = this.mPath[n + 1];
                Term term5 = ArrayInterpolator.this.mEqualities.get(new SymmetricPair<Term>(term3, term4));
                Term term6 = term3;
                if (term5 == null) {
                    if (!ArrayInterpolator.this.mLemmaInfo.getLemmaType().equals(":weakeq-ext") || !this.checkAndAddSelectEdgeStep(term3, term4)) {
                        this.addStoreEdgeStep(term3, term4);
                    }
                } else {
                    Interpolator.LitInfo litInfo = ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo(term5);
                    this.mTail.closeAPath(this.mHead, term6, litInfo);
                    this.mTail.openAPath(this.mHead, term6, litInfo);
                    if (litInfo.getMixedVar() != null) {
                        Interpolator.Occurrence occurrence = ArrayInterpolator.this.mInterpolator.getOccurrence(term4);
                        term6 = litInfo.getMixedVar();
                        this.mTail.closeAPath(this.mHead, term6, occurrence);
                        this.mTail.openAPath(this.mHead, term6, occurrence);
                    }
                }
                ++n;
            }
            this.mTail.closeAPath(this.mHead, this.mPath[this.mPath.length - 1], (Interpolator.Occurrence)object);
            this.mTail.openAPath(this.mHead, this.mPath[this.mPath.length - 1], (Interpolator.Occurrence)object);
            if (bl) {
                this.addDiseq((Interpolator.Occurrence)object2, (Interpolator.Occurrence)object);
                this.closeWeakPath();
            } else {
                this.closeWeakPath();
            }
            return this.mPathInterpolants;
        }

        private void addStoreEdgeStep(Term term, Term term2) {
            Term term3;
            Term term4;
            if (ArrayInterpolator.isStoreTerm(term) && ArrayInterpolator.getArrayFromStore(term).equals(term2)) {
                term4 = term;
                term3 = term2;
            } else {
                term4 = term2;
                term3 = term;
            }
            assert (ArrayInterpolator.getArrayFromStore(term4).equals(term3));
            Term term5 = term;
            Interpolator.Occurrence occurrence = ArrayInterpolator.this.mInterpolator.getOccurrence(term4);
            Term term6 = ArrayInterpolator.getIndexFromStore(term4);
            Term term7 = ArrayInterpolator.this.mDisequalities.get(new SymmetricPair<Term>(term6, this.mPathIndex));
            if (term7 != null) {
                Interpolator.LitInfo litInfo = ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo(term7);
                Interpolator.Occurrence occurrence2 = occurrence.intersect(litInfo);
                this.mTail.closeAPath(this.mHead, term5, occurrence);
                this.mTail.closeAPath(this.mHead, term5, occurrence2);
                this.mTail.openAPath(this.mHead, term5, occurrence2);
                this.mTail.openAPath(this.mHead, term5, occurrence);
                this.mTail.addIndexDisequality(this.mHead, term7);
            } else {
                this.mTail.closeAPath(this.mHead, term5, occurrence);
                this.mTail.openAPath(this.mHead, term5, occurrence);
            }
        }

        private boolean checkAndAddSelectEdgeStep(Term term, Term term2) {
            Interpolator.Occurrence occurrence;
            MatchingSelectEquality matchingSelectEquality = this.findSelectEquality(term, term2);
            if (matchingSelectEquality == null) {
                return false;
            }
            Term term3 = matchingSelectEquality.mEqualityLit;
            InterpolatorAtomInfo interpolatorAtomInfo = ArrayInterpolator.this.mInterpolator.getAtomTermInfo(term3);
            Interpolator.LitInfo litInfo = ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo(term3);
            ApplicationTerm applicationTerm = interpolatorAtomInfo.getEquality();
            Term term4 = applicationTerm.getParameters()[matchingSelectEquality.mIsSwapped ? 1 : 0];
            Term term5 = applicationTerm.getParameters()[matchingSelectEquality.mIsSwapped ? 0 : 1];
            Term term6 = term;
            this.mTail.closeAPath(this.mHead, term6, litInfo);
            this.mTail.openAPath(this.mHead, term6, litInfo);
            TermVariable termVariable = litInfo.getMixedVar();
            if (termVariable != null) {
                occurrence = ArrayInterpolator.this.mInterpolator.getOccurrence(term4);
                this.mTail.closeAPath(this.mHead, term6, occurrence);
                this.mTail.openAPath(this.mHead, term6, occurrence);
            }
            if (!matchingSelectEquality.mIsConstLeft) {
                this.mTail.addSelectIndexEquality(this.mHead, term4);
            }
            if (termVariable != null) {
                occurrence = ArrayInterpolator.this.mInterpolator.getOccurrence(term5);
                term6 = matchingSelectEquality.mIsConstLeft || matchingSelectEquality.mIsConstRight ? ArrayInterpolator.this.buildConst((Term)termVariable, term.getSort()) : term3;
                this.mTail.closeAPath(this.mHead, term6, occurrence);
                this.mTail.openAPath(this.mHead, term6, occurrence);
            }
            if (!matchingSelectEquality.mIsConstRight) {
                this.mTail.addSelectIndexEquality(this.mHead, term5);
            }
            return true;
        }

        public void collectStorePaths() {
            Object object;
            Object object2;
            this.mStores = new Vector();
            this.mStorePaths = new Vector[ArrayInterpolator.this.mNumInterpolants];
            int n = 0;
            while (n < ArrayInterpolator.this.mNumInterpolants) {
                this.mStorePaths[n] = new Vector();
                ++n;
            }
            this.mHead = new WeakPathEnd();
            this.mTail = new WeakPathEnd();
            Term term = this.mPath[0];
            Term term2 = this.mPath[this.mPath.length - 1];
            Interpolator.Occurrence occurrence = ArrayInterpolator.this.mInterpolator.getOccurrence(term);
            Interpolator.Occurrence occurrence2 = ArrayInterpolator.this.mInterpolator.getOccurrence(term2);
            this.mTail.closeAPath(this.mHead, null, occurrence);
            this.mTail.openAPath(this.mHead, null, occurrence);
            int n2 = 0;
            while (n2 < this.mPath.length - 1) {
                object2 = this.mPath[n2];
                object = this.mPath[n2 + 1];
                Term term3 = ArrayInterpolator.this.mEqualities.get(new SymmetricPair<Term>((Term)object2, (Term)object));
                Term term4 = object2;
                if (term3 == null) {
                    if (ArrayInterpolator.isStoreTerm(object2) && ArrayInterpolator.getArrayFromStore(object2).equals(object)) {
                        var10_14 = object2;
                        var11_15 = object;
                    } else {
                        var10_14 = object;
                        var11_15 = object2;
                    }
                    assert (ArrayInterpolator.getArrayFromStore((Term)var10_14).equals(var11_15));
                    Term term5 = ArrayInterpolator.getIndexFromStore((Term)var10_14);
                    Interpolator.Occurrence occurrence3 = ArrayInterpolator.this.mInterpolator.getOccurrence((Term)var10_14);
                    this.mTail.closeAPath(this.mHead, term4, occurrence3);
                    this.mTail.openAPath(this.mHead, term4, occurrence3);
                    this.mTail.addMainStoreIndex(this.mHead, term5);
                    this.mStores.add(term5);
                } else {
                    var10_14 = ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo(term3);
                    this.mTail.closeAPath(this.mHead, term4, (Interpolator.Occurrence)var10_14);
                    this.mTail.openAPath(this.mHead, term4, (Interpolator.Occurrence)var10_14);
                    if (((Interpolator.LitInfo)var10_14).getMixedVar() != null) {
                        var11_15 = ArrayInterpolator.this.mInterpolator.getOccurrence((Term)object);
                        term4 = ((Interpolator.LitInfo)var10_14).getMixedVar();
                        this.mTail.closeAPath(this.mHead, term4, (Interpolator.Occurrence)var11_15);
                        this.mTail.openAPath(this.mHead, term4, (Interpolator.Occurrence)var11_15);
                    }
                }
                ++n2;
            }
            this.mTail.closeAPath(this.mHead, this.mPath[this.mPath.length - 1], occurrence2);
            this.mTail.openAPath(this.mHead, this.mPath[this.mPath.length - 1], occurrence2);
            this.addDiseq(occurrence, occurrence2);
            this.closeWeakeqExt(occurrence, occurrence2);
            if (ArrayInterpolator.this.mDiseqInfo.getMixedVar() != null) {
                n2 = 0;
                while (n2 < ArrayInterpolator.this.mNumInterpolants) {
                    if (ArrayInterpolator.this.mDiseqInfo.isMixed(n2)) {
                        object2 = this.mStorePaths[n2].get(0);
                        object = this.mStorePaths[n2].get(this.mStorePaths[n2].size() - 1);
                        int n3 = object2.mStores != null ? object2.mStores.size() : 0;
                        int n4 = object.mStores != null ? object.mStores.size() : 0;
                        ArrayInterpolator.this.mRewriteSide[n2] = n3 <= n4 ? this.mPath[0] : this.mPath[this.mPath.length - 1];
                    }
                    ++n2;
                }
                ArrayInterpolator.this.determineInterpolationColor();
            }
        }

        public Set<Term>[] interpolateStorePathInfoExt() {
            Object object;
            Object object3;
            assert (this.mStorePaths != null);
            int n = 0;
            while (n < this.mStores.size()) {
                object3 = this.mStores.get(n);
                Interpolator.Occurrence object22 = ArrayInterpolator.this.mInterpolator.getOccurrence((Term)object3);
                if (!ArrayInterpolator.this.mIndexPathInfos.containsKey(object3)) {
                    object = new WeakPathInfo(ArrayInterpolator.this.mIndexPaths.get(object3));
                    Term[] termArray = ArrayInterpolator.this.findSharedTerms((Term)object3);
                    ((WeakPathInfo)object).mSharedIndex = termArray;
                    int n2 = 0;
                    while (n2 < ArrayInterpolator.this.mNumInterpolants) {
                        if (termArray[n2] == null && (object22.isALocal(n2) && ArrayInterpolator.this.mABSwitchOccur.isBLocal(n2) || object22.isBLocal(n2) && ArrayInterpolator.this.mABSwitchOccur.isALocal(n2))) {
                            ((WeakPathInfo)object).mSharedIndex[n2] = ArrayInterpolator.this.mDoubleDot;
                        }
                        ++n2;
                    }
                    ((WeakPathInfo)object).interpolateWeakPathInfo(true);
                    ArrayInterpolator.this.mIndexPathInfos.put((Term)object3, (WeakPathInfo)object);
                }
                ++n;
            }
            n = 0;
            while (n < ArrayInterpolator.this.mNumInterpolants) {
                object3 = null;
                for (StorePath storePath : this.mStorePaths[n]) {
                    if (ArrayInterpolator.this.mDiseqInfo.isMixed(n) && ArrayInterpolator.this.mRewriteSide[n] == this.mPath[0] && storePath.mLeft == null || ArrayInterpolator.this.mDiseqInfo.isMixed(n) && ArrayInterpolator.this.mRewriteSide[n] == this.mPath[this.mPath.length - 1] && storePath.mRight == null) {
                        object3 = storePath;
                        continue;
                    }
                    this.mTail.addInterpolantClauseExt(n, storePath);
                }
                if (ArrayInterpolator.this.mDiseqInfo.isMixed(n)) {
                    WeakPathEnd weakPathEnd = ArrayInterpolator.this.mRewriteSide[n] == this.mPath[0] ? this.mHead : this.mTail;
                    object = weakPathEnd == this.mHead ? this.mTail : this.mHead;
                    weakPathEnd.buildRecursiveInterpolant(n, (WeakPathEnd)object, (StorePath)object3);
                }
                ++n;
            }
            return this.mPathInterpolants;
        }

        public Set<Term>[] interpolateStorePathInfoConst() {
            assert (this.mStorePaths != null);
            int n = 0;
            while (n < ArrayInterpolator.this.mNumInterpolants) {
                boolean bl = !ArrayInterpolator.this.mABSwitchOccur.isALocal(n);
                for (StorePath storePath : this.mStorePaths[n]) {
                    Term term3;
                    Object object;
                    Term term2;
                    TermVariable termVariable;
                    HashSet<Term> hashSet = new HashSet<Term>();
                    int n2 = 0;
                    if (storePath.mStores != null) {
                        n2 = storePath.mStores.size();
                        termVariable = storePath.mStores.iterator();
                        while (termVariable.hasNext()) {
                            term2 = (Term)termVariable.next();
                            object = ArrayInterpolator.this.mInterpolator.getOccurrence(term2);
                            if (!((Interpolator.Occurrence)object).isAB(n)) continue;
                            hashSet.add(term2);
                            --n2;
                        }
                    }
                    TermVariable termVariable2 = termVariable = n2 == 0 ? null : ArrayInterpolator.this.mTheory.createFreshTermVariable("cdot", storePath.mStores.iterator().next().getSort());
                    if (storePath.mLeft != null && storePath.mRight != null) {
                        object = storePath.mLeft;
                        for (Term term3 : hashSet) {
                            object = ArrayInterpolator.this.mTheory.term("store", new Term[]{object, term3, ArrayInterpolator.this.buildSelect(storePath.mRight, term3)});
                        }
                        if (storePath.mIsAPath && bl) {
                            term2 = ArrayInterpolator.this.buildWeqTerm((Term)object, storePath.mRight, n2, (Term)ArrayInterpolator.this.mTheory.mTrue, termVariable);
                            this.mPathInterpolants[n].add(term2);
                            continue;
                        }
                        if (storePath.mIsAPath || bl) continue;
                        term2 = ArrayInterpolator.this.buildNweqTerm((Term)object, storePath.mRight, n2, (Term)ArrayInterpolator.this.mTheory.mFalse, termVariable);
                        this.mPathInterpolants[n].add(term2);
                        continue;
                    }
                    if ((!storePath.mIsAPath || !bl) && (storePath.mIsAPath || bl)) continue;
                    Object object2 = object = storePath.mLeft != null ? storePath.mLeft : storePath.mRight;
                    assert (object != null);
                    term3 = storePath.mIsAPath ? ArrayInterpolator.this.mTheory.mTrue : ArrayInterpolator.this.mTheory.mFalse;
                    term2 = ArrayInterpolator.this.buildConstPathInterpolant(storePath.mIsAPath, (Term)object, hashSet, termVariable, n2, term3);
                    this.mPathInterpolants[n].add(term2);
                }
                ++n;
            }
            return this.mPathInterpolants;
        }

        private MatchingSelectEquality findSelectEquality(Term term, Term term2) {
            for (SymmetricPair<Term> symmetricPair : ArrayInterpolator.this.mEqualities.keySet()) {
                Term term3;
                Term term4 = symmetricPair.getFirst();
                Term term5 = symmetricPair.getSecond();
                boolean bl = ArrayInterpolator.isSelectTerm(term4);
                boolean bl2 = ArrayInterpolator.isSelectTerm(term5);
                if (bl && bl2) {
                    if (this.isGoodSelect(term4, term) && this.isGoodSelect(term5, term2)) {
                        return new MatchingSelectEquality(ArrayInterpolator.this.mEqualities.get(symmetricPair), false, false, false);
                    }
                    if (this.isGoodSelect(term5, term) && this.isGoodSelect(term4, term2)) {
                        return new MatchingSelectEquality(ArrayInterpolator.this.mEqualities.get(symmetricPair), true, false, false);
                    }
                }
                if (ArrayInterpolator.isConstArray(term)) {
                    term3 = ArrayInterpolator.getValueFromConst(term);
                    if (term4 == term3 && bl2 && this.isGoodSelect(term5, term2)) {
                        return new MatchingSelectEquality(ArrayInterpolator.this.mEqualities.get(symmetricPair), false, true, false);
                    }
                    if (term5 == term3 && bl && this.isGoodSelect(term4, term2)) {
                        return new MatchingSelectEquality(ArrayInterpolator.this.mEqualities.get(symmetricPair), true, true, false);
                    }
                }
                if (!ArrayInterpolator.isConstArray(term2)) continue;
                term3 = ArrayInterpolator.getValueFromConst(term2);
                if (term4 == term3 && bl2 && this.isGoodSelect(term5, term)) {
                    return new MatchingSelectEquality(ArrayInterpolator.this.mEqualities.get(symmetricPair), true, false, true);
                }
                if (term5 != term3 || !bl || !this.isGoodSelect(term4, term)) continue;
                return new MatchingSelectEquality(ArrayInterpolator.this.mEqualities.get(symmetricPair), false, false, true);
            }
            return null;
        }

        private boolean isGoodSelect(Term term, Term term2) {
            if (ArrayInterpolator.getArrayFromSelect(term) == term2) {
                Term term3 = ArrayInterpolator.getIndexFromSelect(term);
                return term3 == this.mPathIndex || ArrayInterpolator.this.mEqualities.containsKey(new SymmetricPair<Term>(term3, this.mPathIndex));
            }
            return false;
        }

        public void addDiseq(Interpolator.Occurrence occurrence, Interpolator.Occurrence occurrence2) {
            Term term = this.mPath[0];
            Term term2 = this.mPath[this.mPath.length - 1];
            if (ArrayInterpolator.this.mDiseqInfo.getMixedVar() == null) {
                this.mTail.closeAPath(this.mHead, term2, ArrayInterpolator.this.mABSwitchOccur);
                this.mTail.openAPath(this.mHead, term2, ArrayInterpolator.this.mABSwitchOccur);
                this.mHead.closeAPath(this.mTail, term, ArrayInterpolator.this.mABSwitchOccur);
                this.mHead.openAPath(this.mTail, term, ArrayInterpolator.this.mABSwitchOccur);
            } else {
                this.mTail.closeAPath(this.mHead, term2, occurrence2);
                this.mTail.openAPath(this.mHead, term2, occurrence2);
                this.mTail.closeAPath(this.mHead, term2, ArrayInterpolator.this.mDiseqInfo);
                this.mTail.openAPath(this.mHead, term2, ArrayInterpolator.this.mDiseqInfo);
                this.mHead.closeAPath(this.mTail, term, occurrence);
                this.mHead.openAPath(this.mTail, term, occurrence);
                this.mHead.closeAPath(this.mTail, term, ArrayInterpolator.this.mDiseqInfo);
                this.mHead.openAPath(this.mTail, term, ArrayInterpolator.this.mDiseqInfo);
                if (ArrayInterpolator.this.mLemmaInfo.getLemmaType().equals(":read-over-weakeq")) {
                    if (ArrayInterpolator.this.mIndexEquality != null) {
                        Interpolator.LitInfo litInfo = ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo(ArrayInterpolator.this.mIndexEquality);
                        this.mTail.addSelectIndexEqAllColors(this.mHead, litInfo, ArrayInterpolator.this.mIndexEquality);
                    }
                    this.mTail.closeAPath(this.mHead, ArrayInterpolator.this.mDiseq, occurrence);
                    this.mHead.closeAPath(this.mTail, ArrayInterpolator.this.mDiseq, occurrence2);
                } else if (ArrayInterpolator.this.mLemmaInfo.getLemmaType().equals(":read-const-weakeq") || ArrayInterpolator.this.mLemmaInfo.getLemmaType().equals(":const-weakeq")) {
                    this.mTail.closeAPath(this.mHead, ArrayInterpolator.this.mDiseq, ArrayInterpolator.this.mABSwitchOccur);
                    this.mTail.openAPath(this.mHead, ArrayInterpolator.this.mDiseq, ArrayInterpolator.this.mABSwitchOccur);
                    this.mHead.closeAPath(this.mTail, ArrayInterpolator.this.mDiseq, ArrayInterpolator.this.mABSwitchOccur);
                    this.mHead.openAPath(this.mTail, ArrayInterpolator.this.mDiseq, ArrayInterpolator.this.mABSwitchOccur);
                } else if (this.mPathIndex != null) {
                    this.mTail.closeAPath(this.mHead, (Term)ArrayInterpolator.this.mRecursionVar, ArrayInterpolator.this.mABSwitchOccur);
                    this.mTail.openAPath(this.mHead, (Term)ArrayInterpolator.this.mRecursionVar, ArrayInterpolator.this.mABSwitchOccur);
                    this.mHead.closeAPath(this.mTail, (Term)ArrayInterpolator.this.mRecursionVar, ArrayInterpolator.this.mABSwitchOccur);
                    this.mHead.openAPath(this.mTail, (Term)ArrayInterpolator.this.mRecursionVar, ArrayInterpolator.this.mABSwitchOccur);
                }
            }
        }

        private void closeWeakPath() {
            int n = 0;
            while (n < ArrayInterpolator.this.mNumInterpolants) {
                if (ArrayInterpolator.this.mABSwitchOccur.isALocal(n)) {
                    assert (ArrayInterpolator.this.mDiseqInfo.isALocal(n) || !ArrayInterpolator.this.mLemmaInfo.getLemmaType().equals(":read-over-weakeq"));
                    if (this.mHead.mTerm[n] != null) {
                        this.mHead.addInterpolantClausePathSeg(true, n, null);
                    }
                    if (this.mTail.mTerm[n] != null) {
                        this.mTail.addInterpolantClausePathSeg(true, n, null);
                    }
                    if (this.mHead.mLastChange[n] == null && this.mTail.mLastChange[n] == null) {
                        this.mHead.addInterpolantClausePathSeg(true, n, null);
                    }
                } else {
                    if (this.mHead.mLastChange[n] != this.mHead.mTerm[n]) {
                        this.mHead.addInterpolantClausePathSeg(false, n, null);
                    }
                    if (this.mTail.mLastChange[n] != this.mTail.mTerm[n]) {
                        this.mTail.addInterpolantClausePathSeg(false, n, null);
                    }
                    if (this.mHead.mLastChange[n] == null && this.mTail.mLastChange[n] == null) {
                        this.mHead.addInterpolantClausePathSeg(false, n, null);
                    }
                }
                ++n;
            }
        }

        private void closeWeakeqExt(Interpolator.Occurrence occurrence, Interpolator.Occurrence occurrence2) {
            while (this.mHead.mColor < this.mMaxColor || this.mTail.mColor < this.mMaxColor) {
                if (this.mHead.mColor < this.mTail.mColor) {
                    if (ArrayInterpolator.this.mDiseqInfo.isMixed(this.mHead.mColor)) {
                        this.mHead.mColor = ArrayInterpolator.this.getParent(this.mHead.mColor);
                        continue;
                    }
                    this.mHead.closeSingleAPath(this.mTail, this.mPath[0]);
                    continue;
                }
                if (this.mHead.mColor == this.mTail.mColor) {
                    if (!ArrayInterpolator.this.mDiseqInfo.isALocal(this.mHead.mColor)) {
                        assert (ArrayInterpolator.this.mDiseqInfo.isAB(this.mHead.mColor));
                        this.mHead.closeSingleAPath(this.mTail, this.mPath[0]);
                        this.mTail.closeSingleAPath(this.mHead, this.mPath[this.mPath.length - 1]);
                        continue;
                    }
                    this.mHead.mColor = this.mTail.mColor = ArrayInterpolator.this.getParent(this.mHead.mColor);
                    continue;
                }
                if (ArrayInterpolator.this.mDiseqInfo.isMixed(this.mTail.mColor)) {
                    this.mTail.mColor = ArrayInterpolator.this.getParent(this.mTail.mColor);
                    continue;
                }
                this.mTail.closeSingleAPath(this.mHead, this.mPath[this.mPath.length - 1]);
            }
            int n = 0;
            while (n < ArrayInterpolator.this.mNumInterpolants) {
                if (ArrayInterpolator.this.mDiseqInfo.isALocal(n)) {
                    if (this.mHead.mTerm[n] != this.mPath[0]) {
                        this.mHead.addStorePathExt(true, n, null);
                    }
                    if (this.mTail.mTerm[n] != this.mPath[this.mPath.length - 1]) {
                        this.mTail.addStorePathExt(true, n, null);
                    }
                } else if (ArrayInterpolator.this.mDiseqInfo.isBorShared(n)) {
                    if (this.mHead.mLastChange[n] != this.mPath[0]) {
                        this.mHead.addStorePathExt(false, n, null);
                    }
                    if (this.mTail.mLastChange[n] != this.mPath[this.mPath.length - 1]) {
                        this.mTail.addStorePathExt(false, n, null);
                    }
                } else if (occurrence.isALocal(n)) {
                    if (this.mHead.mTerm[n] != this.mPath[0]) {
                        this.mHead.addStorePathExt(true, n, null);
                    }
                    if (this.mTail.mTerm[n] != this.mPath[this.mPath.length - 1]) {
                        this.mTail.addStorePathExt(false, n, null);
                    }
                } else {
                    if (this.mHead.mLastChange[n] != this.mPath[0]) {
                        this.mHead.addStorePathExt(false, n, null);
                    }
                    if (this.mTail.mLastChange[n] != this.mPath[this.mPath.length - 1]) {
                        this.mTail.addStorePathExt(true, n, null);
                    }
                }
                ++n;
            }
        }

        private Term buildFPiTerm(boolean bl, int n, Term term, ArrayList<Term> arrayList, ArrayList<Term> arrayList2) {
            Term term2;
            TermVariable termVariable;
            ApplicationTerm applicationTerm;
            Interpolator.LitInfo litInfo;
            InterpolatorAtomInfo interpolatorAtomInfo;
            Term term32;
            if (arrayList == null && arrayList2 == null) {
                return bl ? ArrayInterpolator.this.mTheory.mFalse : ArrayInterpolator.this.mTheory.mTrue;
            }
            HashSet<Term> hashSet = new HashSet<Term>();
            if (arrayList != null) {
                for (Term term32 : arrayList) {
                    interpolatorAtomInfo = ArrayInterpolator.this.mInterpolator.getAtomTermInfo(term32);
                    litInfo = ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo(term32);
                    applicationTerm = interpolatorAtomInfo.getEquality();
                    if (litInfo.isMixed(n)) {
                        termVariable = litInfo.getMixedVar();
                        term2 = ArrayInterpolator.this.mTheory.term("@EQ", new Term[]{termVariable, term});
                        hashSet.add(term2);
                        continue;
                    }
                    termVariable = applicationTerm.getParameters()[0].equals(this.mPathIndex) ? applicationTerm.getParameters()[1] : applicationTerm.getParameters()[0];
                    term2 = ArrayInterpolator.this.mTheory.equals(new Term[]{termVariable, term});
                    if (!bl && litInfo.isALocal(n)) {
                        term2 = ArrayInterpolator.this.mTheory.not(term2);
                    }
                    hashSet.add(term2);
                }
            }
            if (arrayList2 != null) {
                for (Term term32 : arrayList2) {
                    interpolatorAtomInfo = ArrayInterpolator.this.mInterpolator.getAtomTermInfo(term32);
                    litInfo = ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo(term32);
                    applicationTerm = interpolatorAtomInfo.getEquality();
                    termVariable = litInfo.isMixed(n) ? litInfo.getMixedVar() : (applicationTerm.getParameters()[0].equals(this.mPathIndex) ? applicationTerm.getParameters()[1] : applicationTerm.getParameters()[0]);
                    term2 = ArrayInterpolator.this.mTheory.equals(new Term[]{termVariable, term});
                    if (bl) {
                        term2 = ArrayInterpolator.this.mTheory.not(term2);
                    }
                    hashSet.add(term2);
                }
            }
            term32 = bl ? ArrayInterpolator.this.mTheory.or(hashSet.toArray(new Term[hashSet.size()])) : ArrayInterpolator.this.mTheory.and(hashSet.toArray(new Term[hashSet.size()]));
            return term32;
        }

        class MatchingSelectEquality {
            Term mEqualityLit;
            boolean mIsSwapped;
            boolean mIsConstLeft;
            boolean mIsConstRight;

            public MatchingSelectEquality(Term term, boolean bl, boolean bl2, boolean bl3) {
                this.mEqualityLit = term;
                this.mIsSwapped = bl;
                this.mIsConstLeft = bl2;
                this.mIsConstRight = bl3;
            }
        }

        class WeakPathEnd {
            int mColor;
            Term[] mTerm;
            Term[] mLastChange;
            ArrayList<Term>[] mIndexDiseqs;
            ArrayList<Term>[] mIndexEqs;
            Set<Term>[] mMainStores;

            public WeakPathEnd() {
                this.mColor = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mNumInterpolants;
                this.mTerm = new Term[((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mNumInterpolants];
                this.mLastChange = new Term[((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mNumInterpolants];
                if (WeakPathInfo.this.mPathIndex != null) {
                    this.mIndexDiseqs = new ArrayList[((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mNumInterpolants];
                    this.mIndexEqs = new ArrayList[((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mNumInterpolants];
                } else {
                    this.mMainStores = new Set[((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mNumInterpolants];
                }
            }

            public void closeAPath(WeakPathEnd weakPathEnd, Term term, Interpolator.Occurrence occurrence) {
                assert (weakPathEnd.mColor <= WeakPathInfo.this.mMaxColor);
                WeakPathInfo.this.mHasABPath.and(occurrence.mInA);
                while (this.mColor < ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mNumInterpolants && occurrence.isBLocal(this.mColor)) {
                    this.closeSingleAPath(weakPathEnd, term);
                }
            }

            public void openAPath(WeakPathEnd weakPathEnd, Term term, Interpolator.Occurrence occurrence) {
                int n;
                while ((n = ArrayInterpolator.this.getChild(this.mColor, occurrence)) >= 0) {
                    assert (occurrence.isALocal(n));
                    this.openSingleAPath(weakPathEnd, term, n);
                }
            }

            private void closeSingleAPath(WeakPathEnd weakPathEnd, Term term) {
                assert (WeakPathInfo.this.mHasABPath.isEmpty());
                int n = this.mColor;
                this.mColor = ArrayInterpolator.this.getParent(n);
                if (n < WeakPathInfo.this.mMaxColor) {
                    if (WeakPathInfo.this.mPathIndex != null) {
                        this.addInterpolantClausePathSeg(true, n, term);
                    } else {
                        this.addStorePathExt(true, n, term);
                    }
                    this.mTerm[n] = null;
                } else {
                    assert (WeakPathInfo.this.mMaxColor == n);
                    weakPathEnd.mTerm[n] = term;
                    WeakPathInfo.this.mMaxColor = ArrayInterpolator.this.getParent(n);
                }
                this.mLastChange[n] = term;
                if (weakPathEnd.mLastChange[n] == null) {
                    weakPathEnd.mLastChange[n] = term;
                }
            }

            private void openSingleAPath(WeakPathEnd weakPathEnd, Term term, int n) {
                if (WeakPathInfo.this.mHasABPath.get(n)) {
                    weakPathEnd.mColor = this.mColor = n;
                    WeakPathInfo.this.mMaxColor = this.mColor;
                    BitSet bitSet = new BitSet();
                    bitSet.set(((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mInterpolator.mStartOfSubtrees[n], n);
                    WeakPathInfo.this.mHasABPath.and(bitSet);
                } else {
                    this.mTerm[n] = term;
                    this.mColor = n;
                    if (this.mLastChange[n] != null) {
                        if (WeakPathInfo.this.mPathIndex != null) {
                            this.addInterpolantClausePathSeg(false, n, term);
                        } else {
                            this.addStorePathExt(false, n, term);
                        }
                    }
                    this.mLastChange[n] = term;
                    if (weakPathEnd.mLastChange[n] == null) {
                        weakPathEnd.mLastChange[n] = term;
                    }
                    WeakPathInfo.this.mHasABPath.clear();
                }
            }

            private void addIndexDisequality(WeakPathEnd weakPathEnd, Term term) {
                Interpolator.LitInfo litInfo = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo(term);
                this.addIndexDiseqAllColors(weakPathEnd, litInfo, term);
                if (litInfo.getMixedVar() != null) {
                    Interpolator.Occurrence occurrence = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mInterpolator.getOccurrence(WeakPathInfo.this.mPathIndex);
                    this.addIndexDiseqAllColors(weakPathEnd, occurrence, term);
                }
            }

            private void addIndexDiseqAllColors(WeakPathEnd weakPathEnd, Interpolator.Occurrence occurrence, Term term) {
                int n;
                int n2 = this.mColor;
                WeakPathInfo.this.mHasABPath.and(occurrence.mInA);
                while (n2 < ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mNumInterpolants && occurrence.isBLocal(n2)) {
                    assert (WeakPathInfo.this.mHasABPath.isEmpty());
                    n = n2;
                    n2 = ArrayInterpolator.this.getParent(n);
                    this.addIndexDiseqOneColor(weakPathEnd, term, n);
                }
                while ((n = ArrayInterpolator.this.getChild(n2, occurrence)) >= 0) {
                    assert (occurrence.isALocal(n));
                    if (WeakPathInfo.this.mHasABPath.get(n)) {
                        BitSet bitSet = new BitSet();
                        bitSet.set(((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mInterpolator.mStartOfSubtrees[n], n);
                        WeakPathInfo.this.mHasABPath.and(bitSet);
                        continue;
                    }
                    this.addIndexDiseqOneColor(weakPathEnd, term, n);
                    n2 = n;
                }
            }

            private void addIndexDiseqOneColor(WeakPathEnd weakPathEnd, Term term, int n) {
                if (weakPathEnd.mLastChange[n] == null) {
                    if (weakPathEnd.mIndexDiseqs[n] == null) {
                        weakPathEnd.mIndexDiseqs[n] = new ArrayList();
                    }
                    weakPathEnd.mIndexDiseqs[n].add(term);
                } else {
                    if (this.mIndexDiseqs[n] == null) {
                        this.mIndexDiseqs[n] = new ArrayList();
                    }
                    this.mIndexDiseqs[n].add(term);
                }
            }

            private void addSelectIndexEquality(WeakPathEnd weakPathEnd, Term term) {
                assert (ArrayInterpolator.isSelectTerm(term));
                if (ArrayInterpolator.getIndexFromSelect(term) != WeakPathInfo.this.mPathIndex) {
                    Term term2 = ArrayInterpolator.getIndexFromSelect(term);
                    Term term3 = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mEqualities.get(new SymmetricPair<Term>(term2, WeakPathInfo.this.mPathIndex));
                    Interpolator.LitInfo litInfo = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo(term3);
                    this.addSelectIndexEqAllColors(weakPathEnd, litInfo, term3);
                    if (litInfo.getMixedVar() != null) {
                        Interpolator.Occurrence occurrence = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mInterpolator.getOccurrence(WeakPathInfo.this.mPathIndex);
                        this.addSelectIndexEqAllColors(weakPathEnd, occurrence, term3);
                    }
                }
            }

            private void addSelectIndexEqAllColors(WeakPathEnd weakPathEnd, Interpolator.Occurrence occurrence, Term term) {
                int n;
                int n2 = this.mColor;
                WeakPathInfo.this.mHasABPath.and(occurrence.mInA);
                while (n2 < ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mNumInterpolants && occurrence.isBLocal(n2)) {
                    assert (WeakPathInfo.this.mHasABPath.isEmpty());
                    n = n2;
                    n2 = ArrayInterpolator.this.getParent(n);
                    this.addSelectIndexEqOneColor(weakPathEnd, term, n);
                }
                while ((n = ArrayInterpolator.this.getChild(n2, occurrence)) >= 0) {
                    assert (occurrence.isALocal(n));
                    if (WeakPathInfo.this.mHasABPath.get(n)) {
                        BitSet bitSet = new BitSet();
                        bitSet.set(((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mInterpolator.mStartOfSubtrees[n], n);
                        WeakPathInfo.this.mHasABPath.and(bitSet);
                        continue;
                    }
                    this.addSelectIndexEqOneColor(weakPathEnd, term, n);
                    n2 = n;
                }
            }

            private void addSelectIndexEqOneColor(WeakPathEnd weakPathEnd, Term term, int n) {
                if (weakPathEnd.mLastChange[n] == null) {
                    if (weakPathEnd.mIndexEqs[n] == null) {
                        weakPathEnd.mIndexEqs[n] = new ArrayList();
                    }
                    weakPathEnd.mIndexEqs[n].add(term);
                } else {
                    if (this.mIndexEqs[n] == null) {
                        this.mIndexEqs[n] = new ArrayList();
                    }
                    this.mIndexEqs[n].add(term);
                }
            }

            private void addMainStoreIndex(WeakPathEnd weakPathEnd, Term term) {
                int n = 0;
                while (n < ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mNumInterpolants) {
                    if (weakPathEnd.mLastChange[n] == null) {
                        if (weakPathEnd.mMainStores[n] == null) {
                            weakPathEnd.mMainStores[n] = new HashSet<Term>();
                        }
                        weakPathEnd.mMainStores[n].add(term);
                    } else {
                        if (this.mMainStores[n] == null) {
                            this.mMainStores[n] = new HashSet<Term>();
                        }
                        this.mMainStores[n].add(term);
                    }
                    ++n;
                }
            }

            private void addInterpolantClausePathSeg(boolean bl, int n, Term term) {
                boolean bl2 = !((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mABSwitchOccur.isALocal(n);
                Term term2 = this.mLastChange[n];
                Term term3 = term;
                if (WeakPathInfo.this.mSharedIndex[n] != null) {
                    Term term4 = WeakPathInfo.this.mSharedIndex[n];
                    Term term5 = WeakPathInfo.this.buildFPiTerm(bl, n, term4, this.mIndexDiseqs[n], this.mIndexEqs[n]);
                    this.mIndexDiseqs[n] = null;
                    this.mIndexEqs[n] = null;
                    if (bl2 && bl || !bl2 && !bl) {
                        Term term6 = ArrayInterpolator.this.buildSelectEq(term2, term3, term4);
                        Term term7 = bl2 ? ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.or(new Term[]{term6, term5}) : ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.and(new Term[]{((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.not(term6), term5});
                        WeakPathInfo.this.mPathInterpolants[n].add(term7);
                    } else {
                        if (bl && !term5.equals(((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.mFalse)) assert (WeakPathInfo.this.mSharedIndex[n] == WeakPathInfo.this.mPathIndex || ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mLemmaInfo.getLemmaType().equals(":weakeq-ext"));
                        WeakPathInfo.this.mPathInterpolants[n].add(term5);
                    }
                } else if (bl2 && bl || !bl2 && !bl) {
                    int n2;
                    ApplicationTerm applicationTerm;
                    Object object;
                    Term term8;
                    HashSet<Term> hashSet = new HashSet<Term>();
                    if (this.mIndexDiseqs[n] != null) {
                        Iterator<Term> iterator = this.mIndexDiseqs[n].iterator();
                        while (iterator.hasNext()) {
                            Term term4;
                            Interpolator.Occurrence occurrence;
                            term8 = iterator.next();
                            object = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mInterpolator.getAtomTermInfo(term8);
                            Interpolator.LitInfo litInfo2 = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo(term8);
                            if (litInfo2.isMixed(n) || !(occurrence = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mInterpolator.getOccurrence(term4 = (applicationTerm = ((InterpolatorAtomInfo)object).getEquality()).getParameters()[0].equals(WeakPathInfo.this.mPathIndex) ? applicationTerm.getParameters()[1] : applicationTerm.getParameters()[0])).isAB(n)) continue;
                            hashSet.add(term4);
                            iterator.remove();
                        }
                    }
                    int n3 = n2 = this.mIndexDiseqs[n] == null ? 0 : this.mIndexDiseqs[n].size();
                    if (((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mLemmaInfo.getLemmaType().equals(":read-const-weakeq") && term.equals(((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mDiseq)) {
                        object = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.createFreshTermVariable("cdot", WeakPathInfo.this.mPathIndex.getSort());
                        Term term5 = WeakPathInfo.this.buildFPiTerm(bl, n, (Term)object, this.mIndexDiseqs[n], this.mIndexEqs[n]);
                        this.mIndexDiseqs[n] = null;
                        this.mIndexEqs[n] = null;
                        term8 = ArrayInterpolator.this.buildConstPathInterpolant(bl, term2, hashSet, (TermVariable)object, n2, term5);
                    } else {
                        object = term2;
                        for (Term term6 : hashSet) {
                            object = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.term("store", new Term[]{object, term6, ArrayInterpolator.this.buildSelect(term3, term6)});
                        }
                        TermVariable termVariable = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.createFreshTermVariable("cdot", WeakPathInfo.this.mPathIndex.getSort());
                        applicationTerm = WeakPathInfo.this.buildFPiTerm(bl, n, (Term)termVariable, this.mIndexDiseqs[n], this.mIndexEqs[n]);
                        this.mIndexDiseqs[n] = null;
                        this.mIndexEqs[n] = null;
                        term8 = bl ? ArrayInterpolator.this.buildWeqTerm((Term)object, term3, n2, (Term)applicationTerm, termVariable) : ArrayInterpolator.this.buildNweqTerm((Term)object, term3, n2, (Term)applicationTerm, termVariable);
                    }
                    WeakPathInfo.this.mPathInterpolants[n].add(term8);
                } else if (((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mLemmaInfo.getLemmaType().equals(":read-over-weakeq") ? !$assertionsDisabled && this.mIndexDiseqs[n] != null : !$assertionsDisabled && this.mIndexDiseqs[n] != null && ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mDiseqInfo.isMixed(n)) {
                    throw new AssertionError();
                }
            }

            private void addStorePathExt(boolean bl, int n, Term term) {
                Term term2;
                Term term3;
                if (this.equals(WeakPathInfo.this.mTail)) {
                    term3 = this.mLastChange[n];
                    term2 = term;
                } else {
                    term3 = term;
                    term2 = this.mLastChange[n];
                }
                Set<Term> set = this.mMainStores[n];
                StorePath storePath = new StorePath(term3, term2, set, bl);
                if (this.equals(WeakPathInfo.this.mTail)) {
                    WeakPathInfo.this.mStorePaths[n].add(storePath);
                } else {
                    WeakPathInfo.this.mStorePaths[n].add(0, storePath);
                }
                if (term3 != null && term2 != null) {
                    this.mMainStores[n] = null;
                }
            }

            private void addInterpolantClauseExt(int n, StorePath storePath) {
                boolean bl;
                boolean bl2 = storePath.mIsAPath;
                boolean bl3 = bl = !((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mABSwitchOccur.isALocal(n);
                if (bl && bl2 || !bl && !bl2) {
                    Term term = storePath.mLeft;
                    Term term2 = storePath.mRight;
                    assert (term != null && term2 != null);
                    if (storePath.mStores != null) {
                        Term term3;
                        HashSet<Term> hashSet = new HashSet<Term>();
                        HashSet<Term> hashSet2 = new HashSet<Term>();
                        for (Term term4 : storePath.mStores) {
                            WeakPathInfo weakPathInfo2 = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mIndexPathInfos.get(term4);
                            term3 = bl2 ? ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.and(weakPathInfo2.mPathInterpolants[n].toArray(new Term[weakPathInfo2.mPathInterpolants[n].size()])) : ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.or(weakPathInfo2.mPathInterpolants[n].toArray(new Term[weakPathInfo2.mPathInterpolants[n].size()]));
                            if (weakPathInfo2.mSharedIndex[n] != null && weakPathInfo2.mSharedIndex[n] != ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mDoubleDot) {
                                hashSet2.add(weakPathInfo2.mSharedIndex[n]);
                                WeakPathInfo.this.mPathInterpolants[n].add(term3);
                                continue;
                            }
                            hashSet.add(term3);
                        }
                        int n2 = storePath.mStores == null ? 0 : storePath.mStores.size() - hashSet2.size();
                        Term term5 = term;
                        for (Term term4 : hashSet2) {
                            term5 = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.term("store", new Term[]{term5, term4, ArrayInterpolator.this.buildSelect(term2, term4)});
                        }
                        if (bl2) {
                            Term term6 = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.or(hashSet.toArray(new Term[hashSet.size()]));
                            term3 = ArrayInterpolator.this.buildWeqTerm(term5, term2, n2, term6, ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mDoubleDot);
                        } else {
                            Term term7 = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.and(hashSet.toArray(new Term[hashSet.size()]));
                            term3 = ArrayInterpolator.this.buildNweqTerm(term5, term2, n2, term7, ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mDoubleDot);
                        }
                        WeakPathInfo.this.mPathInterpolants[n].add(term3);
                    } else {
                        Term term6 = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.equals(new Term[]{term, term2});
                        if (!bl2) {
                            term6 = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.not(term6);
                        }
                        WeakPathInfo.this.mPathInterpolants[n].add(term6);
                    }
                } else if (storePath.mStores != null) {
                    for (Term term : storePath.mStores) {
                        WeakPathInfo weakPathInfo = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mIndexPathInfos.get(term);
                        Term term7 = bl2 ? ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.or(weakPathInfo.mPathInterpolants[n].toArray(new Term[weakPathInfo.mPathInterpolants[n].size()])) : ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.and(weakPathInfo.mPathInterpolants[n].toArray(new Term[weakPathInfo.mPathInterpolants[n].size()]));
                        WeakPathInfo.this.mPathInterpolants[n].add(term7);
                    }
                }
            }

            private void buildRecursiveInterpolant(int n, WeakPathEnd weakPathEnd, StorePath storePath) {
                boolean bl = storePath.mIsAPath;
                Term term = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.term("@EQ", new Term[]{((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mDiseqInfo.getMixedVar(), ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mRecursionVar});
                Term term2 = bl ? ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.and(WeakPathInfo.this.mPathInterpolants[n].toArray(new Term[WeakPathInfo.this.mPathInterpolants[n].size()])) : ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.or(WeakPathInfo.this.mPathInterpolants[n].toArray(new Term[WeakPathInfo.this.mPathInterpolants[n].size()]));
                WeakPathInfo.this.mPathInterpolants[n].clear();
                Term term3 = bl ? ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.and(new Term[]{term, term2}) : ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.or(new Term[]{term, term2});
                TermVariable termVariable = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mRecursionVar;
                if (storePath.mStores != null) {
                    for (Term term4 : storePath.mStores) {
                        int n2;
                        Object object;
                        Term term5;
                        BitSet bitSet;
                        Term term6;
                        Object object2;
                        BitSet bitSet2;
                        Set<Term> set;
                        WeakPathInfo weakPathInfo;
                        TermVariable termVariable2 = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.createFreshTermVariable("recursive", ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mRecursionVar.getSort());
                        if (((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mRecIndexPathInfos.containsKey(term4)) {
                            weakPathInfo = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mRecIndexPathInfos.get(term4);
                            set = weakPathInfo.mPathInterpolants[n];
                        } else {
                            weakPathInfo = new WeakPathInfo(((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mIndexPaths.get(term4));
                            weakPathInfo.mSharedIndex = ArrayInterpolator.this.findSharedTerms(term4);
                            bitSet2 = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mABSwitchOccur.mInA;
                            ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mABSwitchOccur.mInA = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mABSwitchOccur.mInB;
                            ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mABSwitchOccur.mInB = bitSet2;
                            weakPathInfo.interpolateWeakPathInfo(false);
                            bitSet2 = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mABSwitchOccur.mInB;
                            ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mABSwitchOccur.mInB = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mABSwitchOccur.mInA;
                            ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mABSwitchOccur.mInA = bitSet2;
                            set = weakPathInfo.mPathInterpolants[n];
                        }
                        if (weakPathInfo.mSharedIndex[n] != null) {
                            object2 = weakPathInfo.mSharedIndex[n];
                            term6 = bl ? ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.or(set.toArray(new Term[set.size()])) : ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.and(set.toArray(new Term[set.size()]));
                            Object object3 = bitSet2 = this.equals(WeakPathInfo.this.mHead) ? weakPathInfo.mTail.mLastChange[n] : weakPathInfo.mHead.mLastChange[n];
                            if (((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mEqualities.containsValue(bitSet2)) {
                                bitSet = null;
                                Interpolator.LitInfo litInfo = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo((Term)bitSet2);
                                term5 = litInfo.getMixedVar();
                            } else {
                                bitSet = bitSet2;
                                term5 = ArrayInterpolator.this.buildSelect((Term)bitSet, (Term)object2);
                            }
                        } else {
                            Term term7;
                            bitSet2 = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.createFreshTermVariable("cdot", term4.getSort());
                            object2 = bitSet2;
                            term6 = bl ? ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.or(set.toArray(new Term[set.size()])) : ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.and(set.toArray(new Term[set.size()]));
                            Term term8 = term7 = this.equals(WeakPathInfo.this.mHead) ? weakPathInfo.mTail.mLastChange[n] : weakPathInfo.mHead.mLastChange[n];
                            assert (!((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mEqualities.containsValue(term7));
                            bitSet = term7;
                            term5 = ArrayInterpolator.this.buildSelect((Term)bitSet, (Term)object2);
                        }
                        if (this.equals(WeakPathInfo.this.mHead)) {
                            object = weakPathInfo.mTail.mIndexDiseqs[n];
                            n2 = object == null ? 0 : object.size();
                            bitSet2 = weakPathInfo.buildFPiTerm(!bl, n, (Term)object2, (ArrayList<Term>)object, weakPathInfo.mTail.mIndexEqs[n]);
                        } else {
                            object = weakPathInfo.mHead.mIndexDiseqs[n];
                            n2 = object == null ? 0 : object.size();
                            bitSet2 = weakPathInfo.buildFPiTerm(!bl, n, (Term)object2, (ArrayList<Term>)object, weakPathInfo.mHead.mIndexEqs[n]);
                        }
                        object = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.term("store", new Term[]{termVariable2, object2, term5});
                        Term term9 = bl ? ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.and(new Term[]{((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.let(termVariable, object, term3), bitSet2}) : ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.or(new Term[]{((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.let(termVariable, object, term3), bitSet2});
                        if (weakPathInfo.mSharedIndex[n] != null) {
                            term3 = bl ? ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.or(new Term[]{term6, term9}) : ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.and(new Term[]{term6, term9});
                        } else {
                            Term term10;
                            Object object4;
                            StorePath storePath22;
                            assert (object2 instanceof TermVariable);
                            assert (bitSet != null);
                            TermVariable termVariable3 = (TermVariable)object2;
                            HashSet<Term> hashSet = new HashSet<Term>();
                            for (StorePath storePath22 : WeakPathInfo.this.mStorePaths[n]) {
                                object4 = storePath22.mLeft;
                                Term term11 = storePath22.mRight;
                                if (object4 == null || term11 == null) continue;
                                int n3 = storePath22.mStores != null ? storePath22.mStores.size() : 0;
                                term10 = bl ? ArrayInterpolator.this.buildNweqTerm((Term)object4, term11, n3, term9, termVariable3) : ArrayInterpolator.this.buildWeqTerm((Term)object4, term11, n3, term9, termVariable3);
                                hashSet.add(term10);
                            }
                            storePath22 = weakPathEnd.mLastChange[n];
                            BitSet bitSet3 = bitSet;
                            object4 = weakPathEnd.mMainStores[n];
                            int n4 = n2 + (object4 == null ? 0 : object4.size());
                            Term term12 = bl ? ArrayInterpolator.this.buildNweqTerm((Term)storePath22, (Term)bitSet3, n4, term9, termVariable3) : ArrayInterpolator.this.buildWeqTerm((Term)storePath22, (Term)bitSet3, n4, term9, termVariable3);
                            hashSet.add(term12);
                            term10 = bl ? ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.or(hashSet.toArray(new Term[hashSet.size()])) : ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.and(hashSet.toArray(new Term[hashSet.size()]));
                            term3 = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.let(termVariable, (Term)termVariable2, term3);
                            term3 = bl ? ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.or(new Term[]{term3, term6, term10}) : ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.and(new Term[]{term3, term6, term10});
                        }
                        termVariable = termVariable2;
                    }
                }
                term3 = ((WeakPathInfo)WeakPathInfo.this).ArrayInterpolator.this.mTheory.let(termVariable, this.mLastChange[n], term3);
                WeakPathInfo.this.mPathInterpolants[n].add(term3);
            }
        }
    }
}

