/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashMap;
import java.util.Map;

public class DAGSize
extends NonRecursive {
    private final Map<Term, Long> mCache = new HashMap<Term, Long>();
    private boolean mComputeTreeSize;
    private long mSize = 0L;

    public void reset() {
        super.reset();
        this.mCache.clear();
        this.mSize = 0L;
    }

    public int size(Term term) {
        this.mComputeTreeSize = false;
        this.run((NonRecursive.Walker)new TermOnceWalker(new FormulaUnLet().unlet(term)));
        return (int)this.mSize;
    }

    public long treesize(Term term) {
        this.mComputeTreeSize = true;
        this.run((NonRecursive.Walker)new TermOnceWalker(new FormulaUnLet().unlet(term)));
        return this.mSize;
    }

    private class TermOnceWalker
    extends NonRecursive.TermWalker {
        public TermOnceWalker(Term term) {
            super(term);
        }

        public void walk(NonRecursive nonRecursive) {
            if (DAGSize.this.mCache.containsKey(this.mTerm)) {
                if (DAGSize.this.mComputeTreeSize) {
                    DAGSize.this.mSize += DAGSize.this.mCache.get(this.mTerm).longValue();
                }
                return;
            }
            if (DAGSize.this.mComputeTreeSize) {
                DAGSize.this.enqueueWalker(new TreeSizeCache(this.mTerm));
            } else {
                DAGSize.this.mCache.put(this.mTerm, 0L);
            }
            ++DAGSize.this.mSize;
            super.walk(nonRecursive);
        }

        public void walk(NonRecursive nonRecursive, ConstantTerm constantTerm) {
        }

        public void walk(NonRecursive nonRecursive, AnnotatedTerm annotatedTerm) {
            nonRecursive.enqueueWalker((NonRecursive.Walker)new TermOnceWalker(annotatedTerm.getSubterm()));
        }

        public void walk(NonRecursive nonRecursive, ApplicationTerm applicationTerm) {
            Term[] termArray = applicationTerm.getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term = termArray[n2];
                nonRecursive.enqueueWalker((NonRecursive.Walker)new TermOnceWalker(term));
                ++n2;
            }
        }

        public void walk(NonRecursive nonRecursive, LetTerm letTerm) {
            throw new InternalError("Input should be unletted");
        }

        public void walk(NonRecursive nonRecursive, LambdaTerm lambdaTerm) {
            nonRecursive.enqueueWalker((NonRecursive.Walker)new TermOnceWalker(lambdaTerm.getSubterm()));
        }

        public void walk(NonRecursive nonRecursive, QuantifiedFormula quantifiedFormula) {
            nonRecursive.enqueueWalker((NonRecursive.Walker)new TermOnceWalker(quantifiedFormula.getSubformula()));
        }

        public void walk(NonRecursive nonRecursive, MatchTerm matchTerm) {
            nonRecursive.enqueueWalker((NonRecursive.Walker)new TermOnceWalker(matchTerm.getDataTerm()));
            Term[] termArray = matchTerm.getCases();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term = termArray[n2];
                nonRecursive.enqueueWalker((NonRecursive.Walker)new TermOnceWalker(term));
                ++n2;
            }
        }

        public void walk(NonRecursive nonRecursive, TermVariable termVariable) {
        }
    }

    private class TreeSizeCache
    implements NonRecursive.Walker {
        long mSizeBefore = 0L;
        Term mTerm;

        public TreeSizeCache(Term term) {
            this.mSizeBefore = DAGSize.this.mSize;
            this.mTerm = term;
        }

        public void walk(NonRecursive nonRecursive) {
            DAGSize.this.mCache.put(this.mTerm, DAGSize.this.mSize - this.mSizeBefore);
        }
    }
}

