/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ContractStatement;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import java.util.List;
import java.util.function.Predicate;

public final class Terminates
extends ContractStatement {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(Terminates.class);
    Expression formula;

    public Terminates(Expression expression) {
        this.formula = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Terminates: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Terminates").append('[');
        stringBuffer.append(this.formula);
        return stringBuffer.append(']').toString();
    }

    public Expression getFormula() {
        return this.formula;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.formula);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((ContractStatement)this)) {
            return;
        }
        if (aCSLVisitor.visit(this) && this.formula != null) {
            this.formula.accept(aCSLVisitor);
        }
    }

    @Override
    public ContractStatement accept(ACSLTransformer aCSLTransformer) {
        ContractStatement contractStatement = aCSLTransformer.transform(this);
        if (contractStatement != this) {
            return contractStatement;
        }
        Expression expression = null;
        if (this.formula != null) {
            expression = this.formula.accept(aCSLTransformer);
        }
        if (this.formula != expression) {
            return new Terminates(expression);
        }
        return this;
    }
}

