/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.domain;

import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;

public class NonrelationalState<VALUE extends INonrelationalValue<VALUE>>
implements IAbstractState<NonrelationalState<VALUE>> {
    private final Map<Term, VALUE> mVariablesToValues;

    public NonrelationalState(Map<Term, VALUE> map) {
        this.mVariablesToValues = map;
    }

    public NonrelationalState() {
        this(Map.of());
    }

    public Term toTerm(Script script) {
        List list = this.mVariablesToValues.entrySet().stream().map(entry -> ((INonrelationalValue)entry.getValue()).toTerm((Term)entry.getKey(), script)).collect(Collectors.toList());
        return SmtUtils.and((Script)script, list);
    }

    private NonrelationalState<VALUE> merge(NonrelationalState<VALUE> nonrelationalState, BinaryOperator<VALUE> binaryOperator) {
        HashMap<Term, INonrelationalValue> hashMap = new HashMap<Term, INonrelationalValue>();
        for (Map.Entry<Term, VALUE> entry : this.mVariablesToValues.entrySet()) {
            INonrelationalValue iNonrelationalValue;
            Term term = entry.getKey();
            INonrelationalValue iNonrelationalValue2 = (INonrelationalValue)nonrelationalState.mVariablesToValues.get(term);
            if (iNonrelationalValue2 == null || (iNonrelationalValue = (INonrelationalValue)binaryOperator.apply((INonrelationalValue)entry.getValue(), iNonrelationalValue2)).isTop()) continue;
            hashMap.put(term, iNonrelationalValue);
        }
        return new NonrelationalState(hashMap);
    }

    @Override
    public NonrelationalState<VALUE> join(NonrelationalState<VALUE> nonrelationalState) {
        return this.merge(nonrelationalState, INonrelationalValue::join);
    }

    @Override
    public NonrelationalState<VALUE> widen(NonrelationalState<VALUE> nonrelationalState) {
        return this.merge(nonrelationalState, INonrelationalValue::widen);
    }

    @Override
    public boolean isBottom() {
        return this.mVariablesToValues.values().stream().anyMatch(INonrelationalValue::isBottom);
    }

    public String toString() {
        return this.mVariablesToValues.toString();
    }
}

