/*
 * Copyright (C) 2009-2012 University of Freiburg
 *
 * This file is part of SMTInterpol.
 *
 * SMTInterpol is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * SMTInterpol is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with SMTInterpol.  If not, see <http://www.gnu.org/licenses/>.
 */
/* DIMACS format lexer */
package de.uni_freiburg.informatik.ultimate.smtinterpol.dimacs;
import com.github.jhoenicke.javacup.runtime.Symbol;
import com.github.jhoenicke.javacup.runtime.SimpleSymbolFactory;

/**
 * This is a autogenerated lexer for dimacs.
 * It is generated from smtlib.flex by JFlex.
 */
%%

%class Lexer
%public
%unicode
%implements com.github.jhoenicke.javacup.runtime.Scanner
%type com.github.jhoenicke.javacup.runtime.Symbol
%function next_token
%line
%column

%{
  private SimpleSymbolFactory symFactory;
  
  public void setSymbolFactory(SimpleSymbolFactory factory) {
    symFactory = factory;
  }

  private Symbol symbol(int type) {
    return symFactory.newSymbol(yytext(), type, yyline+1, yycolumn, yyline+1, yycolumn+yylength());
  }
  private Symbol symbol(int type, String value) {
    return symFactory.newSymbol(value, type, yyline+1, yycolumn, yyline+1, yycolumn+yylength(), value);
  }
%}

LineTerminator = \r|\n|\r\n
InputCharacter = [^\r\n]
WhiteSpace     = {LineTerminator} | [ \t\f]

/* comments */
Comment = "c " {InputCharacter}* {LineTerminator}

/* Identifiers are numbers different from 0 */
Number = [1-9][0-9]*

%%

<YYINITIAL>  {
  ^"p"            { return symbol(LexerSymbols.PROBLEM); }
  "cnf"           { return symbol(LexerSymbols.CNF); }
  "-"             { return symbol(LexerSymbols.NOT); }
  "0"             { return symbol(LexerSymbols.EOC); }

  /* Numbers and Ids */
  {Number}                   { return symbol(LexerSymbols.NUMBER, yytext()); }
 
  /* comments */
  ^{Comment}                     { /* ignore */ }
 
  /* whitespace */
  {WhiteSpace}                   { /* ignore */ }
}

/* error fallback */
.|\n                             { return symbol(LexerSymbols.error, yytext()); }

<<EOF>>                          { return symbol(LexerSymbols.EOF); }
