/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public final class BuchiIsEmptyXW<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private static final String LOG_SEPARATOR = "########################################";
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private final Boolean mResult;
    private final Bridge mReachabilityBridge = new Bridge();
    private final Bridge mReachabilityBridgeA = new Bridge();
    private final Bridge mReachabilityBridgeC = new Bridge();
    private final Bridge mReachabilityBridgeAc = new Bridge();
    private STATE mWitnessInitial;
    private STATE mWitnessCritical;

    public BuchiIsEmptyXW(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iNestedWordAutomaton;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mResult = this.checkEmptiness();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Result is " + String.valueOf(this.mResult);
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public Boolean getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }

    public NestedLassoRun<LETTER, STATE> getAcceptingNestedLassoRun() {
        if (this.mResult.booleanValue()) {
            if (this.mLogger.isInfoEnabled()) {
                this.mLogger.info((Object)"There is no accepting nested lasso run");
            }
            return null;
        }
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)"Starting construction of run");
        }
        NestedRun<LETTER, STATE> nestedRun = this.reconstructionC(this.mWitnessInitial, this.mWitnessCritical);
        NestedRun<LETTER, STATE> nestedRun2 = this.reconstructionAc(this.mWitnessCritical, this.mWitnessCritical);
        NestedLassoRun<LETTER, STATE> nestedLassoRun = new NestedLassoRun<LETTER, STATE>(nestedRun, nestedRun2);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Accepting run: " + String.valueOf(nestedLassoRun)));
            this.mLogger.debug((Object)("Accepted word:  Stem:" + String.valueOf(nestedLassoRun.getStem().getWord()) + " Loop: " + String.valueOf(nestedLassoRun.getLoop().getWord())));
        }
        return nestedLassoRun;
    }

    public boolean checkEmptiness() throws AutomataOperationCanceledException {
        Object object22;
        Worklist worklist = new Worklist();
        HashSet<STATE> hashSet = new HashSet<STATE>();
        HashSet<STATE> hashSet2 = new HashSet<STATE>();
        HashSet hashSet3 = new HashSet();
        Set set = this.mOperand.getVpAlphabet().getCallAlphabet();
        Set set2 = this.mOperand.getVpAlphabet().getReturnAlphabet();
        for (Object object22 : this.mOperand.getStates()) {
            hashSet.add(object22);
            if (!this.mOperand.isFinal(object22)) continue;
            hashSet2.add(object22);
        }
        hashSet3.addAll(this.mOperand.getInitialStates());
        for (Object object22 : hashSet) {
            for (STATE object3 : this.getCallPredStates(object22, set)) {
                for (STATE STATE : this.getReturnSuccStates(object22, object3, set2)) {
                    this.addReachabilityBridgeIfNotPresent(worklist, object22, object3, STATE);
                }
            }
        }
        this.addReachabilityBridgeInternalPredecessors(worklist, hashSet);
        while (!worklist.isEmpty()) {
            object22 = worklist.dequeue();
            this.extendPathCallReturn(((StatePair)object22).mSource, ((StatePair)object22).mTarget, set, set2, this.mReachabilityBridge, worklist);
            this.extendPathBeyondDestination(((StatePair)object22).mSource, ((StatePair)object22).mTarget, this.mReachabilityBridge, worklist);
            this.extendPathBeyondOrigin(((StatePair)object22).mSource, ((StatePair)object22).mTarget, this.mReachabilityBridge, worklist);
            if (!this.isCancellationRequested()) continue;
            throw new AutomataOperationCanceledException(this.getClass());
        }
        assert (worklist.isEmpty());
        for (Object object22 : hashSet2) {
            this.extendAcceptingPath(object22, this.mReachabilityBridge, this.mReachabilityBridgeA, worklist);
            this.extendPathCallReturn(object22, object22, set, set2, this.mReachabilityBridgeA, worklist);
        }
        while (!worklist.isEmpty()) {
            object22 = worklist.dequeue();
            this.extendAcceptingPathCallReturn(((StatePair)object22).mSource, ((StatePair)object22).mTarget, set, set2, this.mReachabilityBridge, this.mReachabilityBridgeA, worklist);
            if (!this.isCancellationRequested()) continue;
            throw new AutomataOperationCanceledException(this.getClass());
        }
        assert (worklist.isEmpty());
        this.copyBridge(this.mReachabilityBridge, this.mReachabilityBridgeC, worklist);
        for (Object object22 : hashSet) {
            for (OutgoingCallTransition outgoingCallTransition : this.mOperand.callSuccessors(object22)) {
                STATE STATE;
                STATE = outgoingCallTransition.getSucc();
                if (this.mReachabilityBridgeC.containsPair(object22, STATE)) continue;
                this.mReachabilityBridgeC.addElement(object22, STATE, new SingletonBridge(STATE));
                worklist.enqueue(object22, STATE);
            }
        }
        while (!worklist.isEmpty()) {
            object22 = worklist.dequeue();
            this.extendPathBeyondDestination(((StatePair)object22).mSource, ((StatePair)object22).mTarget, this.mReachabilityBridgeC, worklist);
            this.extendPathBeyondOrigin(((StatePair)object22).mSource, ((StatePair)object22).mTarget, this.mReachabilityBridgeC, worklist);
            if (!this.isCancellationRequested()) continue;
            throw new AutomataOperationCanceledException(this.getClass());
        }
        assert (worklist.isEmpty());
        this.copyBridge(this.mReachabilityBridgeA, this.mReachabilityBridgeAc, worklist);
        for (Object object22 : hashSet2) {
            this.extendAcceptingPath(object22, this.mReachabilityBridgeC, this.mReachabilityBridgeAc, worklist);
        }
        for (Object object22 : hashSet3) {
            for (Object object : this.mReachabilityBridgeC.getAllTargets(object22)) {
                if (!this.mReachabilityBridgeAc.containsPair(object, object)) continue;
                this.mWitnessInitial = object22;
                this.mWitnessCritical = object;
                this.logWitness();
                return false;
            }
        }
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)LOG_SEPARATOR);
            this.mLogger.info((Object)"The NWA is empty.");
            this.mLogger.info((Object)LOG_SEPARATOR);
        }
        return true;
    }

    private void logWitness() {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)LOG_SEPARATOR);
            this.mLogger.info((Object)("witnessInitial: " + String.valueOf(this.mWitnessInitial) + ", witnessCritical: " + String.valueOf(this.mWitnessCritical)));
            this.mLogger.info((Object)LOG_SEPARATOR);
        }
    }

    private void addReachabilityBridgeInternalPredecessors(Worklist worklist, Set<STATE> set) {
        for (STATE STATE : set) {
            for (OutgoingInternalTransition outgoingInternalTransition : this.mOperand.internalSuccessors(STATE)) {
                STATE STATE2 = outgoingInternalTransition.getSucc();
                if (this.mReachabilityBridge.containsPair(STATE, STATE2)) continue;
                this.mReachabilityBridge.addElement(STATE, STATE2, new SingletonBridge(STATE2));
                worklist.enqueue(STATE, STATE2);
            }
        }
    }

    private void addReachabilityBridgeIfNotPresent(Worklist worklist, STATE STATE, STATE STATE2, STATE STATE3) {
        if (!this.mReachabilityBridge.containsPair(STATE2, STATE3)) {
            this.mReachabilityBridge.addElement(STATE2, STATE3, new QuadrupleBridge(STATE2, STATE, STATE, STATE3));
            worklist.enqueue(STATE2, STATE3);
        }
    }

    public Collection<STATE> getCallPredStates(STATE STATE, Collection<LETTER> collection) {
        HashSet<STATE> hashSet = new HashSet<STATE>();
        for (LETTER LETTER : collection) {
            for (IncomingCallTransition<LETTER, STATE> incomingCallTransition : this.mOperand.callPredecessors(STATE, LETTER)) {
                hashSet.add(incomingCallTransition.getPred());
            }
        }
        return hashSet;
    }

    public Collection<STATE> getReturnSuccStates(STATE STATE, STATE STATE2, Collection<LETTER> collection) {
        HashSet<STATE> hashSet = new HashSet<STATE>();
        for (LETTER LETTER : collection) {
            for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.mOperand.returnSuccessors(STATE, STATE2, LETTER)) {
                hashSet.add(outgoingReturnTransition.getSucc());
            }
        }
        return hashSet;
    }

    LETTER getFirstInternalSymbol(STATE STATE, STATE STATE2) {
        for (Object LETTER : this.mOperand.lettersInternal(STATE)) {
            for (OutgoingInternalTransition outgoingInternalTransition : this.mOperand.internalSuccessors(STATE, LETTER)) {
                if (!outgoingInternalTransition.getSucc().equals(STATE2)) continue;
                return LETTER;
            }
        }
        return null;
    }

    LETTER getFirstCallSymbol(STATE STATE, STATE STATE2) {
        for (Object LETTER : this.mOperand.lettersCall(STATE)) {
            for (OutgoingCallTransition outgoingCallTransition : this.mOperand.callSuccessors(STATE, LETTER)) {
                if (!outgoingCallTransition.getSucc().equals(STATE2)) continue;
                return LETTER;
            }
        }
        return null;
    }

    LETTER getFirstReturnSymbol(STATE STATE, STATE STATE2, STATE STATE3) {
        for (OutgoingReturnTransition outgoingReturnTransition : this.mOperand.returnSuccessorsGivenHier(STATE, STATE2)) {
            if (!outgoingReturnTransition.getSucc().equals(STATE3)) continue;
            return outgoingReturnTransition.getLetter();
        }
        return null;
    }

    void extendPathCallReturn(STATE STATE, STATE STATE2, Collection<LETTER> collection, Collection<LETTER> collection2, Bridge bridge, Worklist worklist) {
        for (STATE STATE3 : this.getCallPredStates(STATE, collection)) {
            Collection<STATE> collection3 = this.getReturnSuccStates(STATE2, STATE3, collection2);
            for (STATE STATE4 : collection3) {
                if (bridge.containsPair(STATE3, STATE4)) continue;
                QuadrupleBridge quadrupleBridge = new QuadrupleBridge(STATE3, STATE, STATE2, STATE4);
                bridge.addElement(STATE3, STATE4, quadrupleBridge);
                worklist.enqueue(STATE3, STATE4);
            }
        }
    }

    void extendPathBeyondDestination(STATE STATE, STATE STATE2, Bridge bridge, Worklist worklist) {
        for (Object STATE3 : bridge.getAllTargets(STATE2)) {
            if (bridge.containsPair(STATE, STATE3)) continue;
            bridge.addElement(STATE, STATE3, new SingletonBridge(STATE2));
            worklist.enqueue(STATE, STATE3);
        }
    }

    void extendPathBeyondOrigin(STATE STATE, STATE STATE2, Bridge bridge, Worklist worklist) {
        for (Object STATE3 : bridge.getAllSources(STATE)) {
            if (bridge.containsPair(STATE3, STATE2)) continue;
            bridge.addElement(STATE3, STATE2, new SingletonBridge(STATE));
            worklist.enqueue(STATE3, STATE2);
        }
    }

    void extendAcceptingPath(STATE STATE, Bridge bridge, Bridge bridge2, Worklist worklist) {
        if (bridge.containsPair(STATE, STATE) && !bridge2.containsPair(STATE, STATE)) {
            bridge2.addElement(STATE, STATE, new OmegaBridge());
            worklist.enqueue(STATE, STATE);
        }
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        hashSet.add(STATE);
        hashSet.addAll(bridge.getAllSources(STATE));
        hashSet2.add(STATE);
        hashSet2.addAll(bridge.getAllTargets(STATE));
        for (Object e : hashSet) {
            for (Object e2 : hashSet2) {
                if (e == e2 && e2 == STATE || bridge2.containsPair(e, e2)) continue;
                bridge2.addElement(e, e2, new SingletonBridge(STATE));
                worklist.enqueue(e, e2);
            }
        }
    }

    void extendAcceptingPathCallReturn(STATE STATE, STATE STATE2, Collection<LETTER> collection, Collection<LETTER> collection2, Bridge bridge, Bridge bridge2, Worklist worklist) {
        for (STATE STATE3 : this.getCallPredStates(STATE, collection)) {
            for (STATE STATE4 : this.getReturnSuccStates(STATE2, STATE3, collection2)) {
                HashSet hashSet = new HashSet();
                HashSet hashSet2 = new HashSet();
                hashSet.add(STATE3);
                hashSet.addAll(bridge.getAllSources(STATE3));
                hashSet2.add(STATE4);
                hashSet2.addAll(bridge.getAllTargets(STATE4));
                this.extendAcceptingPathCallReturnHelper(STATE, STATE2, bridge2, worklist, STATE3, STATE4, hashSet, hashSet2);
            }
        }
    }

    void copyBridge(Bridge bridge, Bridge bridge2, Worklist worklist) {
        Set set = bridge.getAllSources();
        if (set != null) {
            for (Object STATE : set) {
                Set set2 = bridge.getAllTargets(STATE);
                if (set2 == null) continue;
                for (Object STATE2 : set2) {
                    bridge2.addElement(STATE, STATE2, bridge.getBridgeRange(STATE, STATE2));
                    worklist.enqueue(STATE, STATE2);
                }
            }
        }
    }

    NestedRun<LETTER, STATE> reconstructionC(STATE STATE, STATE STATE2) {
        if (!this.mReachabilityBridgeC.containsPair(STATE, STATE2)) {
            return new NestedRun(STATE2);
        }
        IBridgeRange iBridgeRange = this.mReachabilityBridgeC.getBridgeRange(STATE, STATE2);
        if (iBridgeRange instanceof QuadrupleBridge) {
            Object STATE3 = ((QuadrupleBridge)iBridgeRange).mCallPredecessor;
            Object STATE4 = ((QuadrupleBridge)iBridgeRange).mCallSuccessor;
            Object STATE5 = ((QuadrupleBridge)iBridgeRange).mReturnPredecessor;
            Object STATE6 = ((QuadrupleBridge)iBridgeRange).mReturnSuccessor;
            NestedRun nestedRun = new NestedRun(STATE3, this.getFirstCallSymbol(STATE3, STATE4), Integer.MAX_VALUE, STATE4);
            NestedRun nestedRun2 = new NestedRun(STATE5, this.getFirstReturnSymbol(STATE5, STATE3, STATE6), Integer.MIN_VALUE, STATE6);
            return STATE4 == STATE5 ? nestedRun.concatenate(nestedRun2) : nestedRun.concatenate(this.reconstructionC(STATE4, STATE5)).concatenate(nestedRun2);
        }
        if (iBridgeRange instanceof SingletonBridge) {
            Object STATE7 = ((SingletonBridge)iBridgeRange).mSingleton;
            if (this.getFirstInternalSymbol(STATE, STATE2) != null) {
                return new NestedRun<LETTER, STATE>(STATE, this.getFirstInternalSymbol(STATE, STATE2), -2, STATE2);
            }
            if (this.getFirstCallSymbol(STATE, STATE2) != null) {
                return new NestedRun<LETTER, STATE>(STATE, this.getFirstCallSymbol(STATE, STATE2), Integer.MAX_VALUE, STATE2);
            }
            return this.reconstructionC(STATE, STATE7).concatenate(this.reconstructionC(STATE7, STATE2));
        }
        throw new IllegalArgumentException("unsupported bridge range");
    }

    NestedRun<LETTER, STATE> reconstructionAc(STATE STATE, STATE STATE2) {
        assert (this.mReachabilityBridgeAc.containsPair(STATE, STATE2)) : "Pair (" + String.valueOf(STATE) + "," + String.valueOf(STATE2) + ") not contained";
        IBridgeRange iBridgeRange = this.mReachabilityBridgeAc.getBridgeRange(STATE, STATE2);
        if (iBridgeRange instanceof OmegaBridge) {
            return this.reconstructionC(STATE, STATE2);
        }
        if (iBridgeRange instanceof SingletonBridge) {
            Object STATE3 = ((SingletonBridge)iBridgeRange).mSingleton;
            return this.reconstructionC(STATE, STATE3).concatenate(this.reconstructionC(STATE3, STATE2));
        }
        if (iBridgeRange instanceof QuadrupleBridge) {
            Object STATE4 = ((QuadrupleBridge)iBridgeRange).mCallPredecessor;
            Object STATE5 = ((QuadrupleBridge)iBridgeRange).mCallSuccessor;
            Object STATE6 = ((QuadrupleBridge)iBridgeRange).mReturnPredecessor;
            Object STATE7 = ((QuadrupleBridge)iBridgeRange).mReturnSuccessor;
            NestedRun nestedRun = new NestedRun(STATE4, this.getFirstCallSymbol(STATE4, STATE5), Integer.MAX_VALUE, STATE5);
            NestedRun nestedRun2 = new NestedRun(STATE6, this.getFirstReturnSymbol(STATE6, STATE4, STATE7), Integer.MIN_VALUE, STATE7);
            return STATE5 == STATE6 && this.mOperand.isFinal(STATE5) ? this.reconstructionC(STATE, STATE4).concatenate(nestedRun).concatenate(nestedRun2).concatenate(this.reconstructionC(STATE7, STATE2)) : this.reconstructionC(STATE, STATE4).concatenate(nestedRun).concatenate(this.reconstructionAc(STATE5, STATE6).concatenate(nestedRun2).concatenate(this.reconstructionC(STATE7, STATE2)));
        }
        return null;
    }

    private void extendAcceptingPathCallReturnHelper(STATE STATE, STATE STATE2, Bridge bridge, Worklist worklist, STATE STATE3, STATE STATE4, Set<STATE> set, Set<STATE> set2) {
        for (STATE STATE5 : set) {
            for (STATE STATE6 : set2) {
                if (bridge.containsPair(STATE5, STATE6)) continue;
                bridge.addElement(STATE5, STATE6, new QuadrupleBridge(STATE3, STATE, STATE2, STATE4));
                worklist.enqueue(STATE5, STATE6);
            }
        }
    }

    private class Bridge {
        private final Map<STATE, HashMap<STATE, IBridgeRange>> mBridgeInOrder = new HashMap();
        private final Map<STATE, HashMap<STATE, IBridgeRange>> mBridgeReverseOrder = new HashMap();

        void addElement(STATE STATE, STATE STATE2, IBridgeRange iBridgeRange) {
            assert (!this.mBridgeInOrder.containsKey(STATE) || !this.mBridgeInOrder.get(STATE).containsKey(STATE2));
            if (!this.mBridgeInOrder.containsKey(STATE)) {
                this.mBridgeInOrder.put(STATE, new HashMap());
            }
            this.mBridgeInOrder.get(STATE).put(STATE2, iBridgeRange);
            assert (!this.mBridgeReverseOrder.containsKey(STATE2) || !this.mBridgeReverseOrder.get(STATE2).containsKey(STATE));
            if (!this.mBridgeReverseOrder.containsKey(STATE2)) {
                this.mBridgeReverseOrder.put(STATE2, new HashMap());
            }
            this.mBridgeReverseOrder.get(STATE2).put(STATE, iBridgeRange);
        }

        Set<STATE> getAllSources() {
            if (!this.mBridgeInOrder.isEmpty()) {
                return this.mBridgeInOrder.keySet();
            }
            return Collections.emptySet();
        }

        Set<STATE> getAllSources(STATE STATE) {
            if (this.mBridgeReverseOrder.containsKey(STATE)) {
                return this.mBridgeReverseOrder.get(STATE).keySet();
            }
            return Collections.emptySet();
        }

        Set<STATE> getAllTargets(STATE STATE) {
            if (this.mBridgeInOrder.containsKey(STATE)) {
                return this.mBridgeInOrder.get(STATE).keySet();
            }
            return Collections.emptySet();
        }

        IBridgeRange getBridgeRange(STATE STATE, STATE STATE2) {
            if (this.mBridgeInOrder.containsKey(STATE) && this.mBridgeInOrder.get(STATE).containsKey(STATE2)) {
                return this.mBridgeInOrder.get(STATE).get(STATE2);
            }
            return null;
        }

        boolean containsPair(STATE STATE, STATE STATE2) {
            return this.mBridgeInOrder.containsKey(STATE) && this.mBridgeInOrder.get(STATE).containsKey(STATE2);
        }

        public String toString() {
            assert (this.mBridgeInOrder != null);
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry entry : this.mBridgeInOrder.entrySet()) {
                Object STATE = entry.getKey();
                for (Object STATE2 : entry.getValue().keySet()) {
                    stringBuilder.append('(').append(STATE).append(',').append(STATE2).append(") ");
                }
            }
            return stringBuilder.toString();
        }
    }

    private static interface IBridgeRange {
    }

    private static class OmegaBridge
    implements IBridgeRange {
        private OmegaBridge() {
        }

        public String toString() {
            return "OmegaBridge";
        }
    }

    private class QuadrupleBridge
    implements IBridgeRange {
        private final STATE mCallPredecessor;
        private final STATE mCallSuccessor;
        private final STATE mReturnPredecessor;
        private final STATE mReturnSuccessor;

        public QuadrupleBridge(STATE STATE, STATE STATE2, STATE STATE3, STATE STATE4) {
            this.mCallPredecessor = STATE;
            this.mCallSuccessor = STATE2;
            this.mReturnPredecessor = STATE3;
            this.mReturnSuccessor = STATE4;
        }

        public String toString() {
            return "QuadrupleBridge(" + String.valueOf(this.mCallPredecessor) + ", " + String.valueOf(this.mCallSuccessor) + ", " + String.valueOf(this.mReturnPredecessor) + ", " + String.valueOf(this.mReturnSuccessor) + ")";
        }
    }

    private class SingletonBridge
    implements IBridgeRange {
        private final STATE mSingleton;

        public SingletonBridge(STATE STATE) {
            this.mSingleton = STATE;
        }

        public String toString() {
            return "SingletonBridge(" + String.valueOf(this.mSingleton) + ")";
        }
    }

    private class StatePair {
        private final STATE mSource;
        private final STATE mTarget;

        public StatePair(STATE STATE, STATE STATE2) {
            this.mSource = STATE;
            this.mTarget = STATE2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.mSource == ((StatePair)object).mSource && this.mTarget == ((StatePair)object).mTarget;
        }

        public int hashCode() {
            return (this.mSource.hashCode() + 41) * 41 + this.mTarget.hashCode();
        }

        public String toString() {
            return "(" + String.valueOf(this.mSource) + "," + String.valueOf(this.mTarget) + ")";
        }
    }

    private class Worklist {
        private final LinkedList<StatePair> mWorklist = new LinkedList();

        void enqueue(STATE STATE, STATE STATE2) {
            StatePair statePair = new StatePair(STATE, STATE2);
            this.mWorklist.addLast(statePair);
        }

        StatePair dequeue() {
            assert (!this.mWorklist.isEmpty());
            return this.mWorklist.removeFirst();
        }

        boolean isEmpty() {
            return this.mWorklist.isEmpty();
        }
    }
}

