/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness;

import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.IExtractedCorrectnessWitness;
import de.uni_freiburg.informatik.ultimate.witnessparser.preferences.WitnessParserPreferences;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;

public abstract class CorrectnessWitnessExtractor {
    private final IUltimateServiceProvider mServices;
    protected final ILogger mLogger;
    protected IPreferenceProvider mPrefs;
    protected final boolean mIgnoreUnmatchedEntries;
    protected IASTTranslationUnit mTranslationUnit;
    private IExtractedCorrectnessWitness mResult;
    protected ExtractionStatistics mStats;

    public CorrectnessWitnessExtractor(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mPrefs = WitnessParserPreferences.getPrefs((IUltimateServiceProvider)iUltimateServiceProvider);
        this.mIgnoreUnmatchedEntries = this.mPrefs.getBoolean("Ignore witness entries that could not be matched");
        this.mStats = new ExtractionStatistics();
    }

    public void setAST(IASTTranslationUnit iASTTranslationUnit) {
        this.mTranslationUnit = iASTTranslationUnit;
    }

    public IExtractedCorrectnessWitness getWitness() {
        if (this.mResult == null) {
            if (!this.isReady()) {
                this.mLogger.warn((Object)"Cannot extract witness if there is no witness");
                return null;
            }
            this.mResult = this.extractWitness();
            this.printWitness();
        }
        return this.mResult;
    }

    private void printWitness() {
        List<String> list = this.mResult.printAllEntries();
        if (list.isEmpty()) {
            this.mLogger.info((Object)"Witness did not contain any usable entries.");
            return;
        }
        this.mLogger.info((Object)"Found the following entries in the witness:");
        list.forEach(arg_0 -> ((ILogger)this.mLogger).info(arg_0));
    }

    protected abstract boolean isReady();

    protected abstract IExtractedCorrectnessWitness extractWitness();

    public static final class ExtractionStatistics {
        private int mSuccess = 0;
        private int mFailure = 0;

        public void success() {
            ++this.mSuccess;
        }

        public void fail() {
            ++this.mFailure;
        }

        public int getSuccess() {
            return this.mSuccess;
        }

        public int getFailure() {
            return this.mFailure;
        }

        public int getTotal() {
            return this.mSuccess + this.mFailure;
        }

        public String toString() {
            return "T/S/F " + this.getTotal() + "/" + this.getSuccess() + "/" + this.getFailure();
        }
    }
}

