/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;

public class AffineTerm
implements Serializable {
    private static final long serialVersionUID = -4454719554662175493L;
    private Rational mConstant;
    private final Map<Term, Rational> mCoefficients;

    public AffineTerm() {
        this.mCoefficients = new LinkedHashMap<Term, Rational>();
        this.mConstant = Rational.ZERO;
    }

    public AffineTerm(AffineTerm affineTerm) {
        this.mConstant = affineTerm.mConstant;
        this.mCoefficients = new LinkedHashMap<Term, Rational>(affineTerm.mCoefficients);
    }

    public AffineTerm(BigInteger bigInteger) {
        this();
        this.mConstant = Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE);
    }

    public AffineTerm(Rational rational) {
        this();
        this.mConstant = rational;
    }

    public AffineTerm(Term term, Rational rational) {
        this();
        this.mCoefficients.put(term, rational);
    }

    public boolean isConstant() {
        return this.mCoefficients.isEmpty();
    }

    public boolean isZero() {
        return this.mCoefficients.isEmpty() && this.mConstant.equals((Object)Rational.ZERO);
    }

    public Rational getConstant() {
        return this.mConstant;
    }

    public void add(Rational rational) {
        this.mConstant = this.mConstant.add(rational);
    }

    public void add(Term term, Rational rational) {
        if (this.mCoefficients.containsKey(term)) {
            Rational rational2 = this.mCoefficients.get(term).add(rational);
            if (!rational2.equals((Object)Rational.ZERO)) {
                this.mCoefficients.put(term, rational2);
            } else {
                this.mCoefficients.remove(term);
            }
        } else if (!rational.equals((Object)Rational.ZERO)) {
            this.mCoefficients.put(term, rational);
        }
    }

    public void add(AffineTerm affineTerm) {
        this.add(affineTerm.mConstant);
        for (Map.Entry<Term, Rational> entry : affineTerm.mCoefficients.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public void mult(Rational rational) {
        this.mConstant = this.mConstant.mul(rational);
        for (Map.Entry<Term, Rational> entry : this.mCoefficients.entrySet()) {
            this.mCoefficients.put(entry.getKey(), entry.getValue().mul(rational));
        }
    }

    public Term asRealTerm(Script script) {
        Term[] termArray = new Term[this.mCoefficients.size() + 1];
        int n = 0;
        for (Map.Entry<Term, Rational> entry : this.mCoefficients.entrySet()) {
            Term term = entry.getValue().toTerm(SmtSortUtils.getRealSort((Script)script));
            termArray[n] = script.term("*", new Term[]{term, entry.getKey()});
            ++n;
        }
        termArray[n] = this.mConstant.toTerm(SmtSortUtils.getRealSort((Script)script));
        return SmtUtils.sum((Script)script, (Sort)SmtSortUtils.getRealSort((Script)script), (Term[])termArray);
    }

    public Term asIntTerm(Script script) {
        Term[] termArray = new Term[this.mCoefficients.size() + 1];
        int n = 0;
        for (Map.Entry<Term, Rational> entry : this.mCoefficients.entrySet()) {
            assert (entry.getValue().isIntegral());
            Term term = SmtUtils.constructIntValue((Script)script, (BigInteger)entry.getValue().numerator());
            termArray[n] = script.term("*", new Term[]{term, entry.getKey()});
            ++n;
        }
        assert (this.mConstant.isIntegral());
        termArray[n] = SmtUtils.constructIntValue((Script)script, (BigInteger)this.mConstant.numerator());
        return SmtUtils.sum((Script)script, (Sort)SmtSortUtils.getIntSort((Script)script), (Term[])termArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Map.Entry<Term, Rational> entry : this.mCoefficients.entrySet()) {
            if (entry.getValue().isNegative() || !bl) {
                if (!bl) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(entry.getValue().isNegative() ? "- " : "+ ");
            }
            stringBuilder.append(String.valueOf(entry.getValue().abs()) + "*" + String.valueOf(entry.getKey()));
            bl = false;
        }
        if (!this.mConstant.equals((Object)Rational.ZERO) || stringBuilder.length() == 0) {
            if (this.mConstant.isNegative() || !bl) {
                if (!bl) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(this.mConstant.isNegative() ? "- " : "+ ");
            }
            stringBuilder.append(this.mConstant.abs());
        }
        return stringBuilder.toString();
    }
}

