/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtsolver.external;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Executor;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.SmtCommandUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;

public class NonIncrementalScriptor
extends NoopScript {
    private static final String PRINT_SUCCESS = ":print-success";
    private static final boolean mNewScriptAfterEachReset = false;
    private int mNewScriptCounter = 0;
    protected final LinkedList<ArrayList<SmtCommandUtils.ISmtCommand<?>>> mCommandStack;
    protected Executor mExecutor;
    private Script.LBool mStatus = Script.LBool.UNKNOWN;
    private PrintWriter mPw;
    private final String mPathOfDumpedFakeNonIncrementalScript;
    private final String mBasenameOfDumpedFakeNonIcrementalScript;

    public NonIncrementalScriptor(String string, ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, String string2, boolean bl, String string3, String string4, String string5) throws IOException {
        if (bl) {
            this.mPathOfDumpedFakeNonIncrementalScript = string3;
            this.mBasenameOfDumpedFakeNonIcrementalScript = string4;
            String string6 = string3 + File.separator + string4 + "_fakeNonIncremental.smt2";
            this.mPw = this.constructPrintWriter(string6);
        } else {
            this.mPw = null;
            this.mPathOfDumpedFakeNonIncrementalScript = null;
            this.mBasenameOfDumpedFakeNonIcrementalScript = null;
        }
        this.mExecutor = new Executor(string, (Script)this, iLogger, iUltimateServiceProvider, string2, string5);
        this.mCommandStack = new LinkedList();
        this.mCommandStack.push(new ArrayList());
    }

    private String constructFullFilenameForNewScript() {
        String string = this.mPathOfDumpedFakeNonIncrementalScript + File.separator + this.mBasenameOfDumpedFakeNonIcrementalScript + "_fakeNonIncremental_" + this.mNewScriptCounter + ".smt2";
        ++this.mNewScriptCounter;
        return string;
    }

    private PrintWriter constructPrintWriter(String string) throws FileNotFoundException {
        return new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(new FileOutputStream(string))), true);
    }

    protected void addToCurrentAssertionStack(SmtCommandUtils.ISmtCommand<?> iSmtCommand) {
        this.mCommandStack.getLast().add(iSmtCommand);
    }

    private void resetAssertionStack() {
        this.mCommandStack.clear();
        this.mCommandStack.add(new ArrayList());
    }

    public void setLogic(Logics logics) throws UnsupportedOperationException, SMTLIBException {
        super.setLogic(logics);
        this.addToCurrentAssertionStack(new SmtCommandUtils.SetLogicCommand(logics.name()));
    }

    public void setOption(String string, Object object) throws UnsupportedOperationException, SMTLIBException {
        if (!string.equals(PRINT_SUCCESS)) {
            this.addToCurrentAssertionStack(new SmtCommandUtils.SetOptionCommand(string, object));
        }
    }

    public void setInfo(String string, Object object) {
        this.addToCurrentAssertionStack(new SmtCommandUtils.SetInfoCommand(string, object));
    }

    public void declareSort(String string, int n) throws SMTLIBException {
        super.declareSort(string, n);
        this.addToCurrentAssertionStack(new SmtCommandUtils.DeclareSortCommand(string, n));
    }

    public void defineSort(String string, Sort[] sortArray, Sort sort) throws SMTLIBException {
        super.defineSort(string, sortArray, sort);
        this.addToCurrentAssertionStack(new SmtCommandUtils.DefineSortCommand(string, sortArray, sort));
    }

    public void declareFun(String string, Sort[] sortArray, Sort sort) throws SMTLIBException {
        super.declareFun(string, sortArray, sort);
        this.addToCurrentAssertionStack(new SmtCommandUtils.DeclareFunCommand(string, sortArray, sort));
    }

    public void defineFun(String string, TermVariable[] termVariableArray, Sort sort, Term term) throws SMTLIBException {
        super.defineFun(string, termVariableArray, sort, term);
        this.addToCurrentAssertionStack(new SmtCommandUtils.DefineFunCommand(string, termVariableArray, sort, term));
    }

    public void push(int n) throws SMTLIBException {
        super.push(n);
        int n2 = 0;
        while (n2 < n) {
            this.mCommandStack.add(new ArrayList());
            ++n2;
        }
    }

    public void pop(int n) throws SMTLIBException {
        super.pop(n);
        int n2 = 0;
        while (n2 < n) {
            this.mCommandStack.removeLast();
            ++n2;
        }
        this.mStatus = Script.LBool.UNKNOWN;
    }

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        this.addToCurrentAssertionStack(new SmtCommandUtils.AssertCommand(term));
        this.mStatus = Script.LBool.UNKNOWN;
        return Script.LBool.UNKNOWN;
    }

    public Script.LBool checkSat() throws SMTLIBException {
        new SmtCommandUtils.ResetCommand().executeWithExecutor(this.mExecutor, this.mPw);
        new SmtCommandUtils.SetOptionCommand(PRINT_SUCCESS, true).executeWithExecutor(this.mExecutor, this.mPw);
        for (ArrayList arrayList : this.mCommandStack) {
            for (SmtCommandUtils.ISmtCommand iSmtCommand : arrayList) {
                iSmtCommand.executeWithExecutor(this.mExecutor, this.mPw);
            }
        }
        this.mStatus = new SmtCommandUtils.CheckSatCommand().executeWithExecutor(this.mExecutor, this.mPw);
        if (this.mPw != null) {
            this.mPw.println("; response to preceding check-sat was " + String.valueOf(this.mStatus) + " when this script was constructed");
        }
        return this.mStatus;
    }

    public Term[] getAssertions() throws SMTLIBException {
        this.mExecutor.input("(get-assertions)");
        return this.mExecutor.parseGetAssertionsResult();
    }

    public Term getProof() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Proofs are not supported");
    }

    public Term[] getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        this.mExecutor.input(SmtCommandUtils.GetUnsatCoreCommand.buildString());
        return this.mExecutor.parseGetUnsatCoreResult();
    }

    public Map<Term, Term> getValue(Term[] termArray) throws SMTLIBException, UnsupportedOperationException {
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            if (!(term.getSort().isNumericSort() || term.getSort() == this.getTheory().getBooleanSort() || term.getSort().getRealSort().getName().equals("BitVec") || term.getSort().getRealSort().getName().equals("FloatingPoint"))) {
                throw new UnsupportedOperationException();
            }
            ++n2;
        }
        this.mExecutor.input(SmtCommandUtils.GetValueCommand.buildString(termArray));
        return this.mExecutor.parseGetValueResult();
    }

    public Assignments getAssignment() throws SMTLIBException, UnsupportedOperationException {
        this.mExecutor.input("(get-assignment)");
        return this.mExecutor.parseGetAssignmentResult();
    }

    public Object getOption(String string) throws UnsupportedOperationException {
        this.mExecutor.input("(get-option " + string + ")");
        return this.mExecutor.parseGetOptionResult();
    }

    public Object getInfo(String string) throws UnsupportedOperationException {
        this.mExecutor.input("(get-info " + string + ")");
        Object[] objectArray = this.mExecutor.parseGetInfoResult();
        if (objectArray.length == 1) {
            return objectArray[0];
        }
        return objectArray;
    }

    public void exit() {
        this.mExecutor.exit();
    }

    public Term simplify(Term term) throws SMTLIBException {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        super.reset();
        new SmtCommandUtils.ResetCommand().executeWithExecutor(this.mExecutor, this.mPw);
        this.resetAssertionStack();
        this.mStatus = Script.LBool.UNKNOWN;
    }

    public Model getModel() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Script.LBool getStatus() {
        return this.mStatus;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (ArrayList arrayList : this.mCommandStack) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("; next level of assertion stack").append(System.lineSeparator());
            }
            for (SmtCommandUtils.ISmtCommand iSmtCommand : arrayList) {
                stringBuilder.append(iSmtCommand.toString()).append(System.lineSeparator());
            }
        }
        return stringBuilder.toString();
    }
}

