/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.math.BigInteger;
import java.util.Objects;
import java.util.function.Function;

public class BitvectorConstant {
    private final BigInteger mValue;
    private final BigInteger mIndex;

    public BitvectorConstant(BigInteger bigInteger, BigInteger bigInteger2) {
        this.mValue = BitvectorConstant.computeUnifiedValue(bigInteger, bigInteger2);
        this.mIndex = bigInteger2;
    }

    public BitvectorConstant(BigInteger bigInteger, String string) {
        BigInteger bigInteger2 = new BigInteger(string);
        this.mValue = BitvectorConstant.computeUnifiedValue(bigInteger, bigInteger2);
        this.mIndex = bigInteger2;
    }

    private static BigInteger computeUnifiedValue(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.mod(new BigInteger("2").pow(bigInteger2.intValueExact()));
    }

    public BigInteger getValue() {
        return this.mValue;
    }

    public BigInteger getIndex() {
        return this.mIndex;
    }

    public String getStringIndex() {
        return this.mIndex.toString();
    }

    public boolean isZero() {
        return this.mValue.signum() == 0;
    }

    public boolean isOne() {
        return this.mValue.equals(BigInteger.ONE);
    }

    public int hashCode() {
        return Objects.hash(this.mIndex, this.mValue);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BitvectorConstant bitvectorConstant = (BitvectorConstant)object;
        if (this.mIndex == null ? bitvectorConstant.mIndex != null : !this.mIndex.equals(bitvectorConstant.mIndex)) {
            return false;
        }
        return !(this.mValue == null ? bitvectorConstant.mValue != null : !this.mValue.equals(bitvectorConstant.mValue));
    }

    public String toString() {
        return "(_ bv" + String.valueOf(this.mValue) + " " + String.valueOf(this.mIndex) + ")";
    }

    public static BitvectorConstant maxValue(int n) {
        return new BitvectorConstant(BigInteger.valueOf(2L).pow(n).subtract(BigInteger.valueOf(1L)), BigInteger.valueOf(n));
    }

    public static BitvectorConstant maxValue(BigInteger bigInteger) {
        return new BitvectorConstant(BigInteger.valueOf(2L).pow(bigInteger.intValueExact()).subtract(BigInteger.valueOf(1L)), bigInteger);
    }

    public static BitvectorConstant bvadd(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bitvectorConstant, bitvectorConstant2, bigInteger -> bigInteger2 -> bigInteger.add((BigInteger)bigInteger2));
    }

    public static BitvectorConstant bvsub(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bitvectorConstant, bitvectorConstant2, bigInteger -> bigInteger2 -> bigInteger.subtract((BigInteger)bigInteger2));
    }

    public static BitvectorConstant bvmul(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bitvectorConstant, bitvectorConstant2, bigInteger -> bigInteger2 -> bigInteger.multiply((BigInteger)bigInteger2));
    }

    public static BitvectorConstant bvudiv(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        if (bitvectorConstant2.getValue().signum() == 0) {
            return BitvectorConstant.maxValue(bitvectorConstant.getIndex());
        }
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bitvectorConstant, bitvectorConstant2, bigInteger -> bigInteger2 -> bigInteger.divide((BigInteger)bigInteger2));
    }

    public static BitvectorConstant bvurem(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        if (bitvectorConstant2.getValue().signum() == 0) {
            return bitvectorConstant;
        }
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bitvectorConstant, bitvectorConstant2, bigInteger -> bigInteger2 -> bigInteger.remainder((BigInteger)bigInteger2));
    }

    public static BitvectorConstant bvsdiv(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        if (BitvectorConstant.toSignedInt(bitvectorConstant2.getValue(), bitvectorConstant2.getIndex()).signum() == 0) {
            return BitvectorConstant.bvudiv(bitvectorConstant, bitvectorConstant2);
        }
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bitvectorConstant, bitvectorConstant2, bigInteger -> bigInteger2 -> BitvectorConstant.toSignedInt(bigInteger, bitvectorConstant.getIndex()).divide(BitvectorConstant.toSignedInt(bigInteger2, bitvectorConstant2.getIndex())));
    }

    public static BitvectorConstant bvsrem(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        if (BitvectorConstant.toSignedInt(bitvectorConstant2.getValue(), bitvectorConstant2.getIndex()).signum() == 0) {
            return BitvectorConstant.bvurem(bitvectorConstant, bitvectorConstant2);
        }
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bitvectorConstant, bitvectorConstant2, bigInteger -> bigInteger2 -> BitvectorConstant.toSignedInt(bigInteger, bitvectorConstant.getIndex()).remainder(BitvectorConstant.toSignedInt(bigInteger2, bitvectorConstant2.getIndex())));
    }

    public static BitvectorConstant bvsmod(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        BigInteger bigInteger = BitvectorConstant.toSignedInt(bitvectorConstant.getValue(), bitvectorConstant.getIndex());
        BigInteger bigInteger2 = BitvectorConstant.toSignedInt(bitvectorConstant2.getValue(), bitvectorConstant2.getIndex());
        BitvectorConstant bitvectorConstant3 = bitvectorConstant;
        BitvectorConstant bitvectorConstant4 = bitvectorConstant2;
        if (bigInteger.signum() == -1) {
            bitvectorConstant3 = BitvectorConstant.bvneg(bitvectorConstant3);
        }
        if (bigInteger2.signum() == -1) {
            bitvectorConstant4 = BitvectorConstant.bvneg(bitvectorConstant4);
        }
        BitvectorConstant bitvectorConstant5 = BitvectorConstant.bvurem(bitvectorConstant3, bitvectorConstant4);
        if (bigInteger.signum() == -1 && bigInteger2.signum() == 1) {
            return BitvectorConstant.bvadd(BitvectorConstant.bvneg(bitvectorConstant5), bitvectorConstant2);
        }
        if (bigInteger.signum() == 1 && bigInteger2.signum() == -1) {
            return BitvectorConstant.bvadd(bitvectorConstant5, bitvectorConstant2);
        }
        if (bigInteger.signum() == -1 && bigInteger2.signum() == -1) {
            return BitvectorConstant.bvneg(bitvectorConstant5);
        }
        return bitvectorConstant5;
    }

    public static BitvectorConstant bvand(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bitvectorConstant, bitvectorConstant2, bigInteger -> bigInteger2 -> bigInteger.and((BigInteger)bigInteger2));
    }

    public static BitvectorConstant bvor(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bitvectorConstant, bitvectorConstant2, bigInteger -> bigInteger2 -> bigInteger.or((BigInteger)bigInteger2));
    }

    public static BitvectorConstant bvxor(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bitvectorConstant, bitvectorConstant2, bigInteger -> bigInteger2 -> bigInteger.xor((BigInteger)bigInteger2));
    }

    public static BitvectorConstant bvshl(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bitvectorConstant, bitvectorConstant2, bigInteger -> bigInteger2 -> bigInteger.shiftLeft(bigInteger2.intValueExact()));
    }

    public static BitvectorConstant bvlshr(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bitvectorConstant, bitvectorConstant2, bigInteger -> bigInteger2 -> bigInteger.shiftRight(bigInteger2.intValueExact()));
    }

    public static BitvectorConstant bvashr(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        return BitvectorConstant.similarIndexBvOp_BitvectorResult(bitvectorConstant, bitvectorConstant2, bigInteger -> bigInteger2 -> BitvectorConstant.toSignedInt(bigInteger, bitvectorConstant.getIndex()).shiftRight(bigInteger2.intValueExact()));
    }

    public static BitvectorConstant bvnot(BitvectorConstant bitvectorConstant) {
        return new BitvectorConstant(bitvectorConstant.getValue().not(), bitvectorConstant.getIndex());
    }

    public static BitvectorConstant bvneg(BitvectorConstant bitvectorConstant) {
        return new BitvectorConstant(BitvectorConstant.toSignedInt(bitvectorConstant.getValue(), bitvectorConstant.getIndex()).negate(), bitvectorConstant.getIndex());
    }

    public static BitvectorConstant similarIndexBvOp_BitvectorResult(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2, Function<BigInteger, Function<BigInteger, BigInteger>> function) {
        if (bitvectorConstant.getIndex().equals(bitvectorConstant2.getIndex())) {
            return new BitvectorConstant(function.apply(bitvectorConstant.getValue()).apply(bitvectorConstant2.getValue()), bitvectorConstant.getIndex());
        }
        throw new IllegalArgumentException("incompatible indices " + String.valueOf(bitvectorConstant.getIndex()) + " " + String.valueOf(bitvectorConstant2.getIndex()));
    }

    public static Boolean comparison(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2, Function<BigInteger, Function<BigInteger, Boolean>> function) {
        if (bitvectorConstant.getIndex().equals(bitvectorConstant2.getIndex())) {
            return function.apply(bitvectorConstant.getValue()).apply(bitvectorConstant2.getValue());
        }
        throw new IllegalArgumentException("incompatible indices " + String.valueOf(bitvectorConstant.getIndex()) + " " + String.valueOf(bitvectorConstant2.getIndex()));
    }

    public static boolean bvult(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        return BitvectorConstant.comparison(bitvectorConstant, bitvectorConstant2, bigInteger -> bigInteger2 -> bigInteger.compareTo((BigInteger)bigInteger2) < 0);
    }

    public static boolean bvule(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        return BitvectorConstant.comparison(bitvectorConstant, bitvectorConstant2, bigInteger -> bigInteger2 -> bigInteger.compareTo((BigInteger)bigInteger2) <= 0);
    }

    public static boolean bvugt(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        return BitvectorConstant.comparison(bitvectorConstant, bitvectorConstant2, bigInteger -> bigInteger2 -> bigInteger.compareTo((BigInteger)bigInteger2) > 0);
    }

    public static boolean bvuge(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        return BitvectorConstant.comparison(bitvectorConstant, bitvectorConstant2, bigInteger -> bigInteger2 -> bigInteger.compareTo((BigInteger)bigInteger2) >= 0);
    }

    public static boolean bvslt(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        return BitvectorConstant.comparison(bitvectorConstant, bitvectorConstant2, bigInteger -> bigInteger2 -> BitvectorConstant.toSignedInt(bigInteger, bitvectorConstant.getIndex()).compareTo(BitvectorConstant.toSignedInt(bigInteger2, bitvectorConstant2.getIndex())) < 0);
    }

    public static boolean bvsle(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        return BitvectorConstant.comparison(bitvectorConstant, bitvectorConstant2, bigInteger -> bigInteger2 -> BitvectorConstant.toSignedInt(bigInteger, bitvectorConstant.getIndex()).compareTo(BitvectorConstant.toSignedInt(bigInteger2, bitvectorConstant2.getIndex())) <= 0);
    }

    public static boolean bvsgt(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        return BitvectorConstant.comparison(bitvectorConstant, bitvectorConstant2, bigInteger -> bigInteger2 -> BitvectorConstant.toSignedInt(bigInteger, bitvectorConstant.getIndex()).compareTo(BitvectorConstant.toSignedInt(bigInteger2, bitvectorConstant2.getIndex())) > 0);
    }

    public static boolean bvsge(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        return BitvectorConstant.comparison(bitvectorConstant, bitvectorConstant2, bigInteger -> bigInteger2 -> BitvectorConstant.toSignedInt(bigInteger, bitvectorConstant.getIndex()).compareTo(BitvectorConstant.toSignedInt(bigInteger2, bitvectorConstant2.getIndex())) >= 0);
    }

    public static BitvectorConstant concat(BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        BigInteger bigInteger = bitvectorConstant.getIndex().add(bitvectorConstant2.getIndex());
        BigInteger bigInteger2 = bitvectorConstant.getValue().multiply(BigInteger.TWO.pow(bitvectorConstant2.getIndex().intValue())).add(bitvectorConstant2.getValue());
        return new BitvectorConstant(bigInteger2, bigInteger);
    }

    public static BitvectorConstant extract(BitvectorConstant bitvectorConstant, int n, int n2) {
        int n3 = n + 1 - n2;
        String string = BitvectorConstant.bvToBinaryString(bitvectorConstant);
        String string2 = n3 < string.length() ? string.substring(string.length() - 1 - n, string.length() - n2) : string;
        BigInteger bigInteger = BitvectorConstant.binaryStringToBv(string2);
        return new BitvectorConstant(bigInteger, BigInteger.valueOf(n3));
    }

    private static BigInteger binaryStringToBv(String string) {
        return new BigInteger(string, 2);
    }

    private static String bvToBinaryString(BitvectorConstant bitvectorConstant) {
        String string = bitvectorConstant.getValue().toString(2);
        String string2 = new String(new char[bitvectorConstant.getIndex().intValueExact() - string.length()]).replace('\u0000', '0');
        String string3 = string2 + string;
        assert (string3.length() == bitvectorConstant.getIndex().intValueExact());
        return string3;
    }

    public static BitvectorConstant zero_extend(BitvectorConstant bitvectorConstant, BigInteger bigInteger) {
        return new BitvectorConstant(bitvectorConstant.getValue(), bitvectorConstant.getIndex().add(bigInteger));
    }

    public static BitvectorConstant sign_extend(BitvectorConstant bitvectorConstant, BigInteger bigInteger) {
        BigInteger bigInteger2 = bitvectorConstant.toSignedInt();
        return new BitvectorConstant(bigInteger2, bitvectorConstant.getIndex().add(bigInteger));
    }

    public static BigInteger toSignedInt(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = new BigInteger("2").pow(bigInteger2.intValueExact() - 1);
        if (bigInteger.compareTo(bigInteger3) < 0) {
            return bigInteger;
        }
        BigInteger bigInteger4 = new BigInteger("2").pow(bigInteger2.intValueExact());
        return bigInteger.subtract(bigInteger4);
    }

    public BigInteger toSignedInt() {
        return BitvectorConstant.toSignedInt(this.mValue, this.mIndex);
    }

    public static BitvectorConstantOperationResult apply(BvOp bvOp, BitvectorConstant ... bitvectorConstantArray) {
        if (bitvectorConstantArray == null) {
            throw new IllegalArgumentException("No operands");
        }
        if (bitvectorConstantArray.length != bvOp.getArity()) {
            throw new IllegalArgumentException("Operation " + String.valueOf((Object)bvOp) + " has arity " + bvOp.getArity() + " but " + bitvectorConstantArray.length + " operands given");
        }
        return switch (bvOp) {
            case BvOp.bvadd -> new BitvectorConstantOperationResult(BitvectorConstant.bvadd(bitvectorConstantArray[0], bitvectorConstantArray[1]));
            case BvOp.bvand -> new BitvectorConstantOperationResult(BitvectorConstant.bvand(bitvectorConstantArray[0], bitvectorConstantArray[1]));
            case BvOp.bvashr -> new BitvectorConstantOperationResult(BitvectorConstant.bvashr(bitvectorConstantArray[0], bitvectorConstantArray[1]));
            case BvOp.bvlshr -> new BitvectorConstantOperationResult(BitvectorConstant.bvlshr(bitvectorConstantArray[0], bitvectorConstantArray[1]));
            case BvOp.bvmul -> new BitvectorConstantOperationResult(BitvectorConstant.bvmul(bitvectorConstantArray[0], bitvectorConstantArray[1]));
            case BvOp.bvneg -> new BitvectorConstantOperationResult(BitvectorConstant.bvneg(bitvectorConstantArray[0]));
            case BvOp.bvnot -> new BitvectorConstantOperationResult(BitvectorConstant.bvnot(bitvectorConstantArray[0]));
            case BvOp.bvor -> new BitvectorConstantOperationResult(BitvectorConstant.bvor(bitvectorConstantArray[0], bitvectorConstantArray[1]));
            case BvOp.bvsdiv -> new BitvectorConstantOperationResult(BitvectorConstant.bvsdiv(bitvectorConstantArray[0], bitvectorConstantArray[1]));
            case BvOp.bvsge -> new BitvectorConstantOperationResult(BitvectorConstant.bvsge(bitvectorConstantArray[0], bitvectorConstantArray[1]));
            case BvOp.bvsgt -> new BitvectorConstantOperationResult(BitvectorConstant.bvsgt(bitvectorConstantArray[0], bitvectorConstantArray[1]));
            case BvOp.bvshl -> new BitvectorConstantOperationResult(BitvectorConstant.bvshl(bitvectorConstantArray[0], bitvectorConstantArray[1]));
            case BvOp.bvsle -> new BitvectorConstantOperationResult(BitvectorConstant.bvsle(bitvectorConstantArray[0], bitvectorConstantArray[1]));
            case BvOp.bvslt -> new BitvectorConstantOperationResult(BitvectorConstant.bvslt(bitvectorConstantArray[0], bitvectorConstantArray[1]));
            case BvOp.bvsrem -> new BitvectorConstantOperationResult(BitvectorConstant.bvsrem(bitvectorConstantArray[0], bitvectorConstantArray[1]));
            case BvOp.bvsub -> new BitvectorConstantOperationResult(BitvectorConstant.bvsub(bitvectorConstantArray[0], bitvectorConstantArray[1]));
            case BvOp.bvudiv -> new BitvectorConstantOperationResult(BitvectorConstant.bvudiv(bitvectorConstantArray[0], bitvectorConstantArray[1]));
            case BvOp.bvuge -> new BitvectorConstantOperationResult(BitvectorConstant.bvuge(bitvectorConstantArray[0], bitvectorConstantArray[1]));
            case BvOp.bvugt -> new BitvectorConstantOperationResult(BitvectorConstant.bvugt(bitvectorConstantArray[0], bitvectorConstantArray[1]));
            case BvOp.bvule -> new BitvectorConstantOperationResult(BitvectorConstant.bvule(bitvectorConstantArray[0], bitvectorConstantArray[1]));
            case BvOp.bvult -> new BitvectorConstantOperationResult(BitvectorConstant.bvult(bitvectorConstantArray[0], bitvectorConstantArray[1]));
            case BvOp.bvurem -> new BitvectorConstantOperationResult(BitvectorConstant.bvurem(bitvectorConstantArray[0], bitvectorConstantArray[1]));
            case BvOp.bvxor -> new BitvectorConstantOperationResult(BitvectorConstant.bvxor(bitvectorConstantArray[0], bitvectorConstantArray[1]));
            case BvOp.sign_extend, BvOp.zero_extend, BvOp.extract, BvOp.concat, BvOp.bvsmod -> throw new UnsupportedOperationException("Operation currently unsupported: " + String.valueOf((Object)bvOp));
            default -> throw new MatchException(null, null);
        };
    }

    public static final class BitvectorConstantOperationResult {
        private final BitvectorConstant mBvResult;
        private final Boolean mBooleanResult;

        public BitvectorConstantOperationResult(BitvectorConstant bitvectorConstant) {
            this.mBvResult = bitvectorConstant;
            this.mBooleanResult = null;
        }

        public BitvectorConstantOperationResult(boolean bl) {
            this.mBvResult = null;
            this.mBooleanResult = bl;
        }

        public boolean isBoolean() {
            return this.mBooleanResult != null;
        }

        public boolean getBooleanResult() {
            return this.mBooleanResult;
        }

        public BitvectorConstant getBvResult() {
            return this.mBvResult;
        }
    }

    public static enum BvOp {
        sign_extend(2, false, false),
        zero_extend(2, false, false),
        extract(3, false, false),
        concat(2, false, false),
        bvadd(2, false, true),
        bvsub(2, false, false),
        bvmul(2, false, true),
        bvudiv(2, false, false),
        bvurem(2, false, false),
        bvsdiv(2, false, false),
        bvsrem(2, false, false),
        bvsmod(2, false, false),
        bvand(2, false, true),
        bvor(2, false, true),
        bvxor(2, false, true),
        bvnot(1, false, true),
        bvneg(1, false, true),
        bvshl(2, false, false),
        bvlshr(2, false, false),
        bvashr(2, false, false),
        bvult(2, true, false),
        bvule(2, true, false),
        bvugt(2, true, false),
        bvuge(2, true, false),
        bvslt(2, true, false),
        bvsle(2, true, false),
        bvsgt(2, true, false),
        bvsge(2, true, false);

        private final int mArity;
        private final boolean mIsBoolean;
        private final boolean mIsAssociative;

        private BvOp(int n2, boolean bl, boolean bl2) {
            this.mArity = n2;
            this.mIsBoolean = bl;
            this.mIsAssociative = bl2;
        }

        public int getArity() {
            return this.mArity;
        }

        public boolean isBoolean() {
            return this.mIsBoolean;
        }

        public boolean isCommutative() {
            return this.mIsAssociative;
        }
    }

    public static enum ExtendOperation {
        sign_extend(BvOp.sign_extend),
        zero_extend(BvOp.zero_extend);

        private final BvOp mBvOp;

        private ExtendOperation(BvOp bvOp) {
            this.mBvOp = bvOp;
        }

        public BvOp getBvOp() {
            return this.mBvOp;
        }
    }
}

