/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.procedureinliner;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.Activator;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.IInlineSelector;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.InlineVersionTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.InlinerStatistic;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.backtranslation.InlinerBacktranslator;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.callgraph.CallGraphBuilder;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.callgraph.CallGraphNode;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.callgraph.CallGraphNodeLabel;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.callgraph.NodeLabeler;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.exceptions.CancelToolchainException;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.preferences.PreferenceItem;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.preferences.PreferencesInlineSelector;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.ITranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class Inliner
implements IUnmanagedObserver {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final IProgressMonitorService mProgressMonitorService;
    private final IInlineSelector mInlineSelector;
    private Unit mAstUnit;
    private Collection<Declaration> mNonProcedureDeclarations;
    private Map<String, CallGraphNode> mCallGraph;
    private Map<String, Procedure> mNewProceduresWithBody;
    private final InlinerBacktranslator mBacktranslator;

    public Inliner(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mProgressMonitorService = iUltimateServiceProvider.getProgressMonitorService();
        this.mInlineSelector = new PreferencesInlineSelector(iUltimateServiceProvider);
        this.mBacktranslator = new InlinerBacktranslator(iUltimateServiceProvider);
    }

    public void init(ModelType modelType, int n, int n2) {
        this.mNewProceduresWithBody = new HashMap<String, Procedure>();
    }

    public void finish() {
        this.mServices.getBacktranslationService().addTranslator((ITranslator)this.mBacktranslator);
    }

    public boolean performedChanges() {
        return true;
    }

    public boolean process(IElement iElement) throws Throwable {
        if (!this.mProgressMonitorService.continueProcessing()) {
            return false;
        }
        if (iElement instanceof Unit) {
            this.mAstUnit = (Unit)iElement;
            try {
                this.inline();
            }
            catch (CancelToolchainException cancelToolchainException) {
                cancelToolchainException.logErrorAndCancelToolchain(this.mServices, Activator.PLUGIN_ID);
            }
            return false;
        }
        return true;
    }

    private void inline() throws CancelToolchainException {
        this.buildCallGraph();
        InlineVersionTransformer.GlobalScopeManager globalScopeManager = new InlineVersionTransformer.GlobalScopeManager(this.mNonProcedureDeclarations);
        InlinerStatistic inlinerStatistic = new InlinerStatistic(this.mCallGraph);
        for (CallGraphNode callGraphNode : this.proceduresToBeProcessed()) {
            if (!callGraphNode.hasInlineFlags()) continue;
            assert (callGraphNode.isImplemented()) : "Cannot inline procedure that is not implemented";
            InlineVersionTransformer inlineVersionTransformer = new InlineVersionTransformer(this.mServices, globalScopeManager, inlinerStatistic);
            this.mNewProceduresWithBody.put(callGraphNode.getId(), inlineVersionTransformer.inlineCallsInside(callGraphNode));
            this.mBacktranslator.addBacktranslation(inlineVersionTransformer);
        }
        this.mLogger.info((Object)inlinerStatistic.toString());
        this.writeNewDeclarationsToAstUnit();
    }

    private void buildCallGraph() throws CancelToolchainException {
        CallGraphBuilder callGraphBuilder = new CallGraphBuilder();
        callGraphBuilder.buildCallGraph(this.mAstUnit);
        this.mCallGraph = callGraphBuilder.getCallGraph();
        this.mNonProcedureDeclarations = callGraphBuilder.getNonProcedureDeclarations();
        this.mInlineSelector.setInlineFlags(this.mCallGraph, callGraphBuilder.getProgramIsConcurrent());
    }

    private Collection<CallGraphNode> proceduresToBeProcessed() {
        if (!this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean(PreferenceItem.PROCESS_ONLY_ENTRY_AND_RE_ENTRY_PROCEDURES.getName())) {
            return this.mCallGraph.values();
        }
        List<String> list = PreferenceItem.ENTRY_PROCEDURES.getStringValueTokens(this.mServices);
        Collection<String> collection = this.missingEntryProcedures(list);
        if (collection.size() == list.size()) {
            this.mLogger.warn((Object)"Program contained no entry procedure!");
        }
        if (collection.isEmpty()) {
            return this.entryAndReEntryProcedures(list);
        }
        this.mLogger.warn((Object)("Missing entry procedures: " + String.valueOf(collection)));
        if (this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean(PreferenceItem.ENTRY_PROCEDURE_FALLBACK.getName())) {
            this.mLogger.warn((Object)"Fallback enabled. All procedures will be processed.");
            return this.mCallGraph.values();
        }
        this.mLogger.warn((Object)"Fallback not enabled! The resulting program might be not inlined or even empty.");
        return this.entryAndReEntryProcedures(list);
    }

    private Collection<String> missingEntryProcedures(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : collection) {
            if (this.mCallGraph.containsKey(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private Collection<CallGraphNode> entryAndReEntryProcedures(Collection<String> collection) {
        NodeLabeler nodeLabeler = new NodeLabeler(collection);
        collection = nodeLabeler.label(this.mCallGraph);
        HashSet<CallGraphNode> hashSet = new HashSet<CallGraphNode>();
        for (String string : collection) {
            CallGraphNode callGraphNode = this.mCallGraph.get(string);
            hashSet.add(callGraphNode);
        }
        return hashSet;
    }

    private void writeNewDeclarationsToAstUnit() {
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>(this.mNonProcedureDeclarations);
        boolean bl = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean(PreferenceItem.ELIMINATE_DEAD_CODE.getName());
        for (CallGraphNode callGraphNode : this.mCallGraph.values()) {
            if (bl && callGraphNode.getLabel() == CallGraphNodeLabel.DEAD) continue;
            Procedure procedure = callGraphNode.getProcedureWithSpecification();
            Procedure procedure2 = callGraphNode.getProcedureWithBody();
            Procedure procedure3 = this.mNewProceduresWithBody.get(callGraphNode.getId());
            if (procedure3 == null) {
                arrayList.add((Declaration)procedure);
                if (!callGraphNode.isImplemented() || callGraphNode.isCombined()) continue;
                arrayList.add((Declaration)procedure2);
                continue;
            }
            if (!callGraphNode.isCombined()) {
                arrayList.add((Declaration)procedure);
            }
            arrayList.add((Declaration)procedure3);
        }
        this.mAstUnit.setDeclarations(arrayList.toArray(new Declaration[arrayList.size()]));
    }
}

