/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.reqtotest.req;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.srparse.SrParseScopeAfter;
import de.uni_freiburg.informatik.ultimate.lib.srparse.SrParseScopeGlobally;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.AbsencePattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.DeclarationPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.InvarianceBoundL2Pattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.InvariancePattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternType;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.ResponseBoundL12Pattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.ResponseBoundL1Pattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.ResponseDelayPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.UniversalityPattern;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.pea2boogie.CddToSmt;
import de.uni_freiburg.informatik.ultimate.reqtotest.req.Req2TestReqSymbolTable;
import java.util.LinkedHashSet;
import java.util.List;

public class ReqToInOut {
    private final ILogger mLogger;
    private final Req2TestReqSymbolTable mReqSymbolTable;
    private final CddToSmt mCddToSmt;
    private final LinkedHashSet<TermVariable> mInputs;
    private final LinkedHashSet<TermVariable> mHidden;
    private final LinkedHashSet<TermVariable> mOutputs;
    private static final boolean UNIVERSALITY_IS_DEFINITNG = false;

    public ReqToInOut(ILogger iLogger, Req2TestReqSymbolTable req2TestReqSymbolTable, CddToSmt cddToSmt) {
        this.mLogger = iLogger;
        this.mReqSymbolTable = req2TestReqSymbolTable;
        this.mCddToSmt = cddToSmt;
        this.mInputs = new LinkedHashSet();
        this.mHidden = new LinkedHashSet();
        this.mOutputs = new LinkedHashSet();
    }

    public void requirementToInOut(List<PatternType<?>> list) {
        for (PatternType<?> termVariable : list) {
            if (termVariable instanceof DeclarationPattern) continue;
            this.addRequirement(termVariable);
        }
        this.mLogger.warn((Object)"Guessing In/Out/Hidden, please verify the Resluts.");
        this.mLogger.warn((Object)"Inputs:");
        this.mLogger.warn((Object)this.mInputs.toString());
        this.mLogger.warn((Object)"Hidden:");
        this.mLogger.warn((Object)this.mHidden.toString());
        this.mLogger.warn((Object)"Output:");
        this.mLogger.warn((Object)this.mOutputs.toString());
        for (TermVariable termVariable : this.mInputs) {
            this.mReqSymbolTable.updateVariableCategoryInput(termVariable.toString());
        }
        for (TermVariable termVariable : this.mHidden) {
            this.mReqSymbolTable.updateVariableCategoryHidden(termVariable.toString());
        }
        for (TermVariable termVariable : this.mOutputs) {
            this.mReqSymbolTable.updateVariableCategoryOutput(termVariable.toString());
        }
    }

    public void addRequirement(PatternType<?> patternType) {
        if (patternType instanceof InvariancePattern) {
            this.addInvariantPattern(patternType);
        } else if (patternType instanceof ResponseDelayPattern) {
            this.addBndResponsePatternUTPattern(patternType);
        } else if (patternType instanceof InvarianceBoundL2Pattern) {
            this.addBndInvariance(patternType);
        } else if (patternType instanceof ResponseBoundL12Pattern) {
            this.addBndResponsePatternTTPattern(patternType);
        } else if (patternType instanceof UniversalityPattern) {
            this.addUniversalityPattern(patternType);
        } else if (patternType instanceof AbsencePattern) {
            this.addInstAbsPattern(patternType);
        } else if (patternType instanceof ResponseBoundL1Pattern) {
            this.addBndResponsePatternTUPattern(patternType);
        } else {
            throw new RuntimeException("Pattern type is not supported at:" + patternType.toString());
        }
    }

    private void addTriggerSet(TermVariable[] termVariableArray) {
        TermVariable[] termVariableArray2 = termVariableArray;
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray2[n2];
            this.addTriggerVariable(termVariable);
            ++n2;
        }
    }

    private void addTriggerVariable(TermVariable termVariable) {
        if (this.mReqSymbolTable.isConstVar(termVariable.toString())) {
            return;
        }
        if (!this.mHidden.contains(termVariable)) {
            if (this.mOutputs.contains(termVariable)) {
                this.mOutputs.remove(termVariable);
                this.mHidden.add(termVariable);
            } else {
                this.mInputs.add(termVariable);
            }
        }
    }

    private void addEffectSet(TermVariable[] termVariableArray) {
        TermVariable[] termVariableArray2 = termVariableArray;
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray2[n2];
            this.addEffectVariable(termVariable);
            ++n2;
        }
    }

    private void addEffectVariable(TermVariable termVariable) {
        if (this.mReqSymbolTable.isConstVar(termVariable.toString())) {
            return;
        }
        if (!this.mHidden.contains(termVariable)) {
            if (this.mInputs.contains(termVariable)) {
                this.mInputs.remove(termVariable);
                this.mHidden.add(termVariable);
            } else {
                this.mOutputs.add(termVariable);
            }
        }
    }

    private void addBndResponsePatternTTPattern(PatternType<?> patternType) {
        if (patternType.getScope() instanceof SrParseScopeGlobally) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(1));
            Term term2 = this.mCddToSmt.toSmt((CDD)list.get(0));
            this.addTriggerSet(term.getFreeVars());
            this.addEffectSet(term2.getFreeVars());
        } else {
            this.scopeNotImplementedWarning(patternType);
        }
    }

    private void addBndResponsePatternTUPattern(PatternType<?> patternType) {
        if (patternType.getScope() instanceof SrParseScopeGlobally) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(1));
            Term term2 = this.mCddToSmt.toSmt((CDD)list.get(0));
            this.addTriggerSet(term.getFreeVars());
            this.addEffectSet(term2.getFreeVars());
        } else {
            this.scopeNotImplementedWarning(patternType);
        }
    }

    private void addBndInvariance(PatternType<?> patternType) {
        if (patternType.getScope() instanceof SrParseScopeGlobally) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(1));
            Term term2 = this.mCddToSmt.toSmt((CDD)list.get(0));
            this.addTriggerSet(term.getFreeVars());
            this.addEffectSet(term2.getFreeVars());
        } else {
            this.scopeNotImplementedWarning(patternType);
        }
    }

    private void addBndResponsePatternUTPattern(PatternType<?> patternType) {
        if (patternType.getScope() instanceof SrParseScopeGlobally) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(1));
            Term term2 = this.mCddToSmt.toSmt((CDD)list.get(0));
            this.addTriggerSet(term.getFreeVars());
            this.addEffectSet(term2.getFreeVars());
        } else if (patternType.getScope() instanceof SrParseScopeAfter) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(1));
            Term term3 = this.mCddToSmt.toSmt((CDD)list.get(0));
            Term term4 = this.mCddToSmt.toSmt(patternType.getScope().getCdd1());
            this.addTriggerSet(term4.getFreeVars());
            this.addTriggerSet(term.getFreeVars());
            this.addEffectSet(term3.getFreeVars());
        } else {
            this.scopeNotImplementedWarning(patternType);
        }
    }

    private void addInvariantPattern(PatternType<?> patternType) {
        if (patternType.getScope() instanceof SrParseScopeGlobally) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(1));
            Term term2 = this.mCddToSmt.toSmt((CDD)list.get(0));
            this.addTriggerSet(term.getFreeVars());
            this.addEffectSet(term2.getFreeVars());
        } else if (patternType.getScope() instanceof SrParseScopeAfter) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(1));
            Term term3 = this.mCddToSmt.toSmt((CDD)list.get(0));
            Term term4 = this.mCddToSmt.toSmt(patternType.getScope().getCdd1());
            this.addTriggerSet(term.getFreeVars());
            this.addEffectSet(term3.getFreeVars());
            this.addTriggerSet(term4.getFreeVars());
        } else {
            this.scopeNotImplementedWarning(patternType);
        }
    }

    private void addUniversalityPattern(PatternType<?> patternType) {
        if (patternType.getScope() instanceof SrParseScopeGlobally) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(0));
            this.addEffectSet(term.getFreeVars());
        } else {
            this.scopeNotImplementedWarning(patternType);
        }
    }

    private void addInstAbsPattern(PatternType<?> patternType) {
        if (patternType.getScope() instanceof SrParseScopeGlobally) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(0));
            this.addEffectSet(term.getFreeVars());
        } else {
            this.scopeNotImplementedWarning(patternType);
        }
    }

    private void getImmediateResponsePatternToAutomaton(PatternType<?> patternType) {
        if (patternType.getScope() instanceof SrParseScopeGlobally) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(1));
            Term term2 = this.mCddToSmt.toSmt((CDD)list.get(0));
            this.addTriggerSet(term.getFreeVars());
            this.addEffectSet(term2.getFreeVars());
        } else {
            this.scopeNotImplementedWarning(patternType);
        }
    }

    private void addTogglePatternDelayed(PatternType<?> patternType) {
        if (patternType.getScope() instanceof SrParseScopeGlobally) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(0));
            Term term2 = this.mCddToSmt.toSmt((CDD)list.get(1));
            Term term3 = this.mCddToSmt.toSmt((CDD)list.get(2));
            this.addTriggerSet(term.getFreeVars());
            this.addTriggerSet(term2.getFreeVars());
            this.addEffectSet(term3.getFreeVars());
        } else {
            this.scopeNotImplementedWarning(patternType);
        }
    }

    private void scopeNotImplementedWarning(PatternType<?> patternType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Scope not implemented: ");
        stringBuilder.append(patternType.getScope().toString());
        stringBuilder.append(" [in: ");
        stringBuilder.append(patternType.getId());
        stringBuilder.append(" ]");
        this.mLogger.warn((Object)stringBuilder.toString());
    }
}

