/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.J3dI18N;
import javax.media.j3d.MasterControl;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.VirtualUniverse;

public class Alpha
extends NodeComponent {
    private int loopCount;
    public static final int INCREASING_ENABLE = 1;
    public static final int DECREASING_ENABLE = 2;
    private int mode;
    private float triggerTime;
    private float phaseDelay;
    private float increasingAlpha;
    private long increasingAlphaRamp;
    private float incAlphaRampInternal;
    private float alphaAtOne;
    private float decreasingAlpha;
    private long decreasingAlphaRamp;
    private float decAlphaRampInternal;
    private float alphaAtZero;
    private long pauseTime = 0L;
    private boolean paused = false;
    private float stopTime;
    private long startTime = MasterControl.systemStartTime;

    public Alpha() {
        this.loopCount = -1;
        this.mode = 1;
        this.increasingAlpha = 1.0f;
    }

    public Alpha(int n, int n2, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        this.loopCount = n;
        this.mode = n2;
        this.triggerTime = (float)l * 0.001f;
        this.phaseDelay = (float)l2 * 0.001f;
        this.increasingAlpha = (float)l3 * 0.001f;
        this.alphaAtOne = (float)l5 * 0.001f;
        this.increasingAlphaRamp = l4;
        this.incAlphaRampInternal = (float)l4 * 0.001f;
        if (this.incAlphaRampInternal > 0.5f * this.increasingAlpha) {
            this.incAlphaRampInternal = 0.5f * this.increasingAlpha;
        }
        this.decreasingAlpha = (float)l6 * 0.001f;
        this.alphaAtZero = (float)l8 * 0.001f;
        this.decreasingAlphaRamp = l7;
        this.decAlphaRampInternal = (float)l7 * 0.001f;
        if (this.decAlphaRampInternal > 0.5f * this.decreasingAlpha) {
            this.decAlphaRampInternal = 0.5f * this.decreasingAlpha;
        }
        this.computeStopTime();
    }

    public Alpha(int n, long l, long l2, long l3, long l4, long l5) {
        this(n, 1, l, l2, l3, l4, l5, 0L, 0L, 0L);
    }

    public Alpha(int n, long l) {
        this.mode = 1;
        this.increasingAlpha = (float)l * 0.001f;
        this.loopCount = n;
        if (n >= 0) {
            this.stopTime = (float)n * this.increasingAlpha;
        }
    }

    public void pause() {
        this.pause(System.currentTimeMillis());
    }

    public void pause(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException(J3dI18N.getString("Alpha0"));
        }
        this.paused = true;
        this.pauseTime = l;
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public void resume() {
        this.resume(System.currentTimeMillis());
    }

    public void resume(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException(J3dI18N.getString("Alpha0"));
        }
        if (this.paused) {
            long l2 = this.startTime + l - this.pauseTime;
            this.paused = false;
            this.pauseTime = 0L;
            this.setStartTime(l2);
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public long getPauseTime() {
        return this.pauseTime;
    }

    public float value() {
        long l = this.paused ? this.pauseTime : System.currentTimeMillis();
        return this.value(l);
    }

    public float value(long l) {
        float f = (float)(l - this.startTime) * 0.001f;
        if ((this.mode & 1) != 0 && (this.mode & 2) == 0) {
            if (f <= this.triggerTime + this.phaseDelay) {
                return 0.0f;
            }
            if (this.loopCount != -1 && f >= this.stopTime) {
                return 1.0f;
            }
            if (this.incAlphaRampInternal == 0.0f) {
                float f2 = this.mfmod(f - this.triggerTime - this.phaseDelay + 6.0f * (this.increasingAlpha + this.alphaAtOne), this.increasingAlpha + this.alphaAtOne) / this.increasingAlpha;
                if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                return f2;
            }
            float f3 = this.incAlphaRampInternal;
            float f4 = this.mfmod(f - this.triggerTime - this.phaseDelay + 6.0f * (this.increasingAlpha + this.alphaAtOne), this.increasingAlpha + this.alphaAtOne);
            if (f4 >= this.increasingAlpha) {
                float f5 = 1.0f;
                return f5;
            }
            float f6 = 1.0f / (this.increasingAlpha * f3 - f3 * f3);
            float f7 = f4 < f3 ? 0.5f * f6 * f4 * f4 : (f4 < this.increasingAlpha - f3 ? 0.5f * f6 * f3 * f3 + (f4 - f3) * f6 * f3 : f6 * f3 * f3 + (this.increasingAlpha - 2.0f * f3) * f6 * f3 - 0.5f * f6 * (this.increasingAlpha - f4) * (this.increasingAlpha - f4));
            return f7;
        }
        if ((this.mode & 1) == 0 && (this.mode & 2) != 0) {
            if (f <= this.triggerTime + this.phaseDelay) {
                return 1.0f;
            }
            if (this.loopCount != -1 && f >= this.stopTime) {
                return 0.0f;
            }
            if (this.decAlphaRampInternal == 0.0f) {
                float f8 = this.mfmod(f - this.triggerTime - this.phaseDelay + 6.0f * (this.decreasingAlpha + this.alphaAtZero), this.decreasingAlpha + this.alphaAtZero) / this.decreasingAlpha;
                if (f8 > 1.0f) {
                    f8 = 0.0f;
                    return f8;
                }
                f8 = 1.0f - f8;
                return f8;
            }
            float f9 = this.decAlphaRampInternal;
            float f10 = this.mfmod(f - this.triggerTime - this.phaseDelay + 6.0f * (this.decreasingAlpha + this.alphaAtZero), this.decreasingAlpha + this.alphaAtZero);
            if (f10 >= this.decreasingAlpha) {
                float f11 = 0.0f;
                return f11;
            }
            float f12 = 1.0f / (this.decreasingAlpha * f9 - f9 * f9);
            float f13 = f10 < f9 ? 0.5f * f12 * f10 * f10 : (f10 < this.decreasingAlpha - f9 ? 0.5f * f12 * f9 * f9 + (f10 - f9) * f12 * f9 : f12 * f9 * f9 + (this.decreasingAlpha - 2.0f * f9) * f12 * f9 - 0.5f * f12 * (this.decreasingAlpha - f10) * (this.decreasingAlpha - f10));
            f13 = 1.0f - f13;
            return f13;
        }
        if ((this.mode & 1) != 0 && (this.mode & 2) != 0) {
            float f14;
            if (f <= this.triggerTime + this.phaseDelay) {
                return 0.0f;
            }
            if (this.loopCount != -1 && f >= this.stopTime) {
                return 0.0f;
            }
            if (this.incAlphaRampInternal == 0.0f && this.decAlphaRampInternal == 0.0f) {
                float f15 = this.mfmod(f - this.triggerTime - this.phaseDelay + 6.0f * (this.increasingAlpha + this.alphaAtOne + this.decreasingAlpha + this.alphaAtZero), this.increasingAlpha + this.alphaAtOne + this.decreasingAlpha + this.alphaAtZero);
                float f16 = f15 / this.increasingAlpha;
                if (f16 < 1.0f) {
                    return f16;
                }
                if ((f15 -= this.increasingAlpha) < this.alphaAtOne) {
                    f16 = 1.0f;
                    return f16;
                }
                f16 = (f15 -= this.alphaAtOne) / this.decreasingAlpha;
                f16 = f16 < 1.0f ? 1.0f - f16 : 0.0f;
                return f16;
            }
            float f17 = this.incAlphaRampInternal;
            if (f17 == 0.0f) {
                f17 = 1.0E-5f;
            }
            if ((f14 = this.mfmod(f - this.triggerTime - this.phaseDelay + 6.0f * (this.increasingAlpha + this.alphaAtOne + this.decreasingAlpha + this.alphaAtZero), this.increasingAlpha + this.alphaAtOne + this.decreasingAlpha + this.alphaAtZero)) <= this.increasingAlpha) {
                float f18 = 1.0f / (this.increasingAlpha * f17 - f17 * f17);
                float f19 = f14 < f17 ? 0.5f * f18 * f14 * f14 : (f14 < this.increasingAlpha - f17 ? 0.5f * f18 * f17 * f17 + (f14 - f17) * f18 * f17 : f18 * f17 * f17 + (this.increasingAlpha - 2.0f * f17) * f18 * f17 - 0.5f * f18 * (this.increasingAlpha - f14) * (this.increasingAlpha - f14));
                return f19;
            }
            if (f14 <= this.increasingAlpha + this.alphaAtOne) {
                float f20 = 1.0f;
                return f20;
            }
            if (f14 >= this.increasingAlpha + this.alphaAtOne + this.decreasingAlpha) {
                float f21 = 0.0f;
                return f21;
            }
            f14 -= this.increasingAlpha + this.alphaAtOne;
            f17 = this.decAlphaRampInternal;
            if (f17 == 0.0f) {
                f17 = 1.0E-5f;
            }
            float f22 = 1.0f / (this.decreasingAlpha * f17 - f17 * f17);
            float f23 = f14 < f17 ? 0.5f * f22 * f14 * f14 : (f14 < this.decreasingAlpha - f17 ? 0.5f * f22 * f17 * f17 + (f14 - f17) * f22 * f17 : f22 * f17 * f17 + (this.decreasingAlpha - 2.0f * f17) * f22 * f17 - 0.5f * f22 * (this.decreasingAlpha - f14) * (this.decreasingAlpha - f14));
            f23 = 1.0f - f23;
            return f23;
        }
        return 0.0f;
    }

    float mfmod(float f, float f2) {
        float f3 = f;
        float f4 = f2;
        if (f4 < 0.0f) {
            f4 = -f4;
        }
        if (f3 < 0.0f) {
            f3 = -f3;
        }
        int n = (int)(f3 / f4);
        float f5 = f3 - (float)n * f4;
        if (f < 0.0f) {
            return f2 - f5;
        }
        return f5;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long l) {
        this.startTime = l;
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public void setLoopCount(int n) {
        this.loopCount = n;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getTriggerTime() {
        return (long)(this.triggerTime * 1000.0f);
    }

    public void setTriggerTime(long l) {
        this.triggerTime = (float)l * 0.001f;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getPhaseDelayDuration() {
        return (long)(this.phaseDelay * 1000.0f);
    }

    public void setPhaseDelayDuration(long l) {
        this.phaseDelay = (float)l * 0.001f;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getIncreasingAlphaDuration() {
        return (long)(this.increasingAlpha * 1000.0f);
    }

    public void setIncreasingAlphaDuration(long l) {
        this.increasingAlpha = (float)l * 0.001f;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getIncreasingAlphaRampDuration() {
        return this.increasingAlphaRamp;
    }

    public void setIncreasingAlphaRampDuration(long l) {
        this.increasingAlphaRamp = l;
        this.incAlphaRampInternal = (float)l * 0.001f;
        if (this.incAlphaRampInternal > 0.5f * this.increasingAlpha) {
            this.incAlphaRampInternal = 0.5f * this.increasingAlpha;
        }
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getAlphaAtOneDuration() {
        return (long)(this.alphaAtOne * 1000.0f);
    }

    public void setAlphaAtOneDuration(long l) {
        this.alphaAtOne = (float)l * 0.001f;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getDecreasingAlphaDuration() {
        return (long)(this.decreasingAlpha * 1000.0f);
    }

    public void setDecreasingAlphaDuration(long l) {
        this.decreasingAlpha = (float)l * 0.001f;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getDecreasingAlphaRampDuration() {
        return this.decreasingAlphaRamp;
    }

    public void setDecreasingAlphaRampDuration(long l) {
        this.decreasingAlphaRamp = l;
        this.decAlphaRampInternal = (float)l * 0.001f;
        if (this.decAlphaRampInternal > 0.5f * this.decreasingAlpha) {
            this.decAlphaRampInternal = 0.5f * this.decreasingAlpha;
        }
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getAlphaAtZeroDuration() {
        return (long)(this.alphaAtZero * 1000.0f);
    }

    public void setAlphaAtZeroDuration(long l) {
        this.alphaAtZero = (float)l * 0.001f;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public boolean finished() {
        long l = this.paused ? this.pauseTime : System.currentTimeMillis();
        return this.loopCount != -1 && (float)(l - this.startTime) * 0.001f > this.stopTime;
    }

    private final void computeStopTime() {
        if (this.loopCount >= 0) {
            float f = 0.0f;
            if ((this.mode & 1) != 0) {
                f = this.increasingAlpha + this.alphaAtOne;
            }
            if ((this.mode & 2) != 0) {
                f += this.decreasingAlpha + this.alphaAtZero;
            }
            this.stopTime = this.triggerTime + this.phaseDelay + (float)this.loopCount * f;
        } else {
            this.stopTime = 0.0f;
        }
    }

    Alpha cloneAlpha() {
        Alpha alpha = new Alpha();
        alpha.setStartTime(this.getStartTime());
        alpha.setLoopCount(this.getLoopCount());
        alpha.setMode(this.getMode());
        alpha.setTriggerTime(this.getTriggerTime());
        alpha.setPhaseDelayDuration(this.getPhaseDelayDuration());
        alpha.setIncreasingAlphaDuration(this.getIncreasingAlphaDuration());
        alpha.setIncreasingAlphaRampDuration(this.getIncreasingAlphaRampDuration());
        alpha.setAlphaAtOneDuration(this.getAlphaAtOneDuration());
        alpha.setDecreasingAlphaDuration(this.getDecreasingAlphaDuration());
        alpha.setDecreasingAlphaRampDuration(this.getDecreasingAlphaRampDuration());
        alpha.setAlphaAtZeroDuration(this.getAlphaAtZeroDuration());
        return alpha;
    }
}

