/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import de.uni_freiburg.informatik.ultimate.util.ScopeUtils;
import java.util.ArrayList;
import java.util.Iterator;

public class ScopedArrayList<E>
extends ArrayList<E> {
    int[] mLevels = new int[5];
    int mCurscope = -1;

    @Override
    public void clear() {
        this.mLevels = new int[5];
        this.mCurscope = -1;
        super.clear();
    }

    public void beginScope() {
        if (++this.mCurscope == this.mLevels.length) {
            this.mLevels = ScopeUtils.grow((int[])this.mLevels);
        }
        this.mLevels[this.mCurscope] = this.size();
    }

    public void endScope() {
        int n = this.mLevels[this.mCurscope];
        super.removeRange(n, this.size());
        if (ScopeUtils.shouldShrink((int)(--this.mCurscope), (int)this.mLevels.length)) {
            this.mLevels = ScopeUtils.shrink((int[])this.mLevels);
        }
    }

    public int getLastScopeSize() {
        return this.mLevels[this.mCurscope];
    }

    public void addToLevel(E e, int n) {
        if (n > this.mCurscope) {
            this.add(e);
        } else {
            int n2 = this.mLevels[n];
            this.add(n2, e);
            int n3 = n;
            while (n3 <= this.mCurscope) {
                int n4 = n;
                this.mLevels[n4] = this.mLevels[n4] + 1;
                ++n3;
            }
        }
    }

    public Iterable<E> currentScope() {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return ScopedArrayList.this.listIterator(ScopedArrayList.this.mLevels[ScopedArrayList.this.mCurscope]);
            }
        };
    }
}

