/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea;

import de.uni_freiburg.informatik.ultimate.lib.pea.BoogieBooleanExpressionDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.BooleanDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.Decision;
import de.uni_freiburg.informatik.ultimate.lib.pea.InitialTransition;
import de.uni_freiburg.informatik.ultimate.lib.pea.Phase;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseEventAutomata;
import de.uni_freiburg.informatik.ultimate.lib.pea.RangeDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.Transition;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PEAComplement {
    public static final String TOTAL_POSTFIX = "_total";
    public static final String COMPLEMENT_POSTFIX = "_complement";
    public static final String SINK_NAME = "sink";
    private final PhaseEventAutomata mPEAtoComplement;
    private final PhaseEventAutomata mTotalisedPEA;
    private final PhaseEventAutomata mComplementPEA;
    private final Set<String> mConstVars;

    public PEAComplement(PhaseEventAutomata phaseEventAutomata) {
        this.mPEAtoComplement = phaseEventAutomata;
        this.mConstVars = Collections.emptySet();
        this.mTotalisedPEA = this.totalise(this.mPEAtoComplement);
        this.mComplementPEA = this.complement(this.mTotalisedPEA);
    }

    public PEAComplement(PhaseEventAutomata phaseEventAutomata, Set<String> set) {
        this.mPEAtoComplement = phaseEventAutomata;
        this.mConstVars = set;
        this.mTotalisedPEA = this.totalise(this.mPEAtoComplement);
        this.mComplementPEA = this.complement(this.mTotalisedPEA);
    }

    public PhaseEventAutomata totalise(PhaseEventAutomata phaseEventAutomata) {
        Phase phase = new Phase(SINK_NAME, CDD.TRUE, CDD.TRUE);
        phase.addTransition(phase, CDD.TRUE, new String[0]);
        phase.setTerminal(false);
        this.computeInitialTransitionSink(phaseEventAutomata, phase);
        Map<String, Phase> map = this.copyPhases(phaseEventAutomata.getPhases(), TOTAL_POSTFIX);
        map.put(phase.getName(), phase);
        ArrayList<InitialTransition> arrayList = new ArrayList<InitialTransition>();
        for (Phase phase2 : phaseEventAutomata.getInit()) {
            arrayList.add(new InitialTransition(CDD.TRUE, map.get(phase2.getName())));
        }
        if (phase.isInit()) {
            arrayList.add(new InitialTransition(phase.getInitialTransition().getGuard(), phase));
        }
        HashSet<String> hashSet = new HashSet<String>(phaseEventAutomata.getClocks());
        for (Phase phase3 : phaseEventAutomata.getPhases()) {
            this.totalizeTransition(phase3, phase, map, hashSet);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : phaseEventAutomata.getClocks()) {
            arrayList2.add(this.addSuffixString(string, TOTAL_POSTFIX));
        }
        return new PhaseEventAutomata(this.addSuffixString(phaseEventAutomata.getName(), TOTAL_POSTFIX), new ArrayList<Phase>(map.values()), arrayList, arrayList2, new HashMap<String, String>(phaseEventAutomata.getVariables()));
    }

    private void totalizeTransition(Phase phase, Phase phase2, Map<String, Phase> map, Set<String> set) {
        CDD cDD;
        Object object;
        Object object2;
        CDD cDD2;
        Object object3;
        Object object4;
        Object object5;
        Phase phase3 = map.get(phase.getName());
        CDD cDD3 = phase.getClockInvariant();
        CDD cDD4 = phase.getStateInv().and(RangeDecision.strict(cDD3));
        if (phase.isStrict()) {
            CDD object62 = phase3.getClockInvariant();
            object5 = object62.toDNF_CDD();
            object4 = new ArrayList<RangeDecision>();
            object3 = this.strictConstraintHandling((CDD)object5, CDD.TRUE, (List<RangeDecision>)object4);
            phase3.setModifiedConstraints((List<RangeDecision>)object4);
            phase3.setClockInv((CDD)object3);
            for (Transition transition : phase.getTransitions()) {
                cDD2 = transition.getGuard();
                object2 = object4.iterator();
                while (object2.hasNext()) {
                    object = (RangeDecision)object2.next();
                    cDD = RangeDecision.create(((RangeDecision)object).getVar(), -2, ((RangeDecision)object).getVal(0));
                    cDD2 = cDD2.and(cDD);
                }
                transition.setGuard(cDD2);
            }
        }
        for (Transition transition : phase.getTransitions()) {
            object4 = map.get(transition.getDest().getName());
            object3 = phase3.addTransition((Phase)object4, this.addClockSuffixCDD(transition.getGuard(), TOTAL_POSTFIX), this.addClockSuffix(transition.getResets(), TOTAL_POSTFIX));
            String[] stringArray = ((Transition)object3).getResets();
            CDD cDD5 = ((Phase)object4).getStateInv();
            cDD2 = ((Phase)object4).getClockInv();
            object = transition.getGuard();
            object2 = ((CDD)object).unprime(set);
            if (stringArray.length > 0) {
                cDD = RangeDecision.filterCdd(cDD2, stringArray);
                cDD4 = cDD4.or(((CDD)object2).and(cDD5).and(RangeDecision.strict(cDD)));
                continue;
            }
            cDD4 = cDD4.or(((CDD)object2).and(cDD5).and(RangeDecision.strict(cDD2)));
        }
        Set<String> set2 = set;
        set2.addAll(this.mConstVars);
        object5 = cDD4.prime(set2);
        object4 = this.addClockSuffixCDD((CDD)object5, TOTAL_POSTFIX);
        phase3.addTransition(phase2, ((CDD)object4).negate(), new String[0]);
        map.put(phase3.getName(), phase3);
    }

    public PhaseEventAutomata complement(PhaseEventAutomata phaseEventAutomata) {
        ArrayList<Phase> arrayList = new ArrayList<Phase>();
        Map<String, Phase> map = this.copyPhases(phaseEventAutomata.mPhases, COMPLEMENT_POSTFIX);
        for (Phase phase : phaseEventAutomata.getPhases()) {
            Phase phase2 = map.get(phase.getName());
            boolean bl = !phase.getTerminal();
            phase2.setTerminal(bl);
            for (Transition transition : phase.getTransitions()) {
                phase2.addTransition(map.get(transition.getDest().getName()), this.addClockSuffixCDD(transition.getGuard(), COMPLEMENT_POSTFIX), this.addClockSuffix(transition.getResets(), COMPLEMENT_POSTFIX));
            }
            arrayList.add(phase2);
        }
        ArrayList<InitialTransition> arrayList2 = new ArrayList<InitialTransition>();
        for (Phase phase : phaseEventAutomata.getInit()) {
            arrayList2.add(new InitialTransition(phase.getInitialTransition().getGuard(), map.get(phase.getName())));
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (String string : phaseEventAutomata.getClocks()) {
            arrayList3.add(this.addSuffixString(string, TOTAL_POSTFIX));
        }
        return new PhaseEventAutomata(this.addSuffixString(phaseEventAutomata.getName(), COMPLEMENT_POSTFIX), arrayList, arrayList2, arrayList3, new HashMap<String, String>(phaseEventAutomata.getVariables()));
    }

    private void computeInitialTransitionSink(PhaseEventAutomata phaseEventAutomata, Phase phase) {
        CDD cDD = CDD.FALSE;
        List<Phase> list = phaseEventAutomata.getInit();
        for (Phase object : list) {
            assert (object.getInitialTransition() != null);
            InitialTransition initialTransition = object.getInitialTransition();
            CDD cDD2 = object.getStateInvariant().and(initialTransition.getGuard());
            cDD = cDD.or(cDD2);
        }
        if (cDD != CDD.TRUE) {
            InitialTransition initialTransition = new InitialTransition(cDD.negate(), phase);
            phase.setInitialTransition(initialTransition);
        } else {
            phase.setInit(false);
        }
    }

    private CDD strictConstraintHandling(CDD cDD, CDD cDD2, List<RangeDecision> list) {
        if (cDD == CDD.TRUE || cDD == CDD.FALSE) {
            return cDD2;
        }
        if (cDD.isAtomic()) {
            RangeDecision rangeDecision = (RangeDecision)cDD.getDecision();
            if (rangeDecision.getOp(0) == -2) {
                CDD cDD3 = RangeDecision.create(rangeDecision.getVar(), -1, rangeDecision.getVal(0));
                cDD2 = cDD2.and(cDD3);
                list.add(rangeDecision);
            }
            return cDD2;
        }
        if (cDD.getChilds() != null) {
            CDD cDD4;
            RangeDecision rangeDecision = (RangeDecision)cDD.getDecision();
            if (rangeDecision.getOp(0) == -2) {
                cDD4 = RangeDecision.create(rangeDecision.getVar(), -1, rangeDecision.getVal(0));
                cDD2 = cDD2.and(cDD4);
                list.add(rangeDecision);
            }
            cDD4 = cDD.getChilds()[0];
            this.strictConstraintHandling(cDD4, cDD2, list);
        }
        return cDD2;
    }

    private Map<String, Phase> copyPhases(List<Phase> list, String string) {
        HashMap<String, Phase> hashMap = new HashMap<String, Phase>();
        for (Phase phase : list) {
            Phase phase2 = new Phase(phase.getName(), phase.getStateInv(), this.addClockSuffixCDD(phase.getClockInv(), string));
            phase2.setTerminal(phase.getTerminal());
            hashMap.put(phase2.getName(), phase2);
            if (phase.getInitialTransition() != null) {
                InitialTransition initialTransition = phase.getInitialTransition();
                InitialTransition initialTransition2 = new InitialTransition(initialTransition.getGuard(), phase2);
                phase2.setInitialTransition(initialTransition2);
            }
            phase2.setModifiedConstraints(phase.getModifiedConstraints());
        }
        return hashMap;
    }

    public String addSuffixString(String string, String string2) {
        Object object;
        if (string.contains(COMPLEMENT_POSTFIX)) {
            object = string.split(COMPLEMENT_POSTFIX)[0];
            object = (String)object + string2;
        }
        if (string.contains(TOTAL_POSTFIX)) {
            object = string.split(TOTAL_POSTFIX)[0];
            object = (String)object + string2;
        } else {
            object = string + string2;
        }
        return object;
    }

    private String[] addClockSuffix(String[] stringArray, String string) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray2[n2];
            String string2 = this.addSuffixString((String)object, string);
            arrayList.add(string2);
            ++n2;
        }
        object = new String[arrayList.size()];
        return arrayList.toArray((T[])object);
    }

    /*
     * WARNING - void declaration
     */
    private CDD addClockSuffixCDD(CDD cDD, String string) {
        void var5_8;
        List<List<Pair<Decision<?>, int[]>>> list = cDD.getDecisionsDNF();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (List<Pair<Decision<?>, int[]>> object2 : list) {
            Object object = CDD.TRUE;
            for (Pair<Decision<?>, int[]> pair : object2) {
                Object object3;
                Object object4;
                if (pair.getFirst() instanceof RangeDecision) {
                    object4 = (Decision)pair.getFirst();
                    object3 = (RangeDecision)object4;
                    int n = ((int[])pair.getSecond())[0];
                    int n2 = ((RangeDecision)object3).getOp(n);
                    int n3 = ((RangeDecision)object3).getVal(n);
                    String string2 = this.addSuffixString(((Decision)object4).getVar(), string);
                    CDD cDD2 = RangeDecision.create(string2, n2, n3);
                    object = ((CDD)object).and(cDD2);
                    continue;
                }
                if (pair.getFirst() instanceof BoogieBooleanExpressionDecision) {
                    object4 = (BoogieBooleanExpressionDecision)pair.getFirst();
                    object3 = BoogieBooleanExpressionDecision.create(((BoogieBooleanExpressionDecision)object4).getExpression());
                    if (((int[])pair.getSecond())[0] == 1) {
                        object3 = ((CDD)object3).negate();
                    }
                    object = ((CDD)object).and((CDD)object3);
                    continue;
                }
                object4 = BooleanDecision.create(((Decision)pair.getFirst()).getVar());
                if (((int[])pair.getSecond())[0] == 1) {
                    object4 = ((CDD)object4).negate();
                }
                object = ((CDD)object).and((CDD)object4);
            }
            arrayList.add(object);
        }
        CDD cDD3 = CDD.FALSE;
        for (Object object6 : arrayList) {
            CDD cDD4 = var5_8.or((CDD)object6);
        }
        return var5_8;
    }

    public PhaseEventAutomata getTotalisedPEA() {
        return this.mTotalisedPEA;
    }

    public PhaseEventAutomata getComplementPEA() {
        return this.mComplementPEA;
    }
}

