/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PolyPacSimplificationTermWalker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.TermContextTransformationEngine;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.Context;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class QuantifierPushTermWalker
extends TermContextTransformationEngine.TermWalker<Context> {
    private static final TermContextTransformationEngine.Repetition OPTION_APPLY_REPEATEDLY = TermContextTransformationEngine.Repetition.NO_REPETITION;
    private static final boolean OPTION_SIMPLIFY_CONSTRUCTED_APPLICATION_TERMS = true;
    private static final boolean DEBUG_CHECK_RESULT = false;
    private static final boolean DEBUG_CHECK_SIMPLIFICATION_POTENTIAL_OF_INPUT_AND_OUTPUT = false;
    private static final boolean DEBUG_ERROR_ON_FALSE_CC = false;
    private static final boolean DEBUG_TREE_SIZE_ORDER = false;
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mMgdScript;
    private final QuantifierPusher.PqeTechniques mPqeTechniques;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final boolean mApplyDistributivity;

    private QuantifierPushTermWalker(IUltimateServiceProvider iUltimateServiceProvider, boolean bl, QuantifierPusher.PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, ManagedScript managedScript) {
        this.mServices = iUltimateServiceProvider;
        this.mApplyDistributivity = bl;
        this.mPqeTechniques = pqeTechniques;
        this.mMgdScript = managedScript;
        this.mSimplificationTechnique = simplificationTechnique;
    }

    @Override
    protected Context constructContextForApplicationTerm(Context context, FunctionSymbol functionSymbol, List<Term> list, int n) {
        return context.constructChildContextForConDis(this.mServices, this.mMgdScript, functionSymbol, list, n);
    }

    @Override
    protected Context constructContextForQuantifiedFormula(Context context, int n, List<TermVariable> list) {
        return context.constructChildContextForQuantifiedFormula(this.mMgdScript.getScript(), list);
    }

    @Override
    protected TermContextTransformationEngine.DescendResult convert(Context context, Term term) {
        QuantifierPusher.FormulaClassification formulaClassification = null;
        Object object = PolyPacSimplificationTermWalker.simplify(this.mServices, this.mMgdScript, context.getCriticalConstraint(), term);
        int n = 0;
        do {
            Object object2;
            formulaClassification = QuantifierPusher.classify(object);
            switch (formulaClassification) {
                case NOT_QUANTIFIED: {
                    if (SmtUtils.isAtomicFormula(object)) {
                        if (!SmtUtils.isTrueLiteral(object) && !SmtUtils.isFalseLiteral(object)) {
                            object = QuantifierPusher.simplify(this.mServices, this.mMgdScript, QuantifierPusher.SimplificationOccasion.ATOM, this.mSimplificationTechnique, context, object);
                        }
                        return new TermContextTransformationEngine.FinalResultForAscend((Term)object);
                    }
                    object2 = SmtUtils.unzipNot(object);
                    if (object2 != null && SmtUtils.isAtomicFormula(object2)) {
                        object = QuantifierPusher.simplify(this.mServices, this.mMgdScript, QuantifierPusher.SimplificationOccasion.ATOM, this.mSimplificationTechnique, context, object);
                        return new TermContextTransformationEngine.FinalResultForAscend((Term)object);
                    }
                    return new TermContextTransformationEngine.IntermediateResultForDescend((Term)object);
                }
                case SAME_QUANTIFIER: {
                    object = QuantifierUtils.flattenQuantifiers(this.mMgdScript.getScript(), (QuantifiedFormula)object);
                    break;
                }
                case DUAL_QUANTIFIER: {
                    object2 = context.constructChildContextForQuantifiedFormula(this.mMgdScript.getScript(), Arrays.asList(((QuantifiedFormula)object).getVariables()));
                    EliminationTask eliminationTask = new EliminationTask((QuantifiedFormula)object, (Context)object2);
                    Term term2 = QuantifierPusher.processDualQuantifier(this.mServices, this.mMgdScript, this.mApplyDistributivity, this.mPqeTechniques, this.mSimplificationTechnique, eliminationTask, QuantifierPushTermWalker::eliminate);
                    QuantifierPusher.FormulaClassification formulaClassification2 = QuantifierPusher.classify(term2);
                    if (formulaClassification2 == QuantifierPusher.FormulaClassification.DUAL_QUANTIFIER) {
                        return new TermContextTransformationEngine.FinalResultForAscend(term2);
                    }
                    object = term2;
                    break;
                }
                case CORRESPONDING_FINITE_CONNECTIVE: {
                    object = QuantifierPusher.pushOverCorrespondingFiniteConnective(this.mMgdScript.getScript(), (QuantifiedFormula)object);
                    assert (object != null) : "corresponding connective case must never fail";
                    break;
                }
                case ATOM: {
                    EliminationTask eliminationTask;
                    object2 = QuantifierPusher.applyEliminationToAtom(this.mServices, this.mMgdScript, this.mApplyDistributivity, this.mPqeTechniques, context, (QuantifiedFormula)object);
                    if (object2 == null) {
                        eliminationTask = QuantifierPusher.pushInner(this.mServices, this.mMgdScript, this.mApplyDistributivity, this.mPqeTechniques, this.mSimplificationTechnique, context.getBoundByAncestors(), (QuantifiedFormula)object, context.getCriticalConstraint(), QuantifierPushTermWalker::eliminate);
                        return new TermContextTransformationEngine.FinalResultForAscend((Term)eliminationTask);
                    }
                    object = object2;
                    break;
                }
                case DUAL_FINITE_CONNECTIVE: {
                    Term term2;
                    object2 = new EliminationTask((QuantifiedFormula)object, context);
                    EliminationTask eliminationTask = QuantifierPusher.tryToPushOverDualFiniteConnective(this.mServices, this.mMgdScript, this.mApplyDistributivity, this.mPqeTechniques, this.mSimplificationTechnique, (EliminationTask)object2, QuantifierPushTermWalker::eliminate);
                    if (eliminationTask == null) {
                        term2 = QuantifierPusher.pushInner(this.mServices, this.mMgdScript, this.mApplyDistributivity, this.mPqeTechniques, this.mSimplificationTechnique, context.getBoundByAncestors(), (QuantifiedFormula)object, context.getCriticalConstraint(), QuantifierPushTermWalker::eliminate);
                        return new TermContextTransformationEngine.FinalResultForAscend(term2);
                    }
                    object = eliminationTask;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown value " + String.valueOf((Object)formulaClassification)));
                }
            }
            if (++n % 10 != 0) continue;
            object2 = this.mServices.getLoggingService().getLogger(QuantifierPusher.class);
            object2.info((Object)String.format("Run %s iterations without descend maybe there is a nontermination bug.", n));
        } while (this.mServices.getProgressMonitorService().continueProcessing());
        throw new ToolchainCanceledException(QuantifierPusher.class, String.format("running %s iterations on subformula", n));
    }

    @Override
    protected Term constructResultForApplicationTerm(Context context, ApplicationTerm applicationTerm, Term[] termArray) {
        if (applicationTerm.getFunction().getName().equals("and")) {
            Term term = SmtUtils.and(this.mMgdScript.getScript(), termArray);
            Term term2 = PolyPacSimplificationTermWalker.simplify(this.mServices, this.mMgdScript, context.getCriticalConstraint(), term);
            return term2;
        }
        if (applicationTerm.getFunction().getName().equals("or")) {
            Term term = SmtUtils.or(this.mMgdScript.getScript(), termArray);
            Term term3 = PolyPacSimplificationTermWalker.simplify(this.mServices, this.mMgdScript, context.getCriticalConstraint(), term);
            return term3;
        }
        if (applicationTerm.getFunction().getName().equals("=")) {
            Term term = SmtUtils.equality(this.mMgdScript.getScript(), termArray);
            return PolyPacSimplificationTermWalker.simplify(this.mServices, this.mMgdScript, context.getCriticalConstraint(), term);
        }
        assert (Arrays.equals(applicationTerm.getParameters(), termArray));
        return applicationTerm;
    }

    @Override
    protected Term constructResultForQuantifiedFormula(Context context, QuantifiedFormula quantifiedFormula, Term term) {
        return SmtUtils.quantifier(this.mMgdScript.getScript(), quantifiedFormula.getQuantifier(), Arrays.asList(quantifiedFormula.getVariables()), term);
    }

    @Override
    protected TermContextTransformationEngine.Repetition applyRepeatedly() {
        return OPTION_APPLY_REPEATEDLY;
    }

    public static Term eliminate(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl, QuantifierPusher.PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, Term term) {
        managedScript.assertScriptNotLocked();
        return QuantifierPushTermWalker.eliminate(iUltimateServiceProvider, managedScript, bl, pqeTechniques, simplificationTechnique, new Context(managedScript.getScript()), term);
    }

    public static Term eliminate(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl, QuantifierPusher.PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, Context context, Term term) {
        QuantifierPushTermWalker.checkSimplificationPotential(iUltimateServiceProvider, managedScript, "Quantifier elimination called on non-simplified input", term);
        Comparator<Term> comparator = null;
        Term term2 = TermContextTransformationEngine.transform(new QuantifierPushTermWalker(iUltimateServiceProvider, bl, pqeTechniques, simplificationTechnique, managedScript), comparator, context, term);
        QuantifierPushTermWalker.checkSimplificationPotential(iUltimateServiceProvider, managedScript, "Quantifier elimination failed to simlify output", term2);
        return term2;
    }

    private static void checkSimplificationPotential(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, String string, Term term) {
    }

    @Override
    protected void checkIntermediateResult(Context context, Term term, Term term2) {
        Script.LBool lBool = SmtUtils.checkEquivalenceUnderAssumption(term, term2, context.getCriticalConstraint(), this.mMgdScript.getScript());
        switch (lBool) {
            case SAT: {
                throw new AssertionError((Object)String.format("Intermediate result not equivalent. Input: %s Output: %s Assumption: %s", term, term2, context.getCriticalConstraint()));
            }
            case UNKNOWN: {
                ILogger iLogger = this.mServices.getLoggingService().getLogger(this.getClass());
                iLogger.warn((Object)String.format("Insufficient ressources to check equivalence of intermediate result. Input: %s Output: %s Assumption: %s", term, term2, context.getCriticalConstraint()));
                break;
            }
            case UNSAT: {
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value: " + String.valueOf(lBool)));
            }
        }
    }
}

