/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.statefactory;

import de.uni_freiburg.informatik.ultimate.automata.counting.ICaUnionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LevelRankingState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.StateWithRankInfo;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.incrementalinclusion.IIncrementalInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationCheckResultStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNetAndAutomataInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.Marking;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Condition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBlackWhiteStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiComplementDeterministicStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiComplementNcsbSimpleStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiComplementNcsbStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiComplementSvwStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IConcurrentProductStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IFinitePrefix2PetriNetStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IRelabelStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISenwaStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IUnionStateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StringFactory
implements ISenwaStateFactory<String>,
IBlackWhiteStateFactory<String>,
IFinitePrefix2PetriNetStateFactory<String>,
IBuchiComplementDeterministicStateFactory<String>,
IBuchiComplementNcsbStateFactory<String>,
IBuchiComplementSvwStateFactory<String>,
IIncrementalInclusionStateFactory<String>,
IMinimizationStateFactory<String>,
IMinimizationCheckResultStateFactory<String>,
IUnionStateFactory<String>,
IBuchiComplementNcsbSimpleStateFactory<String>,
IRelabelStateFactory<String>,
IConcurrentProductStateFactory<String>,
IPetriNetAndAutomataInclusionStateFactory<String>,
ICaUnionStateFactory<String> {
    public static final String INFINITY = "\u221e";
    private static final String EMPTY_STRING = "";
    private static final String EMPTY_SET = "{}";
    private static final char X_STRING = 'X';
    private static final String COMMA_SPACE = ", ";
    private static final char COMMA = ',';
    private static final char OPEN_PARENTHESIS = '(';
    private static final char CLOSE_PARENTHESIS = ')';
    private static final char OPEN_BRACE = '{';
    private static final char CLOSE_BRACE = '}';
    private static final char OPEN_BRACKET = '[';
    private static final char CLOSE_BRACKET = ']';
    private static final int RANK_ONE = 1;
    private static final int RANK_TWO = 2;
    private static final int RANK_THREE = 3;
    private static final int MINIMUM_LIST_SIZE = 2;
    private static final int MINIMUM_PAIR_LIST_SIZE = 7;

    private String product(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(string).append(COMMA_SPACE).append(string2).append(']');
        return stringBuilder.toString();
    }

    @Override
    public String union(String string, String string2) {
        return this.product(string, string2);
    }

    @Override
    public String intersection(String string, String string2) {
        return this.product(string, string2);
    }

    @Override
    public String concurrentProduct(String string, String string2) {
        return this.product(string, string2);
    }

    @Override
    public String intersectBuchi(String string, String string2, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(string).append(COMMA_SPACE).append(string2).append(", track").append(n).append(']');
        return stringBuilder.toString();
    }

    @Override
    public String determinize(Map<String, Set<String>> map) {
        StringBuilder stringBuilder = new StringBuilder(map.size() * 7);
        stringBuilder.append('{');
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = EMPTY_STRING;
            for (String string3 : entry.getValue()) {
                stringBuilder.append(string2).append('(').append(string).append(',').append(string3).append(')');
                string2 = COMMA_SPACE;
            }
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public String createSinkStateContent() {
        return "\u2205SinkState";
    }

    @Override
    public String createEmptyStackState() {
        return "\u20ac";
    }

    @Override
    public String getContentOnPetriNet2FiniteAutomaton(Marking<String> marking) {
        StringBuilder stringBuilder = new StringBuilder(marking.size() * 2);
        stringBuilder.append('{');
        boolean bl = true;
        for (String string : marking) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(string);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public String getBlackContent(String string) {
        return "Black:" + string;
    }

    @Override
    public String getWhiteContent(String string) {
        return "White:" + string;
    }

    @Override
    public String buchiComplementFkv(LevelRankingState<?, String> levelRankingState) {
        if (levelRankingState.isNonAcceptingSink()) {
            return levelRankingState.toString();
        }
        boolean bl = !levelRankingState.getOperand().getVpAlphabet().getCallAlphabet().isEmpty();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (StateWithRankInfo<String> stateWithRankInfo : levelRankingState.getDownStates()) {
            for (StateWithRankInfo<String> stateWithRankInfo2 : levelRankingState.getUpStates(stateWithRankInfo)) {
                stringBuilder.append('(');
                if (bl) {
                    StringFactory.buchiComplementFkvHelper(stringBuilder, stateWithRankInfo);
                    stringBuilder.append(',');
                }
                StringFactory.buchiComplementFkvHelper(stringBuilder, stateWithRankInfo2);
                stringBuilder.append(')');
            }
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public String buchiComplementNcsb(LevelRankingState<?, String> levelRankingState) {
        if (levelRankingState.isNonAcceptingSink()) {
            return levelRankingState.toString();
        }
        ArrayList<Pair<StateWithRankInfo<String>, String>> arrayList = new ArrayList<Pair<StateWithRankInfo<String>, String>>();
        ArrayList<Pair<StateWithRankInfo<String>, String>> arrayList2 = new ArrayList<Pair<StateWithRankInfo<String>, String>>();
        ArrayList<Pair<StateWithRankInfo<String>, String>> arrayList3 = new ArrayList<Pair<StateWithRankInfo<String>, String>>();
        ArrayList<Pair<StateWithRankInfo<String>, String>> arrayList4 = new ArrayList<Pair<StateWithRankInfo<String>, String>>();
        for (StateWithRankInfo<String> stateWithRankInfo : levelRankingState.getDownStates()) {
            for (StateWithRankInfo<String> stateWithRankInfo2 : levelRankingState.getUpStates(stateWithRankInfo)) {
                if (!stateWithRankInfo2.hasRank()) {
                    throw new IllegalArgumentException("must have rank");
                }
                switch (stateWithRankInfo2.getRank()) {
                    case 3: {
                        arrayList.add((Pair<StateWithRankInfo<String>, String>)new Pair(stateWithRankInfo, (Object)stateWithRankInfo2.getState()));
                        break;
                    }
                    case 2: {
                        StringFactory.buchiComplementNcsbHelperRankTwo(arrayList2, arrayList4, stateWithRankInfo, stateWithRankInfo2);
                        break;
                    }
                    case 1: {
                        arrayList3.add(new Pair(stateWithRankInfo, (Object)stateWithRankInfo2.getState()));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Only ranks 1, 2, 3 are allowed.");
                    }
                }
            }
        }
        boolean bl = !levelRankingState.getOperand().getVpAlphabet().getCallAlphabet().isEmpty();
        StringBuilder stringBuilder = new StringBuilder(arrayList.size() + arrayList2.size() + arrayList3.size() + arrayList4.size());
        stringBuilder.append('(');
        StringFactory.prettyprintCollectionOfStates(stringBuilder, arrayList, bl);
        stringBuilder.append(',');
        StringFactory.prettyprintCollectionOfStates(stringBuilder, arrayList2, bl);
        stringBuilder.append(',');
        StringFactory.prettyprintCollectionOfStates(stringBuilder, arrayList3, bl);
        stringBuilder.append(',');
        StringFactory.prettyprintCollectionOfStates(stringBuilder, arrayList4, bl);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private static void prettyprintCollectionOfStates(StringBuilder stringBuilder, List<Pair<StateWithRankInfo<String>, String>> list, boolean bl) {
        if (list.isEmpty()) {
            stringBuilder.append(EMPTY_SET);
            return;
        }
        stringBuilder.append('{');
        boolean bl2 = true;
        for (Pair<StateWithRankInfo<String>, String> pair : list) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(',');
            }
            if (bl) {
                stringBuilder.append('(').append(pair.getFirst()).append(',').append((String)pair.getSecond()).append(')');
                continue;
            }
            stringBuilder.append((String)pair.getSecond());
        }
        stringBuilder.append('}');
    }

    @Override
    public String buchiComplementDeterministicNonFinal(String string) {
        return "NonFinal:" + string;
    }

    @Override
    public String buchiComplementDeterministicFinal(String string) {
        return "Final:" + string;
    }

    @Override
    public String merge(Collection<String> collection) {
        if (collection == null) {
            return EMPTY_SET;
        }
        StringBuilder stringBuilder = new StringBuilder(collection.size() * 2);
        stringBuilder.append('{');
        String string = EMPTY_STRING;
        for (String string2 : collection) {
            stringBuilder.append(string).append(string2);
            string = COMMA_SPACE;
        }
        return stringBuilder.append('}').toString();
    }

    public static String createDoubleDeckerContent(String string, String string2) {
        return "<" + string + "," + string2 + ">";
    }

    @Override
    public String buchiComplementSvw(Integer n, Integer n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(').append(n).append(',').append(n2).append(')');
        return stringBuilder.toString();
    }

    @Override
    public String finitePrefix2net(Condition<?, String> condition) {
        return condition.toString();
    }

    @Override
    public String senwa(String string, String string2) {
        return string2 + " (entry " + string + ")";
    }

    private static void buchiComplementFkvHelper(StringBuilder stringBuilder, StateWithRankInfo<String> stateWithRankInfo) {
        stringBuilder.append(stateWithRankInfo.getState()).append(',');
        if (stateWithRankInfo.hasRank()) {
            stringBuilder.append(stateWithRankInfo.getRank());
            if (stateWithRankInfo.isInO()) {
                stringBuilder.append('X');
            }
        } else {
            stringBuilder.append(INFINITY);
        }
    }

    private static void buchiComplementNcsbHelperRankTwo(List<Pair<StateWithRankInfo<String>, String>> list, List<Pair<StateWithRankInfo<String>, String>> list2, StateWithRankInfo<String> stateWithRankInfo, StateWithRankInfo<String> stateWithRankInfo2) {
        list.add((Pair<StateWithRankInfo<String>, String>)new Pair(stateWithRankInfo, (Object)stateWithRankInfo2.getState()));
        if (stateWithRankInfo2.isInO()) {
            list2.add((Pair<StateWithRankInfo<String>, String>)new Pair(stateWithRankInfo, (Object)stateWithRankInfo2.getState()));
        }
    }

    @Override
    public String buchiComplementNcsbSimple(int n) {
        return "s" + n;
    }

    @Override
    public String relabel(String string, int n) {
        return "q" + n;
    }

    @Override
    public String constructInitialState() {
        return "UnionInitialState";
    }
}

