/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.FunctionModelHelper;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.ILibraryModel;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.IncorrectSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class AssertLibraryModel
implements ILibraryModel {
    private final FunctionModelHelper mHelper;
    private final ExpressionResultTransformer mExprResultTransformer;
    private final boolean mCheckAssertions;

    public AssertLibraryModel(FunctionModelHelper functionModelHelper, ExpressionResultTransformer expressionResultTransformer, boolean bl) {
        this.mHelper = functionModelHelper;
        this.mExprResultTransformer = expressionResultTransformer;
        this.mCheckAssertions = bl;
    }

    @Override
    public Collection<ILibraryModel.FunctionModel> getFunctionModels() {
        ArrayList<ILibraryModel.FunctionModel> arrayList = new ArrayList<ILibraryModel.FunctionModel>();
        arrayList.add(new ILibraryModel.FunctionModel("__assert_fail", this::handleAssertFail));
        arrayList.add(new ILibraryModel.FunctionModel("__assert_func", this::handleAssertFail));
        arrayList.add(new ILibraryModel.FunctionModel("assert", this::handleAssert));
        arrayList.add(new ILibraryModel.FunctionModel("_Static_assert", this::handleStaticAssert));
        arrayList.add(new ILibraryModel.FunctionModel("static_assert", this::handleStaticAssert));
        return arrayList;
    }

    private Result handleAssertFail(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        Object object;
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 4, string, iASTInitializerClauseArray);
        ArrayList<ExpressionResult> arrayList = new ArrayList<ExpressionResult>();
        IASTInitializerClause[] iASTInitializerClauseArray2 = iASTInitializerClauseArray;
        int n = iASTInitializerClauseArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iASTInitializerClauseArray2[n2];
            arrayList.add((ExpressionResult)iDispatcher.dispatch((IASTNode)object));
            ++n2;
        }
        object = new ExpressionResultBuilder().addAllExceptLrValue(arrayList);
        return ((ExpressionResultBuilder)object).addStatement(this.mHelper.createAnnotatedAssertOrAssume(iLocation, string, this.mCheckAssertions, Spec.ASSERT, (Expression)ExpressionFactory.createBooleanLiteral((ILocation)iLocation, (boolean)false))).build();
    }

    private Result handleAssert(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 1, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformSwitchRexIntToBool((ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClauseArray[0]), iLocation, (IASTNode)iASTFunctionCallExpression);
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).addStatement(this.mHelper.createAnnotatedAssertOrAssume(iLocation, string, this.mCheckAssertions, Spec.ASSERT, expressionResult.getLrValue().getValue())).build();
    }

    private Result handleStaticAssert(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        int n = iASTInitializerClauseArray.length;
        if (n == 2) {
            this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
            if (this.mHelper.isStringLiteral(iASTInitializerClauseArray[1])) {
                String string2 = String.valueOf(((IASTLiteralExpression)iASTInitializerClauseArray[1]).getValue());
                ExpressionResult expressionResult = this.mExprResultTransformer.transformSwitchRexIntToBool((ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClauseArray[0]), iLocation, (IASTNode)iASTFunctionCallExpression);
                return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).addStatement(this.mHelper.createAnnotatedAssertOrAssume(iLocation, string, this.mCheckAssertions, Spec.ASSERT, expressionResult.getLrValue().getValue(), string2)).build();
            }
            throw new IncorrectSyntaxException(iLocation, "Message parameter of static assert is not a string literal");
        }
        this.mHelper.checkArguments(iLocation, 1, string, iASTInitializerClauseArray);
        return this.handleAssert(iDispatcher, iASTFunctionCallExpression, iLocation, string);
    }
}

