/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking;

import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.Formula2NFCompiler;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Formula2DNFCompiler
extends Formula2NFCompiler {
    @Override
    protected void changeNodeSyncChildAnd(Element element, Element[] elementArray, int n) {
        throw new RuntimeException("A formula that is no testformula is not allowed to have sync events");
    }

    @Override
    protected void changeNodeSyncChildOr(Element element, Element[] elementArray, int n) {
        throw new RuntimeException("A formula in guards, invariants, or clockinvariants may not have sync events");
    }

    @Override
    protected Element getNewTreeElement() {
        return this.document.createElement("formulaTree");
    }

    @Override
    protected boolean isTreeElement(Node node) {
        return node.getNodeName().equals("formulaTree");
    }

    @Override
    protected boolean isBasicElement(Node node) {
        String string = node.getNodeName();
        return string.equals("booleanExpression") || string.equals("eventExpression") || string.equals("rangeExpression");
    }

    @Override
    protected boolean isFormulaElement(Node node) {
        String string = node.getNodeName();
        return string.equals("invariant") || string.equals("clockInvariant") || string.equals("guard");
    }

    @Override
    protected boolean isCorrectOperator(String string) {
        return string.equals("OR") || string.equals("AND") || string.equals("NOT");
    }

    public Element compile(Element element) {
        this.document = new DocumentImpl();
        Element element2 = (Element)this.document.importNode(element, true);
        this.document.appendChild(element2);
        this.makeBinary(element2);
        this.buildNF(element2);
        this.makeNAry(element2);
        return element2;
    }

    protected void makeNAry(Element element) {
        if (!(this.isBasicElement(element) || this.isTreeElement(element) || this.isFormulaElement(element))) {
            throw new RuntimeException("A formula may only contain a tag indicating formula type, tree elements, and basic elements");
        }
        if (this.isBasicElement(element)) {
            this.logger.debug((Object)"Elementary element, returning...");
            return;
        }
        Element[] elementArray = this.getFormulaOperands(element);
        int n = 0;
        while (n < elementArray.length) {
            this.makeNAry(elementArray[n]);
            if (element.getAttribute("operator").equals("OR") && elementArray[n].getAttribute("operator").equals("OR") || element.getAttribute("operator").equals("AND") && elementArray[n].getAttribute("operator").equals("AND")) {
                var4_4 = this.getFormulaOperands(elementArray[n]);
                int n2 = 0;
                while (n2 < ((Element[])var4_4).length) {
                    element.appendChild(var4_4[n2]);
                    ++n2;
                }
                element.removeChild(elementArray[n]);
            } else if (element.getAttribute("operator").equals("NOT") && elementArray[n].getAttribute("operator").equals("NOT")) {
                var4_4 = element.getParentNode();
                Element[] elementArray2 = this.getFormulaOperands(elementArray[n]);
                var4_4.replaceChild(elementArray2[0], element);
            }
            ++n;
        }
    }

    public void compile(Document document) {
        Node node;
        Node node2;
        NodeList nodeList = document.getElementsByTagName("invariant");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            this.logger.info((Object)("Converting formula " + n2 + "/" + n));
            Element element = this.compile((Element)nodeList.item(n2));
            Element element2 = (Element)document.importNode(element, true);
            node2 = nodeList.item(n2).getParentNode();
            node2.replaceChild(element2, nodeList.item(n2));
            ++n2;
        }
        this.logger.info((Object)"Finished!");
        NodeList nodeList2 = document.getElementsByTagName("clockInvariant");
        int n3 = nodeList2.getLength();
        int n4 = 0;
        while (n4 < n3) {
            this.logger.info((Object)("Converting clockinvariant " + n4 + "/" + n3));
            node2 = this.compile((Element)nodeList2.item(n4));
            Element element = (Element)document.importNode(node2, true);
            node = nodeList2.item(n4).getParentNode();
            node.replaceChild(element, nodeList2.item(n4));
            ++n4;
        }
        this.logger.info((Object)"Finished!");
        NodeList nodeList3 = document.getElementsByTagName("guard");
        int n5 = nodeList3.getLength();
        int n6 = 0;
        while (n6 < n5) {
            this.logger.info((Object)("Converting guard " + n6 + "/" + n5));
            node = this.compile((Element)nodeList3.item(n6));
            Element element = (Element)document.importNode(node, true);
            Node node3 = nodeList3.item(n6).getParentNode();
            node3.replaceChild(element, nodeList3.item(n6));
            ++n6;
        }
        this.logger.info((Object)"Finished!");
    }
}

