/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.preprocessor;

import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.LTLStepAnnotation;
import de.uni_freiburg.informatik.ultimate.core.lib.observers.BaseObserver;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;

public class LTLStepAnnotator
extends BaseObserver {
    protected LTLStepAnnotator() {
    }

    public boolean process(IElement iElement) {
        if (iElement instanceof Unit) {
            Unit unit = (Unit)iElement;
            this.processUnit(unit);
            return false;
        }
        return true;
    }

    private void processUnit(Unit unit) {
        BoogieLTLStepAnnotator boogieLTLStepAnnotator = new BoogieLTLStepAnnotator();
        unit.accept((GeneratedBoogieAstTransformer)boogieLTLStepAnnotator);
    }

    private static final class BoogieLTLStepAnnotator
    extends GeneratedBoogieAstTransformer {
        private BoogieLTLStepAnnotator() {
        }

        private Statement attachLTLSpecification(Statement statement, NamedAttribute[] namedAttributeArray) {
            if (namedAttributeArray != null) {
                NamedAttribute[] namedAttributeArray2 = namedAttributeArray;
                int n = namedAttributeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NamedAttribute namedAttribute = namedAttributeArray2[n2];
                    if (namedAttribute.getName() == "ltl_step") {
                        LTLStepAnnotation lTLStepAnnotation = new LTLStepAnnotation();
                        lTLStepAnnotation.annotate((IElement)statement);
                    }
                    ++n2;
                }
            }
            return statement;
        }

        public Statement transform(AssumeStatement assumeStatement) {
            return this.attachLTLSpecification((Statement)assumeStatement, assumeStatement.getAttributes());
        }

        public Statement transform(AssertStatement assertStatement) {
            return this.attachLTLSpecification((Statement)assertStatement, assertStatement.getAttributes());
        }

        public Statement transform(CallStatement callStatement) {
            return this.attachLTLSpecification((Statement)callStatement, callStatement.getAttributes());
        }
    }
}

