/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag;

import de.uni_freiburg.informatik.ultimate.core.lib.models.BaseDirectedGraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IDirectedGraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableDirectedGraph;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.IRegex;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.RegexDag;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.RegexDagNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class RegexDagCompressor<L> {
    private final Map<IRegex<L>, Set<RegexDagNode<L>>> mMergetable = new LinkedHashMap<IRegex<L>, Set<RegexDagNode<L>>>();
    private boolean mMergedFlag;
    private RegexDag<L> mDag;

    public RegexDag<L> compress(RegexDag<L> regexDag) {
        this.mDag = regexDag;
        this.mMergedFlag = true;
        while (this.mMergedFlag) {
            this.mMergedFlag = false;
            this.searchAndMerge(this.mDag.getSource(), BaseDirectedGraph::getOutgoingNodes, BaseDirectedGraph::getIncomingNodes);
            this.searchAndMerge(this.mDag.getSink(), BaseDirectedGraph::getIncomingNodes, BaseDirectedGraph::getOutgoingNodes);
        }
        return this.mDag;
    }

    private void searchAndMerge(RegexDagNode<L> regexDagNode, Function<RegexDagNode<L>, Collection<RegexDagNode<L>>> function, Function<RegexDagNode<L>, Collection<RegexDagNode<L>>> function2) {
        HashSet<RegexDagNode<L>> hashSet = new HashSet<RegexDagNode<L>>();
        ArrayDeque<RegexDagNode<L>> arrayDeque = new ArrayDeque<RegexDagNode<L>>();
        hashSet.add(regexDagNode);
        arrayDeque.add(regexDagNode);
        while (!arrayDeque.isEmpty()) {
            RegexDagNode regexDagNode2 = (RegexDagNode)((Object)arrayDeque.remove());
            this.mergeInDirection(regexDagNode2, function, function2);
            function.apply(regexDagNode2).stream().filter(hashSet::add).forEach(arrayDeque::add);
            this.eliminateIfEpsilon(regexDagNode2);
        }
    }

    private void mergeInDirection(RegexDagNode<L> regexDagNode, Function<RegexDagNode<L>, Collection<RegexDagNode<L>>> function, Function<RegexDagNode<L>, Collection<RegexDagNode<L>>> function2) {
        this.mMergetable.clear();
        this.safeCandidates(regexDagNode, function).forEach(this::addToMergetable);
        this.mMergetable.entrySet().stream().forEach(this::groupToSingleNode);
    }

    private Set<RegexDagNode<L>> safeCandidates(RegexDagNode<L> regexDagNode, Function<RegexDagNode<L>, Collection<RegexDagNode<L>>> function) {
        LinkedHashSet<RegexDagNode<L>> linkedHashSet = new LinkedHashSet<RegexDagNode<L>>(function.apply(regexDagNode));
        linkedHashSet.removeAll(IDirectedGraph.transitiveNodes(linkedHashSet, function));
        return linkedHashSet;
    }

    private void addToMergetable(RegexDagNode<L> regexDagNode) {
        this.mMergetable.computeIfAbsent(regexDagNode.getContent(), iRegex -> new LinkedHashSet()).add(regexDagNode);
    }

    private RegexDagNode<L> groupToSingleNode(Map.Entry<IRegex<L>, Set<RegexDagNode<L>>> entry) {
        if (entry.getValue().size() == 1) {
            return entry.getValue().iterator().next();
        }
        return this.groupToNewNode(entry.getKey(), entry.getValue());
    }

    private RegexDagNode<L> groupToNewNode(IRegex<L> iRegex, Set<RegexDagNode<L>> set) {
        RegexDagNode<L> regexDagNode = new RegexDagNode<L>(iRegex);
        set.forEach(regexDagNode2 -> this.merge(regexDagNode, (RegexDagNode<L>)((Object)regexDagNode2)));
        return regexDagNode;
    }

    private void merge(RegexDagNode<L> regexDagNode3, RegexDagNode<L> regexDagNode4) {
        this.mMergedFlag = true;
        regexDagNode4.getIncomingNodes().stream().forEach(regexDagNode2 -> {
            boolean bl = regexDagNode2.removeOutgoing((IModifiableDirectedGraph)regexDagNode4);
        });
        regexDagNode4.getOutgoingNodes().stream().forEach(regexDagNode2 -> {
            boolean bl = regexDagNode2.removeIncoming((IModifiableDirectedGraph)regexDagNode4);
        });
        HashSet hashSet = new HashSet(regexDagNode3.getIncomingNodes());
        hashSet.add(regexDagNode3);
        regexDagNode4.getIncomingNodes().stream().filter(regexDagNode -> !hashSet.contains(regexDagNode)).forEach(arg_0 -> regexDagNode3.connectIncoming(arg_0));
        hashSet.clear();
        hashSet.addAll(regexDagNode3.getOutgoingNodes());
        hashSet.add(regexDagNode3);
        regexDagNode4.getOutgoingNodes().stream().filter(regexDagNode -> !hashSet.contains(regexDagNode)).forEach(arg_0 -> regexDagNode3.connectOutgoing(arg_0));
        if (regexDagNode4 == this.mDag.getSink()) {
            this.mDag.setSink(regexDagNode3);
        }
        if (regexDagNode4 == this.mDag.getSource()) {
            this.mDag.setSource(regexDagNode3);
        }
    }

    private void eliminateIfEpsilon(RegexDagNode<L> regexDagNode) {
        if (!regexDagNode.isEpsilon()) {
            return;
        }
        ArrayList arrayList = regexDagNode.getIncomingNodes();
        ArrayList arrayList2 = regexDagNode.getOutgoingNodes();
        if (arrayList.isEmpty() && arrayList2.isEmpty()) {
            return;
        }
        if (regexDagNode == this.mDag.getSource()) {
            if (arrayList2.size() > 1) {
                return;
            }
            this.mDag.setSource((RegexDagNode)((Object)arrayList2.get(0)));
        } else if (regexDagNode == this.mDag.getSink()) {
            if (arrayList.size() > 1) {
                return;
            }
            this.mDag.setSink((RegexDagNode)((Object)arrayList.get(0)));
        }
        arrayList = new ArrayList(arrayList);
        arrayList2 = new ArrayList(arrayList2);
        for (RegexDagNode regexDagNode3 : arrayList) {
            for (RegexDagNode regexDagNode4 : arrayList2) {
                regexDagNode3.connectOutgoing((IModifiableDirectedGraph)regexDagNode4);
            }
        }
        arrayList.forEach(regexDagNode2 -> {
            boolean bl = regexDagNode2.removeOutgoing((IModifiableDirectedGraph)regexDagNode);
        });
        arrayList2.forEach(regexDagNode2 -> {
            boolean bl = regexDagNode2.removeIncoming((IModifiableDirectedGraph)regexDagNode);
        });
    }
}

