/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.CopyingTransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrSummarizer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public class QvasrIcfgTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    private final ILogger mLogger;
    private final ManagedScript mScript;
    private final IIcfg<INLOC> mOriginalIcfg;
    private final ITransformulaTransformer mTransformer;
    private final IUltimateServiceProvider mServices;
    private final IIcfg<OUTLOC> mResult;

    public QvasrIcfgTransformer(ILogger iLogger, IIcfg<INLOC> iIcfg, Class<OUTLOC> clazz, ILocationFactory<INLOC, OUTLOC> iLocationFactory, String string, IcfgTransformationBacktranslator icfgTransformationBacktranslator, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mLogger = iLogger;
        this.mOriginalIcfg = iIcfg;
        this.mServices = iUltimateServiceProvider;
        this.mScript = iIcfg.getCfgSmtToolkit().getManagedScript();
        this.mTransformer = new QvasrLoopAccelerationTransformer(this.mLogger, iIcfg.getCfgSmtToolkit().getManagedScript(), iIcfg.getCfgSmtToolkit());
        this.mResult = new IcfgTransformer<INLOC, OUTLOC>(this.mLogger, iIcfg, iLocationFactory, icfgTransformationBacktranslator, clazz, string, this.mTransformer).getResult();
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResult;
    }

    private final class QvasrLoopAccelerationTransformer
    extends CopyingTransformulaTransformer {
        public QvasrLoopAccelerationTransformer(ILogger iLogger, ManagedScript managedScript, CfgSmtToolkit cfgSmtToolkit) {
            super(iLogger, managedScript, cfgSmtToolkit);
        }

        @Override
        public ITransformulaTransformer.TransformulaTransformationResult transform(IIcfgTransition<? extends IcfgLocation> iIcfgTransition, UnmodifiableTransFormula unmodifiableTransFormula) {
            QvasrSummarizer qvasrSummarizer = new QvasrSummarizer(QvasrIcfgTransformer.this.mLogger, QvasrIcfgTransformer.this.mServices, QvasrIcfgTransformer.this.mScript);
            if (iIcfgTransition.getSource() == iIcfgTransition.getTarget()) {
                QvasrIcfgTransformer.this.mLogger.debug((Object)"Found loop, starting Qvasr summarization.");
                UnmodifiableTransFormula unmodifiableTransFormula2 = iIcfgTransition.getTransformula();
                if (!SmtUtils.containsArrayVariables((Term[])new Term[]{unmodifiableTransFormula2.getFormula()}) || !SmtUtils.isArrayFree((Term)unmodifiableTransFormula2.getFormula())) {
                    return super.transform(iIcfgTransition, unmodifiableTransFormula);
                }
                UnmodifiableTransFormula unmodifiableTransFormula3 = qvasrSummarizer.summarizeLoop(unmodifiableTransFormula2);
                return new ITransformulaTransformer.TransformulaTransformationResult(unmodifiableTransFormula3);
            }
            return super.transform(iIcfgTransition, unmodifiableTransFormula);
        }
    }
}

