/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CStructOrUnion;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.util.Objects;

public final class CPointer
implements ICType {
    private final ICType mPointsToType;

    public CPointer(ICType iCType) {
        this.mPointsToType = iCType;
    }

    public ICType getPointsToType() {
        return this.mPointsToType;
    }

    @Override
    public boolean isIncomplete() {
        return false;
    }

    @Override
    public String toString() {
        CPointer cPointer = this;
        ICType iCType = null;
        int n = 1;
        while ((iCType = cPointer.getPointsToType()) instanceof CPointer) {
            cPointer = (CPointer)iCType;
            ++n;
        }
        if (iCType instanceof CStructOrUnion) {
            return CoreUtil.repeat((int)n, (String)"*") + ((CStructOrUnion)iCType).getName();
        }
        return CoreUtil.repeat((int)n, (String)"*") + iCType.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mPointsToType);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return Objects.equals(this.mPointsToType, ((CPointer)object).mPointsToType);
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    @Override
    public boolean isScalarType() {
        return true;
    }

    @Override
    public boolean isVoidPointerType() {
        return this.mPointsToType.getUnderlyingType().isVoidType();
    }

    public static CPointer voidPointer() {
        return new CPointer(new CPrimitive(CPrimitive.CPrimitives.VOID));
    }
}

