/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.ISOMLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.TestGraphs;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.picking.MultiPickedState;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TwoModelDemo
extends JApplet {
    Graph<String, Number> graph;
    VisualizationViewer<String, Number> vv1;
    VisualizationViewer<String, Number> vv2;
    MutableTransformer layoutTransformer;
    Dimension preferredSize = new Dimension(300, 300);

    public TwoModelDemo() {
        this.graph = TestGraphs.getOneComponentGraph();
        FRLayout<String, Number> layout1 = new FRLayout<String, Number>(this.graph);
        ISOMLayout<String, Number> layout2 = new ISOMLayout<String, Number>(this.graph);
        DefaultVisualizationModel<String, Number> vm1 = new DefaultVisualizationModel<String, Number>(layout1, this.preferredSize);
        DefaultVisualizationModel<String, Number> vm2 = new DefaultVisualizationModel<String, Number>(layout2, this.preferredSize);
        this.vv1 = new VisualizationViewer<String, Number>(vm1, this.preferredSize);
        this.vv2 = new VisualizationViewer<String, Number>(vm2, this.preferredSize);
        this.vv1.setRenderContext(this.vv2.getRenderContext());
        this.vv2.getRenderContext().setMultiLayerTransformer(this.vv1.getRenderContext().getMultiLayerTransformer());
        this.vv2.getRenderContext().getMultiLayerTransformer().addChangeListener(this.vv1);
        this.vv1.setBackground(Color.white);
        this.vv2.setBackground(Color.white);
        MultiPickedState ps = new MultiPickedState();
        this.vv1.setPickedVertexState(ps);
        this.vv2.setPickedVertexState(ps);
        MultiPickedState pes = new MultiPickedState();
        this.vv1.setPickedEdgeState(pes);
        this.vv2.setPickedEdgeState(pes);
        this.vv1.getRenderContext().setEdgeDrawPaintTransformer(new PickableEdgePaintTransformer(this.vv1.getPickedEdgeState(), Color.black, Color.red));
        this.vv1.getRenderContext().setVertexFillPaintTransformer(new PickableVertexPaintTransformer(this.vv1.getPickedVertexState(), Color.red, Color.yellow));
        this.vv1.setVertexToolTipTransformer(new ToStringLabeller());
        this.vv2.setVertexToolTipTransformer(new ToStringLabeller());
        Container content = this.getContentPane();
        JPanel panel = new JPanel(new GridLayout(1, 0));
        panel.add(new GraphZoomScrollPane(this.vv1));
        panel.add(new GraphZoomScrollPane(this.vv2));
        content.add(panel);
        DefaultModalGraphMouse gm1 = new DefaultModalGraphMouse();
        DefaultModalGraphMouse gm2 = new DefaultModalGraphMouse();
        this.vv1.setGraphMouse(gm1);
        this.vv2.setGraphMouse(gm2);
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(TwoModelDemo.this.vv1, 1.1f, TwoModelDemo.this.vv1.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(TwoModelDemo.this.vv1, 0.9090909f, TwoModelDemo.this.vv1.getCenter());
            }
        });
        JPanel zoomPanel = new JPanel(new GridLayout(1, 2));
        zoomPanel.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel modePanel = new JPanel();
        modePanel.setBorder(BorderFactory.createTitledBorder("Mouse Mode"));
        gm1.getModeComboBox().addItemListener(gm2.getModeListener());
        modePanel.add(gm1.getModeComboBox());
        JPanel controls = new JPanel();
        zoomPanel.add(plus);
        zoomPanel.add(minus);
        controls.add(zoomPanel);
        controls.add(modePanel);
        content.add((Component)controls, "South");
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(new TwoModelDemo());
        f.pack();
        f.setVisible(true);
    }
}

