/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.Iterator;

public class NumberOfTransitions<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private final int mResult;

    public NumberOfTransitions(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        super(automataLibraryServices);
        this.mOperand = iNestedWordAutomaton;
        this.mResult = this.computeNumberOfTransitions(iNestedWordAutomaton);
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public Integer getResult() {
        return this.mResult;
    }

    private int computeNumberOfTransitions(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        int n = 0;
        for (STATE STATE : iNestedWordAutomaton.getStates()) {
            Iterator iterator = iNestedWordAutomaton.internalSuccessors(STATE).iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
            iterator = iNestedWordAutomaton.callSuccessors(STATE).iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
            iterator = iNestedWordAutomaton.returnSuccessors(STATE).iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
        }
        return n;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }
}

