/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ModifiesSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.AddressStore;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.AddressStoreFactory;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.AliasAnalysis;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.IdentifierReplacer;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.MayAlias;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.MemorySliceException;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.MemorySliceUtils;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.MemorySlicer;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.PointerBase;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MemoryArrayReplacer
extends BoogieTransformer {
    private final AddressStoreFactory mAsFac;
    private final UnionFind<AddressStore> mUf;
    private final Map<AddressStore, Integer> mRepToMemorySlice;
    private final int[] mSliceAccessCounter;
    private int mAccessCounter;
    private final int[] mSliceInitializationCounter;
    private int mInitializationCounter;
    private final int[] mSliceWriteCounter;
    private int mWriteCounter;
    private final HashRelation<String, Integer> mProcedureToModifiedMemorySlices;
    private String mCurrentProcedure;

    public MemoryArrayReplacer(AddressStoreFactory addressStoreFactory, MayAlias mayAlias, Map<AddressStore, Integer> map, HashRelation<String, Integer> hashRelation) {
        this.mAsFac = addressStoreFactory;
        this.mUf = mayAlias.getAddressStores();
        this.mRepToMemorySlice = map;
        this.mProcedureToModifiedMemorySlices = hashRelation;
        this.mSliceAccessCounter = new int[this.mRepToMemorySlice.size()];
        this.mAccessCounter = 0;
        this.mSliceInitializationCounter = new int[this.mRepToMemorySlice.size()];
        this.mInitializationCounter = 0;
        this.mSliceWriteCounter = new int[this.mRepToMemorySlice.size()];
        this.mWriteCounter = 0;
    }

    public String generateLogMessage() {
        if (this.mSliceAccessCounter.length == 0) {
            return "No memory access in input program.";
        }
        int n = Arrays.stream(this.mSliceAccessCounter).max().getAsInt();
        long l = Math.round((double)n / (double)this.mAccessCounter * 100.0);
        return String.format("Split %s memory accesses to %s slices as follows %s. %s percent of accesses are in the largest equivalence class. The %s initializations are split as follows %s. The %s writes are split as follows %s.", this.mAccessCounter, this.mSliceAccessCounter.length, Arrays.toString(this.mSliceAccessCounter), l, this.mInitializationCounter, Arrays.toString(this.mSliceInitializationCounter), this.mWriteCounter, Arrays.toString(this.mSliceWriteCounter));
    }

    protected Declaration processDeclaration(Declaration declaration) {
        if (declaration instanceof Procedure) {
            this.mCurrentProcedure = ((Procedure)declaration).getIdentifier();
        }
        return super.processDeclaration(declaration);
    }

    protected Specification processSpecification(Specification specification) {
        if (specification instanceof ModifiesSpecification) {
            ModifiesSpecification modifiesSpecification = (ModifiesSpecification)specification;
            Set set = this.mProcedureToModifiedMemorySlices.getImage((Object)this.mCurrentProcedure);
            return MemorySlicer.reviseModifiesSpec(set, modifiesSpecification, "#memory_$Pointer$", "#memory_int", "#memory_real");
        }
        return super.processSpecification(specification);
    }

    protected Statement processStatement(Statement statement) {
        CallStatement callStatement;
        if (statement instanceof CallStatement) {
            callStatement = (CallStatement)statement;
            if (callStatement.getMethodName().startsWith("read~int") || callStatement.getMethodName().startsWith("read~unchecked~int") || callStatement.getMethodName().startsWith("read~real") || callStatement.getMethodName().startsWith("read~unchecked~real")) {
                assert (callStatement.getArguments().length == 2);
                Expression expression = callStatement.getArguments()[0];
                int n = this.getMemorySliceNumberFromPointer(expression);
                String string = MemorySliceUtils.constructMemorySliceSuffix(n);
                CallStatement callStatement2 = new CallStatement(callStatement.getLoc(), callStatement.getAttributes(), callStatement.isForall(), callStatement.getLhs(), callStatement.getMethodName() + string, callStatement.getArguments());
                ModelUtils.copyAnnotations((IElement)statement, (IElement)callStatement2);
                ++this.mAccessCounter;
                int n2 = n;
                this.mSliceAccessCounter[n2] = this.mSliceAccessCounter[n2] + 1;
                return callStatement2;
            }
            if (callStatement.getMethodName().startsWith("write~init~int") || callStatement.getMethodName().startsWith("write~int") || callStatement.getMethodName().startsWith("write~unchecked~int") || callStatement.getMethodName().startsWith("write~init~real") || callStatement.getMethodName().startsWith("write~real") || callStatement.getMethodName().startsWith("write~unchecked~real")) {
                assert (callStatement.getArguments().length == 3);
                Expression expression = callStatement.getArguments()[1];
                int n = this.getMemorySliceNumberFromPointer(expression);
                String string = MemorySliceUtils.constructMemorySliceSuffix(n);
                CallStatement callStatement3 = new CallStatement(callStatement.getLoc(), callStatement.getAttributes(), callStatement.isForall(), callStatement.getLhs(), callStatement.getMethodName() + string, callStatement.getArguments());
                ModelUtils.copyAnnotations((IElement)statement, (IElement)callStatement3);
                ++this.mAccessCounter;
                int n3 = n;
                this.mSliceAccessCounter[n3] = this.mSliceAccessCounter[n3] + 1;
                if (callStatement.getMethodName().startsWith("write~init~int") || callStatement.getMethodName().startsWith("write~init~real")) {
                    ++this.mInitializationCounter;
                    int n4 = n;
                    this.mSliceInitializationCounter[n4] = this.mSliceInitializationCounter[n4] + 1;
                } else {
                    ++this.mWriteCounter;
                    int n5 = n;
                    this.mSliceWriteCounter[n5] = this.mSliceWriteCounter[n5] + 1;
                }
                return callStatement3;
            }
            if (callStatement.getMethodName().equals("read~$Pointer$") || callStatement.getMethodName().equals("read~unchecked~$Pointer$")) {
                assert (callStatement.getArguments().length == 2);
                Expression expression = callStatement.getArguments()[0];
                int n = this.getMemorySliceNumberFromPointer(expression);
                String string = MemorySliceUtils.constructMemorySliceSuffix(n);
                CallStatement callStatement4 = new CallStatement(callStatement.getLoc(), callStatement.getAttributes(), callStatement.isForall(), callStatement.getLhs(), callStatement.getMethodName() + string, callStatement.getArguments());
                ModelUtils.copyAnnotations((IElement)statement, (IElement)callStatement4);
                ++this.mAccessCounter;
                int n6 = n;
                this.mSliceAccessCounter[n6] = this.mSliceAccessCounter[n6] + 1;
                return callStatement4;
            }
            if (callStatement.getMethodName().equals("write~$Pointer$") || callStatement.getMethodName().equals("write~init~$Pointer$") || callStatement.getMethodName().equals("write~unchecked~$Pointer$")) {
                assert (callStatement.getArguments().length == 3);
                Expression expression = callStatement.getArguments()[1];
                int n = this.getMemorySliceNumberFromPointer(expression);
                String string = MemorySliceUtils.constructMemorySliceSuffix(n);
                CallStatement callStatement5 = new CallStatement(callStatement.getLoc(), callStatement.getAttributes(), callStatement.isForall(), callStatement.getLhs(), callStatement.getMethodName() + string, callStatement.getArguments());
                ModelUtils.copyAnnotations((IElement)statement, (IElement)callStatement5);
                ++this.mAccessCounter;
                int n7 = n;
                this.mSliceAccessCounter[n7] = this.mSliceAccessCounter[n7] + 1;
                if (callStatement.getMethodName().equals("write~init~$Pointer$")) {
                    ++this.mInitializationCounter;
                    int n8 = n;
                    this.mSliceInitializationCounter[n8] = this.mSliceInitializationCounter[n8] + 1;
                } else {
                    ++this.mWriteCounter;
                    int n9 = n;
                    this.mSliceWriteCounter[n9] = this.mSliceWriteCounter[n9] + 1;
                }
                return callStatement5;
            }
            if (callStatement.getMethodName().equals("#Ultimate.C_memset") || callStatement.getMethodName().equals("#Ultimate.C_memcpy") || callStatement.getMethodName().equals("#Ultimate.C_memmove") || callStatement.getMethodName().equals("#Ultimate.C_strcpy") || callStatement.getMethodName().equals("#Ultimate.C_realloc")) {
                Expression expression = callStatement.getArguments()[0];
                int n = this.getMemorySliceNumberFromPointer(expression);
                String string = MemorySliceUtils.constructMemorySliceSuffix(n);
                CallStatement callStatement6 = new CallStatement(callStatement.getLoc(), callStatement.getAttributes(), callStatement.isForall(), callStatement.getLhs(), callStatement.getMethodName() + string, callStatement.getArguments());
                ModelUtils.copyAnnotations((IElement)statement, (IElement)callStatement6);
                ++this.mAccessCounter;
                int n10 = n;
                this.mSliceAccessCounter[n10] = this.mSliceAccessCounter[n10] + 1;
                ++this.mWriteCounter;
                int n11 = n;
                this.mSliceWriteCounter[n11] = this.mSliceWriteCounter[n11] + 1;
                return callStatement6;
            }
            if (!(callStatement.getMethodName().equals("#Ultimate.allocInit") || callStatement.getMethodName().equals("#Ultimate.allocOnStack") || callStatement.getMethodName().equals("#Ultimate.allocOnHeap"))) {
                callStatement.getMethodName().equals("ULTIMATE.dealloc");
            }
        }
        if (statement instanceof AssignmentStatement) {
            callStatement = (AssignmentStatement)statement;
            AssignmentStatement assignmentStatement = this.handleInitToZero((AssignmentStatement)callStatement);
            if (assignmentStatement != null) {
                return assignmentStatement;
            }
            AssignmentStatement assignmentStatement2 = this.handleArrayWrite((AssignmentStatement)callStatement);
            if (assignmentStatement2 != null) {
                return assignmentStatement2;
            }
            if (MemorySliceUtils.containsMemoryArrays((BoogieASTNode)statement)) {
                throw new MemorySliceException("Statement contains memory arrays " + String.valueOf(statement));
            }
        }
        return super.processStatement(statement);
    }

    protected Expression processExpression(Expression expression) {
        IdentifierExpression identifierExpression;
        if (expression instanceof IdentifierExpression && (identifierExpression = (IdentifierExpression)expression).getIdentifier().startsWith("#memory")) {
            throw new MemorySliceException("Found direct access to memory array (without a read-call), which is not supported yet.");
        }
        return super.processExpression(expression);
    }

    private AssignmentStatement handleArrayWrite(AssignmentStatement assignmentStatement) {
        if (assignmentStatement.getLhs().length != 1) {
            return null;
        }
        LeftHandSide leftHandSide = assignmentStatement.getLhs()[0];
        if (!(leftHandSide instanceof ArrayLHS)) {
            return null;
        }
        ArrayLHS arrayLHS = (ArrayLHS)leftHandSide;
        if (MemorySliceUtils.isPointerArray(arrayLHS.getArray()) || MemorySliceUtils.isIntArray(arrayLHS.getArray()) || MemorySliceUtils.isRealArray(arrayLHS.getArray())) {
            if (arrayLHS.getIndices().length != 1) {
                return null;
            }
            Expression expression = arrayLHS.getIndices()[0];
            int n = this.getMemorySliceNumberFromPointer(expression);
            ++this.mAccessCounter;
            int n2 = n;
            this.mSliceAccessCounter[n2] = this.mSliceAccessCounter[n2] + 1;
            ++this.mWriteCounter;
            int n3 = n;
            this.mSliceWriteCounter[n3] = this.mSliceWriteCounter[n3] + 1;
            String string = this.getMemorySliceSuffixFromPointer(expression);
            String string2 = ((VariableLHS)arrayLHS.getArray()).getIdentifier();
            String string3 = string2 + string;
            IdentifierReplacer identifierReplacer = new IdentifierReplacer(Collections.singletonMap(string2, string3), null, null);
            LeftHandSide leftHandSide2 = identifierReplacer.processLeftHandSide(leftHandSide);
            Expression expression2 = assignmentStatement.getRhs()[0];
            if (MemorySliceUtils.containsMemoryArrays((BoogieASTNode)expression2)) {
                throw new MemorySliceException("Contains mem arrays " + String.valueOf(expression2));
            }
            AssignmentStatement assignmentStatement2 = new AssignmentStatement(assignmentStatement.getLocation(), new LeftHandSide[]{leftHandSide2}, new Expression[]{expression2});
            ModelUtils.copyAnnotations((IElement)assignmentStatement, (IElement)assignmentStatement2);
            return assignmentStatement2;
        }
        return null;
    }

    private AssignmentStatement handleInitToZero(AssignmentStatement assignmentStatement) {
        String string;
        if (assignmentStatement.getLhs().length != 1) {
            return null;
        }
        LeftHandSide leftHandSide = assignmentStatement.getLhs()[0];
        if (!(leftHandSide instanceof VariableLHS)) {
            return null;
        }
        if (!(assignmentStatement.getRhs()[0] instanceof FunctionApplication)) {
            return null;
        }
        FunctionApplication functionApplication = (FunctionApplication)assignmentStatement.getRhs()[0];
        if (functionApplication.getIdentifier().equals("~initToZeroAtPointerBaseAddress~int")) {
            string = "#memory_int";
        } else if (functionApplication.getIdentifier().equals("~initToZeroAtPointerBaseAddress~$Pointer$")) {
            string = "#memory_$Pointer$";
        } else {
            return null;
        }
        FunctionApplication functionApplication2 = (FunctionApplication)assignmentStatement.getRhs()[0];
        Expression expression = functionApplication2.getArguments()[1];
        int n = this.getMemorySliceNumberFromBase(expression);
        ++this.mAccessCounter;
        int n2 = n;
        this.mSliceAccessCounter[n2] = this.mSliceAccessCounter[n2] + 1;
        ++this.mWriteCounter;
        int n3 = n;
        this.mSliceWriteCounter[n3] = this.mSliceWriteCounter[n3] + 1;
        String string2 = this.getMemorySliceSuffixFromBase(expression);
        String string3 = string + string2;
        VariableLHS variableLHS = MemorySliceUtils.replaceLeftHandSide(leftHandSide, Collections.singletonMap(string, string3), null, null);
        IdentifierExpression identifierExpression = MemorySliceUtils.replaceIdentifierExpression(functionApplication2.getArguments()[0], Collections.singletonMap(string, string3), null, null);
        Expression[] expressionArray = new Expression[]{identifierExpression, expression};
        FunctionApplication functionApplication3 = new FunctionApplication(functionApplication2.getLoc(), functionApplication2.getType(), functionApplication2.getIdentifier(), expressionArray);
        ModelUtils.copyAnnotations((IElement)functionApplication2, (IElement)functionApplication3);
        AssignmentStatement assignmentStatement2 = new AssignmentStatement(assignmentStatement.getLocation(), new LeftHandSide[]{variableLHS}, new Expression[]{functionApplication3});
        ModelUtils.copyAnnotations((IElement)assignmentStatement, (IElement)assignmentStatement2);
        return assignmentStatement2;
    }

    private int getMemorySliceNumberFromBase(Expression expression) {
        PointerBase pointerBase = AliasAnalysis.extractPointerBaseFromBase(this.mAsFac, expression);
        AddressStore addressStore = (AddressStore)this.mUf.find((Object)pointerBase);
        Objects.requireNonNull(addressStore);
        Integer n = this.mRepToMemorySlice.get(addressStore);
        Objects.requireNonNull(n);
        return n;
    }

    private int getMemorySliceNumberFromPointer(Expression expression) {
        PointerBase pointerBase = AliasAnalysis.extractPointerBaseFromPointer(this.mAsFac, expression);
        AddressStore addressStore = (AddressStore)this.mUf.find((Object)pointerBase);
        Objects.requireNonNull(addressStore);
        Integer n = this.mRepToMemorySlice.get(addressStore);
        Objects.requireNonNull(n);
        return n;
    }

    private String getMemorySliceSuffixFromBase(Expression expression) {
        int n = this.getMemorySliceNumberFromBase(expression);
        return MemorySliceUtils.constructMemorySliceSuffix(n);
    }

    private String getMemorySliceSuffixFromPointer(Expression expression) {
        int n = this.getMemorySliceNumberFromPointer(expression);
        return MemorySliceUtils.constructMemorySliceSuffix(n);
    }
}

