/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.AnnotatedProgramPoint;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.ImpRootNode;
import de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.CodeCheckSettings;
import de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.GraphWriter;
import java.util.HashSet;

public abstract class CodeChecker {
    private final CodeCheckSettings mGlobalSettings;
    protected IIcfg<IcfgLocation> mOriginalRoot;
    protected CfgSmtToolkit mCfgToolkit;
    protected final ImpRootNode mGraphRoot;
    protected IHoareTripleChecker mEdgeChecker;
    protected IPredicateUnifier mPredicateUnifier;
    protected GraphWriter mGraphWriter;
    protected final ILogger mLogger;

    public CodeChecker(CfgSmtToolkit cfgSmtToolkit, IIcfg<IcfgLocation> iIcfg, ImpRootNode impRootNode, GraphWriter graphWriter, IHoareTripleChecker iHoareTripleChecker, IPredicateUnifier iPredicateUnifier, ILogger iLogger, CodeCheckSettings codeCheckSettings) {
        this.mLogger = iLogger;
        this.mCfgToolkit = cfgSmtToolkit;
        this.mOriginalRoot = iIcfg;
        this.mGraphRoot = impRootNode;
        this.mEdgeChecker = iHoareTripleChecker;
        this.mPredicateUnifier = iPredicateUnifier;
        this.mGraphWriter = graphWriter;
        this.mGlobalSettings = codeCheckSettings;
    }

    public abstract boolean codeCheck(NestedRun<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint> var1, IPredicate[] var2, AnnotatedProgramPoint var3);

    protected IPredicate conjugatePredicates(IPredicate iPredicate, IPredicate iPredicate2) {
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>(2, 1.0f);
        hashSet.add(this.mPredicateUnifier.getOrConstructPredicate(iPredicate));
        hashSet.add(this.mPredicateUnifier.getOrConstructPredicate(iPredicate2));
        return this.mPredicateUnifier.getOrConstructPredicateForConjunction(hashSet);
    }

    protected IPredicate negatePredicate(IPredicate iPredicate) {
        IPredicate iPredicate2 = this.mPredicateUnifier.getPredicateFactory().not(iPredicate);
        return this.mPredicateUnifier.getOrConstructPredicate(iPredicate2);
    }

    public CodeCheckSettings getGlobalSettings() {
        return this.mGlobalSettings;
    }
}

