/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.OldVarsAssignmentCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.GlobalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class IncrementalHoareTripleChecker
implements IHoareTripleChecker {
    private static final String MSG_UNEXPECTED_QUICKCHECK_RESULT = "unexpected quickcheck result";
    private static final String MSG_WRONG_KIND_OF_ACTION = "Wrong kind of action";
    private static final String ANNOT_NAMED = ":named";
    public static final boolean UNLET_TERMS = true;
    protected static final String ID_PRECONDITION = "precondition";
    protected static final String ID_PRECONDITION_NON_MOD_GLOBAL_EQUALITY = "precondNonModGlobalEquality";
    protected static final String ID_TRANSITION_MODIFIABLE_GLOBAL_EQUALITY = "modifiableVarEquality";
    protected static final String ID_TRANSITION_FORMULA = "codeBlock";
    protected static final String ID_LOCAL_VARS_ASSIGNMENT = "localVarsAssignment";
    protected static final String ID_HIERACHICAL_PRECONDITION = "hierarchicalPrecondition";
    protected static final String ID_NEGATED_POSTCONDITION = "negatedPostcondition";
    private static final String MSG_START_EDGE_CHECK = "starting to check validity of Hoare triples";
    private static final String MSG_END_EDGE_CHECK = "finished to check validity of Hoare triples";
    protected final ManagedScript mManagedScript;
    protected final ModifiableGlobalsTable mModifiableGlobalVariableManager;
    private final OldVarsAssignmentCache mOldVarsAssignmentCache;
    private IPredicate mAssertedPrecond;
    protected IPredicate mAssertedHier;
    protected IAction mAssertedAction;
    private IPredicate mAssertedPostcond;
    private ScopedHashMap<IProgramVar, Term> mHierConstants;
    public final boolean mUseNamedTerms = true;
    protected final HoareTripleCheckerStatisticsGenerator mEdgeCheckerBenchmark;
    private final boolean mConstructCounterexamples;
    private IProgramExecution.ProgramState<Term> mCounterexampleStatePrecond;
    private IProgramExecution.ProgramState<Term> mCounterexampleStatePostcond;

    public IncrementalHoareTripleChecker(CfgSmtToolkit cfgSmtToolkit, boolean bl) {
        this.mManagedScript = cfgSmtToolkit.getManagedScript();
        this.mModifiableGlobalVariableManager = cfgSmtToolkit.getModifiableGlobalsTable();
        this.mOldVarsAssignmentCache = cfgSmtToolkit.getOldVarsAssignmentCache();
        this.mEdgeCheckerBenchmark = new HoareTripleCheckerStatisticsGenerator();
        this.mConstructCounterexamples = bl;
    }

    @Override
    public HoareTripleCheckerStatisticsGenerator getStatistics() {
        return this.mEdgeCheckerBenchmark;
    }

    @Override
    public IncrementalPlicationChecker.Validity checkInternal(IPredicate iPredicate, IInternalAction iInternalAction, IPredicate iPredicate2) {
        Script.LBool lBool = this.prepareAssertionStackAndAddTransition(iInternalAction);
        if (lBool == Script.LBool.UNSAT) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        Script.LBool lBool2 = this.prepareAssertionStackAndAddPrecondition(iPredicate);
        if (lBool2 == Script.LBool.UNSAT) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        Script.LBool lBool3 = this.prepareAssertionStackAndAddPostcond(iPredicate2);
        if (lBool3 == Script.LBool.UNSAT) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        assert (lBool3 == Script.LBool.UNKNOWN || lBool3 == null) : "unexpected quickcheck result";
        assert (this.mAssertedPrecond == iPredicate && this.mAssertedHier == null && this.mAssertedAction == iInternalAction && this.mAssertedPostcond == iPredicate2);
        return this.checkValidity();
    }

    @Override
    public IncrementalPlicationChecker.Validity checkCall(IPredicate iPredicate, ICallAction iCallAction, IPredicate iPredicate2) {
        Script.LBool lBool = this.prepareAssertionStackAndAddTransition(iCallAction);
        if (lBool == Script.LBool.UNSAT) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        Script.LBool lBool2 = this.prepareAssertionStackAndAddPrecondition(iPredicate);
        if (lBool2 == Script.LBool.UNSAT) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        Script.LBool lBool3 = this.prepareAssertionStackAndAddPostcond(iPredicate2);
        if (lBool3 == Script.LBool.UNSAT) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        assert (lBool3 == Script.LBool.UNKNOWN || lBool3 == null) : "unexpected quickcheck result";
        assert (this.mAssertedPrecond == iPredicate && this.mAssertedHier == null && this.mAssertedAction == iCallAction && this.mAssertedPostcond == iPredicate2);
        return this.checkValidity();
    }

    @Override
    public IncrementalPlicationChecker.Validity checkReturn(IPredicate iPredicate, IPredicate iPredicate2, IReturnAction iReturnAction, IPredicate iPredicate3) {
        Script.LBool lBool = this.prepareAssertionStackAndAddTransition(iReturnAction);
        if (lBool == Script.LBool.UNSAT) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        Script.LBool lBool2 = this.prepareAssertionStackAndAddPrecondition(iPredicate);
        if (lBool2 == Script.LBool.UNSAT) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        Script.LBool lBool3 = this.prepareAssertionStackAndAddHierpred(iPredicate2);
        if (lBool3 == Script.LBool.UNSAT) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        Script.LBool lBool4 = this.prepareAssertionStackAndAddPostcond(iPredicate3);
        if (lBool4 == Script.LBool.UNSAT) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        assert (lBool4 == Script.LBool.UNKNOWN || lBool4 == null) : "unexpected quickcheck result";
        assert (this.mAssertedPrecond == iPredicate && this.mAssertedHier == iPredicate2 && this.mAssertedAction == iReturnAction && this.mAssertedPostcond == iPredicate3);
        return this.checkValidity();
    }

    protected Script.LBool prepareAssertionStackAndAddTransition(IAction iAction) {
        if (this.mAssertedAction != iAction) {
            if (this.mAssertedAction != null) {
                if (this.mAssertedPrecond != null) {
                    if (this.mAssertedPostcond != null) {
                        this.unAssertPostcondition();
                    }
                    if (this.mAssertedHier != null) {
                        this.unAssertHierPred();
                    }
                    this.unAssertPrecondition();
                }
                this.unAssertCodeBlock();
            }
            Script.LBool lBool = this.assertCodeBlock(iAction);
            return lBool;
        }
        return null;
    }

    protected Script.LBool prepareAssertionStackAndAddPrecondition(IPredicate iPredicate) {
        if (this.mAssertedPrecond != iPredicate) {
            if (this.mAssertedPrecond != null) {
                if (this.mAssertedPostcond != null) {
                    this.unAssertPostcondition();
                }
                if (this.mAssertedHier != null) {
                    this.unAssertHierPred();
                }
                this.unAssertPrecondition();
            }
            Script.LBool lBool = this.assertPrecondition(iPredicate);
            return lBool;
        }
        return null;
    }

    protected Script.LBool prepareAssertionStackAndAddHierpred(IPredicate iPredicate) {
        if (this.mAssertedHier != iPredicate) {
            if (this.mAssertedPostcond != null) {
                this.unAssertPostcondition();
            }
            if (this.mAssertedHier != null) {
                this.unAssertHierPred();
            }
            Script.LBool lBool = this.assertHierPred(iPredicate);
            return lBool;
        }
        return null;
    }

    protected Script.LBool prepareAssertionStackAndAddPostcond(IPredicate iPredicate) {
        if (this.mAssertedPostcond != iPredicate) {
            if (this.mAssertedPostcond != null) {
                this.unAssertPostcondition();
            }
            Script.LBool lBool = this.assertPostcond(iPredicate);
            return lBool;
        }
        return null;
    }

    protected Script.LBool assertPostcond(IPredicate iPredicate) {
        if (this.mAssertedAction instanceof IInternalAction) {
            return this.assertPostcondInternal(iPredicate);
        }
        if (this.mAssertedAction instanceof ICallAction) {
            return this.assertPostcondCall(iPredicate);
        }
        if (this.mAssertedAction instanceof IReturnAction) {
            return this.assertPostcondReturn(iPredicate);
        }
        throw new AssertionError((Object)"unknown trans type");
    }

    public void clearAssertionStack() {
        if (this.mAssertedPostcond != null) {
            this.unAssertPostcondition();
        }
        if (this.mAssertedPrecond != null) {
            this.unAssertPrecondition();
        }
        if (this.mAssertedHier != null) {
            this.unAssertHierPred();
        }
        if (this.mAssertedAction != null) {
            this.unAssertCodeBlock();
        }
    }

    public void releaseLock() {
        this.clearAssertionStack();
        assert (!this.mManagedScript.isLocked()) : "script should not be locked";
    }

    private Script.LBool assertPrecondition(IPredicate iPredicate) {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedAction != null) : "Assert CodeBlock first";
        assert (this.mAssertedPrecond == null) : "precond already asserted";
        this.mAssertedPrecond = iPredicate;
        this.mEdgeCheckerBenchmark.continueEdgeCheckerTime();
        this.mManagedScript.push((Object)this, 1);
        Term term = iPredicate.getClosedFormula();
        Annotation annotation = new Annotation(ANNOT_NAMED, (Object)ID_PRECONDITION);
        term = this.mManagedScript.annotate((Object)this, term, new Annotation[]{annotation});
        annotation = this.mManagedScript.assertTerm((Object)this, term);
        String string = this.mAssertedAction.getPrecedingProcedure();
        Set<IProgramNonOldVar> set = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(string);
        Collection<Term> collection = IncrementalHoareTripleChecker.constructNonModOldVarsEquality(iPredicate.getVars(), set, this.mManagedScript, this);
        if (!collection.isEmpty()) {
            Term term2 = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])collection.toArray(new Term[collection.size()]));
            Annotation annotation2 = new Annotation(ANNOT_NAMED, (Object)ID_PRECONDITION_NON_MOD_GLOBAL_EQUALITY);
            term2 = this.mManagedScript.annotate((Object)this, term2, new Annotation[]{annotation2});
            annotation = this.mManagedScript.assertTerm((Object)this, term2);
        }
        this.mEdgeCheckerBenchmark.stopEdgeCheckerTime();
        return annotation;
    }

    protected static Collection<Term> constructNonModOldVarsEquality(Set<IProgramVar> set, Set<IProgramNonOldVar> set2, ManagedScript managedScript, Object object) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (IProgramVar iProgramVar : set) {
            IProgramNonOldVar iProgramNonOldVar;
            if (!(iProgramVar instanceof IProgramOldVar) || set2.contains(iProgramNonOldVar = ((IProgramOldVar)iProgramVar).getNonOldVar())) continue;
            arrayList.add(IncrementalHoareTripleChecker.oldVarsEquality((IProgramOldVar)iProgramVar, managedScript, object));
        }
        return arrayList;
    }

    private static Term oldVarsEquality(IProgramOldVar iProgramOldVar, ManagedScript managedScript, Object object) {
        assert (iProgramOldVar.isOldvar());
        IProgramNonOldVar iProgramNonOldVar = iProgramOldVar.getNonOldVar();
        Term term = managedScript.term(object, "=", new Term[]{iProgramOldVar.getDefaultConstant(), iProgramNonOldVar.getDefaultConstant()});
        return term;
    }

    private void unAssertPrecondition() {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedPrecond != null) : "No PrePred asserted";
        this.mAssertedPrecond = null;
        this.mManagedScript.pop((Object)this, 1);
        if (this.mAssertedAction == null) {
            throw new AssertionError((Object)"CodeBlock is assigned first");
        }
    }

    protected Script.LBool assertCodeBlock(IAction iAction) {
        Term term;
        if (this.mManagedScript.isLocked()) {
            this.mManagedScript.requestLockRelease();
        }
        this.mManagedScript.lock((Object)this);
        this.mManagedScript.echo((Object)this, new QuotedObject(MSG_START_EDGE_CHECK));
        assert (this.mAssertedAction == null) : "CodeBlock already asserted";
        this.mAssertedAction = iAction;
        this.mEdgeCheckerBenchmark.continueEdgeCheckerTime();
        this.mManagedScript.push((Object)this, 1);
        if (iAction instanceof IInternalAction) {
            term = iAction.getTransformula().getClosedFormula();
        } else if (iAction instanceof ICallAction) {
            term = ((ICallAction)iAction).getLocalVarsAssignment().getClosedFormula();
        } else if (iAction instanceof IReturnAction) {
            term = ((IReturnAction)iAction).getAssignmentOfReturn().getClosedFormula();
        } else {
            throw new AssertionError((Object)"unknown action");
        }
        Annotation annotation = new Annotation(ANNOT_NAMED, (Object)ID_TRANSITION_FORMULA);
        term = this.mManagedScript.annotate((Object)this, term, new Annotation[]{annotation});
        annotation = this.mManagedScript.assertTerm((Object)this, term);
        if (iAction instanceof IReturnAction) {
            this.mHierConstants = new ScopedHashMap();
            IReturnAction iReturnAction = (IReturnAction)iAction;
            String string = iReturnAction.getPrecedingProcedure();
            UnmodifiableTransFormula unmodifiableTransFormula = this.mOldVarsAssignmentCache.getOldVarsAssignment(string);
            Term term2 = unmodifiableTransFormula.getFormula();
            term2 = this.renameVarsToHierConstants(unmodifiableTransFormula.getInVars(), term2);
            term2 = this.renameVarsToDefaultConstants(unmodifiableTransFormula.getOutVars(), term2);
            term2 = new FormulaUnLet().unlet(term2);
            assert (term2.getFreeVars().length == 0);
            Object object = new Annotation(ANNOT_NAMED, (Object)ID_TRANSITION_MODIFIABLE_GLOBAL_EQUALITY);
            term2 = this.mManagedScript.annotate((Object)this, term2, new Annotation[]{object});
            annotation = this.mManagedScript.assertTerm((Object)this, term2);
            object = unmodifiableTransFormula.getInVars().keySet();
            UnmodifiableTransFormula unmodifiableTransFormula2 = iReturnAction.getLocalVarsAssignmentOfCall();
            Term term3 = unmodifiableTransFormula2.getFormula();
            term3 = this.renameNonModifiableGlobalsToDefaultConstants(unmodifiableTransFormula2.getInVars(), (Set<IProgramVar>)object, term3);
            term3 = this.renameVarsToHierConstants(unmodifiableTransFormula2.getInVars(), term3);
            term3 = this.renameVarsToDefaultConstants(unmodifiableTransFormula2.getOutVars(), term3);
            term3 = this.renameAuxVarsToCorrespondingConstants(unmodifiableTransFormula2.getAuxVars(), term3);
            term3 = new FormulaUnLet().unlet(term3);
            assert (term3.getFreeVars().length == 0);
            Annotation annotation2 = new Annotation(ANNOT_NAMED, (Object)ID_LOCAL_VARS_ASSIGNMENT);
            term3 = this.mManagedScript.annotate((Object)this, term3, new Annotation[]{annotation2});
            annotation = this.mManagedScript.assertTerm((Object)this, term3);
        }
        this.mEdgeCheckerBenchmark.stopEdgeCheckerTime();
        return annotation;
    }

    protected void unAssertCodeBlock() {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedAction != null) : "No CodeBlock asserted";
        this.mAssertedAction = null;
        this.mHierConstants = null;
        this.mManagedScript.pop((Object)this, 1);
        if (this.mAssertedPrecond != null) {
            throw new AssertionError((Object)"CodeBlock is unasserted last");
        }
        this.mManagedScript.echo((Object)this, new QuotedObject(MSG_END_EDGE_CHECK));
        this.mManagedScript.unlock((Object)this);
    }

    protected Script.LBool assertHierPred(IPredicate iPredicate) {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedAction != null) : "assert Return first";
        assert (this.mAssertedAction instanceof IReturnAction) : "assert Return first";
        assert (this.mAssertedPrecond != null) : "assert precond fist";
        assert (this.mAssertedHier == null) : "HierPred already asserted";
        this.mAssertedHier = iPredicate;
        this.mEdgeCheckerBenchmark.continueEdgeCheckerTime();
        this.mManagedScript.push((Object)this, 1);
        this.mHierConstants.beginScope();
        Term term = iPredicate.getFormula();
        String string = this.mAssertedAction.getPrecedingProcedure();
        Set<IProgramNonOldVar> set = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(string);
        term = this.renameNonModifiableNonOldGlobalsToDefaultConstants(iPredicate.getVars(), set, term);
        String string2 = this.mAssertedAction.getSucceedingProcedure();
        Set<IProgramNonOldVar> set2 = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(string2);
        term = IncrementalHoareTripleChecker.renameNonModifiableOldGlobalsToDefaultConstantOfNonOldVar(iPredicate.getVars(), set2, term, this.mManagedScript, this);
        term = this.renameVarsToHierConstants(iPredicate.getVars(), term);
        term = new FormulaUnLet().unlet(term);
        assert (term.getFreeVars().length == 0);
        Annotation annotation = new Annotation(ANNOT_NAMED, (Object)ID_HIERACHICAL_PRECONDITION);
        term = this.mManagedScript.annotate((Object)this, term, new Annotation[]{annotation});
        annotation = this.mManagedScript.assertTerm((Object)this, term);
        this.mEdgeCheckerBenchmark.stopEdgeCheckerTime();
        return annotation;
    }

    private Collection<Term> constructCalleeNonModOldVarsEquality(Set<IProgramVar> set, Set<IProgramVar> set2, Set<IProgramVar> set3) {
        if (!set3.containsAll(set2)) {
            // empty if block
        }
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (IProgramVar iProgramVar : set) {
            IProgramNonOldVar iProgramNonOldVar;
            if (!(iProgramVar instanceof GlobalProgramVar) || !set2.contains(iProgramNonOldVar = iProgramVar instanceof IProgramOldVar ? ((IProgramOldVar)iProgramVar).getNonOldVar() : (IProgramNonOldVar)iProgramVar) || set3.contains(iProgramNonOldVar)) continue;
            Term term = this.getOrConstructHierConstant(iProgramNonOldVar);
            Term term2 = SmtUtils.binaryEquality((Script)this.mManagedScript.getScript(), (Term)iProgramVar.getDefaultConstant(), (Term)term);
            arrayList.add(term2);
        }
        return arrayList;
    }

    protected void unAssertHierPred() {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedHier != null) : "No HierPred asserted";
        assert (this.mAssertedAction instanceof IReturnAction) : "Wrong kind of action";
        this.mAssertedHier = null;
        this.mManagedScript.pop((Object)this, 1);
        this.mHierConstants.endScope();
    }

    private Script.LBool assertPostcondInternal(IPredicate iPredicate) {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedPrecond != null);
        assert (this.mAssertedAction != null);
        assert (this.mAssertedAction instanceof IInternalAction) : "Wrong kind of action";
        this.mEdgeCheckerBenchmark.continueEdgeCheckerTime();
        this.mManagedScript.push((Object)this, 1);
        this.mAssertedPostcond = iPredicate;
        Term term = IncrementalHoareTripleChecker.constructPostcondFormula(iPredicate, (IInternalAction)this.mAssertedAction, this.mModifiableGlobalVariableManager, this.mManagedScript, this);
        term = new FormulaUnLet().unlet(term);
        assert (term.getFreeVars().length == 0);
        Term term2 = this.mManagedScript.term((Object)this, "not", new Term[]{term});
        Annotation annotation = new Annotation(ANNOT_NAMED, (Object)ID_NEGATED_POSTCONDITION);
        term2 = this.mManagedScript.annotate((Object)this, term2, new Annotation[]{annotation});
        annotation = this.mManagedScript.assertTerm((Object)this, term2);
        this.mEdgeCheckerBenchmark.stopEdgeCheckerTime();
        return annotation;
    }

    public static Term constructPostcondFormula(IPredicate iPredicate, IInternalAction iInternalAction, ModifiableGlobalsTable modifiableGlobalsTable, ManagedScript managedScript, Object object) {
        Set<IProgramVar> set = iInternalAction.getTransformula().getAssignedVars();
        Term term = IncrementalHoareTripleChecker.renameVarsToPrimedConstants(set, iPredicate.getFormula(), managedScript, object);
        String string = iInternalAction.getSucceedingProcedure();
        Set<IProgramNonOldVar> set2 = modifiableGlobalsTable.getModifiedBoogieVars(string);
        term = IncrementalHoareTripleChecker.renameNonModifiableOldGlobalsToDefaultConstantOfNonOldVar(iPredicate.getVars(), set2, term, managedScript, object);
        term = IncrementalHoareTripleChecker.renameVarsToDefaultConstants(iPredicate.getVars(), term, managedScript, object);
        return term;
    }

    private Script.LBool assertPostcondCall(IPredicate iPredicate) {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedPrecond != null);
        assert (this.mAssertedAction != null);
        assert (this.mAssertedAction instanceof ICallAction) : "Wrong kind of action";
        this.mEdgeCheckerBenchmark.continueEdgeCheckerTime();
        this.mManagedScript.push((Object)this, 1);
        this.mAssertedPostcond = iPredicate;
        Set<IProgramVar> set = iPredicate.getVars();
        Term term = this.renameGlobalsAndOldVarsToNonOldDefaultConstants(set, iPredicate.getFormula());
        term = IncrementalHoareTripleChecker.renameVarsToPrimedConstants(set, term, this.mManagedScript, this);
        term = IncrementalHoareTripleChecker.renameVarsToDefaultConstants(iPredicate.getVars(), term, this.mManagedScript, this);
        term = new FormulaUnLet().unlet(term);
        assert (term.getFreeVars().length == 0);
        Term term2 = this.mManagedScript.term((Object)this, "not", new Term[]{term});
        Annotation annotation = new Annotation(ANNOT_NAMED, (Object)ID_NEGATED_POSTCONDITION);
        term2 = this.mManagedScript.annotate((Object)this, term2, new Annotation[]{annotation});
        annotation = this.mManagedScript.assertTerm((Object)this, term2);
        this.mEdgeCheckerBenchmark.stopEdgeCheckerTime();
        return annotation;
    }

    private Script.LBool assertPostcondReturn(IPredicate iPredicate) {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedPrecond != null);
        assert (this.mAssertedAction instanceof IReturnAction) : "Wrong kind of action";
        assert (this.mAssertedHier != null);
        this.mEdgeCheckerBenchmark.continueEdgeCheckerTime();
        this.mManagedScript.push((Object)this, 1);
        this.mHierConstants.beginScope();
        this.mAssertedPostcond = iPredicate;
        Set<IProgramVar> set = ((IReturnAction)this.mAssertedAction).getAssignmentOfReturn().getOutVars().keySet();
        Term term = IncrementalHoareTripleChecker.renameVarsToPrimedConstants(set, iPredicate.getFormula(), this.mManagedScript, this);
        String string = this.mAssertedAction.getPrecedingProcedure();
        Set<IProgramNonOldVar> set2 = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(string);
        term = IncrementalHoareTripleChecker.renameVarsToDefaultConstants(set2, term, this.mManagedScript, this);
        term = this.renameNonModifiableNonOldGlobalsToDefaultConstants(iPredicate.getVars(), set2, term);
        String string2 = this.mAssertedAction.getSucceedingProcedure();
        Set<IProgramNonOldVar> set3 = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(string2);
        term = IncrementalHoareTripleChecker.renameNonModifiableOldGlobalsToDefaultConstantOfNonOldVar(iPredicate.getVars(), set3, term, this.mManagedScript, this);
        term = this.renameVarsToHierConstants(iPredicate.getVars(), term);
        term = new FormulaUnLet().unlet(term);
        assert (term.getFreeVars().length == 0);
        Term term2 = this.mManagedScript.term((Object)this, "not", new Term[]{term});
        Annotation annotation = new Annotation(ANNOT_NAMED, (Object)ID_NEGATED_POSTCONDITION);
        term2 = this.mManagedScript.annotate((Object)this, term2, new Annotation[]{annotation});
        annotation = this.mManagedScript.assertTerm((Object)this, term2);
        this.mEdgeCheckerBenchmark.stopEdgeCheckerTime();
        return annotation;
    }

    protected void unAssertPostcondition() {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedAction != null) : "Assert CodeBlock first!";
        assert (this.mAssertedPrecond != null) : "Assert precond first!";
        assert (this.mAssertedPostcond != null) : "Assert postcond first!";
        this.mAssertedPostcond = null;
        this.mCounterexampleStatePrecond = null;
        this.mCounterexampleStatePostcond = null;
        this.mManagedScript.pop((Object)this, 1);
        if (this.mAssertedAction instanceof IReturnAction) {
            assert (this.mHierConstants != null) : "Assert hierPred first!";
            assert (this.mAssertedHier != null) : "Assert hierPred first!";
            this.mHierConstants.endScope();
        }
    }

    protected IncrementalPlicationChecker.Validity checkValidity() {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedAction != null) : "Assert CodeBlock first!";
        assert (this.mAssertedPrecond != null) : "Assert precond first! ";
        assert (this.mAssertedPostcond != null) : "Assert postcond first! ";
        this.mEdgeCheckerBenchmark.continueEdgeCheckerTime();
        Script.LBool lBool = this.mManagedScript.checkSat((Object)this);
        if (lBool == Script.LBool.SAT && this.mConstructCounterexamples) {
            this.mCounterexampleStatePrecond = this.constructCounterexampleStateForPrecondition();
            this.mCounterexampleStatePostcond = this.constructCounterexampleStateForPostcondition();
        }
        IncrementalPlicationChecker.Validity validity = IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)lBool);
        this.mEdgeCheckerBenchmark.getSolverCounter(validity).incRe();
        this.mEdgeCheckerBenchmark.stopEdgeCheckerTime();
        return validity;
    }

    private IProgramExecution.ProgramState<Term> constructCounterexampleStateForPrecondition() {
        UnmodifiableTransFormula unmodifiableTransFormula = this.mAssertedAction.getTransformula();
        return this.constructCounterexampleState(unmodifiableTransFormula.getInVars(), TransFormulaUtils::constructOutvarsToInvarsMap, term -> TransFormulaUtils.renameInvarsToDefaultVars(unmodifiableTransFormula, this.mManagedScript, term));
    }

    private IProgramExecution.ProgramState<Term> constructCounterexampleStateForPostcondition() {
        UnmodifiableTransFormula unmodifiableTransFormula = this.mAssertedAction.getTransformula();
        return this.constructCounterexampleState(unmodifiableTransFormula.getOutVars(), TransFormulaUtils::constructInvarsToOutvarsMap, term -> TransFormulaUtils.renameOutvarsToDefaultVars(unmodifiableTransFormula, this.mManagedScript, term));
    }

    private IProgramExecution.ProgramState<Term> constructCounterexampleState(Map<IProgramVar, TermVariable> map, Function<TransFormula, Map<TermVariable, TermVariable>> function, Function<Term, Term> function2) {
        Term term;
        Map.Entry<IProgramVar, TermVariable> entry2;
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        UnmodifiableTransFormula unmodifiableTransFormula = this.mAssertedAction.getTransformula();
        for (Map.Entry<IProgramVar, TermVariable> entry2 : map.entrySet()) {
            if (!SmtUtils.isSortForWhichWeCanGetValues((Sort)entry2.getKey().getTermVariable().getSort())) continue;
            term = UnmodifiableTransFormula.computeClosedFormula((Term)map.get(entry2.getKey()), unmodifiableTransFormula.getInVars(), unmodifiableTransFormula.getOutVars(), Collections.emptySet(), this.mManagedScript);
            hashMap.put((Term)((IProgramVar)entry2.getKey()).getTermVariable(), term);
        }
        entry2 = unmodifiableTransFormula.getInVars().entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
        entry2.addAll(unmodifiableTransFormula.getOutVars().entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet()));
        Set set = SubTermFinder.find((Term)unmodifiableTransFormula.getFormula(), arg_0 -> this.lambda$6((Set)((Object)entry2), arg_0), (boolean)false);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            term = (Term)iterator.next();
            Term term2 = Substitution.apply((ManagedScript)this.mManagedScript, function.apply(unmodifiableTransFormula), (Term)term);
            Term term3 = function2.apply(term2);
            Term term4 = UnmodifiableTransFormula.computeClosedFormula(term2, unmodifiableTransFormula.getInVars(), unmodifiableTransFormula.getOutVars(), Collections.emptySet(), this.mManagedScript);
            hashMap.put(term3, term4);
        }
        return this.generateProgramState(hashMap);
    }

    private IProgramExecution.ProgramState<Term> generateProgramState(Map<Term, Term> map) {
        HashMap<Term, List<Term>> hashMap = new HashMap<Term, List<Term>>();
        for (Map.Entry<Term, Term> entry : map.entrySet()) {
            Map map2 = this.mManagedScript.getValue((Object)this, new Term[]{entry.getValue()});
            Term term = (Term)map2.get(entry.getValue());
            hashMap.put(entry.getKey(), Collections.singletonList(term));
        }
        return new IProgramExecution.ProgramState(hashMap, Term.class);
    }

    private boolean isSuitableArrayReadTerm(Term term, Set<TermVariable> set) {
        return term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("select") && SmtUtils.isSortForWhichWeCanGetValues((Sort)term.getSort()) && Arrays.stream(term.getFreeVars()).allMatch(termVariable -> set.contains(termVariable));
    }

    private static Term renameVarsToDefaultConstants(Set<? extends IProgramVar> set, Term term, ManagedScript managedScript, Object object) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> arrayList2 = new ArrayList<ApplicationTerm>();
        for (IProgramVar termVariableArray2 : set) {
            arrayList.add(termVariableArray2.getTermVariable());
            arrayList2.add(termVariableArray2.getDefaultConstant());
        }
        TermVariable[] termVariableArray = arrayList.toArray(new TermVariable[arrayList.size()]);
        Term[] termArray = arrayList2.toArray(new Term[arrayList2.size()]);
        return managedScript.let(object, termVariableArray, termArray, term);
    }

    private Term renameVarsToDefaultConstants(Map<IProgramVar, TermVariable> map, Term term) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> arrayList2 = new ArrayList<ApplicationTerm>();
        for (Map.Entry<IProgramVar, TermVariable> termVariableArray2 : map.entrySet()) {
            arrayList.add(termVariableArray2.getValue());
            arrayList2.add(termVariableArray2.getKey().getDefaultConstant());
        }
        TermVariable[] termVariableArray = arrayList.toArray(new TermVariable[arrayList.size()]);
        Term[] termArray = arrayList2.toArray(new Term[arrayList2.size()]);
        return this.mManagedScript.let((Object)this, termVariableArray, termArray, term);
    }

    private static Term renameVarsToPrimedConstants(Set<IProgramVar> set, Term term, ManagedScript managedScript, Object object) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> arrayList2 = new ArrayList<ApplicationTerm>();
        for (IProgramVar termVariableArray2 : set) {
            arrayList.add(termVariableArray2.getTermVariable());
            arrayList2.add(termVariableArray2.getPrimedConstant());
        }
        TermVariable[] termVariableArray = arrayList.toArray(new TermVariable[arrayList.size()]);
        Term[] termArray = arrayList2.toArray(new Term[arrayList2.size()]);
        return managedScript.let(object, termVariableArray, termArray, term);
    }

    private Term renameVarsToHierConstants(Set<IProgramVar> set, Term term) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        for (IProgramVar termVariableArray2 : set) {
            arrayList.add(termVariableArray2.getTermVariable());
            arrayList2.add(this.getOrConstructHierConstant(termVariableArray2));
        }
        TermVariable[] termVariableArray = arrayList.toArray(new TermVariable[arrayList.size()]);
        Term[] termArray = arrayList2.toArray(new Term[arrayList2.size()]);
        return this.mManagedScript.let((Object)this, termVariableArray, termArray, term);
    }

    private Term renameVarsToHierConstants(Map<IProgramVar, TermVariable> map, Term term) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        for (Map.Entry<IProgramVar, TermVariable> termVariableArray2 : map.entrySet()) {
            arrayList.add(termVariableArray2.getValue());
            arrayList2.add(this.getOrConstructHierConstant(termVariableArray2.getKey()));
        }
        TermVariable[] termVariableArray = arrayList.toArray(new TermVariable[arrayList.size()]);
        Term[] termArray = arrayList2.toArray(new Term[arrayList2.size()]);
        return this.mManagedScript.let((Object)this, termVariableArray, termArray, term);
    }

    private Term renameAuxVarsToCorrespondingConstants(Set<TermVariable> set, Term term) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        for (TermVariable termVariableArray2 : set) {
            arrayList.add(termVariableArray2);
            Term term2 = this.mManagedScript.term((Object)this, ProgramVarUtils.generateConstantIdentifierForAuxVar(termVariableArray2), new Term[0]);
            arrayList2.add(term2);
        }
        TermVariable[] termVariableArray = arrayList.toArray(new TermVariable[arrayList.size()]);
        Term[] termArray = arrayList2.toArray(new Term[arrayList2.size()]);
        return this.mManagedScript.let((Object)this, termVariableArray, termArray, term);
    }

    private Term getOrConstructHierConstant(IProgramVar iProgramVar) {
        Term term = (Term)this.mHierConstants.get((Object)iProgramVar);
        if (term == null) {
            String string = "c_" + iProgramVar.getTermVariable().getName() + "_Hier";
            Sort sort = iProgramVar.getTermVariable().getSort();
            this.mManagedScript.declareFun((Object)this, string, new Sort[0], sort);
            term = this.mManagedScript.term((Object)this, string, new Term[0]);
            this.mHierConstants.put((Object)iProgramVar, (Object)term);
        }
        return term;
    }

    private Term renameNonModifiableNonOldGlobalsToDefaultConstants(Set<IProgramVar> set, Set<IProgramNonOldVar> set2, Term term) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> arrayList2 = new ArrayList<ApplicationTerm>();
        for (IProgramVar termVariableArray2 : set) {
            if (!termVariableArray2.isGlobal() || !(termVariableArray2 instanceof IProgramNonOldVar) || set2.contains(termVariableArray2)) continue;
            arrayList.add(termVariableArray2.getTermVariable());
            arrayList2.add(termVariableArray2.getDefaultConstant());
        }
        TermVariable[] termVariableArray = arrayList.toArray(new TermVariable[arrayList.size()]);
        Term[] termArray = arrayList2.toArray(new Term[arrayList2.size()]);
        return this.mManagedScript.let((Object)this, termVariableArray, termArray, term);
    }

    private static Term renameNonModifiableOldGlobalsToDefaultConstantOfNonOldVar(Set<IProgramVar> set, Set<IProgramNonOldVar> set2, Term term, ManagedScript managedScript, Object object) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> arrayList2 = new ArrayList<ApplicationTerm>();
        for (IProgramVar termVariableArray2 : set) {
            IProgramNonOldVar iProgramNonOldVar;
            if (!(termVariableArray2 instanceof IProgramOldVar) || set2.contains(iProgramNonOldVar = ((IProgramOldVar)termVariableArray2).getNonOldVar())) continue;
            arrayList.add(termVariableArray2.getTermVariable());
            arrayList2.add(iProgramNonOldVar.getDefaultConstant());
        }
        TermVariable[] termVariableArray = arrayList.toArray(new TermVariable[arrayList.size()]);
        Term[] termArray = arrayList2.toArray(new Term[arrayList2.size()]);
        return managedScript.let(object, termVariableArray, termArray, term);
    }

    private Term renameNonModifiableGlobalsToDefaultConstants(Map<IProgramVar, TermVariable> map, Set<IProgramVar> set, Term term) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> arrayList2 = new ArrayList<ApplicationTerm>();
        for (Map.Entry<IProgramVar, TermVariable> termVariableArray2 : map.entrySet()) {
            IProgramVar iProgramVar = termVariableArray2.getKey();
            if (iProgramVar.isGlobal()) {
                if (iProgramVar.isOldvar()) {
                    assert (!set.contains(iProgramVar));
                    continue;
                }
                if (set.contains(iProgramVar)) continue;
                arrayList.add(termVariableArray2.getValue());
                arrayList2.add(iProgramVar.getDefaultConstant());
                continue;
            }
            assert (!set.contains(iProgramVar));
        }
        TermVariable[] termVariableArray = arrayList.toArray(new TermVariable[arrayList.size()]);
        Term[] termArray = arrayList2.toArray(new Term[arrayList2.size()]);
        return this.mManagedScript.let((Object)this, termVariableArray, termArray, term);
    }

    private Term renameGlobalsAndOldVarsToNonOldDefaultConstants(Set<IProgramVar> set, Term term) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> arrayList2 = new ArrayList<ApplicationTerm>();
        for (IProgramVar termVariableArray2 : set) {
            if (!termVariableArray2.isGlobal()) continue;
            if (termVariableArray2.isOldvar()) {
                arrayList.add(termVariableArray2.getTermVariable());
                IProgramNonOldVar iProgramNonOldVar = ((IProgramOldVar)termVariableArray2).getNonOldVar();
                arrayList2.add(iProgramNonOldVar.getDefaultConstant());
                continue;
            }
            arrayList.add(termVariableArray2.getTermVariable());
            arrayList2.add(termVariableArray2.getDefaultConstant());
        }
        TermVariable[] termVariableArray = arrayList.toArray(new TermVariable[arrayList.size()]);
        Term[] termArray = arrayList2.toArray(new Term[arrayList2.size()]);
        return this.mManagedScript.let((Object)this, termVariableArray, termArray, term);
    }

    public boolean isAssertionStackEmpty() {
        if (this.mAssertedAction == null) {
            assert (this.mAssertedPrecond == null);
            assert (this.mAssertedHier == null);
            return true;
        }
        return false;
    }

    public IProgramExecution.ProgramState<Term> getCounterexampleStatePrecond() {
        if (!this.mConstructCounterexamples) {
            throw new IllegalStateException("Construction of counterexamples is not enabled.");
        }
        if (this.mCounterexampleStatePrecond == null) {
            throw new IllegalStateException("Last response was valid or assertion stack has been altered.");
        }
        return this.mCounterexampleStatePrecond;
    }

    public IProgramExecution.ProgramState<Term> getCounterexampleStatePostcond() {
        if (!this.mConstructCounterexamples) {
            throw new IllegalStateException("Construction of counterexamples is not enabled.");
        }
        if (this.mCounterexampleStatePrecond == null) {
            throw new IllegalStateException("Last response was valid or assertion stack has been altered.");
        }
        return this.mCounterexampleStatePostcond;
    }

    private /* synthetic */ boolean lambda$6(Set set, Term term) {
        return this.isSuitableArrayReadTerm(term, set);
    }
}

