/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.LogicStatement;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Parameter;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.PolyIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class Axiomatic
extends LogicStatement {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(Axiomatic.class);
    LogicStatement[] logicStmts;

    public Axiomatic(PolyIdentifier polyIdentifier, LogicStatement[] logicStatementArray) {
        super(polyIdentifier);
        this.logicStmts = logicStatementArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Axiomatic: " + String.valueOf(this);
    }

    public Axiomatic(PolyIdentifier polyIdentifier, Parameter[] parameterArray, LogicStatement[] logicStatementArray) {
        super(polyIdentifier, parameterArray);
        this.logicStmts = logicStatementArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Axiomatic: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Axiomatic").append('[');
        if (this.logicStmts == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.logicStmts.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.logicStmts[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public LogicStatement[] getLogicStmts() {
        return this.logicStmts;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        if (this.logicStmts != null) {
            list.addAll(Arrays.asList(this.logicStmts));
        }
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((LogicStatement)this)) {
            return;
        }
        if (aCSLVisitor.visit(this)) {
            ACSLNode aCSLNode;
            int n;
            int n2;
            ACSLNode[] aCSLNodeArray;
            if (this.logicStmts != null) {
                aCSLNodeArray = this.logicStmts;
                n2 = this.logicStmts.length;
                n = 0;
                while (n < n2) {
                    aCSLNode = aCSLNodeArray[n];
                    ((LogicStatement)aCSLNode).accept(aCSLVisitor);
                    ++n;
                }
            }
            if (this.polyId != null) {
                this.polyId.accept(aCSLVisitor);
            }
            if (this.parameters != null) {
                aCSLNodeArray = this.parameters;
                n2 = this.parameters.length;
                n = 0;
                while (n < n2) {
                    aCSLNode = aCSLNodeArray[n];
                    ((Parameter)aCSLNode).accept(aCSLVisitor);
                    ++n;
                }
            }
        }
    }

    @Override
    public LogicStatement accept(ACSLTransformer aCSLTransformer) {
        ACSLNode aCSLNode;
        LogicStatement logicStatement = aCSLTransformer.transform(this);
        if (logicStatement != this) {
            return logicStatement;
        }
        boolean bl = false;
        ArrayList<LogicStatement> arrayList = new ArrayList<LogicStatement>();
        if (this.logicStmts != null) {
            LogicStatement[] logicStatementArray = this.logicStmts;
            int n = this.logicStmts.length;
            int n2 = 0;
            while (n2 < n) {
                aCSLNode = logicStatementArray[n2];
                LogicStatement logicStatement2 = ((LogicStatement)aCSLNode).accept(aCSLTransformer);
                bl = bl || logicStatement2 != aCSLNode;
                arrayList.add(logicStatement2);
                ++n2;
            }
        }
        aCSLNode = null;
        if (this.polyId != null) {
            aCSLNode = this.polyId.accept(aCSLTransformer);
        }
        ArrayList<Parameter> arrayList2 = new ArrayList<Parameter>();
        if (this.parameters != null) {
            Parameter[] parameterArray = this.parameters;
            int n = this.parameters.length;
            int n3 = 0;
            while (n3 < n) {
                Parameter parameter = parameterArray[n3];
                Parameter parameter2 = parameter.accept(aCSLTransformer);
                bl = bl || parameter2 != parameter;
                arrayList2.add(parameter2);
                ++n3;
            }
        }
        if (bl || this.polyId != aCSLNode) {
            return new Axiomatic((PolyIdentifier)aCSLNode, arrayList2.toArray(new Parameter[0]), arrayList.toArray(new LogicStatement[0]));
        }
        return this;
    }
}

