/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayEqualityExplicator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndexEqualityManager;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayOccurrenceAnalysis;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelectOverNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelectOverStoreEliminationUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PrenexNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierSequence;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays.DerPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays.Elim1Store;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ThreeValuedEquivalenceRelation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ElimStorePlain {
    public static EliminationTask applyComplexEliminationRules(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, ManagedScript managedScript, EliminationTask eliminationTask) throws ElimStorePlainException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        ArrayOccurrenceAnalysis arrayOccurrenceAnalysis;
        Term term2;
        if (!QuantifierUtils.isQuantifierFree(eliminationTask.getTerm())) {
            throw new AssertionError((Object)"Alternating quantifiers not yet supported");
        }
        if (eliminationTask.getEliminatees().size() != 1) {
            throw new AssertionError((Object)"need exactly one eliminatee");
        }
        TermVariable termVariable = eliminationTask.getEliminatees().iterator().next();
        Term term3 = QuantifierUtils.negateIfUniversal(iUltimateServiceProvider, managedScript, eliminationTask.getQuantifier(), eliminationTask.getContext().getCriticalConstraint());
        ArrayOccurrenceAnalysis arrayOccurrenceAnalysis2 = new ArrayOccurrenceAnalysis(managedScript.getScript(), eliminationTask.getTerm(), (Term)termVariable);
        if (!arrayOccurrenceAnalysis2.getValueOfStore().isEmpty() || !arrayOccurrenceAnalysis2.getOtherFunctionApplications().isEmpty()) {
            return null;
        }
        Term[] termArray = QuantifierUtils.getDualFiniteJuncts(eliminationTask.getQuantifier(), eliminationTask.getTerm());
        Map<Boolean, List<Term>> map = Arrays.stream(termArray).collect(Collectors.partitioningBy(term -> QuantifierUtils.isCorrespondingFiniteJunction(eliminationTask.getQuantifier(), term)));
        Term term4 = QuantifierUtils.applyDualFiniteConnective(managedScript.getScript(), eliminationTask.getQuantifier(), (Collection<Term>)map.get(true));
        ArrayOccurrenceAnalysis arrayOccurrenceAnalysis3 = new ArrayOccurrenceAnalysis(managedScript.getScript(), term4, (Term)termVariable);
        if (!arrayOccurrenceAnalysis3.getDerRelations(eliminationTask.getQuantifier()).isEmpty() || !arrayOccurrenceAnalysis3.getAntiDerRelations(eliminationTask.getQuantifier()).isEmpty()) {
            return null;
        }
        LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>();
        if (arrayOccurrenceAnalysis2.getDerRelations(eliminationTask.getQuantifier()).isEmpty()) {
            term2 = eliminationTask.getTerm();
            arrayOccurrenceAnalysis = arrayOccurrenceAnalysis2;
        } else {
            object6 = new ThreeValuedEquivalenceRelation();
            object5 = new ArrayIndexEqualityManager((ThreeValuedEquivalenceRelation<Term>)object6, term3, eliminationTask.getQuantifier(), iLogger, managedScript);
            try {
                object4 = new DerPreprocessor(iUltimateServiceProvider, managedScript, eliminationTask.getQuantifier(), termVariable, eliminationTask.getTerm(), arrayOccurrenceAnalysis2.getDerRelations(eliminationTask.getQuantifier()), (ArrayIndexEqualityManager)object5);
            }
            catch (ElimStorePlainException elimStorePlainException) {
                ((ArrayIndexEqualityManager)object5).unlockSolver();
                throw elimStorePlainException;
            }
            ((ArrayIndexEqualityManager)object5).unlockSolver();
            linkedHashSet.addAll(((DerPreprocessor)((Object)object4)).getNewAuxVars());
            term2 = ((DerPreprocessor)((Object)object4)).getResult();
            if (((DerPreprocessor)((Object)object4)).introducedDerPossibility()) {
                object6 = ElimStorePlain.applyNonSddEliminations(iUltimateServiceProvider, managedScript, new EliminationTask(eliminationTask.getQuantifier(), Collections.singleton(termVariable), term2, eliminationTask.getContext()), QuantifierPusher.PqeTechniques.ONLY_DER);
                if (!((EliminationTask)object6).getEliminatees().isEmpty()) {
                    throw new AssertionError((Object)" unsuccessful DER");
                }
                linkedHashSet.addAll(((EliminationTask)object6).getEliminatees());
                return new EliminationTask(eliminationTask.getQuantifier(), linkedHashSet, ((EliminationTask)object6).getTerm(), eliminationTask.getContext());
            }
            arrayOccurrenceAnalysis = new ArrayOccurrenceAnalysis(managedScript.getScript(), term2, (Term)termVariable);
            linkedHashSet.add(termVariable);
        }
        if (arrayOccurrenceAnalysis2.getAntiDerRelations(eliminationTask.getQuantifier()).isEmpty()) {
            object4 = term2;
            object6 = arrayOccurrenceAnalysis;
        } else {
            object5 = new ArrayEqualityExplicator(managedScript, eliminationTask.getQuantifier(), termVariable, term2, arrayOccurrenceAnalysis2.getAntiDerRelations(eliminationTask.getQuantifier()));
            object4 = ((ArrayEqualityExplicator)object5).getResultTerm();
            linkedHashSet.addAll(((ArrayEqualityExplicator)object5).getNewAuxVars());
            object6 = new ArrayOccurrenceAnalysis(managedScript.getScript(), (Term)object4, (Term)termVariable);
            if (!ElimStorePlain.varOccurs(termVariable, (Term)object4)) {
                return new EliminationTask(eliminationTask.getQuantifier(), linkedHashSet, (Term)object4, eliminationTask.getContext());
            }
        }
        object5 = new ThreeValuedEquivalenceRelation();
        ArrayIndexEqualityManager arrayIndexEqualityManager = new ArrayIndexEqualityManager((ThreeValuedEquivalenceRelation<Term>)object5, term3, eliminationTask.getQuantifier(), iLogger, managedScript);
        Object object7 = object6;
        Object object8 = object4;
        while (!((ArrayOccurrenceAnalysis)object7).getArraySelectOverStores().isEmpty()) {
            object3 = ((ArrayOccurrenceAnalysis)object7).getArraySelectOverStores().get(0);
            object2 = MultiDimensionalSelectOverStoreEliminationUtils.replace(managedScript, arrayIndexEqualityManager, (Term)object8, (MultiDimensionalSelectOverNestedStore)object3);
            object8 = object = new NnfTransformer(managedScript, iUltimateServiceProvider, NnfTransformer.QuantifierHandling.KEEP).transform((Term)object2);
            object7 = new ArrayOccurrenceAnalysis(managedScript.getScript(), (Term)object8, (Term)termVariable);
            if (ElimStorePlain.varOccurs(termVariable, (Term)object)) continue;
            arrayIndexEqualityManager.unlockSolver();
            return new EliminationTask(eliminationTask.getQuantifier(), linkedHashSet, (Term)object, eliminationTask.getContext());
        }
        arrayIndexEqualityManager.unlockSolver();
        object3 = object8;
        object2 = new EliminationTask(eliminationTask.getQuantifier(), Collections.singleton(termVariable), (Term)object3, eliminationTask.getContext());
        object = new Elim1Store(managedScript, iUltimateServiceProvider, eliminationTask.getQuantifier()).elim1((EliminationTask)object2);
        linkedHashSet.addAll(((EliminationTask)object).getEliminatees());
        EliminationTask eliminationTask2 = new EliminationTask(eliminationTask.getQuantifier(), linkedHashSet, ((EliminationTask)object).getTerm(), eliminationTask.getContext());
        return eliminationTask2;
    }

    private static boolean varOccurs(TermVariable termVariable, Term term) {
        return Arrays.stream(term.getFreeVars()).anyMatch(termVariable2 -> termVariable2 == termVariable);
    }

    private static EliminationTask applyNonSddEliminations(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, EliminationTask eliminationTask, QuantifierPusher.PqeTechniques pqeTechniques) throws ElimStorePlainException {
        Set<TermVariable> set;
        Term term = SmtUtils.quantifier(managedScript.getScript(), eliminationTask.getQuantifier(), eliminationTask.getEliminatees(), eliminationTask.getTerm());
        Term term2 = QuantifierPusher.eliminate(iUltimateServiceProvider, managedScript, true, pqeTechniques, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, term);
        Term term3 = new PrenexNormalForm(managedScript).transform(term2);
        QuantifierSequence quantifierSequence = new QuantifierSequence(managedScript, term3);
        Term term4 = quantifierSequence.getInnerTerm();
        List<QuantifierSequence.QuantifiedVariables> list = quantifierSequence.getQuantifierBlocks();
        if (list.isEmpty()) {
            set = Collections.emptySet();
        } else if (list.size() == 1) {
            set = list.get(0).getVariables();
            if (list.get(0).getQuantifier() != eliminationTask.getQuantifier()) {
                throw new ElimStorePlainException("alternation not yet supported");
            }
        } else {
            if (list.size() > 1) {
                throw new ElimStorePlainException("alternation not yet supported: " + String.valueOf(term3));
            }
            throw new AssertionError();
        }
        return new EliminationTask(eliminationTask.getQuantifier(), set, term4, eliminationTask.getContext());
    }

    public static class ElimStorePlainException
    extends Exception {
        private static final long serialVersionUID = 7719170889993834143L;
        public static final String NON_TOP_LEVEL_DER = "DER that is not on top-level";
        public static final String CAPTURED_INDEX = "Subterm of an index is captued by an inner quantifier";
        private final String mMessage;
        private final TermVariable mEliminatee = null;

        public ElimStorePlainException(String string) {
            super(string);
            this.mMessage = string;
        }

        @Override
        public String getMessage() {
            return this.mMessage;
        }
    }
}

