/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayDeque;

public class AnnotatedTerm
extends Term {
    private final Term mSubterm;
    private final Annotation[] mAnnotations;

    AnnotatedTerm(Annotation[] annotationArray, Term term, int n) {
        super(n);
        this.mAnnotations = annotationArray;
        this.mSubterm = term;
    }

    @Override
    public Sort getSort() {
        return this.mSubterm.getSort();
    }

    public Term getSubterm() {
        return this.mSubterm;
    }

    public Annotation[] getAnnotations() {
        return this.mAnnotations;
    }

    public static int hashAnnotations(Annotation[] annotationArray, Term term) {
        return HashUtils.hashJenkins((int)term.hashCode(), (Object[])annotationArray);
    }

    @Override
    public void toStringHelper(ArrayDeque<Object> arrayDeque) {
        arrayDeque.addLast(")");
        Annotation[] annotationArray = this.getAnnotations();
        int n = annotationArray.length - 1;
        while (n >= 0) {
            if (annotationArray[n].getValue() != null) {
                arrayDeque.addLast(annotationArray[n].getValue());
                arrayDeque.addLast(" ");
            }
            arrayDeque.addLast(" " + annotationArray[n].getKey());
            --n;
        }
        arrayDeque.addLast(this.getSubterm());
        arrayDeque.addLast("(! ");
    }
}

