/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.impulse;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.AnnotatedProgramPoint;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.AppEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.AppHyperEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.DummyCodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.ImpRootNode;
import de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.CodeCheckSettings;
import de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.CodeChecker;
import de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.GraphWriter;
import de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.impulse.RedirectionFinder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.preferences.CodeCheckPreferenceInitializer;
import java.util.HashSet;
import java.util.LinkedList;

public class ImpulseChecker
extends CodeChecker {
    private final RedirectionFinder mCloneFinder = new RedirectionFinder(this);
    private int mNodeId = 0;

    public ImpulseChecker(CfgSmtToolkit cfgSmtToolkit, IIcfg<IcfgLocation> iIcfg, ImpRootNode impRootNode, GraphWriter graphWriter, IHoareTripleChecker iHoareTripleChecker, IPredicateUnifier iPredicateUnifier, ILogger iLogger, CodeCheckSettings codeCheckSettings) {
        super(cfgSmtToolkit, iIcfg, impRootNode, graphWriter, iHoareTripleChecker, iPredicateUnifier, iLogger, codeCheckSettings);
    }

    public void replaceEdge(AppEdge appEdge, AnnotatedProgramPoint annotatedProgramPoint) {
        if (appEdge instanceof AppHyperEdge) {
            ((AnnotatedProgramPoint)appEdge.getSource()).connectOutgoingReturn(((AppHyperEdge)appEdge).getHier(), (IIcfgReturnTransition)appEdge.getStatement(), annotatedProgramPoint);
        } else {
            ((AnnotatedProgramPoint)appEdge.getSource()).connectOutgoing(appEdge.getStatement(), annotatedProgramPoint);
        }
        appEdge.disconnect();
    }

    public boolean defaultRedirecting(AnnotatedProgramPoint[] annotatedProgramPointArray, AnnotatedProgramPoint[] annotatedProgramPointArray2) {
        boolean bl = false;
        int n = 0;
        while (n + 1 < annotatedProgramPointArray.length) {
            if (annotatedProgramPointArray[n + 1].isErrorLocation()) {
                annotatedProgramPointArray2[n].getEdge(annotatedProgramPointArray[n + 1]).disconnect();
                bl = true;
            } else if (this.getGlobalSettings().isDefaultRedirection()) {
                if (this.getGlobalSettings().isCheckSatisfiability()) {
                    this.redirectIfValid(annotatedProgramPointArray2[n].getEdge(annotatedProgramPointArray[n + 1]), annotatedProgramPointArray2[n + 1]);
                } else {
                    this.replaceEdge(annotatedProgramPointArray2[n].getEdge(annotatedProgramPointArray[n + 1]), annotatedProgramPointArray2[n + 1]);
                }
            } else {
                AnnotatedProgramPoint annotatedProgramPoint = annotatedProgramPointArray2[n + 1];
                AppEdge appEdge = annotatedProgramPointArray2[n].getEdge(annotatedProgramPointArray[n + 1]);
                if (this.getGlobalSettings().getRedirectionStrategy() != CodeCheckPreferenceInitializer.RedirectionStrategy.No_Strategy) {
                    annotatedProgramPoint = this.mCloneFinder.getStrongestValidCopy(appEdge);
                }
                if (annotatedProgramPoint != null) {
                    this.redirectIfValid(appEdge, annotatedProgramPoint);
                }
            }
            ++n;
        }
        return bl;
    }

    public boolean redirectEdges(AnnotatedProgramPoint[] annotatedProgramPointArray, AnnotatedProgramPoint[] annotatedProgramPointArray2) {
        int n = 0;
        while (n < annotatedProgramPointArray.length) {
            if (!annotatedProgramPointArray[n].isErrorLocation()) {
                AppEdge[] appEdgeArray;
                AppEdge[] appEdgeArray2 = appEdgeArray = annotatedProgramPointArray[n].getIncomingEdges().toArray(new AppEdge[0]);
                int n2 = appEdgeArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    AppEdge appEdge = appEdgeArray2[n3];
                    AnnotatedProgramPoint annotatedProgramPoint = annotatedProgramPointArray2[n];
                    if (this.getGlobalSettings().getRedirectionStrategy() != CodeCheckPreferenceInitializer.RedirectionStrategy.No_Strategy) {
                        annotatedProgramPoint = this.mCloneFinder.getStrongestValidCopy(appEdge);
                    }
                    if (annotatedProgramPoint != null) {
                        this.redirectIfValid(appEdge, annotatedProgramPoint);
                    }
                    ++n3;
                }
            }
            ++n;
        }
        return true;
    }

    protected void redirectIfValid(AppEdge appEdge, AnnotatedProgramPoint annotatedProgramPoint) {
        if (appEdge.getTarget() == annotatedProgramPoint) {
            return;
        }
        if (this.isValidRedirection(appEdge, annotatedProgramPoint)) {
            if (appEdge instanceof AppHyperEdge) {
                if (!this.getGlobalSettings().isCheckSatisfiability() || this.mEdgeChecker.checkReturn(((AnnotatedProgramPoint)appEdge.getSource()).getPredicate(), ((AppHyperEdge)appEdge).getHier().getPredicate(), (IReturnAction)appEdge.getStatement(), ((AnnotatedProgramPoint)appEdge.getTarget()).getPredicate()) != IncrementalPlicationChecker.Validity.VALID) {
                    ((AnnotatedProgramPoint)appEdge.getSource()).connectOutgoingReturn(((AppHyperEdge)appEdge).getHier(), (IIcfgReturnTransition)appEdge.getStatement(), annotatedProgramPoint);
                }
            } else {
                boolean bl;
                boolean bl2 = bl = !this.getGlobalSettings().isCheckSatisfiability();
                if (!bl) {
                    if (appEdge.getStatement() instanceof IIcfgCallTransition) {
                        bl = this.mEdgeChecker.checkCall(((AnnotatedProgramPoint)appEdge.getSource()).getPredicate(), (ICallAction)appEdge.getStatement(), ((AnnotatedProgramPoint)appEdge.getTarget()).getPredicate()) != IncrementalPlicationChecker.Validity.VALID;
                    } else {
                        boolean bl3 = bl = this.mEdgeChecker.checkInternal(((AnnotatedProgramPoint)appEdge.getSource()).getPredicate(), (IInternalAction)appEdge.getStatement(), ((AnnotatedProgramPoint)appEdge.getTarget()).getPredicate()) != IncrementalPlicationChecker.Validity.VALID;
                    }
                }
                if (bl) {
                    ((AnnotatedProgramPoint)appEdge.getSource()).connectOutgoing(appEdge.getStatement(), annotatedProgramPoint);
                }
            }
            appEdge.disconnect();
        }
    }

    public boolean isValidRedirection(AppEdge appEdge, AnnotatedProgramPoint annotatedProgramPoint) {
        if (appEdge instanceof AppHyperEdge) {
            return this.isValidReturnEdge((AnnotatedProgramPoint)appEdge.getSource(), appEdge.getStatement(), annotatedProgramPoint, ((AppHyperEdge)appEdge).getHier());
        }
        return this.isValidEdge((AnnotatedProgramPoint)appEdge.getSource(), appEdge.getStatement(), annotatedProgramPoint);
    }

    @Override
    public boolean codeCheck(NestedRun<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint> nestedRun, IPredicate[] iPredicateArray, AnnotatedProgramPoint annotatedProgramPoint) {
        AnnotatedProgramPoint[] annotatedProgramPointArray = nestedRun.getStateSequence().toArray(new AnnotatedProgramPoint[0]);
        AnnotatedProgramPoint[] annotatedProgramPointArray2 = new AnnotatedProgramPoint[annotatedProgramPointArray.length];
        AnnotatedProgramPoint annotatedProgramPoint2 = new AnnotatedProgramPoint(annotatedProgramPointArray[0], annotatedProgramPointArray[0].getPredicate(), true, ++this.mNodeId);
        annotatedProgramPointArray2[0] = annotatedProgramPointArray[0];
        annotatedProgramPointArray[0] = annotatedProgramPoint2;
        int n = 0;
        while (n < iPredicateArray.length) {
            annotatedProgramPointArray2[n + 1] = new AnnotatedProgramPoint(annotatedProgramPointArray[n + 1], this.conjugatePredicates(annotatedProgramPointArray[n + 1].getPredicate(), iPredicateArray[n]), true, ++this.mNodeId);
            ++n;
        }
        if (!this.defaultRedirecting(annotatedProgramPointArray, annotatedProgramPointArray2)) {
            throw new AssertionError((Object)"The error location hasn't been reached.");
        }
        this.redirectEdges(annotatedProgramPointArray, annotatedProgramPointArray2);
        if (this.getGlobalSettings().isRemoveFalseNodes()) {
            this.removeFalseNodes(annotatedProgramPointArray, annotatedProgramPointArray2);
        }
        return true;
    }

    public boolean removeFalseNodes(AnnotatedProgramPoint[] annotatedProgramPointArray, AnnotatedProgramPoint[] annotatedProgramPointArray2) {
        int n = 0;
        while (n < annotatedProgramPointArray.length) {
            IPredicate iPredicate;
            if (!annotatedProgramPointArray[n].isErrorLocation() && this.mPredicateUnifier.getOrConstructPredicate((iPredicate = annotatedProgramPointArray2[n].getPredicate()).getFormula()).equals(this.mPredicateUnifier.getFalsePredicate())) {
                annotatedProgramPointArray2[n].isolateNode();
            }
            ++n;
        }
        return true;
    }

    public boolean improveAnnotations(AnnotatedProgramPoint annotatedProgramPoint) {
        HashSet<AnnotatedProgramPoint> hashSet = new HashSet<AnnotatedProgramPoint>();
        HashSet<AnnotatedProgramPoint> hashSet2 = new HashSet<AnnotatedProgramPoint>();
        LinkedList<AnnotatedProgramPoint> linkedList = new LinkedList<AnnotatedProgramPoint>();
        linkedList.add(annotatedProgramPoint);
        hashSet2.add(annotatedProgramPoint);
        while (!linkedList.isEmpty()) {
            int n;
            AnnotatedProgramPoint[] annotatedProgramPointArray;
            AnnotatedProgramPoint annotatedProgramPoint2 = (AnnotatedProgramPoint)((Object)linkedList.poll());
            AnnotatedProgramPoint[] annotatedProgramPointArray2 = annotatedProgramPoint2.getIncomingNodes().toArray(new AnnotatedProgramPoint[0]);
            if (annotatedProgramPointArray2.length == 1) {
                annotatedProgramPointArray = annotatedProgramPointArray2[0];
                hashSet.contains(annotatedProgramPointArray);
            } else {
                AnnotatedProgramPoint[] annotatedProgramPointArray3 = annotatedProgramPointArray2;
                n = annotatedProgramPointArray2.length;
                int n2 = 0;
                while (n2 < n) {
                    annotatedProgramPointArray = annotatedProgramPointArray3[n2];
                    hashSet.contains(annotatedProgramPointArray);
                    ++n2;
                }
            }
            AnnotatedProgramPoint[] annotatedProgramPointArray4 = annotatedProgramPointArray = annotatedProgramPoint2.getOutgoingNodes().toArray(new AnnotatedProgramPoint[0]);
            int n3 = annotatedProgramPointArray.length;
            n = 0;
            while (n < n3) {
                AnnotatedProgramPoint annotatedProgramPoint3 = annotatedProgramPointArray4[n];
                if (!hashSet2.contains((Object)annotatedProgramPoint3)) {
                    hashSet2.add(annotatedProgramPoint3);
                    linkedList.add(annotatedProgramPoint3);
                }
                ++n;
            }
            hashSet.add(annotatedProgramPoint2);
        }
        return true;
    }

    public boolean isValidEdge(AnnotatedProgramPoint annotatedProgramPoint, IIcfgTransition<?> iIcfgTransition, AnnotatedProgramPoint annotatedProgramPoint2) {
        if (iIcfgTransition instanceof DummyCodeBlock) {
            return false;
        }
        boolean bl = true;
        bl = iIcfgTransition instanceof IIcfgCallTransition ? this.mEdgeChecker.checkCall(annotatedProgramPoint.getPredicate(), (ICallAction)iIcfgTransition, annotatedProgramPoint2.getPredicate()) == IncrementalPlicationChecker.Validity.VALID : this.mEdgeChecker.checkInternal(annotatedProgramPoint.getPredicate(), (IInternalAction)iIcfgTransition, annotatedProgramPoint2.getPredicate()) == IncrementalPlicationChecker.Validity.VALID;
        return bl;
    }

    public boolean isValidReturnEdge(AnnotatedProgramPoint annotatedProgramPoint, IIcfgTransition<?> iIcfgTransition, AnnotatedProgramPoint annotatedProgramPoint2, AnnotatedProgramPoint annotatedProgramPoint3) {
        boolean bl = this.mEdgeChecker.checkReturn(annotatedProgramPoint.getPredicate(), annotatedProgramPoint3.getPredicate(), (IReturnAction)iIcfgTransition, annotatedProgramPoint2.getPredicate()) == IncrementalPlicationChecker.Validity.VALID;
        return bl;
    }

    protected boolean connectOutgoingIfValid(AnnotatedProgramPoint annotatedProgramPoint, IIcfgTransition<IcfgLocation> iIcfgTransition, AnnotatedProgramPoint annotatedProgramPoint2) {
        if (this.isValidEdge(annotatedProgramPoint, iIcfgTransition, annotatedProgramPoint2)) {
            annotatedProgramPoint.connectOutgoing(iIcfgTransition, annotatedProgramPoint2);
            return true;
        }
        return false;
    }

    protected boolean connectOutgoingReturnIfValid(AnnotatedProgramPoint annotatedProgramPoint, AnnotatedProgramPoint annotatedProgramPoint2, IIcfgReturnTransition<?, ?> iIcfgReturnTransition, AnnotatedProgramPoint annotatedProgramPoint3) {
        if (this.isValidReturnEdge(annotatedProgramPoint, (IIcfgTransition<?>)iIcfgReturnTransition, annotatedProgramPoint3, annotatedProgramPoint2)) {
            annotatedProgramPoint.connectOutgoingReturn(annotatedProgramPoint2, iIcfgReturnTransition, annotatedProgramPoint3);
            return true;
        }
        return false;
    }

    boolean isStrongerPredicate(AnnotatedProgramPoint annotatedProgramPoint, AnnotatedProgramPoint annotatedProgramPoint2) {
        boolean bl;
        boolean bl2 = bl = this.mPredicateUnifier.getCoverageRelation().isCovered(annotatedProgramPoint.getPredicate(), annotatedProgramPoint2.getPredicate()) == IncrementalPlicationChecker.Validity.VALID;
        if (bl) {
            boolean bl3 = this.mPredicateUnifier.getCoverageRelation().isCovered(annotatedProgramPoint2.getPredicate(), annotatedProgramPoint.getPredicate()) == IncrementalPlicationChecker.Validity.VALID;
            bl &= !bl3 || annotatedProgramPoint.getNodeId() > annotatedProgramPoint2.getNodeId();
        }
        return bl;
    }
}

