/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions;

import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.Ordinal;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class PiecewiseRankingFunction
extends RankingFunction {
    private static final long serialVersionUID = 1605612582853046558L;
    private final AffineFunction[] mranking;
    private final AffineFunction[] mpredicates;
    public final int pieces;

    public PiecewiseRankingFunction(AffineFunction[] affineFunctionArray, AffineFunction[] affineFunctionArray2) {
        this.mranking = affineFunctionArray;
        this.mpredicates = affineFunctionArray2;
        this.pieces = affineFunctionArray.length;
        assert (this.pieces > 0);
        assert (this.pieces == affineFunctionArray2.length);
    }

    @Override
    public String getName() {
        return this.mranking.length + "-piece";
    }

    @Override
    public Set<IProgramVar> getVariables() {
        LinkedHashSet<IProgramVar> linkedHashSet = new LinkedHashSet<IProgramVar>();
        AffineFunction[] affineFunctionArray = this.mranking;
        int n = this.mranking.length;
        int n2 = 0;
        while (n2 < n) {
            AffineFunction affineFunction = affineFunctionArray[n2];
            linkedHashSet.addAll(affineFunction.getVariables());
            ++n2;
        }
        return linkedHashSet;
    }

    public AffineFunction[] getRankingComponents() {
        return this.mranking;
    }

    public AffineFunction[] getPredicates() {
        return this.mpredicates;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mranking.length);
        stringBuilder.append("-piece ranking function:\n");
        stringBuilder.append("  f(");
        boolean bl = true;
        for (IProgramVar iProgramVar : this.getVariables()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(iProgramVar.getGloballyUniqueId());
            bl = false;
        }
        stringBuilder.append(") = {\n");
        int n = 0;
        while (n < this.pieces) {
            stringBuilder.append("    ");
            stringBuilder.append(this.mranking[n]);
            stringBuilder.append(",\tif ");
            stringBuilder.append(this.mpredicates[n]);
            stringBuilder.append(" >= 0");
            if (n < this.pieces - 1) {
                stringBuilder.append(",\n");
            } else {
                stringBuilder.append(".");
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    @Override
    public Term[] asLexTerm(Script script) throws SMTLIBException {
        Term term = SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ZERO);
        int n = this.mranking.length - 1;
        while (n >= 0) {
            AffineFunction affineFunction = this.mranking[n];
            AffineFunction affineFunction2 = this.mpredicates[n];
            Term term2 = script.term(">=", new Term[]{affineFunction2.asTerm(script), SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ZERO)});
            term = script.term("ite", new Term[]{term2, affineFunction.asTerm(script), term});
            --n;
        }
        return new Term[]{term};
    }

    @Override
    public Ordinal evaluate(Map<IProgramVar, Rational> map) {
        Rational rational = Rational.ZERO;
        int n = 0;
        while (n < this.pieces) {
            Rational rational2;
            if (!this.mpredicates[n].evaluate(map).isNegative() && (rational2 = this.mranking[n].evaluate(map)).compareTo(rational) > 0) {
                rational = rational2;
            }
            ++n;
        }
        return Ordinal.fromInteger(rational.ceil().numerator());
    }

    @Override
    public Ordinal codomain() {
        return Ordinal.OMEGA;
    }
}

