/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pathexpressions;

import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.ILabeledEdge;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.ILabeledGraph;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.PathExpression;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.EmptySet;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Epsilon;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.IRegex;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Regex;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PathExpressionComputer<N, L> {
    private final ILabeledGraph<N, L> mGraph;
    private final Map<N, Integer> mNodeToInt = new HashMap<N, Integer>();
    private final Map<Pair<Integer, Integer>, IRegex<L>> mP = new HashMap<Pair<Integer, Integer>, IRegex<L>>();
    private final Map<N, List<IRegex<L>>> mAllPathsFromNode = new HashMap<N, List<IRegex<L>>>();
    private boolean mEliminated;

    public PathExpressionComputer(ILabeledGraph<N, L> iLabeledGraph) {
        this.mGraph = iLabeledGraph;
        this.mapNodesToInt();
    }

    private void mapNodesToInt() {
        int n = 0;
        for (N n2 : this.mGraph.getNodes()) {
            this.mNodeToInt.put(n2, n);
            ++n;
        }
    }

    private Integer intOf(N n) {
        Integer n2 = this.mNodeToInt.get(n);
        if (n2 == null) {
            throw new IllegalArgumentException("Tried to access node which is not in the graph: " + String.valueOf(n));
        }
        return n2;
    }

    public IRegex<L> exprBetween(N n, N n2) {
        assert (this.mGraph.getNodes().contains(n)) : "Tried to compute path expression starting at non-existing node";
        assert (this.mGraph.getNodes().contains(n2)) : "Tried to compute path expression ending at non-existing node";
        List<IRegex<L>> list = this.mAllPathsFromNode.get(n);
        if (list == null) {
            this.eliminate();
            list = this.solve(n, this.extractPathSequence());
            this.mAllPathsFromNode.put(n, list);
        }
        return list.get(this.intOf(n2));
    }

    private List<IRegex<L>> solve(N n, List<PathExpression<L>> list) {
        ArrayList<IRegex<L>> arrayList = new ArrayList<IRegex<L>>(Collections.nCopies(this.mGraph.getNodes().size(), Regex.emptySet()));
        arrayList.set(this.intOf(n), Regex.epsilon());
        for (PathExpression<L> pathExpression : list) {
            int n2;
            if (pathExpression.getSource() == pathExpression.getTarget()) {
                n2 = pathExpression.getSource();
                IRegex iRegex = (IRegex)arrayList.get(n2);
                arrayList.set(n2, Regex.simplifiedConcatenation(iRegex, pathExpression.getExpression()));
                continue;
            }
            n2 = pathExpression.getSource();
            int n3 = pathExpression.getTarget();
            IRegex iRegex = (IRegex)arrayList.get(n2);
            IRegex<L> iRegex2 = Regex.simplifiedConcatenation(iRegex, pathExpression.getExpression());
            IRegex iRegex3 = (IRegex)arrayList.get(n3);
            arrayList.set(n3, Regex.simplifiedUnion(iRegex3, iRegex2));
        }
        this.mAllPathsFromNode.put(n, arrayList);
        return arrayList;
    }

    private List<PathExpression<L>> extractPathSequence() {
        IRegex<L> iRegex;
        int n;
        int n2 = this.mGraph.getNodes().size();
        ArrayList<PathExpression<L>> arrayList = new ArrayList<PathExpression<L>>();
        int n3 = 0;
        while (n3 < n2) {
            n = n3;
            while (n < n2) {
                iRegex = this.pathExpr(n3, n);
                if (!(iRegex instanceof EmptySet) && !(iRegex instanceof Epsilon)) {
                    arrayList.add(new PathExpression<L>(iRegex, n3, n));
                }
                ++n;
            }
            ++n3;
        }
        n3 = n2 - 1;
        while (n3 >= 0) {
            n = 0;
            while (n < n3) {
                iRegex = this.pathExpr(n3, n);
                if (!(iRegex instanceof EmptySet)) {
                    arrayList.add(new PathExpression<L>(iRegex, n3, n));
                }
                ++n;
            }
            --n3;
        }
        return arrayList;
    }

    private void eliminate() {
        IRegex iRegex;
        if (this.mEliminated) {
            return;
        }
        int n = this.mGraph.getNodes().size();
        for (ILabeledEdge<N, L> iLabeledEdge : this.mGraph.getEdges()) {
            Integer n2 = this.intOf(iLabeledEdge.getSource());
            iRegex = this.intOf(iLabeledEdge.getTarget());
            IRegex<L> iRegex2 = this.pathExpr(n2, (Integer)((Object)iRegex));
            iRegex2 = Regex.simplifiedUnion(Regex.literal(iLabeledEdge.getLabel()), iRegex2);
            this.updatePathExpr(n2, (Integer)((Object)iRegex), iRegex2);
        }
        int n3 = 0;
        while (n3 < n) {
            IRegex iRegex3 = this.pathExpr(n3, n3);
            iRegex3 = Regex.simplifiedStar(iRegex3);
            this.updatePathExpr(n3, n3, iRegex3);
            int n4 = n3 + 1;
            while (n4 < n) {
                iRegex = this.pathExpr(n4, n3);
                if (!(iRegex instanceof EmptySet)) {
                    iRegex = Regex.simplifiedConcatenation(iRegex, iRegex3);
                    this.updatePathExpr(n4, n3, iRegex);
                    int n5 = n3 + 1;
                    while (n5 < n) {
                        IRegex<L> iRegex4 = this.pathExpr(n3, n5);
                        if (!(iRegex4 instanceof EmptySet)) {
                            IRegex<L> iRegex5 = this.pathExpr(n4, n5);
                            IRegex iRegex6 = Regex.simplifiedConcatenation(iRegex, iRegex4);
                            IRegex<L> iRegex7 = Regex.simplifiedUnion(iRegex5, iRegex6);
                            this.updatePathExpr(n4, n5, iRegex7);
                        }
                        ++n5;
                    }
                }
                ++n4;
            }
            ++n3;
        }
        this.mEliminated = true;
    }

    private IRegex<L> pathExpr(Integer n, Integer n2) {
        return this.mP.getOrDefault(new Pair((Object)n, (Object)n2), Regex.emptySet());
    }

    private void updatePathExpr(Integer n, Integer n2, IRegex<L> iRegex) {
        this.mP.put((Pair<Integer, Integer>)new Pair((Object)n, (Object)n2), iRegex);
    }
}

