/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.StateBasedTransitionFilterPredicateProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.SummaryReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.FilteredIterable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class NestedWordAutomatonFilteredStates<LETTER, STATE>
implements INestedWordAutomaton<LETTER, STATE> {
    protected final AutomataLibraryServices mServices;
    protected final ILogger mLogger;
    protected final NestedWordAutomatonReachableStates<LETTER, STATE> mNwa;
    protected final Set<STATE> mRemainingStates;
    protected final Set<STATE> mNewInitials;
    protected final Set<STATE> mNewFinals;
    protected final NestedWordAutomatonReachableStates.AncestorComputation mAncestorComputation;
    protected final boolean mFilterCallTransitionsBasedOnDoubleDeckerInformation;
    private final StateBasedTransitionFilterPredicateProvider<LETTER, STATE> mTransitionFilter;

    public NestedWordAutomatonFilteredStates(AutomataLibraryServices automataLibraryServices, NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates, Set<STATE> set, Set<STATE> set2, Set<STATE> set3) {
        this(automataLibraryServices, nestedWordAutomatonReachableStates, set, set2, set3, null);
    }

    public NestedWordAutomatonFilteredStates(AutomataLibraryServices automataLibraryServices, NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates, NestedWordAutomatonReachableStates.AncestorComputation ancestorComputation) {
        this(automataLibraryServices, nestedWordAutomatonReachableStates, ancestorComputation.getStates(), ancestorComputation.getInitials(), ancestorComputation.getFinals(), ancestorComputation);
    }

    private NestedWordAutomatonFilteredStates(AutomataLibraryServices automataLibraryServices, NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates, Set<STATE> set, Set<STATE> set2, Set<STATE> set3, NestedWordAutomatonReachableStates.AncestorComputation ancestorComputation) {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
        this.mNwa = nestedWordAutomatonReachableStates;
        this.mRemainingStates = set;
        this.mNewInitials = set2;
        this.mNewFinals = set3;
        this.mAncestorComputation = ancestorComputation;
        this.mFilterCallTransitionsBasedOnDoubleDeckerInformation = ancestorComputation != null;
        this.mTransitionFilter = new StateBasedTransitionFilterPredicateProvider(this.mRemainingStates);
    }

    @Override
    public int size() {
        return this.getStates().size();
    }

    @Override
    public Set<LETTER> getAlphabet() {
        return this.mNwa.getAlphabet();
    }

    @Override
    public String sizeInformation() {
        return this.mRemainingStates.size() + " states.";
    }

    @Override
    public VpAlphabet<LETTER> getVpAlphabet() {
        return this.mNwa.getVpAlphabet();
    }

    @Override
    public IStateFactory<STATE> getStateFactory() {
        return this.mNwa.getStateFactory();
    }

    @Override
    public Set<STATE> getStates() {
        return this.mRemainingStates;
    }

    @Override
    public Set<STATE> getInitialStates() {
        return this.mNewInitials;
    }

    @Override
    public Collection<STATE> getFinalStates() {
        return this.mNewFinals;
    }

    @Override
    public boolean isInitial(STATE STATE) {
        return this.mNewInitials.contains(STATE);
    }

    @Override
    public boolean isFinal(STATE STATE) {
        return this.mNewFinals.contains(STATE);
    }

    @Override
    public STATE getEmptyStackState() {
        return this.mNwa.getEmptyStackState();
    }

    @Override
    public Set<LETTER> lettersInternal(STATE STATE) {
        HashSet<LETTER> hashSet = new HashSet<LETTER>();
        for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : this.internalSuccessors(STATE)) {
            hashSet.add(outgoingInternalTransition.getLetter());
        }
        return hashSet;
    }

    @Override
    public Set<LETTER> lettersCall(STATE STATE) {
        HashSet<LETTER> hashSet = new HashSet<LETTER>();
        for (OutgoingCallTransition<LETTER, STATE> outgoingCallTransition : this.callSuccessors(STATE)) {
            hashSet.add(outgoingCallTransition.getLetter());
        }
        return hashSet;
    }

    @Override
    public Set<LETTER> lettersReturn(STATE STATE, STATE STATE2) {
        HashSet<LETTER> hashSet = new HashSet<LETTER>();
        for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.returnSuccessorsGivenHier(STATE, STATE2)) {
            hashSet.add(outgoingReturnTransition.getLetter());
        }
        return hashSet;
    }

    @Override
    public Set<LETTER> lettersReturn(STATE STATE) {
        HashSet<LETTER> hashSet = new HashSet<LETTER>();
        for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.returnSuccessors(STATE)) {
            hashSet.add(outgoingReturnTransition.getLetter());
        }
        return hashSet;
    }

    @Override
    public Set<LETTER> lettersInternalIncoming(STATE STATE) {
        HashSet<LETTER> hashSet = new HashSet<LETTER>();
        for (IncomingInternalTransition<LETTER, STATE> incomingInternalTransition : this.internalPredecessors(STATE)) {
            hashSet.add(incomingInternalTransition.getLetter());
        }
        return hashSet;
    }

    @Override
    public Set<LETTER> lettersCallIncoming(STATE STATE) {
        HashSet<LETTER> hashSet = new HashSet<LETTER>();
        for (IncomingCallTransition<LETTER, STATE> incomingCallTransition : this.callPredecessors(STATE)) {
            hashSet.add(incomingCallTransition.getLetter());
        }
        return hashSet;
    }

    @Override
    public Set<LETTER> lettersReturnIncoming(STATE STATE) {
        HashSet<LETTER> hashSet = new HashSet<LETTER>();
        for (IncomingReturnTransition<LETTER, STATE> incomingReturnTransition : this.returnPredecessors(STATE)) {
            hashSet.add(incomingReturnTransition.getLetter());
        }
        return hashSet;
    }

    @Override
    public Set<LETTER> lettersSummary(STATE STATE) {
        HashSet<LETTER> hashSet = new HashSet<LETTER>();
        for (SummaryReturnTransition<LETTER, STATE> summaryReturnTransition : this.summarySuccessors(STATE)) {
            hashSet.add(summaryReturnTransition.getLetter());
        }
        return hashSet;
    }

    private Iterable<STATE> succCall(STATE STATE, LETTER LETTER) {
        HashSet<STATE> hashSet = new HashSet<STATE>();
        for (OutgoingCallTransition<LETTER, STATE> outgoingCallTransition : this.callSuccessors(STATE, LETTER)) {
            hashSet.add(outgoingCallTransition.getSucc());
        }
        return hashSet;
    }

    private Iterable<STATE> succReturn(STATE STATE, STATE STATE2, LETTER LETTER) {
        HashSet<STATE> hashSet = new HashSet<STATE>();
        for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.returnSuccessors(STATE, STATE2, LETTER)) {
            if (!this.mRemainingStates.contains(outgoingReturnTransition.getHierPred()) || !this.mRemainingStates.contains(outgoingReturnTransition.getSucc())) continue;
            hashSet.add(outgoingReturnTransition.getSucc());
        }
        return hashSet;
    }

    private Iterable<STATE> predCall(STATE STATE, LETTER LETTER) {
        HashSet<STATE> hashSet = new HashSet<STATE>();
        for (IncomingCallTransition<LETTER, STATE> incomingCallTransition : this.callPredecessors(STATE, LETTER)) {
            hashSet.add(incomingCallTransition.getPred());
        }
        return hashSet;
    }

    @Override
    public Iterable<IncomingInternalTransition<LETTER, STATE>> internalPredecessors(STATE STATE, LETTER LETTER) {
        Predicate<IncomingInternalTransition<LETTER, STATE>> predicate = this.mTransitionFilter.getInternalPredecessorsPredicate();
        return new FilteredIterable(this.mNwa.internalPredecessors(STATE, LETTER), predicate);
    }

    @Override
    public Iterable<IncomingInternalTransition<LETTER, STATE>> internalPredecessors(STATE STATE) {
        Predicate<IncomingInternalTransition<LETTER, STATE>> predicate = this.mTransitionFilter.getInternalPredecessorsPredicate();
        return new FilteredIterable(this.mNwa.internalPredecessors(STATE), predicate);
    }

    @Override
    public Iterable<IncomingCallTransition<LETTER, STATE>> callPredecessors(STATE STATE, LETTER LETTER) {
        Predicate<IncomingCallTransition> predicate = incomingCallTransition -> this.mRemainingStates.contains(incomingCallTransition.getPred()) && this.isDoubleDeckerThatCanReachPrecious(STATE, incomingCallTransition.getPred());
        return new FilteredIterable(this.mNwa.callPredecessors(STATE, LETTER), predicate);
    }

    @Override
    public Iterable<IncomingCallTransition<LETTER, STATE>> callPredecessors(STATE STATE) {
        Predicate<IncomingCallTransition> predicate = incomingCallTransition -> this.mRemainingStates.contains(incomingCallTransition.getPred()) && this.isDoubleDeckerThatCanReachPrecious(STATE, incomingCallTransition.getPred());
        return new FilteredIterable(this.mNwa.callPredecessors(STATE), predicate);
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE, LETTER LETTER) {
        Predicate<OutgoingInternalTransition<LETTER, STATE>> predicate = this.mTransitionFilter.getInternalSuccessorPredicate();
        return new FilteredIterable(this.mNwa.internalSuccessors(STATE, LETTER), predicate);
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE) {
        Predicate<OutgoingInternalTransition<LETTER, STATE>> predicate = this.mTransitionFilter.getInternalSuccessorPredicate();
        return new FilteredIterable(this.mNwa.internalSuccessors(STATE), predicate);
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE, LETTER LETTER) {
        Predicate<OutgoingCallTransition> predicate = outgoingCallTransition -> this.mRemainingStates.contains(outgoingCallTransition.getSucc()) && (!this.mFilterCallTransitionsBasedOnDoubleDeckerInformation || this.isDoubleDeckerThatCanReachPrecious(outgoingCallTransition.getSucc(), STATE));
        return new FilteredIterable(this.mNwa.callSuccessors(STATE, LETTER), predicate);
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE) {
        Predicate<OutgoingCallTransition> predicate = outgoingCallTransition -> this.mRemainingStates.contains(outgoingCallTransition.getSucc()) && (!this.mFilterCallTransitionsBasedOnDoubleDeckerInformation || this.isDoubleDeckerThatCanReachPrecious(outgoingCallTransition.getSucc(), STATE));
        return new FilteredIterable(this.mNwa.callSuccessors(STATE), predicate);
    }

    @Override
    public Iterable<IncomingReturnTransition<LETTER, STATE>> returnPredecessors(STATE STATE, STATE STATE2, LETTER LETTER) {
        Predicate<IncomingReturnTransition> predicate = incomingReturnTransition -> this.mRemainingStates.contains(incomingReturnTransition.getLinPred()) && this.mRemainingStates.contains(incomingReturnTransition.getHierPred()) && this.isDoubleDeckerThatCanReachPrecious(incomingReturnTransition.getLinPred(), incomingReturnTransition.getHierPred());
        return new FilteredIterable(this.mNwa.returnPredecessors(STATE, STATE2, LETTER), predicate);
    }

    @Override
    public Iterable<IncomingReturnTransition<LETTER, STATE>> returnPredecessors(STATE STATE, LETTER LETTER) {
        Predicate<IncomingReturnTransition> predicate = incomingReturnTransition -> this.mRemainingStates.contains(incomingReturnTransition.getLinPred()) && this.mRemainingStates.contains(incomingReturnTransition.getHierPred()) && this.isDoubleDeckerThatCanReachPrecious(incomingReturnTransition.getLinPred(), incomingReturnTransition.getHierPred());
        return new FilteredIterable(this.mNwa.returnPredecessors(STATE, LETTER), predicate);
    }

    @Override
    public Iterable<IncomingReturnTransition<LETTER, STATE>> returnPredecessors(STATE STATE) {
        Predicate<IncomingReturnTransition> predicate = incomingReturnTransition -> this.mRemainingStates.contains(incomingReturnTransition.getLinPred()) && this.mRemainingStates.contains(incomingReturnTransition.getHierPred()) && this.isDoubleDeckerThatCanReachPrecious(incomingReturnTransition.getLinPred(), incomingReturnTransition.getHierPred());
        return new FilteredIterable(this.mNwa.returnPredecessors(STATE), predicate);
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(STATE STATE, STATE STATE2, LETTER LETTER) {
        Predicate<OutgoingReturnTransition> predicate = outgoingReturnTransition -> this.mRemainingStates.contains(outgoingReturnTransition.getHierPred()) && this.mRemainingStates.contains(outgoingReturnTransition.getSucc()) && this.isDoubleDeckerThatCanReachPrecious(STATE, outgoingReturnTransition.getHierPred());
        return new FilteredIterable(this.mNwa.returnSuccessors(STATE, STATE2, LETTER), predicate);
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(STATE STATE) {
        Predicate<OutgoingReturnTransition> predicate = outgoingReturnTransition -> this.mRemainingStates.contains(outgoingReturnTransition.getHierPred()) && this.mRemainingStates.contains(outgoingReturnTransition.getSucc()) && this.isDoubleDeckerThatCanReachPrecious(STATE, outgoingReturnTransition.getHierPred());
        return new FilteredIterable(this.mNwa.returnSuccessors(STATE), predicate);
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessorsGivenHier(STATE STATE, STATE STATE2) {
        Predicate<OutgoingReturnTransition> predicate = outgoingReturnTransition -> this.mRemainingStates.contains(outgoingReturnTransition.getHierPred()) && this.mRemainingStates.contains(outgoingReturnTransition.getSucc()) && this.isDoubleDeckerThatCanReachPrecious(STATE, outgoingReturnTransition.getHierPred());
        return new FilteredIterable(this.mNwa.returnSuccessorsGivenHier(STATE, STATE2), predicate);
    }

    @Override
    public Iterable<SummaryReturnTransition<LETTER, STATE>> summarySuccessors(STATE STATE, LETTER LETTER) {
        Predicate<SummaryReturnTransition> predicate = summaryReturnTransition -> this.mRemainingStates.contains(summaryReturnTransition.getLinPred()) && this.mRemainingStates.contains(summaryReturnTransition.getSucc()) && this.isDoubleDeckerThatCanReachPrecious(summaryReturnTransition.getLinPred(), STATE);
        return new FilteredIterable(this.mNwa.summarySuccessors(STATE, LETTER), predicate);
    }

    @Override
    public Iterable<SummaryReturnTransition<LETTER, STATE>> summarySuccessors(STATE STATE) {
        Predicate<SummaryReturnTransition> predicate = summaryReturnTransition -> this.mRemainingStates.contains(summaryReturnTransition.getLinPred()) && this.mRemainingStates.contains(summaryReturnTransition.getSucc()) && this.isDoubleDeckerThatCanReachPrecious(summaryReturnTransition.getLinPred(), STATE);
        return new FilteredIterable(this.mNwa.summarySuccessors(STATE), predicate);
    }

    public String toString() {
        return AutomatonDefinitionPrinter.toString(this.mServices, "nwa", this);
    }

    private boolean isDoubleDeckerThatCanReachPrecious(STATE STATE, STATE STATE2) {
        return this.mAncestorComputation.isDownState(STATE, STATE2, NestedWordAutomatonReachableStates.DoubleDeckerReachability.CAN_REACH_PRECIOUS);
    }
}

