/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation;

import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.MetaTraceTransformer;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.PredicateHelper;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.loopaccelerator.IAccelerator;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.loopdetector.ILoopdetector;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.looppreprocessor.ILoopPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.StringDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.QualifiedTracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IDomainSpecificOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.SPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermDomainOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.ITraceCheckPreferences;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.AutomatonFreeRefinementEngine;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementEngineResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class AcceleratedInterpolationCore<L extends IIcfgTransition<?>> {
    private final ILogger mLogger;
    private final ManagedScript mScript;
    private final IAccelerator mAccelerator;
    private final ILoopdetector<IcfgLocation, L> mLoopdetector;
    private final ILoopPreprocessor<IcfgLocation, L, UnmodifiableTransFormula> mLoopPreprocessor;
    private final PredicateHelper<L> mPredHelper;
    private final IUltimateServiceProvider mServices;
    private final PredicateTransformer<Term, IPredicate, TransFormula> mPredTransformer;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final IIcfg<? extends IcfgLocation> mIcfg;
    private final IcfgEdgeFactory mIcfgEdgeFactory;
    private IPredicate[] mInterpolants;
    private final IIcfgSymbolTable mSymbolTable;
    private final Counterexample<L> mCounterexampleTrace;
    private final List<L> mCounterexample;
    private Map<IcfgLocation, Set<List<L>>> mLoops;
    private final Map<IcfgLocation, Set<List<UnmodifiableTransFormula>>> mLoopsAsTf;
    private final Map<IcfgLocation, IcfgLocation> mNestingRelation;
    private final Map<IcfgLocation, Set<List<L>>> mNestedLoops;
    private Map<IcfgLocation, List<UnmodifiableTransFormula>> mNestedLoopsTf;
    private Map<IcfgLocation, List<UnmodifiableTransFormula>> mLoopsTf;
    private final Map<IcfgLocation, L> mLoopExitTransitions;
    private final Map<IcfgLocation, Pair<Integer, Integer>> mLoopSize;
    private final Map<IcfgLocation, List<UnmodifiableTransFormula>> mAccelerations;
    private AccelerationApproximationType mApproximationType;
    private final MetaTraceTransformer.MetaTraceApplicationMethod mMetaTraceApplicationMethod;
    private final MetaTraceTransformer<L> mMetaTraceTransformer;
    private final IStrategySupplier<L> mStrategySupplier;

    public AcceleratedInterpolationCore(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, ManagedScript managedScript, IPredicateUnifier iPredicateUnifier, ITraceCheckPreferences iTraceCheckPreferences, Counterexample<L> counterexample, IIcfg<?> iIcfg, ILoopdetector<IcfgLocation, L> iLoopdetector, ILoopPreprocessor<IcfgLocation, L, UnmodifiableTransFormula> iLoopPreprocessor, IAccelerator iAccelerator, IStrategySupplier<L> iStrategySupplier) {
        this.mScript = managedScript;
        this.mLogger = iLogger;
        this.mIcfg = iIcfg;
        this.mCounterexampleTrace = counterexample;
        this.mCounterexample = counterexample.getWord().asList();
        this.mLoopdetector = iLoopdetector;
        this.mAccelerator = iAccelerator;
        this.mAccelerations = new HashMap<IcfgLocation, List<UnmodifiableTransFormula>>();
        this.mLoopPreprocessor = iLoopPreprocessor;
        this.mLoops = this.mLoopdetector.getLoops();
        this.mLoopsAsTf = this.mLoopdetector.getLoopsTf();
        this.mNestingRelation = this.mLoopdetector.getNestingRelation();
        this.mNestedLoops = this.mLoopdetector.getNestedLoops();
        this.mLoopSize = this.mLoopdetector.getLoopSize();
        this.mLoopExitTransitions = this.mLoopdetector.getLoopExitTransitions();
        this.mNestedLoopsTf = new HashMap<IcfgLocation, List<UnmodifiableTransFormula>>();
        this.mSymbolTable = this.mIcfg.getCfgSmtToolkit().getSymbolTable();
        this.mStrategySupplier = iStrategySupplier;
        this.mServices = iUltimateServiceProvider;
        this.mPredTransformer = new PredicateTransformer(this.mScript, (IDomainSpecificOperationProvider)new TermDomainOperationProvider(this.mServices, this.mScript));
        this.mSimplificationTechnique = iTraceCheckPreferences.getSimplificationTechnique();
        this.mApproximationType = AccelerationApproximationType.PRECISE;
        this.mMetaTraceApplicationMethod = MetaTraceTransformer.MetaTraceApplicationMethod.ONLY_AT_FIRST_LOOP_ENTRY;
        this.mIcfgEdgeFactory = this.mIcfg.getCfgSmtToolkit().getIcfgEdgeFactory();
        this.mPredHelper = new PredicateHelper(iPredicateUnifier, this.mPredTransformer, this.mLogger, this.mScript, this.mServices);
        this.mMetaTraceTransformer = new MetaTraceTransformer<L>(this.mLogger, this.mScript, this.mCounterexample, iPredicateUnifier, this.mServices, this.mPredTransformer, this.mIcfg.getCfgSmtToolkit());
    }

    public Script.LBool acceleratedInterpolationCoreIsCorrect() {
        Script.LBool lBool;
        int n;
        Object object;
        if (this.mLoops.isEmpty() || this.mIcfg.getLoopLocations().isEmpty()) {
            this.mLogger.info((Object)"No loops in this trace, falling back to nested interpolation");
            return this.runStrategy(this.mCounterexampleTrace);
        }
        HashMap<IcfgLocation, Set<List<L>>> hashMap = new HashMap<IcfgLocation, Set<List<L>>>();
        for (Map.Entry<IcfgLocation, Set<List<L>>> entry : this.mLoops.entrySet()) {
            if (this.mIcfg.getLoopLocations().contains(entry.getKey())) {
                hashMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            this.mLoopsAsTf.remove(entry.getKey());
            this.mLoopExitTransitions.remove(entry.getKey());
            this.mLoopSize.remove(entry.getKey());
        }
        this.mLoops = hashMap;
        if (!this.mNestedLoops.isEmpty()) {
            HashMap<IcfgLocation, Set<List<L>>> hashMap2 = new HashMap<IcfgLocation, Set<List<L>>>(this.mNestedLoops);
            for (Map.Entry entry : hashMap2.entrySet()) {
                if (entry.getValue() != null) continue;
                this.mNestedLoops.remove(entry.getKey());
            }
            if (this.mLoopPreprocessor != null) {
                this.mNestedLoopsTf = this.mLoopPreprocessor.preProcessLoop(this.mNestedLoops);
            }
            for (Map.Entry entry : this.mNestingRelation.entrySet()) {
                this.accelerateNestedLoops((IcfgLocation)entry.getKey(), (IcfgLocation)entry.getValue());
            }
        }
        if (this.mLoopPreprocessor != null) {
            this.mLoopsTf = this.mLoopPreprocessor.preProcessLoopInterprocedual(this.mLoops);
            this.mLogger.debug((Object)"Done Preprocessing");
        }
        Iterator<Map.Entry<IcfgLocation, Set<List<L>>>> iterator = this.mLoops.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<IcfgLocation, Set<List<L>>> entry = iterator.next();
            object = this.mLoopsTf.get(entry.getKey());
            n = 0;
            ArrayList<UnmodifiableTransFormula> arrayList = new ArrayList<UnmodifiableTransFormula>();
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                UnmodifiableTransFormula unmodifiableTransFormula = (UnmodifiableTransFormula)iterator2.next();
                this.mLogger.debug((Object)"Starting acceleration");
                UnmodifiableTransFormula unmodifiableTransFormula2 = this.mAccelerator.accelerateLoop(unmodifiableTransFormula, entry.getKey());
                if (!this.mAccelerator.accelerationFinishedCorrectly()) {
                    this.mLogger.debug((Object)"No acceleration found");
                    n = 0;
                    break;
                }
                n = 1;
                Term term = this.mPredHelper.makeReflexive(unmodifiableTransFormula2.getFormula(), unmodifiableTransFormula2);
                UnmodifiableTransFormula unmodifiableTransFormula3 = this.mPredHelper.normalizeTerm(term, unmodifiableTransFormula2, false);
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)("Computed Acceleration: " + unmodifiableTransFormula3.getFormula().toStringDirect()));
                    this.mLogger.debug((Object)("Simplified: " + SmtUtils.simplify((ManagedScript)this.mScript, (Term)unmodifiableTransFormula3.getFormula(), (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA).toStringDirect()));
                }
                arrayList.add(unmodifiableTransFormula3);
            }
            if (n == 0) {
                iterator.remove();
                break;
            }
            if (this.mAccelerator.isOverapprox()) {
                this.mApproximationType = AccelerationApproximationType.OVERAPPROXIMATION;
            }
            this.mAccelerations.put(entry.getKey(), arrayList);
            this.mLogger.info((Object)("Starting analysis with loop acceleration approximation " + this.mApproximationType.toString()));
        }
        if (this.mAccelerations.isEmpty()) {
            this.mLogger.info((Object)"Could not compute an accelerate.");
            return this.runStrategy(this.mCounterexampleTrace);
        }
        Counterexample<L> counterexample = this.generateMetaTrace();
        object = counterexample.getWord();
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Meta-Trace: ");
            n = 0;
            while (n < object.length()) {
                this.mLogger.debug((Object)SmtUtils.simplify((ManagedScript)this.mScript, (Term)((IIcfgTransition)object.getSymbol(n)).getTransformula().getFormula(), (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA).toStringDirect());
                ++n;
            }
        }
        if ((lBool = this.runStrategy(counterexample)) != Script.LBool.UNSAT) {
            return this.runStrategy(this.mCounterexampleTrace);
        }
        this.mInterpolants = this.mMetaTraceTransformer.getInductiveLoopInterpolants(this.mInterpolants, this.mAccelerations, this.mLoopSize, this.mMetaTraceApplicationMethod);
        return lBool;
    }

    private Script.LBool runStrategy(Counterexample<L> counterexample) throws AssertionError {
        List list;
        AutomatonFreeRefinementEngine automatonFreeRefinementEngine = new AutomatonFreeRefinementEngine(this.mServices, this.mLogger, this.mStrategySupplier.constructStrategy(counterexample));
        IRefinementEngineResult iRefinementEngineResult = automatonFreeRefinementEngine.getResult();
        if (iRefinementEngineResult.getCounterexampleFeasibility() != Script.LBool.UNSAT) {
            return iRefinementEngineResult.getCounterexampleFeasibility();
        }
        Collection collection = (Collection)automatonFreeRefinementEngine.getResult().getInfeasibilityProof();
        Optional<QualifiedTracePredicates> optional = collection.stream().filter(QualifiedTracePredicates::isPerfect).findFirst();
        if (optional.isPresent()) {
            list = optional.get().getPredicates();
        } else {
            Optional optional2 = collection.stream().findFirst();
            if (optional2.isEmpty()) {
                throw new AssertionError();
            }
            list = ((QualifiedTracePredicates)optional2.get()).getPredicates();
        }
        this.mInterpolants = list.toArray(new IPredicate[list.size()]);
        return iRefinementEngineResult.getCounterexampleFeasibility();
    }

    private UnmodifiableTransFormula constructEpsilon() {
        return TransFormulaBuilder.getTrivialTransFormula((ManagedScript)this.mScript);
    }

    private Counterexample<L> generateMetaTrace() {
        ArrayList<L> arrayList = new ArrayList<L>(this.mCounterexample);
        ArrayList<UnmodifiableTransFormula> arrayList2 = new ArrayList<UnmodifiableTransFormula>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        ArrayList arrayList4 = new ArrayList();
        ArrayList arrayList5 = new ArrayList();
        arrayList4.addAll(this.mCounterexampleTrace.getControlConfigurations());
        int n = 0;
        while (n < arrayList.size()) {
            IIcfgTransition iIcfgTransition2 = (IIcfgTransition)arrayList.get(n);
            arrayList2.add(iIcfgTransition2.getTransformula());
            arrayList3.add(iIcfgTransition2);
            arrayList5.add(arrayList4.get(n));
            if (this.mLoops.containsKey(iIcfgTransition2.getTarget())) {
                Pair<Integer, Integer> pair;
                UnmodifiableTransFormula unmodifiableTransFormula;
                IcfgInternalTransition icfgInternalTransition;
                UnmodifiableTransFormula unmodifiableTransFormula2;
                IcfgLocation icfgLocation = iIcfgTransition2.getTarget();
                PredicateFactory predicateFactory = new PredicateFactory(this.mServices, this.mScript, this.mSymbolTable);
                IIcfgTransition iIcfgTransition3 = (IIcfgTransition)this.mLoopExitTransitions.get(icfgLocation);
                IcfgLocation icfgLocation2 = iIcfgTransition3.getTarget();
                StringDebugIdentifier stringDebugIdentifier = new StringDebugIdentifier(icfgLocation2.getDebugIdentifier().toString() + "_primed");
                Term term = this.mPredHelper.normalizeTerm(iIcfgTransition3.getTransformula());
                SPredicate sPredicate = predicateFactory.newSPredicate(icfgLocation2, term);
                IcfgLocation icfgLocation3 = new IcfgLocation((DebugIdentifier)stringDebugIdentifier, icfgLocation2.getProcedure());
                IcfgInternalTransition icfgInternalTransition2 = this.mIcfgEdgeFactory.createInternalTransition(icfgLocation3, icfgLocation2, icfgLocation2.getPayload(), iIcfgTransition3.getTransformula());
                List<UnmodifiableTransFormula> list = this.mAccelerations.get(icfgLocation);
                if (list.size() > 1) {
                    int n2 = 0;
                    while (n2 < list.size() - 1) {
                        unmodifiableTransFormula2 = list.get(n2);
                        icfgInternalTransition = this.mIcfgEdgeFactory.createInternalTransition(icfgLocation, icfgLocation3, icfgLocation.getPayload(), unmodifiableTransFormula2);
                        unmodifiableTransFormula = this.constructEpsilon();
                        pair = this.mIcfgEdgeFactory.createInternalTransition(icfgLocation3, icfgLocation, icfgLocation.getPayload(), unmodifiableTransFormula);
                        if (this.mAccelerator.isOverapprox()) {
                            new Overapprox("Because of loopacceleration", (ILocation)icfgLocation).annotate((IElement)icfgInternalTransition);
                        }
                        Term term2 = this.mPredHelper.normalizeTerm(unmodifiableTransFormula2);
                        Term term3 = this.mPredHelper.normalizeTerm(unmodifiableTransFormula);
                        SPredicate sPredicate2 = predicateFactory.newSPredicate(icfgLocation3, term2);
                        SPredicate sPredicate3 = predicateFactory.newSPredicate(icfgLocation, term3);
                        arrayList3.add(icfgInternalTransition);
                        arrayList3.add(pair);
                        arrayList5.add(sPredicate2);
                        arrayList5.add(sPredicate3);
                        ++n2;
                    }
                }
                UnmodifiableTransFormula unmodifiableTransFormula3 = list.get(list.size() - 1);
                unmodifiableTransFormula2 = this.mIcfgEdgeFactory.createInternalTransition(icfgLocation, icfgLocation3, iIcfgTransition2.getTarget().getPayload(), unmodifiableTransFormula3);
                icfgInternalTransition = this.mPredHelper.normalizeTerm(unmodifiableTransFormula3);
                arrayList3.add(unmodifiableTransFormula2);
                arrayList3.add(icfgInternalTransition2);
                unmodifiableTransFormula = predicateFactory.newSPredicate(icfgLocation3, (Term)icfgInternalTransition);
                arrayList5.add(unmodifiableTransFormula);
                arrayList5.add(sPredicate);
                pair = this.mLoopSize.get(iIcfgTransition2.getTarget());
                n = n + (Integer)pair.getSecond() - (Integer)pair.getFirst() + 1;
            }
            ++n;
        }
        arrayList5.add(arrayList4.get(arrayList.size()));
        NestedWord nestedWord = TraceCheckUtils.toNestedWord(arrayList3);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Current trace");
            this.mCounterexample.forEach(iIcfgTransition -> this.mLogger.debug((Object)iIcfgTransition.getTransformula()));
        }
        return new Counterexample((Word)nestedWord, arrayList5);
    }

    private void accelerateNestedLoops(IcfgLocation icfgLocation, IcfgLocation icfgLocation2) {
        Object object;
        Object object2;
        UnmodifiableTransFormula unmodifiableTransFormula22;
        if (!this.mNestedLoops.containsKey(icfgLocation2)) {
            return;
        }
        if (this.mNestingRelation.containsKey(icfgLocation2)) {
            this.accelerateNestedLoops(icfgLocation2, this.mNestingRelation.get(icfgLocation2));
        }
        List<UnmodifiableTransFormula> list = this.mNestedLoopsTf.get(icfgLocation2);
        boolean bl = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (UnmodifiableTransFormula unmodifiableTransFormula22 : list) {
            this.mLogger.debug((Object)"Starting acceleration of nested loop");
            object2 = this.mAccelerator.accelerateLoop(unmodifiableTransFormula22, icfgLocation2);
            if (!this.mAccelerator.accelerationFinishedCorrectly()) {
                this.mLogger.debug((Object)"No acceleration found");
                bl = false;
                break;
            }
            bl = true;
            Term term = this.mPredHelper.makeReflexive(object2.getFormula(), (UnmodifiableTransFormula)object2);
            Term term2 = term;
            Term object3 = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique, (Term)term2);
            object = this.mPredHelper.normalizeTerm(object3, (UnmodifiableTransFormula)object2, true);
            this.mLogger.debug((Object)("Computed Acceleration: " + object.getFormula().toStringDirect()));
            arrayList.add(object);
        }
        if (!bl) {
            return;
        }
        unmodifiableTransFormula22 = TransFormulaUtils.parallelComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, null, (boolean)false, (boolean)false, (UnmodifiableTransFormula[])arrayList.toArray(new UnmodifiableTransFormula[arrayList.size()]));
        Set<List<L>> set = this.mLoops.containsKey(icfgLocation) ? this.mLoops.get(icfgLocation) : this.mNestedLoops.get(icfgLocation);
        object2 = new HashSet();
        for (List list2 : set) {
            object = new ArrayList();
            int n = 0;
            while (n < list2.size()) {
                if (((IIcfgTransition)list2.get(n)).getSource() == icfgLocation2) {
                    this.mLogger.debug((Object)"found nested loophead");
                    object.add(unmodifiableTransFormula22);
                    n = (Integer)this.mLoopSize.get(icfgLocation2).getSecond();
                } else {
                    object.add(((IIcfgTransition)list2.get(n)).getTransformula());
                }
                ++n;
            }
            object2.add(object);
        }
        this.mLoopsAsTf.put(icfgLocation, (Set<List<UnmodifiableTransFormula>>)object2);
        this.mLogger.debug((Object)"Nested loops accelerated");
    }

    public IPredicate[] getInterpolants() {
        return this.mInterpolants;
    }

    public static enum AccelerationApproximationType {
        PRECISE,
        UNDERAPPROXIMATION,
        OVERAPPROXIMATION;

    }

    @FunctionalInterface
    public static interface IStrategySupplier<L extends IAction> {
        public IRefinementStrategy<L> constructStrategy(Counterexample<L> var1);
    }
}

