/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import java.util.Map;
import java.util.function.IntPredicate;

public final class AtomicBlockInfo
extends ModernAnnotations {
    private static final long serialVersionUID = -8370873908642083605L;
    private static int START_DELTA = 1;
    private static int END_DELTA = -1;
    private final int mDelta;

    private AtomicBlockInfo(int n) {
        this.mDelta = n;
    }

    public IAnnotations merge(IAnnotations iAnnotations) {
        if (iAnnotations instanceof AtomicBlockInfo) {
            AtomicBlockInfo atomicBlockInfo = (AtomicBlockInfo)iAnnotations;
            int n = this.mDelta + atomicBlockInfo.mDelta;
            return new AtomicBlockInfo(n);
        }
        return super.merge(iAnnotations);
    }

    public Map<String, Object> getAnnotationsAsMap() {
        return Map.of("delta", this.mDelta);
    }

    public String toString() {
        return AtomicBlockInfo.class.getSimpleName() + "(" + (this.mDelta > 0 ? "+" : "") + this.mDelta + ")";
    }

    public static boolean isStartOfAtomicBlock(IIcfgTransition<?> iIcfgTransition) {
        return AtomicBlockInfo.hasAnnotatedDelta(iIcfgTransition, n -> n > 0);
    }

    public static boolean isEndOfAtomicBlock(IIcfgTransition<?> iIcfgTransition) {
        return AtomicBlockInfo.hasAnnotatedDelta(iIcfgTransition, n -> n < 0);
    }

    public static boolean isCompleteAtomicBlock(IIcfgTransition<?> iIcfgTransition) {
        return AtomicBlockInfo.hasAnnotatedDelta(iIcfgTransition, n -> n == 0);
    }

    public static void addBeginAnnotation(IIcfgTransition<?> iIcfgTransition) {
        AtomicBlockInfo.addAnnotation(iIcfgTransition, START_DELTA);
    }

    public static void addEndAnnotation(IIcfgTransition<?> iIcfgTransition) {
        AtomicBlockInfo.addAnnotation(iIcfgTransition, END_DELTA);
    }

    public static void addCompleteAnnotation(IIcfgTransition<?> iIcfgTransition) {
        AtomicBlockInfo.addAnnotation(iIcfgTransition, 0);
    }

    public static void removeAnnotation(IIcfgTransition<?> iIcfgTransition) {
        iIcfgTransition.getPayload().getAnnotations().remove(AtomicBlockInfo.class.getName());
    }

    private static boolean hasAnnotatedDelta(IIcfgTransition<?> iIcfgTransition, IntPredicate intPredicate) {
        AtomicBlockInfo atomicBlockInfo = (AtomicBlockInfo)ModelUtils.getAnnotation(iIcfgTransition, AtomicBlockInfo.class);
        if (atomicBlockInfo != null) {
            return intPredicate.test(atomicBlockInfo.mDelta);
        }
        return false;
    }

    private static void addAnnotation(IIcfgTransition<?> iIcfgTransition, int n) {
        AtomicBlockInfo atomicBlockInfo = (AtomicBlockInfo)ModelUtils.getAnnotation(iIcfgTransition, AtomicBlockInfo.class);
        if (atomicBlockInfo != null) {
            throw new UnsupportedOperationException("Incompatible atomic block annotation: " + atomicBlockInfo.mDelta + " and " + n);
        }
        iIcfgTransition.getPayload().getAnnotations().put(AtomicBlockInfo.class.getName(), new AtomicBlockInfo(n));
    }
}

