/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

public class NoopScript
implements Script {
    private Theory mTheory;
    protected int mStackLevel = 0;
    protected Theory.SolverSetup mSolverSetup;

    public NoopScript() {
        this(null, null);
    }

    protected NoopScript(Theory theory) {
        this(theory, null);
    }

    protected NoopScript(Theory theory, Theory.SolverSetup solverSetup) {
        this.mTheory = theory;
        this.mSolverSetup = solverSetup;
    }

    @Override
    public Theory getTheory() {
        return this.mTheory;
    }

    private void checkSymbol(String string) throws SMTLIBException {
        if (string.indexOf(124) >= 0 || string.indexOf(92) >= 0) {
            throw new SMTLIBException("Symbol must not contain | or \\");
        }
    }

    @Override
    public void setLogic(String string) throws UnsupportedOperationException {
        try {
            this.setLogic(Logics.valueOf(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedOperationException("Logic " + string + " not supported");
        }
    }

    @Override
    public void setLogic(Logics logics) throws UnsupportedOperationException {
        if (this.mTheory != null) {
            throw new SMTLIBException("Logic already set!");
        }
        this.mTheory = new Theory(logics, this.mSolverSetup);
    }

    @Override
    public void setOption(String string, Object object) throws UnsupportedOperationException, SMTLIBException {
    }

    @Override
    public void setInfo(String string, Object object) {
    }

    @Override
    public FunctionSymbol getFunctionSymbol(String string) {
        return this.mTheory.getFunctionSymbol(string);
    }

    @Override
    public DataType.Constructor constructor(String string, String[] stringArray, Sort[] sortArray) {
        if (string == null) {
            throw new SMTLIBException("Invalid input to declare a datatype");
        }
        this.checkSymbol(string);
        return this.mTheory.createConstructor(string, stringArray, sortArray);
    }

    @Override
    public DataType datatype(String string, int n) {
        if (string == null) {
            throw new SMTLIBException("Invalid input to declare a datatype");
        }
        this.checkSymbol(string);
        return this.mTheory.createDatatypes(string, n);
    }

    private void declareConstructorFunctions(DataType dataType, DataType.Constructor[] constructorArray, Sort[] sortArray) {
        Sort sort;
        String[] stringArray = null;
        if (sortArray == null) {
            if (dataType.mNumParams != 0) {
                throw new SMTLIBException("Sort parameters missing");
            }
            sort = dataType.getSort(stringArray, Theory.EMPTY_SORT_ARRAY);
        } else {
            if (dataType.mNumParams == 0 || dataType.mNumParams != sortArray.length) {
                throw new SMTLIBException("Sort parameter mismatch");
            }
            sort = dataType.getSort(stringArray, sortArray);
        }
        Sort[] sortArray2 = new Sort[]{sort};
        DataType.Constructor[] constructorArray2 = constructorArray;
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataType.Constructor constructor = constructorArray2[n2];
            String string = constructor.getName();
            String[] stringArray2 = constructor.getSelectors();
            Sort[] sortArray3 = constructor.getArgumentSorts();
            if (sortArray == null) {
                this.getTheory().declareInternalFunction(string, sortArray3, sort, 128);
                var14_14 = 0;
                while (var14_14 < stringArray2.length) {
                    this.getTheory().declareInternalFunction(stringArray2[var14_14], sortArray2, sortArray3[var14_14], 256);
                    ++var14_14;
                }
            } else {
                var14_14 = 128 + (constructor.needsReturnOverload() ? 16 : 0);
                this.getTheory().declareInternalPolymorphicFunction(string, sortArray, sortArray3, sort, var14_14);
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    this.getTheory().declareInternalPolymorphicFunction(stringArray2[n3], sortArray, sortArray2, sortArray3[n3], 256);
                    ++n3;
                }
            }
            ++n2;
        }
    }

    @Override
    public void declareDatatype(DataType dataType, DataType.Constructor[] constructorArray) {
        assert (dataType.mNumParams == 0);
        dataType.setConstructors(new Sort[0], constructorArray);
        this.declareConstructorFunctions(dataType, constructorArray, null);
    }

    @Override
    public void declareDatatypes(DataType[] dataTypeArray, DataType.Constructor[][] constructorArray, Sort[][] sortArray) {
        int n = 0;
        while (n < dataTypeArray.length) {
            dataTypeArray[n].setConstructors(sortArray[n], constructorArray[n]);
            this.declareConstructorFunctions(dataTypeArray[n], constructorArray[n], sortArray[n]);
            ++n;
        }
    }

    @Override
    public void declareSort(String string, int n) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        this.checkSymbol(string);
        try {
            this.mTheory.declareSort(string, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SMTLIBException(illegalArgumentException.getMessage());
        }
    }

    @Override
    public void defineSort(String string, Sort[] sortArray, Sort sort) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        this.checkSymbol(string);
        try {
            this.mTheory.defineSort(string, sortArray.length, sort);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SMTLIBException(illegalArgumentException.getMessage());
        }
    }

    @Override
    public void declareFun(String string, Sort[] sortArray, Sort sort) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        this.checkSymbol(string);
        try {
            this.mTheory.declareFunction(string, sortArray, sort);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SMTLIBException(illegalArgumentException.getMessage());
        }
    }

    @Override
    public void defineFun(String string, TermVariable[] termVariableArray, Sort sort, Term term) throws SMTLIBException {
        this.checkSymbol(string);
        this.defineFunInternal(string, termVariableArray, sort, term);
    }

    private void defineFunInternal(String string, TermVariable[] termVariableArray, Sort sort, Term term) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (!sort.equalsSort(term.getSort())) {
            throw new SMTLIBException("Sort mismatch");
        }
        try {
            this.mTheory.defineFunction(string, termVariableArray, term);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SMTLIBException(illegalArgumentException.getMessage());
        }
    }

    @Override
    public void push(int n) {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        this.mStackLevel += n;
        int n2 = 0;
        while (n2 < n) {
            this.mTheory.push();
            ++n2;
        }
    }

    @Override
    public void pop(int n) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (n > this.mStackLevel) {
            throw new SMTLIBException("Not enough levels on assertion stack");
        }
        this.mStackLevel -= n;
        int n2 = 0;
        while (n2 < n) {
            this.mTheory.pop();
            ++n2;
        }
    }

    @Override
    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        return Script.LBool.UNKNOWN;
    }

    @Override
    public Script.LBool checkSat() {
        return Script.LBool.UNKNOWN;
    }

    @Override
    public Script.LBool checkSatAssuming(Term ... termArray) {
        return Script.LBool.UNKNOWN;
    }

    @Override
    public Term[] getAssertions() throws SMTLIBException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Term getProof() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Term[] getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Term, Term> getValue(Term[] termArray) throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Assignments getAssignment() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getOption(String string) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getInfo(String string) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Term simplify(Term term) throws SMTLIBException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.mTheory = null;
        this.mStackLevel = 0;
    }

    @Override
    public Term[] getInterpolants(Term[] termArray) throws SMTLIBException, UnsupportedOperationException {
        int[] nArray = new int[termArray.length];
        return this.getInterpolants(termArray, nArray);
    }

    @Override
    public Term[] getInterpolants(Term[] termArray, int[] nArray) throws SMTLIBException, UnsupportedOperationException {
        return this.getInterpolants(termArray, nArray, this.getProof());
    }

    @Override
    public Term[] getInterpolants(Term[] termArray, int[] nArray, Term term) throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exit() {
    }

    @Override
    public Sort sort(String string, Sort ... sortArray) throws SMTLIBException {
        return this.sort(string, (String[])null, sortArray);
    }

    @Override
    public Sort sort(String string, String[] stringArray, Sort ... sortArray) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        Sort sort = this.mTheory.getSort(string, stringArray, sortArray);
        if (sort == null) {
            throw new SMTLIBException("Sort " + string + " not declared");
        }
        return sort;
    }

    @Override
    public Term term(String string, Term ... termArray) throws SMTLIBException {
        return this.term(string, (String[])null, (Sort)null, termArray);
    }

    @Override
    public Term term(String string, String[] stringArray, Sort sort, Term ... termArray) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        return this.mTheory.term(string, stringArray, sort, termArray);
    }

    @Override
    public TermVariable variable(String string, Sort sort) throws SMTLIBException {
        if (sort == null || string == null) {
            throw new SMTLIBException("Invalid input to create a term variable");
        }
        this.checkSymbol(string);
        return this.mTheory.createTermVariable(string, sort);
    }

    @Override
    public Term quantifier(int n, TermVariable[] termVariableArray, Term term, Term[] ... termArray) throws SMTLIBException {
        if (termVariableArray.length == 0) {
            throw new SMTLIBException("No quantified variables given");
        }
        if (term == null) {
            throw new SMTLIBException("Empty quantifier body");
        }
        if (termArray != null && termArray.length > 0) {
            Annotation[] annotationArray = new Annotation[termArray.length];
            int n2 = 0;
            Term[][] termArray2 = termArray;
            int n3 = termArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Term[] termArray3 = termArray2[n4];
                annotationArray[n2++] = new Annotation(":pattern", termArray3);
                ++n4;
            }
            term = this.mTheory.annotatedTerm(annotationArray, term);
        }
        if (n == 0) {
            return this.mTheory.exists(termVariableArray, term);
        }
        if (n == 1) {
            return this.mTheory.forall(termVariableArray, term);
        }
        throw new SMTLIBException("Unknown Quantifier");
    }

    @Override
    public Term let(TermVariable[] termVariableArray, Term[] termArray, Term term) throws SMTLIBException {
        if (termVariableArray.length != termArray.length) {
            throw new SMTLIBException("Need exactly one value for every variable");
        }
        return this.mTheory.let(termVariableArray, termArray, term);
    }

    @Override
    public Term match(Term term, TermVariable[][] termVariableArray, Term[] termArray, DataType.Constructor[] constructorArray) throws SMTLIBException {
        return this.mTheory.match(term, termVariableArray, termArray, constructorArray);
    }

    @Override
    public Term annotate(Term term, Annotation ... annotationArray) throws SMTLIBException {
        if (annotationArray.length > 0) {
            Annotation[] annotationArray2 = annotationArray;
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray2[n2];
                if (annotation.getKey().equals(":named")) {
                    if (!(annotation.getValue() instanceof String)) {
                        throw new SMTLIBException("Need a string value for :named");
                    }
                    this.checkSymbol((String)annotation.getValue());
                    if (term.getFreeVars().length != 0) {
                        throw new SMTLIBException("Cannot name open terms");
                    }
                    this.defineFunInternal((String)annotation.getValue(), Theory.EMPTY_TERM_VARIABLE_ARRAY, term.getSort(), term);
                }
                ++n2;
            }
            return this.mTheory.annotatedTerm(annotationArray, term);
        }
        return term;
    }

    @Override
    public Term numeral(String string) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (this.mTheory.getNumericSort() == null) {
            throw new SMTLIBException("Logic does not allow numerals");
        }
        try {
            return this.mTheory.numeral(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SMTLIBException("Not a numeral: " + string);
        }
    }

    @Override
    public Term numeral(BigInteger bigInteger) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (this.mTheory.getNumericSort() == null) {
            throw new SMTLIBException("Logic does not allow numerals");
        }
        return this.mTheory.numeral(bigInteger);
    }

    @Override
    public Term decimal(String string) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (this.mTheory.getRealSort() == null) {
            throw new SMTLIBException("Logic does not allow reals");
        }
        try {
            return this.mTheory.decimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SMTLIBException("Not a decimal: " + string);
        }
    }

    @Override
    public Term decimal(BigDecimal bigDecimal) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (this.mTheory.getRealSort() == null) {
            throw new SMTLIBException("Logic does not allow reals");
        }
        return this.mTheory.decimal(bigDecimal);
    }

    @Override
    public Term string(QuotedObject quotedObject) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (this.mTheory.getStringSort() == null) {
            throw new SMTLIBException("Logic does not allow strings");
        }
        return this.mTheory.string(quotedObject);
    }

    @Override
    public Term hexadecimal(String string) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        Term term = this.mTheory.hexadecimal(string);
        if (term == null) {
            throw new SMTLIBException("No bitvector logic");
        }
        return term;
    }

    @Override
    public Term binary(String string) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        Term term = this.mTheory.binary(string);
        if (term == null) {
            throw new SMTLIBException("No bitvector logic");
        }
        return term;
    }

    @Override
    public Sort[] sortVariables(String ... stringArray) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        return this.mTheory.createSortVariables(stringArray);
    }

    @Override
    public Model getModel() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Term[]> checkAllsat(Term[] termArray) throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Term[] findImpliedEquality(Term[] termArray, Term[] termArray2) throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public QuotedObject echo(QuotedObject quotedObject) {
        return quotedObject;
    }

    @Override
    public void resetAssertions() {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        this.mTheory.resetAssertions();
        this.mStackLevel = 0;
    }

    @Override
    public Term[] getUnsatAssumptions() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

