/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.rcfg;

import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.PreprocessorAnnotation;
import de.uni_freiburg.informatik.ultimate.core.lib.observers.BaseObserver;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.IAnnotationProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefEdgeAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefStatementAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.boogie.ScopedBoogieVarBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.rcfg.ReachDefRCFGVisitor;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.util.Util;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;
import java.util.LinkedHashSet;

public class ReachDefRCFG
extends BaseObserver {
    private final ILogger mLogger;
    private final IAnnotationProvider<ReachDefStatementAnnotation> mStatementProvider;
    private final IAnnotationProvider<ReachDefEdgeAnnotation> mEdgeProvider;

    public ReachDefRCFG(ILogger iLogger, IAnnotationProvider<ReachDefStatementAnnotation> iAnnotationProvider, IAnnotationProvider<ReachDefEdgeAnnotation> iAnnotationProvider2) {
        this.mLogger = iLogger;
        this.mStatementProvider = iAnnotationProvider;
        this.mEdgeProvider = iAnnotationProvider2;
    }

    public boolean process(IElement iElement) throws Throwable {
        if (iElement instanceof BoogieIcfgContainer) {
            BoogieIcfgContainer boogieIcfgContainer = (BoogieIcfgContainer)iElement;
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Loops: " + boogieIcfgContainer.getLoopLocations().size()));
            }
            this.process(boogieIcfgContainer);
        }
        return false;
    }

    private void process(BoogieIcfgContainer boogieIcfgContainer) throws Throwable {
        PreprocessorAnnotation preprocessorAnnotation = PreprocessorAnnotation.getAnnotation((IElement)boogieIcfgContainer);
        if (preprocessorAnnotation == null || preprocessorAnnotation.getSymbolTable() == null) {
            this.mLogger.fatal((Object)"No symbol table found on given RootNode.");
            throw new UnsupportedOperationException("No symbol table found on given RootNode.");
        }
        ScopedBoogieVarBuilder scopedBoogieVarBuilder = new ScopedBoogieVarBuilder(preprocessorAnnotation.getSymbolTable());
        LinkedHashSet linkedHashSet = new LinkedHashSet(BoogieIcfgContainer.extractStartEdges((BoogieIcfgContainer)boogieIcfgContainer));
        while (!linkedHashSet.isEmpty()) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)"");
                this.mLogger.debug((Object)("                    Open: " + Util.prettyPrintIterable(linkedHashSet, Util.createHashCodePrinter())));
            }
            IcfgEdge icfgEdge = (IcfgEdge)linkedHashSet.iterator().next();
            linkedHashSet.remove(icfgEdge);
            ReachDefRCFGVisitor reachDefRCFGVisitor = new ReachDefRCFGVisitor(this.mEdgeProvider, this.mStatementProvider, this.mLogger, scopedBoogieVarBuilder);
            boolean bl = reachDefRCFGVisitor.process(icfgEdge);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("                    Fixpoint reached: " + bl));
            }
            if (bl) continue;
            linkedHashSet.addAll(((IcfgLocation)icfgEdge.getTarget()).getOutgoingEdges());
        }
        this.mLogger.debug((Object)"bla");
    }
}

