/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ClauseDeletionHook;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ITheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.ApplyConstructiveEqualityReasoning;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.ApplyDestructiveEqualityReasoning;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprEqualityPredicate;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprHelpers;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprPredicate;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EqualityManager;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TermTuple;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.EprClauseFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.DawgFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.EprDecideStack;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.partialmodel.GroundPropagationInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EprTheory
implements ITheory {
    Map<FunctionSymbol, EprPredicate> mFunctionSymbolToEprPredicate = new HashMap<FunctionSymbol, EprPredicate>();
    Map<Literal, GroundPropagationInfo> mGroundLiteralsToPropagateToReason = new HashMap<Literal, GroundPropagationInfo>();
    ScopedHashSet<DPLLAtom> mAtomsAddedToDPLLEngine = new ScopedHashSet();
    EqualityManager mEqualityManager;
    private ArrayList<Literal[]> mAllGroundingsOfLastAddedEprClause;
    private EprDecideStack mEprStack;
    private DawgFactory<ApplicationTerm, TermVariable> mDawgFactory;
    private EprClauseFactory mClauseFactory;
    private CClosure mCClosure;
    private Clausifier mClausifier;
    private final LogProxy mLogger;
    private Theory mTheory;
    private DPLLEngine mEngine;
    private final ArrayDeque<Literal> mGroundDecisionSuggestions = new ArrayDeque();
    private Clause mStoredConflict;
    private final Deque<Literal> mLiteralsWaitingToBePropagated = new ArrayDeque<Literal>();
    private final Set<Literal> mLiteralsThatAreCurrentlySet = new HashSet<Literal>();
    private Map<Sort, EprEqualityPredicate> mSortToEqualityEprPredicate;

    public EprTheory(LogProxy logProxy) {
        this.mLogger = logProxy;
    }

    public EprTheory(Theory theory, DPLLEngine dPLLEngine, CClosure cClosure, Clausifier clausifier) {
        this.mTheory = theory;
        this.mEngine = dPLLEngine;
        this.mClausifier = clausifier;
        this.mLogger = clausifier.getLogger();
        this.mDawgFactory = new DawgFactory(this);
        this.mClauseFactory = new EprClauseFactory(this);
        this.mEqualityManager = new EqualityManager();
        this.mEprStack = new EprDecideStack(this);
        this.mSortToEqualityEprPredicate = new HashMap<Sort, EprEqualityPredicate>();
    }

    @Override
    public Clause startCheck() {
        this.mLogger.debug("EPRDEBUG: startCheck");
        return null;
    }

    @Override
    public void endCheck() {
        this.mLogger.debug("EPRDEBUG: endCheck");
    }

    @Override
    public Clause setLiteral(Literal literal) {
        this.mLogger.debug("EPRDEBUG: setLiteral " + String.valueOf(literal));
        this.mLiteralsThatAreCurrentlySet.add(literal);
        DPLLAtom dPLLAtom = literal.getAtom();
        if (dPLLAtom instanceof EprGroundPredicateAtom) {
            Clause clause = this.mEprStack.setEprGroundLiteral(literal);
            clause = EprHelpers.sanitizeGroundConflict(this.mClausifier, this.mLogger, clause);
            return clause;
        }
        if (dPLLAtom instanceof EprQuantifiedEqualityAtom || dPLLAtom instanceof EprQuantifiedPredicateAtom) {
            assert (false) : "DPLLEngine is setting a quantified EprAtom --> this cannot be..";
        } else if (dPLLAtom instanceof CCEquality) {
            Clause clause = this.mEprStack.setGroundEquality((CCEquality)dPLLAtom, literal.getSign() == 1);
            clause = EprHelpers.sanitizeGroundConflict(this.mClausifier, this.mLogger, clause);
            return clause;
        }
        return null;
    }

    @Override
    public void backtrackLiteral(Literal literal) {
        this.mLogger.debug("EPRDEBUG: backtrackLiteral " + String.valueOf(literal));
        boolean bl = this.mLiteralsThatAreCurrentlySet.remove(literal);
        assert (bl);
        this.mGroundLiteralsToPropagateToReason.remove(literal);
        DPLLAtom dPLLAtom = literal.getAtom();
        if (dPLLAtom instanceof EprGroundPredicateAtom) {
            this.mEprStack.backtrackToLiteral(literal);
        } else if (dPLLAtom instanceof EprQuantifiedEqualityAtom || dPLLAtom instanceof EprQuantifiedPredicateAtom) {
            assert (false) : "DPLLEngine is unsetting a quantified EprAtom --> this cannot be..";
        } else if (dPLLAtom instanceof CCEquality) {
            this.mEprStack.backtrackToLiteral(literal);
        }
    }

    @Override
    public Clause checkpoint() {
        if (this.isTerminationRequested()) {
            return null;
        }
        this.mLogger.debug("EPRDEBUG: checkpoint");
        assert (this.mLiteralsWaitingToBePropagated.isEmpty()) : "have all propagations been done at this point??";
        if (this.mStoredConflict != null) {
            Clause clause = this.mStoredConflict;
            this.mStoredConflict = null;
            clause = EprHelpers.sanitizeGroundConflict(this.mClausifier, this.mLogger, clause);
            return clause;
        }
        return this.mEprStack.doPropagations();
    }

    @Override
    public Clause computeConflictClause() {
        this.mLogger.debug("EPRDEBUG: computeConflictClause");
        Clause clause = this.mEprStack.eprDpllLoop();
        clause = EprHelpers.sanitizeGroundConflict(this.mClausifier, this.mLogger, clause);
        return clause;
    }

    @Override
    public int checkCompleteness() {
        return 0;
    }

    @Override
    public Literal getPropagatedLiteral() {
        Literal literal = this.mLiteralsWaitingToBePropagated.poll();
        assert (literal == null || !(literal.getAtom() instanceof EprGroundEqualityAtom)) : "should have been caught/converted to CCEquality before";
        if (literal == null) {
            this.mLogger.debug("EPRDEBUG: getPropagatedLiteral -- nothing to propagate");
            return null;
        }
        this.mLogger.debug("EPRDEBUG: getPropagatedLiteral propagating: " + String.valueOf(literal));
        return literal;
    }

    public void addGroundLiteralToPropagate(Literal literal, GroundPropagationInfo groundPropagationInfo) {
        CCEquality cCEquality;
        if (this.mGroundLiteralsToPropagateToReason.keySet().contains(literal)) {
            this.mLogger.debug("EPRDEBUG: EprTheory.addGroundLiteralToPropagate: already added: " + String.valueOf(literal));
            return;
        }
        if (literal.getAtom() instanceof EprGroundEqualityAtom && (cCEquality = ((EprGroundEqualityAtom)literal.getAtom()).getCCEquality(this.mClausifier)) == null && literal.getSign() == 1) {
            return;
        }
        if (literal.getAtom() instanceof EprAtom) {
            this.addAtomToDPLLEngine(literal.getAtom());
        }
        this.mLogger.debug("EPRDEBUG: EprTheory.addGroundLiteralToPropagate(..): literal: " + String.valueOf(literal) + " reason: " + String.valueOf(groundPropagationInfo));
        this.mLiteralsWaitingToBePropagated.add(literal);
        this.mGroundLiteralsToPropagateToReason.put(literal, groundPropagationInfo);
    }

    @Override
    public Clause getUnitClause(Literal literal) {
        return this.mEprStack.explainGroundUnit(literal, this.mGroundLiteralsToPropagateToReason.get(literal));
    }

    @Override
    public Literal getSuggestion() {
        Literal literal = this.mGroundDecisionSuggestions.poll();
        if (literal == null) {
            this.mLogger.debug("EPRDEBUG: (EprTheory): getSuggestion -- no literal to suggest");
        } else {
            this.mLogger.debug("EPRDEBUG: (EprTheory): getSuggestion, suggesting " + String.valueOf(literal));
        }
        return literal;
    }

    public void addGroundDecisionSuggestion(Literal literal) {
        this.mGroundDecisionSuggestions.add(literal);
    }

    @Override
    public void increasedDecideLevel(int n) {
        this.mLogger.debug("EPRDEBUG: increasedDecideLevel");
    }

    @Override
    public void decreasedDecideLevel(int n) {
        this.mLogger.debug("EPRDEBUG: decreasedDecideLevel");
    }

    @Override
    public void backtrackAll() {
        for (Literal literal : this.mLiteralsWaitingToBePropagated) {
            this.mGroundLiteralsToPropagateToReason.remove(literal);
        }
        this.mLiteralsWaitingToBePropagated.clear();
    }

    @Override
    public void backtrackStart() {
        for (Literal literal : this.mLiteralsWaitingToBePropagated) {
            this.mGroundLiteralsToPropagateToReason.remove(literal);
        }
        this.mLiteralsWaitingToBePropagated.clear();
        this.mLogger.debug("EPRDEBUG: backtrackStart");
    }

    @Override
    public Clause backtrackComplete() {
        this.mLogger.debug("EPRDEBUG: backtrackComplete");
        return null;
    }

    @Override
    public void restart(int n) {
        this.mLogger.info("EPRDEBUG: restart");
    }

    @Override
    public void removeAtom(DPLLAtom dPLLAtom) {
        this.mLogger.debug("EPRDEBUG: removeAtom" + String.valueOf(dPLLAtom));
    }

    @Override
    public void push() {
        this.mLogger.debug("EPRDEBUG: (EprTheory) PUSH");
        this.mAtomsAddedToDPLLEngine.beginScope();
    }

    @Override
    public void pop() {
        this.mLogger.debug("EPRDEBUG: (EprTheory) POP");
        this.mAtomsAddedToDPLLEngine.endScope();
    }

    @Override
    public Object[] getStatistics() {
        return null;
    }

    public void addAtomToDPLLEngine(DPLLAtom dPLLAtom) {
        assert (!(dPLLAtom instanceof EprQuantifiedEqualityAtom) && !(dPLLAtom instanceof EprQuantifiedPredicateAtom));
        if (dPLLAtom instanceof CCEquality) {
            return;
        }
        if (!this.mAtomsAddedToDPLLEngine.contains((Object)dPLLAtom)) {
            this.mEngine.addAtom(dPLLAtom);
            this.mAtomsAddedToDPLLEngine.add((Object)dPLLAtom);
        }
    }

    public Literal[] addEprClause(Literal[] literalArray, ClauseDeletionHook clauseDeletionHook, ProofNode proofNode) {
        this.addConstants(EprHelpers.collectAppearingConstants(literalArray, this.mTheory));
        ApplyDestructiveEqualityReasoning applyDestructiveEqualityReasoning = new ApplyDestructiveEqualityReasoning(this, literalArray);
        if (applyDestructiveEqualityReasoning.isResultGround()) {
            return applyDestructiveEqualityReasoning.getResult().toArray(new Literal[applyDestructiveEqualityReasoning.getResult().size()]);
        }
        Set<Literal> set = applyDestructiveEqualityReasoning.getResult();
        Set<Literal> set2 = new ApplyConstructiveEqualityReasoning(this, set).getResult();
        Clause clause = this.mEprStack.createEprClause(set2);
        if (clause != null) {
            assert (this.mStoredConflict == null) : "we'll probably need a queue for this..";
            this.mStoredConflict = clause;
        }
        return null;
    }

    public static boolean isQuantifiedEprAtom(Term term) {
        if (term.getFreeVars().length > 0 && term instanceof ApplicationTerm) {
            if (EprTheory.isEprPredicate(((ApplicationTerm)term).getFunction())) {
                return true;
            }
            if (((ApplicationTerm)term).getFunction().getName().equals("=") && !((ApplicationTerm)term).getParameters()[0].getSort().getName().equals("Bool")) {
                return true;
            }
        }
        return false;
    }

    private static boolean isEprPredicate(FunctionSymbol functionSymbol) {
        return !functionSymbol.isIntern();
    }

    public EprAtom getEprAtom(ApplicationTerm applicationTerm, int n, int n2, SourceAnnotation sourceAnnotation) {
        if (applicationTerm.getFunction().getName().equals("=")) {
            assert (applicationTerm.getFreeVars().length > 0);
            return new EprQuantifiedEqualityAtom(applicationTerm, n, n2, this.getEqualityEprPredicate(applicationTerm.getParameters()[0].getSort()), sourceAnnotation);
        }
        EprPredicate eprPredicate = this.getEprPredicate(applicationTerm.getFunction());
        if (applicationTerm.getFreeVars().length == 0) {
            EprGroundPredicateAtom eprGroundPredicateAtom = (EprGroundPredicateAtom)eprPredicate.getAtomForTermTuple(new TermTuple(applicationTerm.getParameters()), this.mTheory, n2, sourceAnnotation);
            eprPredicate.addDPLLAtom(eprGroundPredicateAtom);
            return eprGroundPredicateAtom;
        }
        return eprPredicate.getAtomForTermTuple(new TermTuple(applicationTerm.getParameters()), this.mTheory, n2, sourceAnnotation);
    }

    private EprPredicate getEprPredicate(FunctionSymbol functionSymbol) {
        EprPredicate eprPredicate = this.mFunctionSymbolToEprPredicate.get(functionSymbol);
        if (eprPredicate == null) {
            eprPredicate = functionSymbol.getName().equals("=") ? new EprEqualityPredicate(functionSymbol, this) : new EprPredicate(functionSymbol, this);
            this.mFunctionSymbolToEprPredicate.put(functionSymbol, eprPredicate);
            this.mEprStack.addNewEprPredicate(eprPredicate);
        }
        return eprPredicate;
    }

    public EprEqualityPredicate getEqualityEprPredicate(Sort sort) {
        EprEqualityPredicate eprEqualityPredicate = this.mSortToEqualityEprPredicate.get(sort);
        if (eprEqualityPredicate == null) {
            FunctionSymbol functionSymbol = this.mTheory.getFunction("=", new Sort[]{sort, sort});
            eprEqualityPredicate = (EprEqualityPredicate)this.getEprPredicate(functionSymbol);
            this.mSortToEqualityEprPredicate.put(sort, eprEqualityPredicate);
        }
        return eprEqualityPredicate;
    }

    public void addConstants(HashSet<ApplicationTerm> hashSet) {
    }

    public ArrayList<Literal[]> getAllGroundingsOfLastAddedEprClause() {
        return this.mAllGroundingsOfLastAddedEprClause;
    }

    public Theory getTheory() {
        return this.mTheory;
    }

    public CClosure getCClosure() {
        return this.mCClosure;
    }

    public EprDecideStack getStateManager() {
        return this.mEprStack;
    }

    public DawgFactory<ApplicationTerm, TermVariable> getDawgFactory() {
        return this.mDawgFactory;
    }

    public EprClauseFactory getEprClauseFactory() {
        return this.mClauseFactory;
    }

    public EqualityManager getEqualityManager() {
        return this.mEqualityManager;
    }

    public Clausifier getClausifier() {
        return this.mClausifier;
    }

    public void addSkolemConstants(Term[] termArray) {
    }

    public LogProxy getLogger() {
        return this.mLogger;
    }

    @Override
    public void printStatistics(LogProxy logProxy) {
    }

    @Override
    public void dumpModel(LogProxy logProxy) {
    }

    public boolean isTerminationRequested() {
        boolean bl = this.mEngine.isTerminationRequested();
        if (bl) {
            this.mLogger.info("EPRDEBUG: timeout received!");
        }
        return bl;
    }

    public static enum TriBool {
        FALSE,
        UNKNOWN,
        TRUE;


        public TriBool negate() {
            return this == UNKNOWN ? UNKNOWN : (this == TRUE ? FALSE : TRUE);
        }
    }
}

