/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IOutgoingTransitionlet;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Deprecated
public class LookaheadPartitionConstructor<LETTER, STATE> {
    private static final int LOOKAHEAD = Integer.MAX_VALUE;
    private final AutomataLibraryServices mServices;
    private final ILogger mLogger;
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private final Set<Set<STATE>> mPartition;
    private final List<Pair<STATE, STATE>> mPairs;
    private final boolean mUseSimulationHack;

    public LookaheadPartitionConstructor(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, boolean bl, boolean bl2) {
        this(automataLibraryServices, iNestedWordAutomaton, Collections.singleton(iNestedWordAutomaton.getStates()), bl, bl2);
    }

    public LookaheadPartitionConstructor(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, Collection<Set<STATE>> collection, boolean bl, boolean bl2) {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
        this.mOperand = iNestedWordAutomaton;
        this.mUseSimulationHack = bl2;
        this.mPartition = this.createPartition(collection, bl);
        this.mPairs = this.findDifferentPairs(this.mPartition);
    }

    public PartitionPairsWrapper<STATE> getResult() {
        return new PartitionPairsWrapper<STATE>(this.mPartition, this.mPairs);
    }

    public PartitionBackedSetOfPairs<STATE> getPartition() {
        return new PartitionBackedSetOfPairs(this.mPartition);
    }

    public List<Pair<STATE, STATE>> getDifferencePairs() {
        return this.mPairs;
    }

    private Set<Set<STATE>> createPartition(Collection<Set<STATE>> collection, boolean bl) {
        Set<Set<STATE>> set = this.splitDifferentSymbols(collection);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Splitting by different symbols, result:");
            this.mLogger.debug(set);
        }
        if (bl) {
            set = this.splitAcceptingStates(set);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)"Splitting by accepting states, result:");
                this.mLogger.debug(set);
            }
        }
        set = this.splitSuccessorsDeterministic(set);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Splitting by different deterministic successors, result:");
            this.mLogger.debug(set);
        }
        return set;
    }

    private Set<Set<STATE>> splitDifferentSymbols(Collection<Set<STATE>> collection) {
        LinkedHashSet<Set<STATE>> linkedHashSet = new LinkedHashSet<Set<STATE>>();
        for (Set<STATE> set : collection) {
            HashRelation hashRelation = new HashRelation();
            for (Object object : set) {
                hashRelation.addPair(this.computeOutgoingSymbols(object), object);
            }
            for (Object object : hashRelation.getDomain()) {
                linkedHashSet.add(hashRelation.getImage(object));
            }
        }
        return linkedHashSet;
    }

    private OutgoingInCaSymbols<LETTER> computeOutgoingSymbols(STATE STATE) {
        Set set = this.mOperand.lettersInternal(STATE);
        Set set2 = this.mOperand.lettersCall(STATE);
        return new OutgoingInCaSymbols(set, set2);
    }

    private Set<Set<STATE>> splitAcceptingStates(Set<Set<STATE>> set) {
        LinkedHashSet<Set<STATE>> linkedHashSet = new LinkedHashSet<Set<STATE>>(2 * set.size());
        for (Set<STATE> set2 : set) {
            LinkedHashSet<STATE> linkedHashSet2 = new LinkedHashSet<STATE>(set2.size());
            LinkedHashSet<STATE> linkedHashSet3 = new LinkedHashSet<STATE>(set2.size());
            for (STATE STATE : set2) {
                if (this.mOperand.isFinal(STATE)) {
                    linkedHashSet2.add(STATE);
                    continue;
                }
                linkedHashSet3.add(STATE);
            }
            if (linkedHashSet2.isEmpty()) {
                assert (!linkedHashSet3.isEmpty()) : "The input sets should not be empty.";
                linkedHashSet.add(linkedHashSet3);
                continue;
            }
            linkedHashSet.add(linkedHashSet2);
            if (linkedHashSet3.isEmpty()) continue;
            linkedHashSet.add(linkedHashSet3);
        }
        return linkedHashSet;
    }

    private Set<Set<STATE>> splitSuccessorsDeterministic(Set<Set<STATE>> set) {
        Set<Set<STATE>> set2 = set;
        HashMap<LinkedHashSet<Set<STATE>>, Set<STATE>> hashMap = new HashMap<LinkedHashSet<Set<STATE>>, Set<STATE>>(this.mOperand.size());
        for (Set<STATE> set3 : set2) {
            for (LinkedHashSet<Set<STATE>> linkedHashSet : set3) {
                hashMap.put(linkedHashSet, set3);
            }
        }
        boolean bl = true;
        int n = 0;
        while (bl) {
            LinkedHashSet<Set<STATE>> linkedHashSet;
            bl = false;
            linkedHashSet = new LinkedHashSet<Set<STATE>>(set2);
            for (Set<STATE> set3 : set2) {
                assert (!set3.isEmpty()) : "Blocks should be non-empty.";
                STATE STATE = set3.iterator().next();
                for (Object LETTER : this.mOperand.lettersInternal(STATE)) {
                    bl |= this.splitLetterSuccessors(hashMap, set3, LETTER, linkedHashSet, true);
                }
                for (Object LETTER : this.mOperand.lettersCall(STATE)) {
                    bl |= this.splitLetterSuccessors(hashMap, set3, LETTER, linkedHashSet, false);
                }
            }
            assert (!bl || set2.size() < linkedHashSet.size()) : "Inconsistent partition refinement.";
            assert (this.partitionsConsistency(set2, linkedHashSet));
            set2 = linkedHashSet;
            bl &= ++n < Integer.MAX_VALUE;
        }
        return set2;
    }

    private boolean splitLetterSuccessors(Map<STATE, Set<STATE>> map, Set<STATE> set, LETTER LETTER, Set<Set<STATE>> set2, boolean bl) {
        Set<Object> set3;
        Set<Object> set4;
        HashMap<Set<STATE>, LinkedHashSet<STATE>> hashMap = new HashMap<Set<STATE>, LinkedHashSet<STATE>>();
        for (STATE STATE : set) {
            Collection<STATE> collection = this.getSuccessors(LETTER, STATE, bl);
            if (collection.isEmpty()) {
                return false;
            }
            for (Object e : collection) {
                set4 = map.get(e);
                set3 = (Set)hashMap.get(set4);
                if (set3 == null) {
                    set3 = new LinkedHashSet<STATE>();
                    hashMap.put((Set<STATE>)set4, (LinkedHashSet<STATE>)set3);
                }
                set3.add(STATE);
            }
        }
        boolean bl2 = false;
        for (Object object : hashMap.values()) {
            boolean bl3;
            boolean bl4 = bl3 = !set2.contains(object);
            if (!bl3) continue;
            HashMap hashMap2 = new HashMap();
            set3 = object.iterator();
            while (set3.hasNext()) {
                set4 = set3.next();
                Set<STATE> set5 = map.get(set4);
                LinkedHashSet<Set<STATE>> linkedHashSet = (LinkedHashSet<Set<STATE>>)hashMap2.get(set5);
                if (linkedHashSet == null) {
                    linkedHashSet = new LinkedHashSet<Set<STATE>>();
                    hashMap2.put(set5, linkedHashSet);
                }
                linkedHashSet.add(set4);
            }
            this.splitLetterSuccessorsHelper(map, set2, hashMap2);
            bl2 = true;
        }
        return bl2;
    }

    private void splitLetterSuccessorsHelper(Map<STATE, Set<STATE>> map, Set<Set<STATE>> set, Map<Set<STATE>, Set<STATE>> map2) {
        for (Map.Entry<Set<STATE>, Set<STATE>> entry : map2.entrySet()) {
            Object object2;
            Set<STATE> set2 = entry.getKey();
            Set<STATE> set3 = entry.getValue();
            assert (!set3.isEmpty());
            set.add(set3);
            for (Object object2 : set3) {
                map.put(object2, set3);
            }
            object2 = new LinkedHashSet(set2.size());
            for (Iterator<STATE> iterator : set2) {
                if (set3.contains(iterator)) continue;
                object2.add(iterator);
                map.put((STATE)iterator, (Set<STATE>)object2);
            }
            if (object2.isEmpty()) continue;
            set.remove(set2);
            set.add((Set<STATE>)object2);
        }
    }

    private Collection<STATE> getSuccessors(LETTER LETTER, STATE STATE, boolean bl) {
        Iterator<IOutgoingTransitionlet<LETTER, STATE>> iterator;
        Iterator<IOutgoingTransitionlet<LETTER, STATE>> iterator2 = iterator = bl ? this.mOperand.internalSuccessors(STATE, LETTER).iterator() : this.mOperand.callSuccessors(STATE, LETTER).iterator();
        assert (iterator.hasNext()) : "There should be at least one outgoing transition.";
        IOutgoingTransitionlet<LETTER, STATE> iOutgoingTransitionlet = iterator.next();
        if (iterator.hasNext()) {
            if (this.mUseSimulationHack) {
                ArrayList<STATE> arrayList = new ArrayList<STATE>();
                arrayList.add(iOutgoingTransitionlet.getSucc());
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next().getSucc());
                }
                return arrayList;
            }
            return Collections.emptyList();
        }
        return Collections.singletonList(iOutgoingTransitionlet.getSucc());
    }

    private boolean partitionsConsistency(Set<Set<STATE>> set, Set<Set<STATE>> set2) {
        boolean bl;
        LinkedHashSet<STATE> linkedHashSet = new LinkedHashSet<STATE>();
        for (Set<STATE> set3 : set) {
            if (set3.isEmpty()) {
                return false;
            }
            for (STATE STATE : set3) {
                bl = linkedHashSet.add(STATE);
                if (bl) continue;
                return false;
            }
        }
        for (Set<STATE> set3 : set2) {
            if (set3.isEmpty()) {
                return false;
            }
            for (STATE STATE : set3) {
                bl = linkedHashSet.remove(STATE);
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    private List<Pair<STATE, STATE>> findDifferentPairs(Set<Set<STATE>> set) {
        List<Pair<STATE, STATE>> list = this.splitHierarchicalPredecessors(set);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Splitting by different hierarchical predecessors, result:");
            this.mLogger.debug(set);
        }
        return list;
    }

    private List<Pair<STATE, STATE>> splitHierarchicalPredecessors(Set<Set<STATE>> set) {
        return Collections.emptyList();
    }

    private static class OutgoingInCaSymbols<LETTER> {
        private static final int PRIME = 31;
        private final Set<LETTER> mInternal;
        private final Set<LETTER> mCall;

        public OutgoingInCaSymbols(Set<LETTER> set, Set<LETTER> set2) {
            this.mInternal = set;
            this.mCall = set2;
        }

        public int hashCode() {
            int n = 31 + (this.mCall == null ? 0 : this.mCall.hashCode());
            n = 31 * n + (this.mInternal == null ? 0 : this.mInternal.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            OutgoingInCaSymbols outgoingInCaSymbols = (OutgoingInCaSymbols)object;
            if (this.mCall == null ? outgoingInCaSymbols.mCall != null : !this.mCall.equals(outgoingInCaSymbols.mCall)) {
                return false;
            }
            return !(this.mInternal == null ? outgoingInCaSymbols.mInternal != null : !this.mInternal.equals(outgoingInCaSymbols.mInternal));
        }

        public String toString() {
            return "OutgoingInCaSymbols [mInternal=" + String.valueOf(this.mInternal) + ", mCall=" + String.valueOf(this.mCall) + "]";
        }
    }

    public static final class PartitionPairsWrapper<STATE> {
        private final Set<Set<STATE>> mPartitionInner;
        private final List<Pair<STATE, STATE>> mPairsInner;

        public PartitionPairsWrapper(Set<Set<STATE>> set, List<Pair<STATE, STATE>> list) {
            this.mPartitionInner = set;
            this.mPairsInner = list;
        }

        public Set<Set<STATE>> getPartition() {
            return this.mPartitionInner;
        }

        public List<Pair<STATE, STATE>> getDifferencePairs() {
            return this.mPairsInner;
        }
    }
}

