/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.EprClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.DawgFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;

public abstract class ClauseLiteral {
    protected final Literal mEngineLiteral;
    protected final DPLLAtom mAtom;
    protected final boolean mPolarity;
    protected final EprTheory mEprTheory;
    protected EprClause mEprClause;
    protected final DawgFactory<ApplicationTerm, TermVariable> mDawgFactory;

    public ClauseLiteral(boolean bl, DPLLAtom dPLLAtom, EprClause eprClause, EprTheory eprTheory) {
        this.mAtom = dPLLAtom;
        this.mEngineLiteral = bl ? dPLLAtom : dPLLAtom.negate();
        this.mPolarity = bl;
        this.mEprClause = eprClause;
        this.mEprTheory = eprTheory;
        this.mDawgFactory = eprTheory.getDawgFactory();
    }

    public boolean getPolarity() {
        return this.mPolarity;
    }

    public Literal getLiteral() {
        return this.mEngineLiteral;
    }

    protected abstract boolean isDirty();

    protected abstract DawgState<ApplicationTerm, EprTheory.TriBool> getDawg();

    public EprClause getClause() {
        return this.mEprClause;
    }

    public String toString() {
        String string = this.mPolarity ? "" : "~";
        return string + this.mAtom.toString();
    }

    static enum ClauseLiteralState {
        Fulfilled,
        Fulfillable,
        Refuted;

    }
}

