/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon;

import de.uni_freiburg.informatik.ultimate.boogie.symboltable.BoogieSymbolTable;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractDomain;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractStateBinaryOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IBoogieSymbolTableVariableProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg.RCFGLiteralCollector;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalDomain;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctExponentialWideningOperator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctLiteralWideningOperator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctPostOperator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctSimpleWideningOperator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctagonDomainPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlockFactory;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;

public class OctagonDomain
implements IAbstractDomain<OctDomainState, IcfgEdge> {
    private final BoogieSymbolTable mSymbolTable;
    private final ILogger mLogger;
    private final LiteralCollectorFactory mLiteralCollectorFactory;
    private final Function<Boolean, OctDomainState> mOctDomainStateFactory;
    private final Supplier<IAbstractStateBinaryOperator<OctDomainState>> mWideningOperatorFactory;
    private final Supplier<IAbstractPostOperator<OctDomainState, IcfgEdge>> mPostOperatorFactory;
    private final BoogieIcfgContainer mBoogieIcfg;
    private final IBoogieSymbolTableVariableProvider mBoogie2SmtSymbolTableVariableProvider;

    public OctagonDomain(ILogger iLogger, BoogieSymbolTable boogieSymbolTable, LiteralCollectorFactory literalCollectorFactory, IUltimateServiceProvider iUltimateServiceProvider, BoogieIcfgContainer boogieIcfgContainer, IBoogieSymbolTableVariableProvider iBoogieSymbolTableVariableProvider) {
        this.mLogger = iLogger;
        this.mSymbolTable = boogieSymbolTable;
        this.mLiteralCollectorFactory = literalCollectorFactory;
        this.mBoogieIcfg = boogieIcfgContainer;
        IPreferenceProvider iPreferenceProvider = iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID);
        this.mOctDomainStateFactory = OctagonDomain.makeDomainStateFactory(iPreferenceProvider);
        this.mWideningOperatorFactory = this.makeWideningOperatorFactory(iPreferenceProvider);
        IAbstractPostOperator iAbstractPostOperator = new IntervalDomain(iLogger, this.mSymbolTable, this.mLiteralCollectorFactory.create().getLiteralCollection(), iUltimateServiceProvider, this.mBoogieIcfg, iBoogieSymbolTableVariableProvider).getPostOperator();
        this.mPostOperatorFactory = this.makePostOperatorFactory(iPreferenceProvider, (IAbstractPostOperator<IntervalDomainState, IcfgEdge>)iAbstractPostOperator, this.mBoogieIcfg.getCodeBlockFactory());
        this.mBoogie2SmtSymbolTableVariableProvider = iBoogieSymbolTableVariableProvider;
    }

    private static Function<Boolean, OctDomainState> makeDomainStateFactory(IPreferenceProvider iPreferenceProvider) {
        OctagonDomainPreferences.LogMessageFormatting logMessageFormatting = (OctagonDomainPreferences.LogMessageFormatting)iPreferenceProvider.getEnum("Log string format", OctagonDomainPreferences.LogMessageFormatting.class);
        return arg_0 -> OctagonDomain.lambda$3(switch (logMessageFormatting) {
            case OctagonDomainPreferences.LogMessageFormatting.FULL_MATRIX -> OctDomainState::logStringFullMatrix;
            case OctagonDomainPreferences.LogMessageFormatting.HALF_MATRIX -> OctDomainState::logStringHalfMatrix;
            case OctagonDomainPreferences.LogMessageFormatting.TERM -> OctDomainState::logStringTerm;
            default -> throw OctagonDomain.makeIllegalSettingException("Log string format", (Object)logMessageFormatting);
        }, arg_0);
    }

    private Supplier<IAbstractStateBinaryOperator<OctDomainState>> makeWideningOperatorFactory(IPreferenceProvider iPreferenceProvider) {
        OctagonDomainPreferences.WideningOperator wideningOperator = (OctagonDomainPreferences.WideningOperator)iPreferenceProvider.getEnum("Octagon widening operator", OctagonDomainPreferences.WideningOperator.class);
        switch (wideningOperator) {
            case SIMPLE: {
                return () -> new OctSimpleWideningOperator();
            }
            case EXPONENTIAL: {
                String string = iPreferenceProvider.getString("Threshold for exponential widening");
                try {
                    BigDecimal bigDecimal = AbsIntUtil.sanitizeBigDecimalValue(string);
                    return () -> new OctExponentialWideningOperator(bigDecimal);
                }
                catch (NumberFormatException numberFormatException) {
                    throw OctagonDomain.makeIllegalSettingException("Octagon widening operator", (Object)wideningOperator);
                }
            }
            case LITERAL: {
                Collection<BigDecimal> collection = this.mLiteralCollectorFactory.create().getNumberLiterals();
                return () -> new OctLiteralWideningOperator(collection);
            }
        }
        throw OctagonDomain.makeIllegalSettingException("Octagon widening operator", (Object)wideningOperator);
    }

    private Supplier<IAbstractPostOperator<OctDomainState, IcfgEdge>> makePostOperatorFactory(IPreferenceProvider iPreferenceProvider, IAbstractPostOperator<IntervalDomainState, IcfgEdge> iAbstractPostOperator, CodeBlockFactory codeBlockFactory) {
        int n = iPreferenceProvider.getInt("Parallel states before merging");
        boolean bl = iPreferenceProvider.getBoolean("Fallback: assign interval projection");
        return () -> new OctPostOperator(this.mLogger, this.mSymbolTable, this.mBoogieIcfg.getCfgSmtToolkit(), n, bl, this.mBoogie2SmtSymbolTableVariableProvider, iAbstractPostOperator, codeBlockFactory);
    }

    private static IllegalArgumentException makeIllegalSettingException(String string, Object object) {
        String string2 = "Illegal value for setting \"" + string + "\": " + String.valueOf(object);
        return new IllegalArgumentException(string2);
    }

    public OctDomainState createTopState() {
        return this.mOctDomainStateFactory.apply(false);
    }

    public OctDomainState createBottomState() {
        return this.mOctDomainStateFactory.apply(true);
    }

    public IAbstractStateBinaryOperator<OctDomainState> getWideningOperator() {
        return this.mWideningOperatorFactory.get();
    }

    public IAbstractPostOperator<OctDomainState, IcfgEdge> getPostOperator() {
        return this.mPostOperatorFactory.get();
    }

    private static /* synthetic */ OctDomainState lambda$3(Function function, Boolean bl) {
        return OctDomainState.createFreshState(function, bl);
    }

    @FunctionalInterface
    public static interface LiteralCollectorFactory {
        public RCFGLiteralCollector create();
    }
}

