/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.preferencejson;

import com.google.gson.Gson;
import de.uni_freiburg.informatik.ultimate.core.model.ICore;
import de.uni_freiburg.informatik.ultimate.core.model.IUltimatePlugin;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.BaseUltimatePreferenceItem;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.PreferenceType;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.UltimatePreferenceItem;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class PreferenceUtil {
    private static final String PLUGIN_ID_CORE = "de.uni_freiburg.informatik.ultimate.core";

    private PreferenceUtil() {
    }

    public static String convertLabelToLongName(String string, UltimatePreferenceItem<?> ultimatePreferenceItem) {
        return PreferenceUtil.convertLabelToLongName(string, ultimatePreferenceItem.getLabel());
    }

    public static String convertLabelToLongName(String string, String string2) {
        int n = string.lastIndexOf(46);
        String string3 = n > 0 ? string.substring(n + 1) : string;
        String string4 = string3 + " " + string2;
        String string5 = string4.replace(":", "").replaceAll("[ ()\"'.]+", ".").toLowerCase(Locale.ENGLISH);
        if (string5.endsWith(".")) {
            return string5.substring(0, string5.length() - 1);
        }
        return string5;
    }

    public static String generateFrontendSettingsJsonFromDefaultSettings(ICore<?> iCore) {
        return PreferenceUtil.generateFrontendSettingsJson(iCore, PreferenceUtil.getDefaultSettings(iCore));
    }

    public static String generateFrontendSettingsJsonFromDeltaSettings(IUltimateServiceProvider iUltimateServiceProvider, ICore<?> iCore) {
        return PreferenceUtil.generateFrontendSettingsJson(iCore, PreferenceUtil.getDeltaSettings(iUltimateServiceProvider, iCore));
    }

    public static String generateBackendWhitelistJsonFromDefaultSettings(ICore<?> iCore) {
        return PreferenceUtil.generateBackendWhitelistJson(PreferenceUtil.getDefaultSettings(iCore));
    }

    public static String generateBackendWhitelistJsonFromDeltaSettings(IUltimateServiceProvider iUltimateServiceProvider, ICore<?> iCore) {
        return PreferenceUtil.generateBackendWhitelistJson(PreferenceUtil.getDeltaSettings(iUltimateServiceProvider, iCore));
    }

    private static String generateFrontendSettingsJson(ICore<?> iCore, Map<String, Map<String, Object>> map) {
        LinkedHashMap linkedHashMap = new LinkedHashMap(1);
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        linkedHashMap.put("frontend_settings", arrayList);
        Map<String, IUltimatePlugin> map2 = Arrays.stream(iCore.getRegisteredUltimatePlugins()).collect(Collectors.toMap(IUltimatePlugin::getPluginID, iUltimatePlugin -> iUltimatePlugin));
        for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            IUltimatePlugin iUltimatePlugin2 = map2.get(entry.getKey());
            Map<String, UltimatePreferenceItem> map3 = BaseUltimatePreferenceItem.constructFlattenedList((BaseUltimatePreferenceItem[])iUltimatePlugin2.getPreferences().getPreferenceItems()).stream().filter(ultimatePreferenceItem -> ultimatePreferenceItem.getType() != PreferenceType.Label).collect(Collectors.toMap(UltimatePreferenceItem::getLabel, ultimatePreferenceItem -> ultimatePreferenceItem));
            for (Map.Entry<String, Object> entry2 : entry.getValue().entrySet()) {
                UltimatePreferenceItem ultimatePreferenceItem2 = map3.get(entry2.getKey());
                if (ultimatePreferenceItem2 == null) {
                    ILogger iLogger = iCore.getCoreLoggingService().getLogger(PreferenceUtil.class);
                    iLogger.error("%s '%s' is not a valid setting (perhaps renamed?)", new Object[]{iUltimatePlugin2.getPluginID(), entry2.getKey()});
                    continue;
                }
                arrayList.add(PreferenceUtil.createFrontendSetting(entry.getKey(), entry2.getKey(), entry2.getValue(), ultimatePreferenceItem2));
            }
        }
        return new Gson().toJson(linkedHashMap);
    }

    private static String generateBackendWhitelistJson(Map<String, Map<String, Object>> map) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            linkedHashMap.put(entry.getKey(), entry.getValue().keySet().stream().collect(Collectors.toUnmodifiableList()));
        }
        return new Gson().toJson(linkedHashMap);
    }

    private static Map<String, Map<String, Object>> getDeltaSettings(IUltimateServiceProvider iUltimateServiceProvider, ICore<?> iCore) {
        Map<String, Map<String, Object>> map = PreferenceUtil.getDefaultSettings(iCore);
        Map<String, Map<String, Object>> map2 = PreferenceUtil.getCurrentSettings(iUltimateServiceProvider, iCore);
        LinkedHashMap<String, Map<String, Object>> linkedHashMap = new LinkedHashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> entry : map2.entrySet()) {
            Map<String, Object> map3 = entry.getValue();
            if (map3.isEmpty()) continue;
            Map<String, Object> map4 = map.get(entry.getKey());
            LinkedHashMap<String, Object> linkedHashMap2 = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> entry2 : map3.entrySet()) {
                if (Objects.equals(entry2.getValue(), map4.get(entry2.getKey()))) continue;
                linkedHashMap2.put(entry2.getKey(), entry2.getValue());
            }
            linkedHashMap.put(entry.getKey(), linkedHashMap2);
        }
        return linkedHashMap;
    }

    private static Map<String, Map<String, Object>> getDefaultSettings(ICore<?> iCore) {
        LinkedHashMap<String, Map<String, Object>> linkedHashMap = new LinkedHashMap<String, Map<String, Object>>();
        String[] stringArray = iCore.getRegisteredUltimatePluginIDs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            IPreferenceProvider iPreferenceProvider = iCore.getPreferenceProvider(string);
            Map map = iPreferenceProvider.getDefaultPreferences();
            Map<String, Object> map2 = linkedHashMap.put(string, map);
            if (map2 != null) {
                throw new IllegalStateException(String.format("Plugin %s is registered twice", string));
            }
            ++n2;
        }
        linkedHashMap.put(PLUGIN_ID_CORE, iCore.getPreferenceProvider(PLUGIN_ID_CORE).getDefaultPreferences());
        return linkedHashMap;
    }

    private static Map<String, Map<String, Object>> getCurrentSettings(IUltimateServiceProvider iUltimateServiceProvider, ICore<?> iCore) {
        LinkedHashMap<String, Map<String, Object>> linkedHashMap = new LinkedHashMap<String, Map<String, Object>>();
        String[] stringArray = iCore.getRegisteredUltimatePluginIDs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            IPreferenceProvider iPreferenceProvider = iUltimateServiceProvider.getPreferenceProvider(string);
            Map map = iPreferenceProvider.getPreferences();
            Map<String, Object> map2 = linkedHashMap.put(string, map);
            if (map2 != null) {
                throw new IllegalStateException(String.format("Plugin %s is registered twice", string));
            }
            ++n2;
        }
        linkedHashMap.put(PLUGIN_ID_CORE, iCore.getPreferenceProvider(PLUGIN_ID_CORE).getPreferences());
        return linkedHashMap;
    }

    private static Map<String, Object> createFrontendSetting(String string, String string2, Object object, UltimatePreferenceItem<?> ultimatePreferenceItem) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(8);
        hashMap.put("plugin_id", string);
        hashMap.put("key", string2);
        hashMap.put("id", PreferenceUtil.convertLabelToLongName(string, string2).replace('.', '_'));
        hashMap.put("name", string2);
        hashMap.put("visible", false);
        hashMap.put("default", PreferenceUtil.getFrontendSettingsValue(ultimatePreferenceItem, object));
        hashMap.put("type", PreferenceUtil.getFrontendSettingsType(ultimatePreferenceItem));
        if (ultimatePreferenceItem.getType() == PreferenceType.Radio || ultimatePreferenceItem.getType() == PreferenceType.Combo) {
            hashMap.put("options", Arrays.asList(ultimatePreferenceItem.getChoices()));
        }
        if (ultimatePreferenceItem.getDescription() != null) {
            hashMap.put("description", ultimatePreferenceItem.getDescription());
        }
        return hashMap;
    }

    private static Object getFrontendSettingsValue(UltimatePreferenceItem<?> ultimatePreferenceItem, Object object) {
        switch (ultimatePreferenceItem.getType()) {
            case Boolean: {
                return Boolean.valueOf(object.toString());
            }
            case Double: {
                return Double.valueOf(object.toString());
            }
            case Integer: {
                return Integer.valueOf(object.toString());
            }
        }
        return object;
    }

    private static String getFrontendSettingsType(UltimatePreferenceItem<?> ultimatePreferenceItem) {
        switch (ultimatePreferenceItem.getType()) {
            case Boolean: {
                return "bool";
            }
            case Double: {
                return "real";
            }
            case Integer: {
                return "int";
            }
        }
        return "string";
    }
}

